/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.App;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NavHelper;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.helpers.SummaryBarRenderer;
import net.i2p.util.PortMapper;

public class HomeHelper
extends HelperBase {
    private static final char S = ',';
    private static final String I = "/themes/console/images/";
    static final String PROP_SERVICES = "routerconsole.services";
    static final String PROP_FAVORITES = "routerconsole.favorites";
    static final String PROP_CONFIG = "routerconsole.configopts";
    static final String PROP_MONITORING = "routerconsole.monitoring";
    static final String PROP_OLDHOME = "routerconsole.oldHomePage";
    private static final String PROP_SEARCH = "routerconsole.showSearch";
    private static final String bottomWrap = "<br>\n<div class=\"clearer\">&nbsp;</div>\n</div>\n</div>\n";
    static final String DEFAULT_SERVICES = String.valueOf(HomeHelper._x("Email")) + ',' + HomeHelper._x("Anonymous webmail client") + ',' + "/webmail" + ',' + "/themes/console/images/" + "email.png" + ',' + HomeHelper._x("Hidden Services Manager") + ',' + HomeHelper._x("Control your client and server tunnels") + ',' + "/i2ptunnelmgr" + ',' + "/themes/console/images/" + "server_32x32.png" + ',' + HomeHelper._x("Torrents") + ',' + HomeHelper._x("Built-in anonymous BitTorrent Client") + ',' + "/torrents" + ',' + "/themes/console/images/" + "i2psnark.png" + ',' + HomeHelper._x("Web Server") + ',' + HomeHelper._x("Local web server for hosting your own content on I2P") + ',' + "http://127.0.0.1:7658/" + ',' + "/themes/console/images/" + "server_32x32.png" + ',' + HomeHelper._x("Addressbook") + ',' + HomeHelper._x("Manage your I2P hosts file here (I2P domain name resolution)") + ',' + "/dns" + ',' + "/themes/console/images/" + "book_addresses.png" + ',';
    static final String DEFAULT_CONFIG = String.valueOf(HomeHelper._x("Configure Homepage")) + ',' + HomeHelper._x("Configure the contents of this page") + ',' + "/confighome" + ',' + "/themes/console/images/" + "info/home.png" + ',' + HomeHelper._x("Configure Bandwidth") + ',' + HomeHelper._x("I2P Bandwidth Configuration") + ',' + "/config" + ',' + "/themes/console/images/" + "info/bandwidth.png" + ',' + HomeHelper._x("Help") + ',' + HomeHelper._x("I2P Router Help") + ',' + "/help" + ',' + "/themes/console/images/" + "support.png" + ',' + HomeHelper._x("Manage Plugins") + ',' + HomeHelper._x("Install and configure I2P plugins") + ',' + "/configplugins" + ',' + "/themes/console/images/" + "plugin.png" + ',' + HomeHelper._x("Router Console") + ',' + HomeHelper._x("I2P Router Console") + ',' + "/console" + ',' + "/themes/console/images/" + "info/console.png" + ',';
    static final String DEFAULT_FAVORITES = String.valueOf(HomeHelper._x("Dev Forum")) + ',' + HomeHelper._x("Development forum") + ',' + "http://zzz.i2p/" + ',' + "/themes/console/images/" + "group_gear.png" + ',' + "echelon.i2p" + ',' + HomeHelper._x("I2P Applications") + ',' + "http://echelon.i2p/" + ',' + "/themes/console/images/" + "echelon.png" + ',' + HomeHelper._x("I2P FAQ") + ',' + HomeHelper._x("Frequently Asked Questions") + ',' + "http://i2p-projekt.i2p/faq" + ',' + "/themes/console/images/" + "question.png" + ',' + HomeHelper._x("I2P Forum") + ',' + HomeHelper._x("Community forum") + ',' + "http://i2pforum.i2p/" + ',' + "/themes/console/images/" + "group.png" + ',' + HomeHelper._x("MuWire") + ',' + HomeHelper._x("Easy anonymous file sharing") + ',' + "http://muwire.i2p/" + ',' + "/themes/console/images/" + "muwire.png" + ',' + HomeHelper._x("Planet I2P") + ',' + HomeHelper._x("I2P News") + ',' + "http://planet.i2p/" + ',' + "/themes/console/images/" + "world.png" + ',' + HomeHelper._x("Project Website") + ',' + HomeHelper._x("I2P home page") + ',' + "http://i2p-projekt.i2p/" + ',' + "/themes/console/images/" + "glass.png" + ',' + HomeHelper._x("The Tin Hat") + ',' + HomeHelper._x("Privacy guides and tutorials") + ',' + "http://secure.thetinhat.i2p/" + ',' + "/themes/console/images/" + "thetinhat.png" + ',';
    static final String DEFAULT_MONITORING = String.valueOf(HomeHelper._x("Logs")) + ',' + HomeHelper._x("View the logs") + ',' + "/logs" + ',' + "/themes/console/images/" + "info/logs.png" + ',' + HomeHelper._x("Graphs") + ',' + HomeHelper._x("Visualize information about the router") + ',' + "/graphs" + ',' + "/themes/console/images/" + "chart_line.png" + ',' + HomeHelper._x("I2P Technical Docs") + ',' + HomeHelper._x("Technical documentation") + ',' + "http://i2p-projekt.i2p/how" + ',' + "/themes/console/images/" + "education.png" + ',' + HomeHelper._x("Trac Wiki") + ',' + ',' + "http://trac.i2p2.i2p/" + ',' + "/themes/console/images/" + "trac_wiki.png" + ',' + HomeHelper._x("I2P Bug Reports") + ',' + HomeHelper._x("Bug tracker") + ',' + "http://trac.i2p2.i2p/report/1" + ',' + "/themes/console/images/" + "bug.png" + ',' + "stats.i2p" + ',' + HomeHelper._x("I2P Network Statistics") + ',' + "http://stats.i2p/cgi-bin/dashboard.cgi" + ',' + "/themes/console/images/" + "chart_bar.png" + ',';
    private static final String SS = Character.toString(',');

    public boolean shouldShowWelcome() {
        return this._context.getProperty("routerconsole.lang") == null;
    }

    public boolean shouldShowSearch() {
        return this._context.getBooleanProperty(PROP_SEARCH);
    }

    private String topWrap(String headline) {
        String str = "<div class=\"ag2\">\n<h4 class=\"app\">" + this._t(headline) + "</h4>\n" + "<div class=\"homeapps\">\n";
        return str;
    }

    public String getServices() {
        String table = this.homeTable(PROP_SERVICES, DEFAULT_SERVICES, null);
        if (table.length() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(1380);
        buf.append(this.topWrap("Applications"));
        buf.append(table);
        buf.append(bottomWrap);
        return buf.toString();
    }

    public String getPlugins() {
        List<App> plugins = NavHelper.getClientApps((I2PAppContext)this._context);
        String table = this.pluginTable(plugins);
        if (table.length() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(1380);
        buf.append(this.topWrap("Plugins"));
        buf.append(table);
        buf.append(bottomWrap);
        return buf.toString();
    }

    public String getConfig() {
        String table = this.homeTable(PROP_CONFIG, DEFAULT_CONFIG, null);
        if (table.length() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(1380);
        buf.append(this.topWrap("Configuration and Help"));
        buf.append(table);
        buf.append(bottomWrap);
        return buf.toString();
    }

    public String getMonitoring() {
        String table = this.homeTable(PROP_MONITORING, DEFAULT_MONITORING, null);
        if (table.length() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(1380);
        buf.append(this.topWrap("Network Information and Developer Information"));
        buf.append(table);
        buf.append(bottomWrap);
        return buf.toString();
    }

    public String getFavorites() {
        String table = this.homeTable(PROP_FAVORITES, DEFAULT_FAVORITES, null);
        if (table.length() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(1380);
        buf.append(this.topWrap("I2P Community Sites"));
        buf.append(table);
        buf.append(bottomWrap);
        return buf.toString();
    }

    public String getConfigServices() {
        return this.configTable(PROP_SERVICES, DEFAULT_SERVICES);
    }

    public String getConfigPlugins() {
        return this.getPlugins();
    }

    public String getConfigConfig() {
        return this.configTable(PROP_CONFIG, DEFAULT_CONFIG);
    }

    public String getConfigMonitoring() {
        return this.configTable(PROP_MONITORING, DEFAULT_MONITORING);
    }

    public String getConfigFavorites() {
        return this.configTable(PROP_FAVORITES, DEFAULT_FAVORITES);
    }

    public String getConfigSearch() {
        return this.configTable("routerconsole.searchEngines", "eepsites.i2p,http://eepsites.i2p/Content/Search/SearchResults.aspx?inpQuery=%s&ref=console,epsilon.i2p,http://epsilon.i2p/search.jsp?q=%s&ref=console");
    }

    public String getConfigHome() {
        return this.getChecked(PROP_OLDHOME);
    }

    public String getProxyStatus() {
        int port = this._context.portMapper().getPort("HTTP");
        if (port <= 0) {
            return this._t("The HTTP proxy is not up");
        }
        return "<img src=\"http://console.i2p/onepixel.png?" + this._context.random().nextInt() + "\"" + " alt=\"" + this._t("Your browser is not properly configured to use the HTTP proxy at {0}", String.valueOf(this._context.getProperty("router.updateProxyHost", "127.0.0.1")) + ':' + port) + "\">";
    }

    private String pluginTable(Collection<App> toAdd) {
        Collection<App> apps = HomeHelper.buildApps(this._context, "");
        if (toAdd != null) {
            apps.addAll(toAdd);
        }
        return this.renderApps(apps);
    }

    private String homeTable(String prop, String dflt, Collection<App> toAdd) {
        String config = this._context.getProperty(prop, dflt);
        Collection<App> apps = HomeHelper.buildApps(this._context, config);
        if (toAdd != null) {
            apps.addAll(toAdd);
        }
        return this.renderApps(apps);
    }

    private String configTable(String prop, String dflt) {
        String config = this._context.getProperty(prop, dflt);
        Collection<App> apps = prop.equals("routerconsole.searchEngines") ? HomeHelper.buildSearchApps(config) : HomeHelper.buildApps(this._context, config);
        return this.renderConfig(apps);
    }

    static Collection<App> buildApps(RouterContext ctx, String config) {
        String[] args = DataHelper.split((String)config, (String)SS);
        TreeSet<App> apps = new TreeSet<App>(new AppComparator());
        int i = 0;
        while (i < args.length - 3) {
            String name = Messages.getString(args[i], (I2PAppContext)ctx);
            String desc = Messages.getString(args[i + 1], (I2PAppContext)ctx);
            String url = args[i + 2];
            String icon = args[i + 3];
            apps.add(new App(name, desc, url, icon));
            i += 4;
        }
        return apps;
    }

    static Collection<App> buildSearchApps(String config) {
        String[] args = DataHelper.split((String)config, (String)SS);
        TreeSet<App> apps = new TreeSet<App>(new AppComparator());
        int i = 0;
        while (i < args.length - 1) {
            String name = args[i];
            String url = args[i + 1];
            apps.add(new App(name, null, url, null));
            i += 2;
        }
        return apps;
    }

    static void saveApps(RouterContext ctx, String prop, Collection<App> apps, boolean full) {
        StringBuilder buf = new StringBuilder(1024);
        for (App app : apps) {
            buf.append(app.name).append(',');
            if (full) {
                buf.append(app.desc).append(',');
            }
            buf.append(app.url).append(',');
            if (!full) continue;
            buf.append(app.icon).append(',');
        }
        ctx.router().saveConfig(prop, buf.toString());
    }

    private String renderApps(Collection<App> apps) {
        if (apps.size() == 0) {
            return "";
        }
        String website = this._t("Web Server");
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<div class=\"appgroup\">");
        PortMapper pm = this._context.portMapper();
        for (App app : apps) {
            String url;
            if (app.name.equals(website) && app.url.equals("http://127.0.0.1:7658/") ? (url = SummaryBarRenderer.getEepsiteURL(pm)) == null : ((url = app.url).equals("/dns") ? !pm.isRegistered("susidns") : (url.equals("/webmail") ? !pm.isRegistered("susimail") : (url.equals("/torrents") ? !pm.isRegistered("i2psnark") : (url.equals("/i2ptunnelmgr") ? !pm.isRegistered("i2ptunnel") : url.equals("/configplugins") && !PluginStarter.pluginsEnabled((I2PAppContext)this._context)))))) continue;
            String plugin = "";
            if (!app.icon.startsWith("/themes") && !app.icon.startsWith("/images")) {
                plugin = " plugin";
            }
            buf.append("\n<div class=\"app" + plugin + "\">\n" + "<div class=\"appimg" + plugin + "\">" + "<a href=\"").append(url).append("\" tabindex=\"-1\"><img alt=\"\" title=\"").append(app.desc).append("\" src=\"").append(app.icon).append(app.icon.contains("?") ? "&amp;" : "?").append("0.9.48").append("\"></a></div>\n<table><tr><td><div class=\"applabel\"><a href=\"").append(url).append("\" title=\"").append(app.desc).append("\">").append(app.name).append("</a></div></td></tr></table>\n</div>");
        }
        buf.append("</div>\n");
        return buf.toString();
    }

    private String renderConfig(Collection<App> apps) {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table class=\"homelinkedit\"><tr><th title=\"").append(this._t("Mark for deletion")).append("\">").append(this._t("Remove")).append("</th><th></th><th>").append(this._t("Name")).append("</th><th>").append(this._t("URL")).append("</th></tr>\n");
        for (App app : apps) {
            buf.append("<tr><td align=\"center\"><input type=\"checkbox\" class=\"optbox\" name=\"delete_").append(app.name).append("\" id=\"").append(app.name).append("\"></td><td align=\"center\">");
            if (app.icon != null) {
                buf.append("<img height=\"16\" alt=\"\" src=\"").append(app.icon).append("\">");
            }
            buf.append("</td><td align=\"left\"><label for=\"").append(app.name).append("\">").append(DataHelper.escapeHTML((String)app.name)).append("</label></td><td align=\"left\"><a href=\"");
            String url = DataHelper.escapeHTML((String)app.url);
            buf.append(url).append("\">");
            if (app.url.length() > 50) {
                buf.append(DataHelper.escapeHTML((String)app.url.substring(0, 48))).append("&hellip;");
            } else {
                buf.append(url);
            }
            buf.append("</a></td></tr>\n");
        }
        buf.append("<tr id=\"addnew\"><td colspan=\"2\" align=\"center\"><b>").append(this._t("Add")).append(":</b></td><td align=\"left\"><input type=\"text\" name=\"nofilter_name\"></td><td align=\"left\"><input type=\"text\" size=\"40\" name=\"nofilter_url\"></td></tr>");
        buf.append("</table>\n");
        return buf.toString();
    }

    private static class AppComparator
    implements Comparator<App>,
    Serializable {
        private AppComparator() {
        }

        @Override
        public int compare(App l, App r) {
            return l.name.toLowerCase().compareTo(r.name.toLowerCase());
        }
    }
}

