/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.i2p.data.DataHelper;
import net.i2p.router.Job;
import net.i2p.router.JobStats;
import net.i2p.router.web.HelperBase;
import net.i2p.util.ObjectCounter;

public class JobQueueHelper
extends HelperBase {
    private static final int MAX_JOBS = 50;

    public String getJobQueueSummary() {
        block3: {
            try {
                if (this._out == null) break block3;
                this.renderStatusHTML(this._out);
                return "";
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return "";
            }
        }
        StringWriter sw = new StringWriter(32768);
        this.renderStatusHTML(sw);
        return sw.toString();
    }

    private void renderStatusHTML(Writer out) throws IOException {
        Job j;
        ArrayList readyJobs = new ArrayList(8);
        ArrayList timedJobs = new ArrayList(128);
        ArrayList activeJobs = new ArrayList(8);
        ArrayList justFinishedJobs = new ArrayList(8);
        int numRunners = this._context.jobQueue().getJobs(readyJobs, timedJobs, activeJobs, justFinishedJobs);
        StringBuilder buf = new StringBuilder(32768);
        buf.append("<div class=\"joblog\">").append("<h2 id=\"jobrunners\">").append(this._t("Job runners")).append(": ").append(numRunners).append("</h2>\n");
        long now = this._context.clock().now();
        buf.append("<h3 id=\"activejobs\">").append(this._t("Active jobs")).append(": ").append(activeJobs.size()).append("</h3><ol>");
        int i = 0;
        while (i < activeJobs.size()) {
            j = (Job)activeJobs.get(i);
            buf.append("<li>(").append(this._t("started {0} ago", DataHelper.formatDuration2((long)(now - j.getTiming().getStartAfter())))).append("): ");
            buf.append(j.toString()).append("</li>\n");
            ++i;
        }
        buf.append("</ol>\n");
        buf.append("<h3 id=\"finishedjobs\">").append(this._t("Just finished jobs")).append(": ").append(justFinishedJobs.size()).append("</h3><ol>");
        i = 0;
        while (i < justFinishedJobs.size()) {
            j = (Job)justFinishedJobs.get(i);
            buf.append("<li>(").append(this._t("finished {0} ago", DataHelper.formatDuration2((long)(now - j.getTiming().getActualEnd())))).append("): ");
            buf.append(j.toString()).append("</li>\n");
            ++i;
        }
        buf.append("</ol>\n");
        buf.append("<h3 id=\"readyjobs\">").append(this._t("Ready/waiting jobs")).append(": ").append(readyJobs.size()).append("</h3><ol>");
        ObjectCounter counter = new ObjectCounter();
        int i2 = 0;
        while (i2 < readyJobs.size()) {
            Job j2 = (Job)readyJobs.get(i2);
            counter.increment((Object)j2.getName());
            if (i2 < 50) {
                buf.append("<li>[waiting ");
                buf.append(DataHelper.formatDuration2((long)(now - j2.getTiming().getStartAfter())));
                buf.append("]: ");
                buf.append(j2.toString()).append("</li>\n");
            }
            ++i2;
        }
        buf.append("</ol>\n");
        this.getJobCounts(buf, (ObjectCounter<String>)counter);
        out.write(buf.toString());
        buf.setLength(0);
        buf.append("<h3 id=\"scheduledjobs\">").append(this._t("Scheduled jobs")).append(": ").append(timedJobs.size()).append("</h3><ol>");
        long prev = Long.MIN_VALUE;
        counter.clear();
        int i3 = 0;
        while (i3 < timedJobs.size()) {
            Job j3 = (Job)timedJobs.get(i3);
            counter.increment((Object)j3.getName());
            if (i3 < 50) {
                long time = j3.getTiming().getStartAfter() - now;
                buf.append("<li>").append(this._t("{0} will start in {1}", j3.getName(), DataHelper.formatDuration2((long)time)));
                if (time < 0L) {
                    buf.append(" <b>DELAYED</b>");
                }
                if (time < prev) {
                    buf.append(" <b>** OUT OF ORDER **</b>");
                }
                prev = time;
                buf.append("</li>\n");
            }
            ++i3;
        }
        buf.append("</ol></div>\n");
        this.getJobCounts(buf, (ObjectCounter<String>)counter);
        out.write(buf.toString());
        buf.setLength(0);
        buf.append("<h3 id=\"totaljobstats\">").append(this._t("Total Job Statistics")).append("</h3>\n");
        this.getJobStats(buf);
        out.write(buf.toString());
    }

    private void getJobCounts(StringBuilder buf, ObjectCounter<String> counter) {
        ArrayList names = new ArrayList(counter.objects());
        if (names.size() < 4) {
            return;
        }
        buf.append("<table id=\"schedjobs\" style=\"width: 30%; margin-left: 100px;\">\n<tr><th>").append(this._t("Job")).append("</th><th>").append(this._t("Queued")).append("</th></tr>\n");
        Collections.sort(names, new JobCountComparator(counter));
        for (String name : names) {
            buf.append("<tr><td>").append(name).append("</td><td align=\"center\">").append(counter.count((Object)name)).append("</td></tr>\n");
        }
        buf.append("</table>\n");
    }

    private void getJobStats(StringBuilder buf) {
        buf.append("<div class=\"widescroll\"><table id=\"jobstats\">\n<tr><th>").append(this._t("Job")).append("</th><th>").append(this._t("Runs")).append("</th><th>").append(this._t("Dropped")).append("</th><th>").append(this._t("Time")).append("</th><th><i>").append(this._t("Avg")).append("</i></th><th><i>").append(this._t("Max")).append("</i></th><th><i>").append(this._t("Min")).append("</i></th><th>").append(this._t("Pending")).append("</th><th><i>").append(this._t("Avg")).append("</i></th><th><i>").append(this._t("Max")).append("</i></th><th><i>").append(this._t("Min")).append("</i></th></tr>\n");
        long totRuns = 0L;
        long totDropped = 0L;
        long totExecTime = 0L;
        long avgExecTime = 0L;
        long maxExecTime = -1L;
        long minExecTime = -1L;
        long totPendingTime = 0L;
        long avgPendingTime = 0L;
        long maxPendingTime = -1L;
        long minPendingTime = -1L;
        ArrayList tstats = new ArrayList(this._context.jobQueue().getJobStats());
        Collections.sort(tstats, new JobStatsComparator());
        for (JobStats stats : tstats) {
            buf.append("<tr>");
            buf.append("<td><b>").append(stats.getName()).append("</b></td>");
            buf.append("<td align=\"right\">").append(stats.getRuns()).append("</td>");
            buf.append("<td align=\"right\">").append(stats.getDropped()).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)stats.getTotalTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((double)stats.getAvgTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)stats.getMaxTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)stats.getMinTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)stats.getTotalPendingTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((double)stats.getAvgPendingTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)stats.getMaxPendingTime())).append("</td>");
            buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)stats.getMinPendingTime())).append("</td>");
            buf.append("</tr>\n");
            totRuns += stats.getRuns();
            totDropped += stats.getDropped();
            totExecTime += stats.getTotalTime();
            if (stats.getMaxTime() > maxExecTime) {
                maxExecTime = stats.getMaxTime();
            }
            if (minExecTime < 0L || minExecTime > stats.getMinTime()) {
                minExecTime = stats.getMinTime();
            }
            totPendingTime += stats.getTotalPendingTime();
            if (stats.getMaxPendingTime() > maxPendingTime) {
                maxPendingTime = stats.getMaxPendingTime();
            }
            if (minPendingTime >= 0L && minPendingTime <= stats.getMinPendingTime()) continue;
            minPendingTime = stats.getMinPendingTime();
        }
        if (totRuns != 0L) {
            if (totExecTime != 0L) {
                avgExecTime = totExecTime / totRuns;
            }
            if (totPendingTime != 0L) {
                avgPendingTime = totPendingTime / totRuns;
            }
        }
        buf.append("<tr class=\"tablefooter\">");
        buf.append("<td><b>").append(this._t("Summary")).append("</b></td>");
        buf.append("<td align=\"right\">").append(totRuns).append("</td>");
        buf.append("<td align=\"right\">").append(totDropped).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)totExecTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)avgExecTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)maxExecTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)minExecTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)totPendingTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)avgPendingTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)maxPendingTime)).append("</td>");
        buf.append("<td align=\"right\">").append(DataHelper.formatDuration2((long)minPendingTime)).append("</td>");
        buf.append("</tr></table></div>\n");
    }

    private static class JobCountComparator
    implements Comparator<String>,
    Serializable {
        private final ObjectCounter<String> _counter;

        public JobCountComparator(ObjectCounter<String> counter) {
            this._counter = counter;
        }

        @Override
        public int compare(String l, String r) {
            int rc;
            int lc = this._counter.count((Object)l);
            if (lc > (rc = this._counter.count((Object)r))) {
                return -1;
            }
            if (lc < rc) {
                return 1;
            }
            return l.compareTo(r);
        }
    }

    private static class JobStatsComparator
    implements Comparator<JobStats>,
    Serializable {
        private JobStatsComparator() {
        }

        @Override
        public int compare(JobStats l, JobStats r) {
            return l.getName().compareTo(r.getName());
        }
    }
}

