/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.router.web.HelperBase;
import net.i2p.servlet.util.WriterOutputStream;

public class StatHelper
extends HelperBase {
    private String _peer;

    public void setPeer(String peer) {
        this._peer = peer;
    }

    public String getProfile() {
        if (this._peer == null || this._peer.length() <= 0) {
            return "No peer specified";
        }
        if (this._peer.length() >= 44) {
            return this.outputProfile();
        }
        Set peers = this._context.profileOrganizer().selectAllPeers();
        for (Hash peer : peers) {
            if (!peer.toBase64().startsWith(this._peer)) continue;
            return this.dumpProfile(peer);
        }
        return "Unknown peer " + this._peer;
    }

    private String outputProfile() {
        Hash peer = new Hash();
        try {
            peer.fromBase64(this._peer);
            return this.dumpProfile(peer);
        }
        catch (DataFormatException dfe) {
            return "Bad peer hash " + this._peer;
        }
    }

    private String dumpProfile(Hash peer) {
        block3: {
            try {
                WriterOutputStream wos = new WriterOutputStream(this._out);
                boolean success = this._context.profileOrganizer().exportProfile(peer, (OutputStream)wos);
                if (!success) break block3;
                wos.flush();
                this._out.flush();
                return "";
            }
            catch (IOException e) {
                e.printStackTrace();
                return "IO Error " + e;
            }
        }
        return "Unknown peer " + this._peer;
    }
}

