/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.IOException;
import java.io.Writer;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;
import net.i2p.stat.Frequency;
import net.i2p.stat.FrequencyStat;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;

public class StatsGenerator {
    private final RouterContext _context;
    static final Map<String, String> groupNames;
    private static final DecimalFormat _fmt;
    private static final DecimalFormat _pct;

    static {
        String[] groups = new String[]{"BandwidthLimiter", StatsGenerator._x("Bandwidth Limiter"), "ClientMessages", StatsGenerator._x("Client Messages"), "i2cp", StatsGenerator._x("I2CP"), "I2PTunnel", StatsGenerator._x("Hidden Services Manager"), "InNetPool", StatsGenerator._x("Inbound Messages"), "JobQueue", StatsGenerator._x("Job Queue"), "NetworkDatabase", StatsGenerator._x("Network Database"), "ntcp", StatsGenerator._x("NTCP"), "Throttle", StatsGenerator._x("Router Limiter"), "udp", StatsGenerator._x("UDP")};
        groupNames = new HashMap<String, String>(groups.length / 2);
        int i = 0;
        while (i < groups.length) {
            groupNames.put(groups[i], groups[i + 1]);
            i += 2;
        }
        _fmt = new DecimalFormat("###,##0.0##");
        _pct = new DecimalFormat("#0.00%");
    }

    public StatsGenerator(RouterContext context) {
        this._context = context;
    }

    public void generateStatsPage(Writer out, boolean showAll) throws IOException {
        StringBuilder buf = new StringBuilder(16384);
        buf.append("<div class=\"joblog\">\n");
        buf.append("<p id=\"gatherstats\">");
        buf.append(this._t("Statistics gathered during this router's uptime")).append(" (");
        long uptime = this._context.router().getUptime();
        buf.append(DataHelper.formatDuration2((long)uptime));
        buf.append(").  ").append(this._t("The data gathered is quantized over a 1 minute period, so should just be used as an estimate."));
        buf.append(' ').append(this._t("These statistics are primarily used for development and debugging."));
        buf.append("</p>");
        buf.append("<form action=\"\"><b>");
        buf.append(this._t("Jump to section")).append(":</b> <select class=\"onchange\">");
        out.write(buf.toString());
        buf.setLength(0);
        Map unsorted = this._context.statManager().getStatsByGroup();
        TreeMap groups = new TreeMap(new AlphaComparator());
        groups.putAll(unsorted);
        for (String string : groups.keySet()) {
            buf.append("<option value=\"#").append(string).append("\">");
            buf.append(this.translateGroup(string)).append("</option>\n");
        }
        buf.append("</select> <input type=\"submit\" value=\"").append(this._t("GO")).append("\" />");
        buf.append("</form>");
        out.write(buf.toString());
        buf.setLength(0);
        for (Map.Entry entry : groups.entrySet()) {
            String group = (String)entry.getKey();
            Set stats = (Set)entry.getValue();
            buf.append("<h3 class=\"stats\"><a name=\"");
            buf.append(group);
            buf.append("\">");
            buf.append(this.translateGroup(group));
            buf.append("</a></h3>");
            buf.append("<ul class=\"statlist\">");
            out.write(buf.toString());
            buf.setLength(0);
            for (String stat : stats) {
                buf.append("<li class=\"statsName\"><b><a name=\"");
                buf.append(stat);
                buf.append("\">");
                buf.append(stat);
                buf.append("</a>:</b>&nbsp;");
                if (this._context.statManager().isFrequency(stat)) {
                    this.renderFrequency(stat, buf);
                } else {
                    this.renderRate(stat, buf, showAll);
                }
                out.write(buf.toString());
                buf.setLength(0);
            }
            out.write("</ul><br>\n");
        }
        out.write("</div>");
        out.flush();
    }

    private void renderFrequency(String name, StringBuilder buf) {
        FrequencyStat freq = this._context.statManager().getFrequency(name);
        buf.append("<i>");
        buf.append(freq.getDescription());
        buf.append("</i><br>");
        if (freq.getEventCount() <= 0L) {
            buf.append("<ul><li class=\"noevents\">").append(this._t("No lifetime events")).append("</li></ul>\n");
            return;
        }
        long uptime = this._context.router().getUptime();
        long[] periods = freq.getPeriods();
        Arrays.sort(periods);
        buf.append("<ul>");
        int i = 0;
        while (i < periods.length) {
            if (periods[i] > uptime) break;
            buf.append("<li>");
            StatsGenerator.renderPeriod(buf, periods[i], this._t("frequency"));
            Frequency curFreq = freq.getFrequency(periods[i]);
            buf.append(DataHelper.formatDuration2((long)Math.round(curFreq.getAverageInterval())));
            buf.append("; ");
            buf.append(this._t("Rolling average events per period"));
            buf.append(": ");
            buf.append(StatsGenerator.num(curFreq.getAverageEventsPerPeriod()));
            buf.append("; ");
            buf.append(this._t("Highest events per period"));
            buf.append(": ");
            buf.append(StatsGenerator.num(curFreq.getMaxAverageEventsPerPeriod()));
            buf.append("; ");
            buf.append(this._t("Lifetime average events per period")).append(": ");
            buf.append(StatsGenerator.num(curFreq.getStrictAverageEventsPerPeriod()));
            buf.append("</li>\n");
            ++i;
        }
        buf.append("<li><b>").append(this._t("Lifetime average frequency")).append(":</b> ");
        buf.append(DataHelper.formatDuration2((long)freq.getFrequency()));
        buf.append(" (");
        buf.append(this.ngettext("1 event", "{0} events", (int)freq.getEventCount()));
        buf.append(")</li></ul><br>\n");
    }

    private void renderRate(String name, StringBuilder buf, boolean showAll) {
        RateStat rate = this._context.statManager().getRate(name);
        String d = rate.getDescription();
        if (!"".equals(d)) {
            buf.append("<span class=\"statsLongName\"><i>");
            buf.append(d);
            buf.append("</i></span><br>");
        }
        if (rate.getLifetimeEventCount() <= 0L) {
            buf.append("<ul><li class=\"noevents\">").append(this._t("No lifetime events")).append("</li></ul>\n");
            return;
        }
        long now = this._context.clock().now();
        long[] periods = rate.getPeriods();
        Arrays.sort(periods);
        buf.append("<ul>");
        int i = 0;
        while (i < periods.length) {
            Rate curRate = rate.getRate(periods[i]);
            if (curRate.getLastCoalesceDate() <= curRate.getCreationDate()) break;
            buf.append("<li>");
            StatsGenerator.renderPeriod(buf, periods[i], this._t("rate"));
            if (curRate.getLastEventCount() > 0L) {
                buf.append(this._t("Average")).append(": ");
                buf.append(StatsGenerator.num(curRate.getAverageValue()));
                buf.append("; ");
                buf.append(this._t("Highest average"));
                buf.append(": ");
                buf.append(StatsGenerator.num(curRate.getExtremeAverageValue()));
                buf.append(". ");
                if (showAll) {
                    buf.append("Highest total in a period: ");
                    buf.append(StatsGenerator.num(curRate.getExtremeTotalValue()));
                    buf.append(". ");
                }
                if (showAll && curRate.getLifetimeTotalEventTime() > 0L) {
                    buf.append("Saturation: ");
                    buf.append(StatsGenerator.pct(curRate.getLastEventSaturation()));
                    buf.append("; Saturated limit: ");
                    buf.append(StatsGenerator.num(curRate.getLastSaturationLimit()));
                    buf.append("; Peak saturation: ");
                    buf.append(StatsGenerator.pct(curRate.getExtremeEventSaturation()));
                    buf.append("; Peak saturated limit: ");
                    buf.append(StatsGenerator.num(curRate.getExtremeSaturationLimit()));
                    buf.append(". ");
                }
                buf.append("<span class=\"nowrap\">");
                buf.append(this.ngettext("There was 1 event in this period.", "There were {0} events in this period.", (int)curRate.getLastEventCount()));
                buf.append("</span> <span class=\"nowrap\">");
                buf.append(this._t("The period ended {0} ago.", DataHelper.formatDuration2((long)(now - curRate.getLastCoalesceDate()))));
                buf.append("</span>");
            } else {
                buf.append(" <i>").append(this._t("No events")).append(" </i>");
            }
            long numPeriods = curRate.getLifetimePeriods();
            if (numPeriods > 0L) {
                double avgFrequency = (double)curRate.getLifetimeEventCount() / (double)numPeriods;
                buf.append("&nbsp;<span class=\"nowrap\">(").append(this._t("Average event count")).append(": ");
                buf.append(StatsGenerator.num(avgFrequency));
                buf.append("; ").append(this._t("Events in peak period")).append(": ");
                buf.append(curRate.getExtremeEventCount());
                buf.append(")</span>");
            }
            if (curRate.getSummaryListener() != null) {
                buf.append("<br><span class=\"statsViewGraphs\"><a href=\"graph?stat=").append(name).append('.').append(periods[i]);
                buf.append("&amp;w=600&amp;h=200\">").append(this._t("Graph Data")).append("</a> - ");
                buf.append(" <a href=\"graph?stat=").append(name).append('.').append(periods[i]);
                buf.append("&amp;w=600&amp;h=200&amp;showEvents=true\">").append(this._t("Graph Event Count")).append("</a></span>");
            }
            buf.append("</li>\n");
            ++i;
        }
        buf.append("<li><b>").append(this._t("Lifetime average value")).append(":</b> ");
        buf.append(StatsGenerator.num(rate.getLifetimeAverageValue()));
        buf.append(" (");
        buf.append(this.ngettext("1 event", "{0} events", (int)rate.getLifetimeEventCount()));
        buf.append(")<br></li></ul><br>\n");
    }

    private static void renderPeriod(StringBuilder buf, long period, String name) {
        buf.append("<b>");
        buf.append(DataHelper.formatDuration2((long)period));
        buf.append(" ");
        buf.append(name);
        buf.append(":</b> ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String num(double num) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format(num);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String pct(double num) {
        DecimalFormat decimalFormat = _pct;
        synchronized (decimalFormat) {
            return _pct.format(num);
        }
    }

    private String translateGroup(String group) {
        String disp = groupNames.get(group);
        if (disp != null) {
            group = disp;
        }
        return this._t(group);
    }

    private String _t(String s) {
        return Messages.getString(s, (I2PAppContext)this._context);
    }

    private String _t(String s, Object o) {
        return Messages.getString(s, o, (I2PAppContext)this._context);
    }

    private String ngettext(String s, String p, int n) {
        return Messages.getString(n, s, p, (I2PAppContext)this._context);
    }

    private static String _x(String s) {
        return s;
    }

    private class AlphaComparator
    implements Comparator<String> {
        private AlphaComparator() {
        }

        @Override
        public int compare(String lhs, String rhs) {
            String lname = StatsGenerator.this.translateGroup(lhs);
            String rname = StatsGenerator.this.translateGroup(rhs);
            return Collator.getInstance().compare(lname, rname);
        }
    }
}

