/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.Collator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientAppManager;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.news.NewsEntry;
import net.i2p.router.news.NewsManager;
import net.i2p.router.web.CSSHelper;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NavHelper;
import net.i2p.router.web.NewsHelper;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.helpers.SummaryHelper;
import net.i2p.util.PortMapper;
import net.i2p.util.SystemVersion;

class SummaryBarRenderer {
    static final String[] ALL_SECTIONS = new String[]{"HelpAndFAQ", "I2PServices", "I2PInternals", "RouterInfo", "ShortRouterInfo", "AdvancedRouterInfo", "MemoryBar", "NetworkReachability", "UpdateStatus", "RestartStatus", "Peers", "PeersAdvanced", "FirewallAndReseedStatus", "Bandwidth", "BandwidthGraph", "Tunnels", "Congestion", "TunnelStatus", "Destinations", "NewsHeadings", "Advanced"};
    static final Map<String, String> SECTION_NAMES;
    private final RouterContext _context;
    private final SummaryHelper _helper;

    static {
        HashMap<String, String> aMap = new HashMap<String, String>();
        aMap.put("HelpAndFAQ", SummaryBarRenderer._x("Help &amp; FAQ"));
        aMap.put("I2PServices", SummaryBarRenderer._x("I2P Services"));
        aMap.put("I2PInternals", SummaryBarRenderer._x("I2P Internals"));
        aMap.put("RouterInfo", SummaryBarRenderer._x("Router Information"));
        aMap.put("ShortRouterInfo", SummaryBarRenderer._x("Router Information (brief)"));
        aMap.put("AdvancedRouterInfo", SummaryBarRenderer._x("Router Information (advanced)"));
        aMap.put("MemoryBar", SummaryBarRenderer._x("Memory Usage Bar"));
        aMap.put("NetworkReachability", SummaryBarRenderer._x("Network Reachability"));
        aMap.put("UpdateStatus", SummaryBarRenderer._x("Update Status"));
        aMap.put("RestartStatus", SummaryBarRenderer._x("Restart Status"));
        aMap.put("Peers", SummaryBarRenderer._x("Peers"));
        aMap.put("PeersAdvanced", SummaryBarRenderer._x("Peers (advanced)"));
        aMap.put("FirewallAndReseedStatus", SummaryBarRenderer._x("Firewall &amp; Reseed Status"));
        aMap.put("Bandwidth", SummaryBarRenderer._x("Bandwidth"));
        aMap.put("BandwidthGraph", SummaryBarRenderer._x("Bandwidth Graph"));
        aMap.put("Tunnels", SummaryBarRenderer._x("Tunnels"));
        aMap.put("Congestion", SummaryBarRenderer._x("Congestion"));
        aMap.put("TunnelStatus", SummaryBarRenderer._x("Tunnel Status"));
        aMap.put("Destinations", SummaryBarRenderer._x("Local Tunnels"));
        aMap.put("NewsHeadings", SummaryBarRenderer._x("News &amp; Updates"));
        aMap.put("Advanced", SummaryBarRenderer._x("Advanced Links"));
        SECTION_NAMES = Collections.unmodifiableMap(aMap);
    }

    public SummaryBarRenderer(RouterContext context, SummaryHelper helper) {
        this._context = context;
        this._helper = helper;
    }

    public void renderSummaryHTML(Writer out) throws IOException {
        String requestURI = this._helper.getRequestURI();
        String page = requestURI.replace("/", "").replace(".jsp", "");
        List<String> sections = this._helper.getSummaryBarSections(page);
        String restartStatus = sections.contains("RestartStatus") ? this.renderRestartStatusHTML() : null;
        StringBuilder buf = new StringBuilder(1024);
        for (String section : sections) {
            buf.setLength(0);
            buf.append("<hr>\n");
            if ("HelpAndFAQ".equals(section)) {
                buf.append(this.renderHelpAndFAQHTML());
            } else if ("I2PServices".equals(section)) {
                buf.append(this.renderI2PServicesHTML());
            } else if ("I2PInternals".equals(section)) {
                buf.append(this.renderI2PInternalsHTML());
            } else if ("Advanced".equals(section)) {
                buf.append(this.renderAdvancedHTML());
            } else if ("RouterInfo".equals(section) || "General".equals(section)) {
                buf.append(this.renderRouterInfoHTML());
            } else if ("ShortRouterInfo".equals(section) || "ShortGeneral".equals(section)) {
                buf.append(this.renderShortRouterInfoHTML());
            } else if ("AdvancedRouterInfo".equals(section)) {
                buf.append(this.renderAdvancedRouterInfoHTML());
            } else if ("MemoryBar".equals(section)) {
                buf.append(this.renderMemoryBarHTML());
            } else if ("NetworkReachability".equals(section)) {
                buf.append(this.renderNetworkReachabilityHTML());
            } else if ("UpdateStatus".equals(section)) {
                buf.append(this.renderUpdateStatusHTML());
            } else if ("RestartStatus".equals(section)) {
                buf.append(restartStatus);
            } else if ("Peers".equals(section)) {
                buf.append(this.renderPeersHTML());
            } else if ("PeersAdvanced".equals(section)) {
                buf.append(this.renderPeersAdvancedHTML());
            } else if ("FirewallAndReseedStatus".equals(section)) {
                buf.append(this.renderFirewallAndReseedStatusHTML());
            } else if ("Bandwidth".equals(section)) {
                buf.append(this.renderBandwidthHTML());
            } else if ("BandwidthGraph".equals(section)) {
                buf.append(this.renderBandwidthGraphHTML());
            } else if ("Tunnels".equals(section)) {
                buf.append(this.renderTunnelsHTML());
            } else if ("Congestion".equals(section)) {
                buf.append(this.renderCongestionHTML());
            } else if ("TunnelStatus".equals(section)) {
                buf.append(this.renderTunnelStatusHTML());
            } else if ("Destinations".equals(section)) {
                buf.append(this.renderDestinationsHTML());
            } else if ("NewsHeadings".equals(section)) {
                buf.append(this.renderNewsHeadingsHTML());
            }
            if (buf.length() <= 5) continue;
            out.write(buf.toString());
        }
    }

    public String renderHelpAndFAQHTML() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3 id=\"helpfaq\"><a href=\"/help\" target=\"_top\" title=\"").append(this._t("I2P Router Help &amp; FAQ")).append("\">").append(this._t("Help &amp; FAQ")).append("</a></h3><hr class=\"b\">\n<table id=\"sb_help\"><tr><td>");
        TreeMap<Object, String> svcs = new TreeMap<Object, String>(Collator.getInstance());
        StringBuilder rbuf = new StringBuilder(128);
        String tx = this._t("Changelog");
        rbuf.append("<a href=\"/viewhistory\" target=\"_top\" title=\"").append(this._t("Recent development changes to the router")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("FAQ");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/help#faq\" target=\"_top\" title=\"").append(this._t("A shortened version of the official Frequently Asked Questions")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Legal");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/viewlicense\" target=\"_top\" title=\"").append(this._t("Information regarding software and licenses used by I2P")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Reachability");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/help#reachability\" target=\"_top\" title=\"").append(this._t("A short guide to the sidebar's network reachability notification")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Setup");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/welcome\" target=\"_top\" title=\"").append(this._t("New Install Wizard")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Sidebar");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/help#sidebarhelp\" target=\"_top\" title=\"").append(this._t("An introduction to the router sidebar")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Troubleshoot");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/console#trouble\" target=\"_top\" title=\"").append(this._t("Troubleshooting &amp; Further Assistance")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        for (String row : svcs.values()) {
            buf.append(row);
        }
        buf.append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderI2PServicesHTML() {
        Map<String, String> apps;
        String url;
        String tx;
        TreeMap<Object, String> svcs = new TreeMap<Object, String>(Collator.getInstance());
        StringBuilder rbuf = new StringBuilder(128);
        PortMapper pm = this._context.portMapper();
        if (pm.isRegistered("susimail")) {
            tx = this._t("Email");
            rbuf.append("<tr><td><img src=\"/themes/console/light/images/inbox.png\" height=\"16\" width=\"16\" alt=\"\"></td><td align=\"left\"><a href=\"/webmail\" target=\"_top\" title=\"").append(this._t("Anonymous webmail client")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a></td></tr>\n");
            svcs.put(tx, rbuf.toString());
        }
        if (pm.isRegistered("jsonrpc")) {
            tx = this._t("I2PControl");
            rbuf.setLength(0);
            rbuf.append("<tr><td><img src=\"/themes/console/images/plugin.png\" height=\"16\" width=\"16\" alt=\"\"></td><td align=\"left\"><a href=\"/jsonrpc/\" target=\"_top\" title=\"").append(this._t("RPC Service")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a></td></tr>\n");
            svcs.put(tx, rbuf.toString());
        }
        if (pm.isRegistered("i2psnark")) {
            tx = this._t("Torrents");
            rbuf.setLength(0);
            rbuf.append("<tr><td><img src=\"/themes/console/images/i2psnark.png\" height=\"16\" width=\"16\" alt=\"\"></td><td align=\"left\"><a href=\"/torrents\" target=\"_top\" title=\"").append(this._t("Built-in anonymous BitTorrent Client")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a></td></tr>\n");
            svcs.put(tx, rbuf.toString());
        }
        if ((url = SummaryBarRenderer.getEepsiteURL(pm)) != null) {
            String tx2 = this._t("Web Server");
            rbuf.setLength(0);
            rbuf.append("<tr><td><img src=\"/themes/console/images/server.png\" height=\"16\" width=\"16\" alt=\"\"></td><td align=\"left\"><a href=\"").append(url).append("\" target=\"_blank\" title=\"").append(this._t("Local web server")).append("\">").append(SummaryBarRenderer.nbsp(tx2)).append("</a></td></tr>\n");
            svcs.put(tx2, rbuf.toString());
        }
        if ((apps = NavHelper.getClientAppLinks()) != null) {
            svcs.putAll(apps);
        }
        if (!svcs.isEmpty()) {
            StringBuilder buf = new StringBuilder(128 * svcs.size());
            buf.append("<h3><a href=\"/configclients\" target=\"_top\" title=\"").append(this._t("Configure startup of clients and webapps (services); manually start dormant services")).append("\">").append(this._t("I2P Services")).append("</a></h3>\n<hr class=\"b\"><table id=\"sb_services\">");
            for (String row : svcs.values()) {
                buf.append(row);
            }
            buf.append("</table>\n");
            return buf.toString();
        }
        return "";
    }

    static String getEepsiteURL(PortMapper pm) {
        String svc;
        int port = pm.getPort("eepsite");
        int sslPort = pm.getPort("https_eepsite");
        if (port <= 0 && sslPort <= 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder(32);
        if (sslPort > 0) {
            buf.append("https://");
            svc = "https_eepsite";
            port = sslPort;
        } else {
            buf.append("http://");
            svc = "eepsite";
        }
        String host = pm.getActualHost(svc, "127.0.0.1");
        if (host.contains(":")) {
            buf.append('[');
        }
        buf.append(host);
        if (host.contains(":")) {
            buf.append(']');
        }
        buf.append(':').append(port).append('/');
        return buf.toString();
    }

    public String renderI2PInternalsHTML() {
        String tx;
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/config\" target=\"_top\" title=\"").append(this._t("Configure I2P Router")).append("\">").append(this._t("I2P Internals")).append("</a></h3><hr class=\"b\">\n<table id=\"sb_internals\"><tr><td>\n");
        TreeMap<Object, String> svcs = new TreeMap<Object, String>(Collator.getInstance());
        StringBuilder rbuf = new StringBuilder(128);
        PortMapper pm = this._context.portMapper();
        if (pm.isRegistered("susidns")) {
            tx = this._t("Addressbook");
            rbuf.append("<a href=\"/dns\" target=\"_top\" title=\"").append(this._t("Manage your I2P hosts file here (I2P domain name resolution)")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
            svcs.put(tx, rbuf.toString());
        }
        if (!StatSummarizer.isDisabled((I2PAppContext)this._context)) {
            tx = this._t("Graphs");
            rbuf.setLength(0);
            rbuf.append("<a href=\"/graphs\" target=\"_top\" title=\"").append(this._t("Graph router performance")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
            svcs.put(tx, rbuf.toString());
        }
        tx = this._t("Help");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/help\" target=\"_top\" title=\"").append(this._t("Router Help and FAQ")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        if (pm.isRegistered("i2ptunnel")) {
            tx = this._t("Hidden Services Manager");
            rbuf.setLength(0);
            rbuf.append("<a href=\"/i2ptunnelmgr\" target=\"_top\" title=\"").append(this._t("Local Tunnels")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
            svcs.put(tx, rbuf.toString());
        }
        tx = this._t("Logs");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/logs\" target=\"_top\" title=\"").append(this._t("Health Report")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("NetDB");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/netdb\" target=\"_top\" title=\"").append(this._t("Show list of all known I2P routers")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Peers");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/peers\" target=\"_top\" title=\"").append(this._t("Show all current peer connections")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Profiles");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/profiles\" target=\"_top\" title=\"").append(this._t("Show recent peer performance profiles")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Tunnels");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/tunnels\" target=\"_top\" title=\"").append(this._t("View existing tunnels and tunnel build status")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        for (String row : svcs.values()) {
            buf.append(row);
        }
        buf.append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderAdvancedHTML() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3 id=\"advanced\"><a title=\"").append(this._t("Advanced Configuration")).append("\" href=\"/configadvanced\" target=\"_top\">").append(this._t("Advanced")).append("</a></h3>\n").append("<hr class=\"b\"><table id=\"sb_advanced\"><tr><td>");
        TreeMap<Object, String> svcs = new TreeMap<Object, String>(Collator.getInstance());
        StringBuilder rbuf = new StringBuilder(128);
        String tx = this._t("Certs");
        rbuf.append("<a target=\"_top\" title=\"").append(this._t("Review active encryption certificates used in console")).append("\" href=\"/certs\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Changelog");
        rbuf.setLength(0);
        rbuf.append("<a title=\"").append(this._t("View full changelog")).append("\" href=\"/viewhistory\" target=\"_blank\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Debug");
        rbuf.setLength(0);
        rbuf.append("<a title=\"").append(this._t("View router debug information")).append("\" href=\"/debug\" target=\"_top\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Events");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/events?from=604800\" target=\"_top\" title=\"").append(this._t("View historical log of router events")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Jars");
        rbuf.setLength(0);
        rbuf.append("<a title=\"").append(this._t("Review extended info about installed .jar and .war files")).append("\" href=\"/jars\" target=\"_top\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        File javadoc = new File(this._context.getBaseDir(), "docs/javadoc/index.html");
        if (javadoc.exists()) {
            tx = "Javadoc";
            rbuf.setLength(0);
            rbuf.append("<a title=\"").append(this._t("Documentation for the I2P API")).append("\" href=\"/javadoc/index.html\" target=\"_blank\">Javadoc</a>\n");
            svcs.put(tx, rbuf.toString());
        }
        tx = this._t("Jobs");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/jobs\" target=\"_top\" title=\"").append(this._t("Show the router's workload, and how it's performing")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("LeaseSets");
        rbuf.setLength(0);
        rbuf.append("<a title=\"").append(this._t("View active leasesets (debug mode)")).append("\" href=\"/netdb?l=2\" target=\"_top\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("NetDB Search");
        rbuf.setLength(0);
        rbuf.append("<a title=\"").append(this._t("Network database search tool")).append("\" href=\"/netdb?f=4\" target=\"_top\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Proof");
        rbuf.setLength(0);
        rbuf.append("<a title=\"").append(this._t("Signed proof of ownership of this router")).append("\" href=\"/proof\" target=\"_top\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Stats");
        rbuf.setLength(0);
        rbuf.append("<a href=\"/stats\" target=\"_top\" title=\"").append(this._t("Textual router performance statistics")).append("\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        tx = this._t("Sybils");
        rbuf.setLength(0);
        rbuf.append("<a title=\"").append(this._t("Review possible sybils in network database")).append("\" href=\"/netdb?f=3\" target=\"_top\">").append(SummaryBarRenderer.nbsp(tx)).append("</a>\n");
        svcs.put(tx, rbuf.toString());
        for (String row : svcs.values()) {
            buf.append(row);
        }
        buf.append("</td></tr></table>");
        return buf.toString();
    }

    public String renderRouterInfoHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/netdb?r=.\" target=\"_top\" title=\"").append(this._t("Your Local Identity [{0}] is your unique I2P router identity, similar to an IP address but tailored to I2P. ", this._helper.getIdent())).append(this._t("Never disclose this to anyone, as it can reveal your real world IP.")).append("\">").append(this._t("Router Info")).append("</a></h3><hr class=\"b\">\n<table id=\"sb_general\"><tr title=\"").append(this._t("The version of the I2P software we are running")).append("\"><td align=\"left\"><b>").append(this._t("Version")).append(":</b></td><td align=\"right\">").append(this._helper.getVersion()).append("</td></tr>\n<tr title=\"").append(this._t("How long we've been running for this session")).append("\"><td align=\"left\"><b>").append(this._t("Uptime")).append(":</b></td><td align=\"right\">").append(this._helper.getUptime()).append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderShortRouterInfoHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<table id=\"sb_shortgeneral\"><tr title=\"").append(this._t("The version of the I2P software we are running")).append("\"><td align=\"left\"><b>").append(this._t("Version")).append(":</b></td><td align=\"right\">").append(this._helper.getVersion()).append("</td></tr>\n<tr title=\"").append(this._t("How long we've been running for this session")).append("\"><td align=\"left\"><b>").append(this._t("Uptime")).append(":</b></td><td align=\"right\">").append(this._helper.getUptime()).append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderAdvancedRouterInfoHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/netdb?r=.\" target=\"_top\" title=\"").append(this._t("Your Local Identity [{0}] is your unique I2P router identity, similar to an IP address but tailored to I2P. ", this._helper.getIdent())).append(this._t("Never disclose this to anyone, as it can reveal your real world IP.")).append("\">").append(this._t("Router Info")).append("</a></h3><hr class=\"b\">\n<table id=\"sb_advancedgeneral\"><tr title=\"").append(this._t("The version of the I2P software we are running")).append("\"><td align=\"left\"><b>").append(this._t("Version")).append(":</b></td><td align=\"right\">").append(this._helper.getVersion()).append("</td></tr>\n<tr title=\"").append(this._t("How long we've been running for this session")).append("\"><td align=\"left\"><b>").append(this._t("Uptime")).append(":</b></td><td align=\"right\">").append(this._helper.getUptime()).append("</td></tr>\n<tr title=\"").append(this._t("Difference between network-synced time and local time")).append("\"><td align=\"left\"><b>").append(this._t("Clock Skew")).append(":</b></td><td align=\"right\">").append(DataHelper.formatDuration2((long)this._context.clock().getOffset())).append("</td></tr>\n<tr title=\"").append(this._t("How much RAM I2P is using / total RAM available to I2P (excludes RAM allocated to the JVM)")).append("\"><td align=\"left\"><b>").append(this._t("Memory")).append(":</b></td><td align=\"right\">").append(this._helper.getMemory()).append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderMemoryBarHTML() {
        if (this._helper == null) {
            return "";
        }
        return this._helper.getMemoryBar();
    }

    public String renderNetworkReachabilityHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        SummaryHelper.NetworkStateMessage reachability = this._helper.getReachability();
        buf.append("<h4><span class=\"sb_netstatus ");
        switch (reachability.getState()) {
            case VMCOMM: {
                buf.append("vmcomm");
                break;
            }
            case CLOCKSKEW: {
                buf.append("clockskew");
                break;
            }
            case ERROR: {
                buf.append("error");
                break;
            }
            case WARN: {
                buf.append("warn");
                break;
            }
            case HIDDEN: {
                buf.append("hidden");
                break;
            }
            case FIREWALLED: {
                buf.append("firewalled");
                break;
            }
            case RUNNING: {
                buf.append("running");
                break;
            }
            default: {
                buf.append("testing");
            }
        }
        buf.append("\"><a href=\"/help#confignet\" target=\"_top\" title=\"").append(this._t("Help with configuring your firewall and router for optimal I2P performance")).append("\">").append(this._t("Network")).append(": ").append(reachability.getMessage()).append("</a></span></h4>\n");
        if (!SigType.ECDSA_SHA256_P256.isAvailable()) {
            buf.append("<hr>\n<h4><span class=\"warn\"><a href=\"http://trac.i2p2.i2p/wiki/Crypto/ECDSA");
            if ("ru".equals(Messages.getLanguage((I2PAppContext)this._context))) {
                buf.append("-ru");
            }
            buf.append("\" target=\"_top\" title=\"").append(this._t("See more information on the wiki")).append("\">").append(this._t("Warning: ECDSA is not available. Update your Java or OS")).append("</a></span></h4>\n");
        }
        if (!SystemVersion.isJava7()) {
            buf.append("<hr><h4><span class=\"warn\">").append(this._t("Warning: Java version {0} is no longer supported by I2P.", System.getProperty("java.version"))).append(' ').append(this._t("Update Java to version {0} or higher to receive I2P updates.", "7")).append("</span></h4>\n");
        }
        return buf.toString();
    }

    public String renderUpdateStatusHTML() {
        if (this._helper == null) {
            return "";
        }
        String updateStatus = this._helper.getUpdateStatus();
        if ("".equals(updateStatus)) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/configupdate\" target=\"_top\" title=\"").append(this._t("Configure I2P Updates")).append("\">").append(this._t("Update Status")).append("</a></h3><hr class=\"b\">\n");
        buf.append(updateStatus);
        return buf.toString();
    }

    public String renderRestartStatusHTML() {
        if (this._helper == null) {
            return "";
        }
        return this._helper.getRestartStatus();
    }

    public String renderPeersHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/peers\" target=\"_top\" title=\"").append(this._t("Show all current peer connections")).append("\">").append(this._t("Peers")).append("</a></h3><hr class=\"b\">\n<table id=\"sb_peers\">\n<tr title=\"").append(this._t("Peers we've been talking to in the last few minutes/last hour")).append("\"><td align=\"left\"><b>").append(this._t("Active")).append(":</b></td><td align=\"right\">");
        int active = this._helper.getActivePeers();
        buf.append(active).append(" / ").append(Math.max(active, this._helper.getActiveProfiles())).append("</td></tr>\n<tr title=\"").append(this._t("The number of peers available for building client tunnels")).append("\"><td align=\"left\"><b>").append(this._t("Fast")).append(":</b></td><td align=\"right\">").append(this._helper.getFastPeers()).append("</td></tr>\n<tr title=\"").append(this._t("The number of peers available for building exploratory tunnels")).append("\"><td align=\"left\"><b>").append(this._t("High capacity")).append(":</b></td><td align=\"right\">").append(this._helper.getHighCapacityPeers()).append("</td></tr>\n<tr title=\"").append(this._t("The number of peers available for network database inquiries")).append("\"><td align=\"left\"><b>").append(this._t("Integrated")).append(":</b></td><td align=\"right\">").append(this._helper.getWellIntegratedPeers()).append("</td></tr>\n<tr title=\"").append(this._t("The total number of peers in our network database")).append("\"><td align=\"left\"><b>").append(this._t("Known")).append(":</b></td><td align=\"right\">").append(this._helper.getAllPeers()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderPeersAdvancedHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/peers\" target=\"_top\" title=\"").append(this._t("Show all current peer connections")).append("\">").append(this._t("Peers")).append("</a></h3><hr class=\"b\">\n<table id=\"sb_peersadvanced\">\n<tr title=\"").append(this._t("Peers we've been talking to in the last few minutes/last hour")).append("\"><td align=\"left\"><b>").append(this._t("Active")).append(":</b></td><td align=\"right\">");
        int active = this._helper.getActivePeers();
        buf.append(active).append(" / ").append(Math.max(active, this._helper.getActiveProfiles())).append("</td></tr>\n<tr title=\"").append(this._t("The number of peers available for building client tunnels")).append("\"><td align=\"left\"><b>").append(this._t("Fast")).append(":</b></td><td align=\"right\">").append(this._helper.getFastPeers()).append("</td></tr>\n<tr title=\"").append(this._t("The number of peers available for building exploratory tunnels")).append("\"><td align=\"left\"><b>").append(this._t("High capacity")).append(":</b></td><td align=\"right\">").append(this._helper.getHighCapacityPeers()).append("</td></tr>\n<tr title=\"").append(this._t("The number of peers available for network database inquiries")).append("\"><td align=\"left\"><b>").append(this._t("Integrated")).append(":</b></td><td align=\"right\">").append(this._helper.getWellIntegratedPeers()).append("</td></tr>\n<tr title=\"").append(this._t("The total number of peers in our network database")).append("\"><td align=\"left\"><b>").append(this._t("Known")).append(":</b></td><td align=\"right\">").append(this._helper.getAllPeers()).append("</td></tr>\n<tr class=\"separator\"><td colspan=\"2\"><hr></td></tr><tr title=\"").append(this._t("The number of peers failing network tests")).append("\"><td align=\"left\"><a href=\"/profiles\"><b>").append(this._t("Failing")).append(":</b></a></td><td align=\"right\">").append(this._helper.getFailingPeers()).append("</td></tr>\n<tr title=\"").append(this._t("The number of banned peers")).append("\"><td align=\"left\"><a href=\"/profiles?f=3\"><b>").append(this._t("Banned")).append(":</b></a></td><td align=\"right\">").append(this._helper.getBanlistedPeers()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderFirewallAndReseedStatusHTML() {
        if (this._helper == null) {
            return "";
        }
        return this._helper.getFirewallAndReseedStatus();
    }

    public String renderBandwidthHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/config\" title=\"").append(this._t("Configure router bandwidth allocation")).append("\" target=\"_top\">").append(this._t("Bandwidth in/out")).append("</a></h3><hr class=\"b\"><table id=\"sb_bandwidth\">\n<tr><td align=\"left\"><b>").append(DataHelper.formatDuration2((long)3000L)).append(":</b></td><td align=\"right\">").append(this._helper.getSecondKBps()).append("Bps</td></tr>\n");
        if (this._context.router().getUptime() > 360000L) {
            buf.append("<tr><td align=\"left\"><b>").append(DataHelper.formatDuration2((long)300000L)).append(":</b></td><td align=\"right\">").append(this._helper.getFiveMinuteKBps()).append("Bps</td></tr>\n");
        }
        if (this._context.router().getUptime() > 120000L) {
            buf.append("<tr><td align=\"left\"><b>").append(this._t("Total")).append(":</b></td><td align=\"right\">").append(this._helper.getLifetimeKBps()).append("Bps</td></tr>\n");
        }
        buf.append("<tr><td align=\"left\"><b>").append(this._t("Used")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundTransferred()).append(" / ").append(this._helper.getOutboundTransferred()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderBandwidthGraphHTML() {
        if (this._helper == null) {
            return "";
        }
        if (StatSummarizer.isDisabled((I2PAppContext)this._context)) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<div id=\"sb_graphcontainer\"");
        String r = this._context.getProperty("routerconsole.summaryRefresh", "15");
        int refr = 60;
        try {
            refr = Integer.parseInt(r);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (refr >= 25) {
            buf.append("><script src=\"/js/refreshGraph.js?").append("0.9.48").append("\" type=\"text/javascript\" id=\"refreshGraph\" async></script>");
        } else {
            buf.append(" style=\"background-image: url(/viewstat.jsp?stat=bw.combined&amp;periodCount=20&amp;width=220&amp;height=50&amp;hideLegend=true&amp;hideGrid=true&amp;time=").append(this._context.clock().now() / 1000L).append("\">");
        }
        buf.append("<a href=\"/graphs\"><table id=\"sb_bandwidthgraph\"><tr title=\"").append(this._t("Our inbound &amp; outbound traffic for the last 20 minutes")).append("\"><td><span id=\"sb_graphstats\">").append(this._helper.getSecondKBps()).append("Bps</span></td></tr></table></a></div>\n");
        return buf.toString();
    }

    public String renderTunnelsHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/tunnels\" target=\"_top\" title=\"").append(this._t("View existing tunnels and tunnel build status")).append("\">").append(this._t("Tunnels")).append("</a></h3><hr class=\"b\"><table id=\"sb_tunnels\">\n<tr title=\"").append(this._t("Used for building and testing tunnels, and communicating with floodfill peers")).append("\"><td align=\"left\"><b>").append(this._t("Exploratory")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundTunnels() + this._helper.getOutboundTunnels()).append("</td></tr>\n<tr title=\"").append(this._t("Tunnels we are using to provide or access services on the network")).append("\"><td align=\"left\"><b>").append(this._t("Client")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundClientTunnels() + this._helper.getOutboundClientTunnels()).append("</td></tr>\n<tr title=\"").append(this._t("Tunnels we are participating in, directly contributing bandwidth to the network")).append("\"><td align=\"left\"><b>").append(this._t("Participating")).append(":</b></td><td align=\"right\">").append(this._helper.getParticipatingTunnels()).append("</td></tr>\n<tr title=\"").append(this._t("The ratio of tunnel hops we provide to tunnel hops we use - a value greater than 1.00 indicates a positive contribution to the network")).append("\"><td align=\"left\"><b>").append(this._t("Share ratio")).append(":</b></td><td align=\"right\">").append(this._helper.getShareRatio()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderCongestionHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/jobs\" target=\"_top\" title=\"").append(this._t("What's in the router's job queue?")).append("\">").append(this._t("Congestion")).append("</a></h3><hr class=\"b\"><table id=\"sb_queue\">\n<tr title=\"").append(this._t("Indicates router performance")).append("\"><td align=\"left\"><b>").append(this._t("Job lag")).append(":</b></td><td align=\"right\">").append(this._helper.getJobLag()).append("</td></tr>\n<tr title=\"").append(this._t("Indicates how quickly outbound messages to other I2P routers are sent")).append("\"><td align=\"left\"><b>").append(this._t("Message delay")).append(":</b></td><td align=\"right\">").append(this._helper.getMessageDelay()).append("</td></tr>\n");
        if (!this._context.getBooleanPropertyDefaultTrue("router.disableTunnelTesting")) {
            buf.append("<tr title=\"").append(this._t("Round trip time for a tunnel test")).append("\"><td align=\"left\"><b>").append(this._t("Tunnel lag")).append(":</b></td><td align=\"right\">").append(this._helper.getTunnelLag()).append("</td></tr>\n");
        }
        buf.append("<tr title=\"").append(this._t("Queued requests from other routers to participate in tunnels")).append("\"><td align=\"left\"><b>").append(this._t("Backlog")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundBacklog()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderTunnelStatusHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(50);
        buf.append("<h4><span class=\"tunnelBuildStatus\">").append(this._helper.getTunnelStatus()).append("</span></h4>\n");
        return buf.toString();
    }

    public String renderDestinationsHTML() {
        if (this._helper == null) {
            return "";
        }
        return this._helper.getDestinations();
    }

    public String renderNewsHeadingsHTML() {
        if (this._helper == null) {
            return "";
        }
        NewsHelper newshelper = this._helper.getNewsHelper();
        if (newshelper == null || newshelper.shouldShowNews()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        String consoleNonce = CSSHelper.getNonce();
        if (consoleNonce != null) {
            NewsManager nmgr;
            List<Object> entries = Collections.emptyList();
            ClientAppManager cmgr = this._context.clientAppManager();
            if (cmgr != null && (nmgr = (NewsManager)cmgr.getRegisteredApp("news")) != null) {
                entries = nmgr.getEntries();
            }
            if (!entries.isEmpty()) {
                int i = 0;
                String freq = this._context.getProperty("router.newsRefreshFrequency", ConfigUpdateHandler.DEFAULT_REFRESH_FREQUENCY);
                long ms = 129600000L;
                try {
                    ms = Long.parseLong(freq);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                int min = ms > 0L ? 1 : 0;
                int max = 3;
                long age = ms > 0L ? 5184000000L : 604800000L;
                long oldest = this._context.clock().now() - age;
                for (NewsEntry newsEntry : entries) {
                    if (i >= min && newsEntry.updated > 0L && newsEntry.updated < oldest) break;
                    if (i == 0) {
                        buf.append("<h3><a href=\"/news\">").append(this._t("News &amp; Updates")).append("</a></h3><hr class=\"b\"><div class=\"sb_newsheadings\">\n<table>\n");
                    }
                    buf.append("<tr><td><a href=\"/?news=1&amp;consoleNonce=").append(consoleNonce).append("\"");
                    if (newsEntry.updated > 0L) {
                        buf.append(" title=\"").append(this._t("Published")).append(": ").append(DataHelper.formatDate((long)newsEntry.updated)).append("\"");
                    }
                    buf.append(">");
                    buf.append(newsEntry.title).append("</a></td></tr>\n");
                    if (++i >= 3) break;
                }
                if (i > 0) {
                    buf.append("</table>\n</div>\n");
                }
            }
        }
        return buf.toString();
    }

    private static final String _x(String s) {
        return s;
    }

    private String _t(String s) {
        return Messages.getString(s, (I2PAppContext)this._context);
    }

    private String _t(String s, Object o) {
        return Messages.getString(s, o, (I2PAppContext)this._context);
    }

    private static String nbsp(String s) {
        if (s.length() <= 30) {
            return s.replace(" ", "&nbsp;");
        }
        return s;
    }
}

