/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.IOException;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.reseed.ReseedChecker;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.NewsHelper;
import net.i2p.router.web.helpers.ConfigRestartBean;
import net.i2p.router.web.helpers.SummaryBarRenderer;
import net.i2p.servlet.util.ServletUtil;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.SystemVersion;

public class SummaryHelper
extends HelperBase {
    static final String THINSP = " / ";
    private static final char S = ',';
    static final String PROP_SUMMARYBAR = "routerconsole.summaryBar.";
    static final String DEFAULT_FULL = "RouterInfo,UpdateStatus,Bandwidth,NetworkReachability,FirewallAndReseedStatus,I2PServices,I2PInternals,HelpAndFAQ,Peers,RestartStatus,Tunnels,TunnelStatus,Destinations,";
    static final String DEFAULT_FULL_ADVANCED = "AdvancedRouterInfo,MemoryBar,UpdateStatus,Bandwidth,NetworkReachability,FirewallAndReseedStatus,I2PServices,I2PInternals,Advanced,Peers,RestartStatus,Tunnels,TunnelStatus,Congestion,Destinations,";
    static final String DEFAULT_MINIMAL = "ShortRouterInfo,Bandwidth,UpdateStatus,NewsHeadings,NetworkReachability,FirewallAndReseedStatus,RestartStatus,Destinations,";
    static final String DEFAULT_MINIMAL_ADVANCED = "AdvancedRouterInfo,MemoryBar,Bandwidth,UpdateStatus,NewsHeadings,NetworkReachability,FirewallAndReseedStatus,RestartStatus,Destinations,";
    private NewsHelper _newshelper;
    private static final String SS = Character.toString(',');
    private String _action;
    private String _consoleNonce;
    private String _updateNonce;
    private String _requestURI;

    public String getIdent() {
        if (this._context == null) {
            return "[no router]";
        }
        if (this._context.routerHash() != null) {
            return this._context.routerHash().toBase64().substring(0, 4);
        }
        return "[unknown]";
    }

    public String getVersion() {
        return "0.9.48-0";
    }

    public String getUptime() {
        if (this._context == null) {
            return "[no router]";
        }
        Router router = this._context.router();
        if (router == null) {
            return "[not up]";
        }
        return DataHelper.formatDuration2((long)router.getUptime());
    }

    public boolean allowReseed() {
        return this._context.netDb().isInitialized() && this._context.netDb().getKnownRouters() < 50 || this._context.getBooleanProperty("i2p.alwaysAllowReseed");
    }

    public int getAllPeers() {
        return Math.max(this._context.netDb().getKnownRouters() - 1, 0);
    }

    public NetworkStateMessage getReachability() {
        return this.reachability();
    }

    private NetworkStateMessage reachability() {
        if (this._context.commSystem().isDummy()) {
            return new NetworkStateMessage(NetworkState.VMCOMM, "VM Comm System");
        }
        long skew = this._context.commSystem().getFramedAveragePeerClockSkew(33);
        if (Math.abs(skew) > 30000L) {
            return new NetworkStateMessage(NetworkState.CLOCKSKEW, this._t("ERR-Clock Skew of {0}", DataHelper.formatDuration2((long)Math.abs(skew))));
        }
        if (this._context.router().isHidden()) {
            return new NetworkStateMessage(NetworkState.HIDDEN, this._t("Hidden"));
        }
        RouterInfo routerInfo = this._context.router().getRouterInfo();
        if (routerInfo == null) {
            return new NetworkStateMessage(NetworkState.TESTING, this._t("Testing"));
        }
        CommSystemFacade.Status status = this._context.commSystem().getStatus();
        String txstatus = this._context.commSystem().getLocalizedStatusString();
        NetworkState state = NetworkState.RUNNING;
        switch (status) {
            case OK: 
            case IPV4_OK_IPV6_UNKNOWN: 
            case IPV4_OK_IPV6_FIREWALLED: 
            case IPV4_UNKNOWN_IPV6_OK: 
            case IPV4_DISABLED_IPV6_OK: 
            case IPV4_SNAT_IPV6_OK: {
                List ras = routerInfo.getTargetAddresses("NTCP", "NTCP2");
                if (ras.isEmpty()) {
                    return new NetworkStateMessage(NetworkState.RUNNING, txstatus);
                }
                byte[] ip = null;
                for (RouterAddress ra : ras) {
                    ip = ra.getIP();
                    if (ip != null) break;
                }
                if (ip == null) {
                    return new NetworkStateMessage(NetworkState.RUNNING, txstatus);
                }
                if (TransportUtil.isPubliclyRoutable(ip, (boolean)true)) {
                    return new NetworkStateMessage(NetworkState.RUNNING, txstatus);
                }
                return new NetworkStateMessage(NetworkState.ERROR, this._t("ERR-Private TCP Address"));
            }
            case DIFFERENT: 
            case IPV4_SNAT_IPV6_UNKNOWN: {
                return new NetworkStateMessage(NetworkState.ERROR, this._t("ERR-SymmetricNAT"));
            }
            case REJECT_UNSOLICITED: {
                state = NetworkState.FIREWALLED;
            }
            case IPV4_DISABLED_IPV6_FIREWALLED: {
                if (routerInfo.getTargetAddress("NTCP") != null) {
                    return new NetworkStateMessage(NetworkState.WARN, this._t("WARN-Firewalled with Inbound TCP Enabled"));
                }
            }
            case IPV4_FIREWALLED_IPV6_OK: 
            case IPV4_FIREWALLED_IPV6_UNKNOWN: {
                if (((FloodfillNetworkDatabaseFacade)this._context.netDb()).floodfillEnabled()) {
                    return new NetworkStateMessage(NetworkState.WARN, this._t("WARN-Firewalled and Floodfill"));
                }
                return new NetworkStateMessage(state, txstatus);
            }
            case DISCONNECTED: {
                return new NetworkStateMessage(NetworkState.TESTING, this._t("Disconnected - check network connection"));
            }
            case HOSED: {
                return new NetworkStateMessage(NetworkState.ERROR, this._t("ERR-UDP Port In Use - Set i2np.udp.internalPort=xxxx in advanced config and restart"));
            }
            case UNKNOWN: {
                state = NetworkState.TESTING;
            }
        }
        RouterAddress ra = routerInfo.getTargetAddress("SSU");
        if (ra == null && this._context.router().getUptime() > 300000L) {
            if (this.getActivePeers() <= 0) {
                return new NetworkStateMessage(NetworkState.ERROR, this._t("ERR-No Active Peers, Check Network Connection and Firewall"));
            }
            if (this._context.getProperty("i2np.ntcp.hostname") == null || this._context.getProperty("i2np.ntcp.port") == null) {
                return new NetworkStateMessage(NetworkState.ERROR, this._t("ERR-UDP Disabled and Inbound TCP host/port not set"));
            }
            return new NetworkStateMessage(NetworkState.WARN, this._t("WARN-Firewalled with UDP Disabled"));
        }
        return new NetworkStateMessage(state, txstatus);
    }

    public String getMemory() {
        long total;
        DecimalFormat integerFormatter = new DecimalFormat("###,###,##0");
        long tot = SystemVersion.getMaxMemory();
        long used = (long)this._context.statManager().getRate("router.memoryUsed").getRate(60000L).getAvgOrLifetimeAvg();
        if (used <= 0L) {
            long free = Runtime.getRuntime().freeMemory();
            used = tot - free;
        }
        if ((used /= 0x100000L) > (total = tot / 0x100000L)) {
            used = total;
        }
        return String.valueOf(integerFormatter.format(used)) + THINSP + total + " MiB";
    }

    public String getMemoryBar() {
        long usedPc;
        DecimalFormat integerFormatter = new DecimalFormat("###,###,##0");
        long tot = SystemVersion.getMaxMemory();
        long used = (long)this._context.statManager().getRate("router.memoryUsed").getRate(60000L).getAvgOrLifetimeAvg();
        if (used <= 0L) {
            long free = Runtime.getRuntime().freeMemory();
            usedPc = 100L - free * 100L / tot;
            used = (tot - free) / 0x100000L;
        } else {
            usedPc = used * 100L / tot;
            used /= 0x100000L;
        }
        long total = tot / 0x100000L;
        if (used > total) {
            used = total;
        }
        if (usedPc > 100L) {
            usedPc = 100L;
        }
        return "<div class=\"percentBarOuter\" id=\"sb_memoryBar\"><div class=\"percentBarText\">RAM: " + integerFormatter.format(used) + THINSP + total + " MiB" + "</div><div class=\"percentBarInner\" style=\"width: " + integerFormatter.format(usedPc) + "%;\"></div></div>";
    }

    public int getActivePeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.commSystem().countActivePeers();
    }

    public boolean showFirewallWarning() {
        return this._context != null && this._context.netDb().isInitialized() && this._context.router().getUptime() > 120000L && !this._context.commSystem().isDummy() && this._context.commSystem().countActivePeers() <= 0 && this._context.netDb().getKnownRouters() > 5;
    }

    public int getActiveProfiles() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countActivePeers();
    }

    public int getFastPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countFastPeers();
    }

    public int getHighCapacityPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countHighCapacityPeers();
    }

    public int getWellIntegratedPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.peerManager().getPeersByCapability('f').size();
    }

    public int getFailingPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.profileOrganizer().countFailingPeers();
    }

    public int getBanlistedPeers() {
        if (this._context == null) {
            return 0;
        }
        return this._context.banlist().getRouterCount();
    }

    public String getSecondKBps() {
        if (this._context == null) {
            return "0 / 0";
        }
        return SummaryHelper.formatPair(this._context.bandwidthLimiter().getReceiveBps(), this._context.bandwidthLimiter().getSendBps());
    }

    public String getFiveMinuteKBps() {
        Rate r;
        Rate r2;
        if (this._context == null) {
            return "0 / 0";
        }
        RateStat receiveRate = this._context.statManager().getRate("bw.recvRate");
        double in = 0.0;
        if (receiveRate != null && (r2 = receiveRate.getRate(300000L)) != null) {
            in = r2.getAverageValue();
        }
        RateStat sendRate = this._context.statManager().getRate("bw.sendRate");
        double out = 0.0;
        if (sendRate != null && (r = sendRate.getRate(300000L)) != null) {
            out = r.getAverageValue();
        }
        return SummaryHelper.formatPair(in, out);
    }

    public String getLifetimeKBps() {
        if (this._context == null) {
            return "0 / 0";
        }
        RateStat receiveRate = this._context.statManager().getRate("bw.recvRate");
        double in = receiveRate == null ? 0.0 : receiveRate.getLifetimeAverageValue();
        RateStat sendRate = this._context.statManager().getRate("bw.sendRate");
        double out = sendRate == null ? 0.0 : sendRate.getLifetimeAverageValue();
        return SummaryHelper.formatPair(in, out);
    }

    private static String formatPair(double in, double out) {
        boolean mega;
        boolean bl = mega = in >= 1000000.0 || out >= 1000000.0;
        if (mega) {
            in /= 1000000.0;
            out /= 1000000.0;
        } else {
            in /= 1000.0;
            out /= 1000.0;
        }
        DecimalFormat fmt = in >= 1000.0 || out >= 1000.0 ? new DecimalFormat("#0") : (in >= 100.0 || out >= 100.0 ? new DecimalFormat("#0.0") : new DecimalFormat("#0.00"));
        return String.valueOf(fmt.format(in)) + THINSP + fmt.format(out) + "&nbsp;" + (mega ? (char)'M' : 'K');
    }

    public String getInboundTransferred() {
        if (this._context == null) {
            return "0";
        }
        long received = this._context.bandwidthLimiter().getTotalAllocatedInboundBytes();
        return String.valueOf(DataHelper.formatSize2Decimal((long)received)) + 'B';
    }

    public String getOutboundTransferred() {
        if (this._context == null) {
            return "0";
        }
        long sent = this._context.bandwidthLimiter().getTotalAllocatedOutboundBytes();
        return String.valueOf(DataHelper.formatSize2Decimal((long)sent)) + 'B';
    }

    public String getDestinations() {
        ArrayList clients = new ArrayList(this._context.clientManager().listClients());
        StringBuilder buf = new StringBuilder(512);
        boolean link = this._context.portMapper().isRegistered("i2ptunnel");
        buf.append("<h3>");
        if (link) {
            buf.append("<a href=\"/i2ptunnelmgr\" target=\"_top\" title=\"").append(this._t("Add/remove/edit &amp; control your client and server tunnels")).append("\">");
        }
        buf.append(this._t("Local Tunnels"));
        if (link) {
            buf.append("</a>");
        }
        buf.append("</h3><hr class=\"b\">");
        if (!clients.isEmpty()) {
            Collections.sort(clients, new AlphaComparator());
            buf.append("<table id=\"sb_localtunnels\">");
            for (Destination client : clients) {
                String name = this.getName(client);
                Hash h = client.calculateHash();
                buf.append("<tr><td align=\"right\"><img src=\"/themes/console/images/");
                if (this._context.clientManager().shouldPublishLeaseSet(h)) {
                    buf.append("server.png\" alt=\"Server\" title=\"").append(this._t("Hidden Service")).append("\">");
                } else {
                    buf.append("client.png\" alt=\"Client\" title=\"").append(this._t("Client")).append("\">");
                }
                buf.append("</td><td align=\"left\"><b><a href=\"tunnels#").append(h.toBase64().substring(0, 4));
                buf.append("\" target=\"_top\" title=\"").append(this._t("Show tunnels")).append("\">");
                if (name.length() <= 32) {
                    buf.append(DataHelper.escapeHTML((String)name));
                } else {
                    buf.append(DataHelper.escapeHTML((String)ServletUtil.truncate((String)name, (int)29))).append("&hellip;");
                }
                buf.append("</a></b></td>\n");
                LeaseSet ls = this._context.netDb().lookupLeaseSetLocally(h);
                if (ls != null && this._context.tunnelManager().getOutboundClientTunnelCount(h) > 0) {
                    if (!ls.isCurrent(0L)) {
                        buf.append("<td><img src=\"/themes/console/images/local_inprogress.png\" alt=\"").append(this._t("Rebuilding")).append("&hellip;\" title=\"").append(this._t("Leases expired"));
                        buf.append(", ").append(this._t("Rebuilding")).append("&hellip;\"></td></tr>\n");
                        continue;
                    }
                    buf.append("<td><img src=\"/themes/console/images/local_up.png\" alt=\"Ready\" title=\"").append(this._t("Ready")).append("\"></td></tr>\n");
                    continue;
                }
                buf.append("<td><img src=\"/themes/console/images/local_inprogress.png\" alt=\"").append(this._t("Building")).append("&hellip;\" title=\"").append(this._t("Building tunnels")).append("&hellip;\"></td></tr>\n");
            }
            buf.append("</table>");
        } else {
            buf.append("<center><i>").append(this._t("none")).append("</i></center>");
        }
        return buf.toString();
    }

    private String getName(Destination d) {
        String name;
        TunnelPoolSettings in = this._context.tunnelManager().getInboundSettings(d.calculateHash());
        String string = name = in != null ? in.getDestinationNickname() : null;
        if (name == null) {
            TunnelPoolSettings out = this._context.tunnelManager().getOutboundSettings(d.calculateHash());
            String string2 = name = out != null ? out.getDestinationNickname() : null;
            name = name == null ? d.toBase32() : this._t(name);
        } else {
            name = this._t(name);
        }
        return name;
    }

    public int getInboundTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getFreeTunnelCount();
    }

    public int getOutboundTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getOutboundTunnelCount();
    }

    public int getInboundClientTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getInboundClientTunnelCount();
    }

    public int getOutboundClientTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getOutboundClientTunnelCount();
    }

    public int getParticipatingTunnels() {
        if (this._context == null) {
            return 0;
        }
        return this._context.tunnelManager().getParticipatingCount();
    }

    public String getShareRatio() {
        if (this._context == null) {
            return "0";
        }
        double sr = this._context.tunnelManager().getShareRatio();
        DecimalFormat fmt = new DecimalFormat("##0.00");
        return fmt.format(sr);
    }

    public String getJobLag() {
        if (this._context == null) {
            return "0";
        }
        RateStat rs = this._context.statManager().getRate("jobQueue.jobLag");
        if (rs == null) {
            return "0";
        }
        Rate lagRate = rs.getRate(60000L);
        return DataHelper.formatDuration2((long)((long)lagRate.getAverageValue()));
    }

    public String getMessageDelay() {
        if (this._context == null) {
            return "0";
        }
        return DataHelper.formatDuration2((long)this._context.throttle().getMessageDelay());
    }

    public String getTunnelLag() {
        if (this._context == null) {
            return "0";
        }
        return DataHelper.formatDuration2((long)this._context.throttle().getTunnelLag());
    }

    public String getTunnelStatus() {
        if (this._context == null) {
            return "";
        }
        return this._context.throttle().getLocalizedTunnelStatus();
    }

    public String getInboundBacklog() {
        if (this._context == null) {
            return "0";
        }
        return String.valueOf(this._context.tunnelManager().getInboundBuildQueueSize());
    }

    private static boolean updateAvailable() {
        return NewsHelper.isUpdateAvailable();
    }

    private boolean unsignedUpdateAvailable() {
        return NewsHelper.isUnsignedUpdateAvailable(this._context);
    }

    private boolean devSU3UpdateAvailable() {
        return NewsHelper.isDevSU3UpdateAvailable(this._context);
    }

    private static String getUpdateVersion() {
        return DataHelper.escapeHTML((String)NewsHelper.updateVersion());
    }

    private static String getUnsignedUpdateVersion() {
        return NewsHelper.unsignedUpdateVersion();
    }

    private static String getDevSU3UpdateVersion() {
        return DataHelper.escapeHTML((String)NewsHelper.devSU3UpdateVersion());
    }

    public String getUpdateStatus() {
        String devSU3Constraint;
        String dver;
        StringBuilder buf = new StringBuilder(512);
        String status = NewsHelper.getUpdateStatus();
        boolean needSpace = false;
        if (status.length() > 0) {
            buf.append("<h4 class=\"sb_info sb_update\">").append(status).append("</h4>\n");
            needSpace = true;
        }
        if ((dver = NewsHelper.updateVersionDownloaded()) == null && (dver = NewsHelper.devSU3VersionDownloaded()) == null) {
            dver = NewsHelper.unsignedVersionDownloaded();
        }
        if (dver != null && !NewsHelper.isUpdateInProgress() && !this._context.router().gracefulShutdownInProgress()) {
            if (needSpace) {
                buf.append("<hr>");
            } else {
                needSpace = true;
            }
            buf.append("<h4 class=\"sb_info sb_update\"><b>").append(this._t("Update downloaded")).append("<br>");
            if (this._context.hasWrapper()) {
                buf.append(this._t("Click Restart to install"));
            } else {
                buf.append(this._t("Click Shutdown and restart to install"));
            }
            buf.append(' ').append(this._t("Version {0}", DataHelper.escapeHTML((String)dver)));
            buf.append("</b></h4>");
        }
        boolean avail = SummaryHelper.updateAvailable();
        boolean unsignedAvail = this.unsignedUpdateAvailable();
        boolean devSU3Avail = this.devSU3UpdateAvailable();
        String constraint = avail ? NewsHelper.updateConstraint() : null;
        String unsignedConstraint = unsignedAvail ? NewsHelper.unsignedUpdateConstraint() : null;
        String string = devSU3Constraint = devSU3Avail ? NewsHelper.devSU3UpdateConstraint() : null;
        if (avail && constraint != null && !NewsHelper.isUpdateInProgress() && !this._context.router().gracefulShutdownInProgress()) {
            if (needSpace) {
                buf.append("<hr>");
            } else {
                needSpace = true;
            }
            buf.append("<h4 class=\"sb_info sb_update\"><b>").append(this._t("Update available")).append(":<br>");
            buf.append(this._t("Version {0}", SummaryHelper.getUpdateVersion())).append("<br>");
            buf.append(constraint).append("</b></h4>");
            avail = false;
        }
        if (unsignedAvail && unsignedConstraint != null && !NewsHelper.isUpdateInProgress() && !this._context.router().gracefulShutdownInProgress()) {
            if (needSpace) {
                buf.append("<hr>");
            } else {
                needSpace = true;
            }
            buf.append("<h4 class=\"sb_info sb_update\"><b>").append(this._t("Update available")).append(":<br>");
            buf.append(this._t("Version {0}", SummaryHelper.getUnsignedUpdateVersion())).append("<br>");
            buf.append(unsignedConstraint).append("</b></h4>");
            unsignedAvail = false;
        }
        if (devSU3Avail && devSU3Constraint != null && !NewsHelper.isUpdateInProgress() && !this._context.router().gracefulShutdownInProgress()) {
            if (needSpace) {
                buf.append("<hr>");
            } else {
                needSpace = true;
            }
            buf.append("<h4 class=\"sb_info sb_update\"><b>").append(this._t("Update available")).append(":<br>");
            buf.append(this._t("Version {0}", SummaryHelper.getDevSU3UpdateVersion())).append("<br>");
            buf.append(devSU3Constraint).append("</b></h4>");
            devSU3Avail = false;
        }
        if ((avail || unsignedAvail || devSU3Avail) && !NewsHelper.isUpdateInProgress() && !this._context.router().gracefulShutdownInProgress() && this._context.portMapper().isRegistered("HTTP") && this.getAction() == null && this.getUpdateNonce() == null) {
            if (needSpace) {
                buf.append("<hr>");
            }
            long nonce = this._context.random().nextLong();
            String prev = System.getProperty("net.i2p.router.web.UpdateHandler.nonce");
            if (prev != null) {
                System.setProperty("net.i2p.router.web.UpdateHandler.noncePrev", prev);
            }
            System.setProperty("net.i2p.router.web.UpdateHandler.nonce", String.valueOf(nonce));
            String uri = this.getRequestURI();
            buf.append("<form action=\"").append(uri).append("\" method=\"POST\">\n");
            buf.append("<input type=\"hidden\" name=\"updateNonce\" value=\"").append(nonce).append("\" >\n");
            if (avail) {
                buf.append("<button type=\"submit\" class=\"download\" name=\"updateAction\" value=\"signed\" >").append(this._t("Download {0} Update", SummaryHelper.getUpdateVersion())).append("</button><br>\n");
            }
            if (devSU3Avail) {
                buf.append("<button type=\"submit\" class=\"download\" name=\"updateAction\" value=\"DevSU3\" >").append(this._t("Download Signed<br>Development Update<br>{0}", SummaryHelper.getDevSU3UpdateVersion())).append("</button><br>\n");
            }
            if (unsignedAvail) {
                buf.append("<button type=\"submit\" class=\"download\" name=\"updateAction\" value=\"Unsigned\" >").append(this._t("Download Unsigned<br>Update {0}", SummaryHelper.getUnsignedUpdateVersion())).append("</button><br>\n");
            }
            buf.append("</form>\n");
        }
        return buf.toString();
    }

    public String getRestartStatus() {
        return ConfigRestartBean.renderStatus(this.getRequestURI(), this.getAction(), this.getConsoleNonce());
    }

    public String getFirewallAndReseedStatus() {
        ReseedChecker checker;
        String status;
        StringBuilder buf = new StringBuilder(256);
        if (this.showFirewallWarning()) {
            buf.append("<h4 id=\"sb_warning\"><a href=\"/help#configurationhelp\" target=\"_top\" title=\"").append(this._t("Help with firewall configuration")).append("\">").append(this._t("Check network connection and NAT/firewall")).append("</a></h4>");
        }
        if ((status = (checker = this._context.netDb().reseedChecker()).getStatus()).length() > 0) {
            buf.append("<div class=\"sb_notice\"><i>").append(status).append("</i></div>");
        }
        if (!checker.inProgress()) {
            String reseedErrorMessage = checker.getError();
            if (reseedErrorMessage.length() > 0) {
                buf.append("<div class=\"sb_notice\"><i>").append(reseedErrorMessage).append("</i></div>");
            }
            if (this.allowReseed()) {
                long nonce = this._context.random().nextLong();
                String prev = System.getProperty("net.i2p.router.web.ReseedHandler.nonce");
                if (prev != null) {
                    System.setProperty("net.i2p.router.web.ReseedHandler.noncePrev", prev);
                }
                System.setProperty("net.i2p.router.web.ReseedHandler.nonce", String.valueOf(nonce));
                String uri = this.getRequestURI();
                buf.append("<p><form action=\"").append(uri).append("\" method=\"POST\">\n");
                buf.append("<input type=\"hidden\" name=\"reseedNonce\" value=\"").append(nonce).append("\" >\n");
                buf.append("<button type=\"submit\" title=\"").append(this._t("Attempt to download router reference files (if automatic reseed has failed)"));
                buf.append("\" class=\"reload\" value=\"Reseed\" >").append(this._t("Reseed")).append("</button></form></p>\n");
            }
        }
        if (buf.length() <= 0) {
            return "";
        }
        return buf.toString();
    }

    public void storeNewsHelper(NewsHelper n) {
        this._newshelper = n;
    }

    public NewsHelper getNewsHelper() {
        return this._newshelper;
    }

    public List<String> getSummaryBarSections(String page) {
        String config;
        if ("home".equals(page)) {
            config = this._context.getProperty(PROP_SUMMARYBAR + page, this.isAdvanced() ? DEFAULT_MINIMAL_ADVANCED : DEFAULT_MINIMAL);
        } else {
            config = this._context.getProperty(PROP_SUMMARYBAR + page);
            if (config == null) {
                config = this._context.getProperty("routerconsole.summaryBar.default", this.isAdvanced() ? DEFAULT_FULL_ADVANCED : DEFAULT_FULL);
            }
        }
        if (config.length() <= 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(DataHelper.split((String)config, (String)SS));
    }

    static void saveSummaryBarSections(RouterContext ctx, String page, Map<Integer, String> sections) {
        StringBuilder buf = new StringBuilder(512);
        for (String section : sections.values()) {
            buf.append(section).append(',');
        }
        ctx.router().saveConfig(PROP_SUMMARYBAR + page, buf.toString());
    }

    public void renderSummaryBar() throws IOException {
        SummaryBarRenderer renderer = new SummaryBarRenderer(this._context, this);
        renderer.renderSummaryHTML(this._out);
    }

    public void setAction(String s) {
        this._action = s == null ? null : DataHelper.stripHTML((String)s);
    }

    public String getAction() {
        return this._action;
    }

    public void setConsoleNonce(String s) {
        this._consoleNonce = s == null ? null : DataHelper.stripHTML((String)s);
    }

    public String getConsoleNonce() {
        return this._consoleNonce;
    }

    public void setUpdateNonce(String s) {
        this._updateNonce = s == null ? null : DataHelper.stripHTML((String)s);
    }

    public String getUpdateNonce() {
        return this._updateNonce;
    }

    public void setRequestURI(String s) {
        this._requestURI = s == null ? null : DataHelper.stripHTML((String)s);
    }

    public String getRequestURI() {
        return this._requestURI != null ? this._requestURI : "/home";
    }

    public String getConfigTable() {
        String[] allSections = SummaryBarRenderer.ALL_SECTIONS;
        Map<String, String> sectionNames = SummaryBarRenderer.SECTION_NAMES;
        List<String> sections = this.getSummaryBarSections("default");
        TreeMap<Object, String> sortedSections = new TreeMap<Object, String>(Collator.getInstance());
        int pos = sections.indexOf("General");
        if (pos >= 0) {
            sections.set(pos, "RouterInfo");
        }
        if ((pos = sections.indexOf("ShortGeneral")) >= 0) {
            sections.set(pos, "ShortRouterInfo");
        }
        int i = 0;
        while (i < allSections.length) {
            String name;
            String section = allSections[i];
            if (!sections.contains(section) && (name = sectionNames.get(section)) != null) {
                sortedSections.put(this._t(name), section);
            }
            ++i;
        }
        String theme = this._context.getProperty("routerconsole.theme", "light");
        String imgPath = "/themes/console/" + theme + "/images/";
        StringBuilder buf = new StringBuilder(2048);
        buf.append("<table id=\"sidebarconf\"><tr><th title=\"Mark section for removal from the sidebar\">").append(this._t("Remove")).append("</th><th>").append(this._t("Name")).append("</th><th colspan=\"2\">").append(this._t("Order")).append("</th></tr>\n");
        for (String string : sections) {
            int i2 = sections.indexOf(string);
            String name = sectionNames.get(string);
            if (name == null) continue;
            buf.append("<tr><td align=\"center\"><input type=\"checkbox\" class=\"optbox\" id=\"").append(name).append("\" name=\"delete_").append(i2).append("\"></td><td align=\"left\"><label for=\"").append(name).append("\">").append(this._t(name)).append("</label></td><td align=\"right\"><input type=\"hidden\" name=\"order_").append(i2).append('_').append(string).append("\" value=\"").append(i2).append("\">");
            if (i2 > 0) {
                buf.append("<button type=\"submit\" class=\"buttonTop\" name=\"action\" value=\"move_").append(i2).append("_top\"><img alt=\"").append(this._t("Top")).append("\" src=\"").append(imgPath).append("move_top.png").append("\" title=\"").append(this._t("Move to top")).append("\"/></button>");
                buf.append("<button type=\"submit\" class=\"buttonUp\" name=\"action\" value=\"move_").append(i2).append("_up\"><img alt=\"").append(this._t("Up")).append("\" src=\"").append(imgPath).append("move_up.png").append("\" title=\"").append(this._t("Move up")).append("\"/></button>");
            }
            buf.append("</td><td align=\"left\">");
            if (i2 < sections.size() - 1) {
                buf.append("<button type=\"submit\" class=\"buttonDown\" name=\"action\" value=\"move_").append(i2).append("_down\"><img alt=\"").append(this._t("Down")).append("\" src=\"").append(imgPath).append("move_down.png").append("\" title=\"").append(this._t("Move down")).append("\"/></button>");
                buf.append("<button type=\"submit\" class=\"buttonBottom\" name=\"action\" value=\"move_").append(i2).append("_bottom\"><img alt=\"").append(this._t("Bottom")).append("\" src=\"").append(imgPath).append("move_bottom.png").append("\" title=\"").append(this._t("Move to bottom")).append("\"/></button>");
            }
            buf.append("</td></tr>\n");
        }
        buf.append("<tr><td align=\"center\"><input type=\"submit\" name=\"action\" class=\"delete\" value=\"").append(this._t("Delete selected")).append("\"></td><td align=\"left\">").append("<select name=\"name\">\n<option value=\"\" selected=\"selected\">").append(this._t("Select a section to add")).append("</option>\n");
        for (Map.Entry entry : sortedSections.entrySet()) {
            String name = (String)entry.getKey();
            String s = (String)entry.getValue();
            buf.append("<option value=\"").append(s).append("\">").append(name).append("</option>\n");
        }
        buf.append("</select>\n<input type=\"hidden\" name=\"order\" value=\"").append(sections.size()).append("\"></td><td align=\"center\" colspan=\"2\"><input type=\"submit\" name=\"action\" class=\"add\" value=\"").append(this._t("Add item")).append("\"></td></tr>").append("</table>\n");
        return buf.toString();
    }

    private class AlphaComparator
    implements Comparator<Destination> {
        private final String xsc;

        private AlphaComparator() {
            this.xsc = SummaryHelper.this._t("shared clients");
        }

        @Override
        public int compare(Destination lhs, Destination rhs) {
            boolean rshared;
            String lname = SummaryHelper.this.getName(lhs);
            String rname = SummaryHelper.this.getName(rhs);
            boolean lshared = lname.startsWith("shared clients") || lname.startsWith(this.xsc);
            boolean bl = rshared = rname.startsWith("shared clients") || rname.startsWith(this.xsc);
            if (lshared && !rshared) {
                return -1;
            }
            if (rshared && !lshared) {
                return 1;
            }
            return Collator.getInstance().compare(lname, rname);
        }
    }

    public static enum NetworkState {
        HIDDEN,
        TESTING,
        FIREWALLED,
        RUNNING,
        WARN,
        ERROR,
        CLOCKSKEW,
        VMCOMM;

    }

    public static class NetworkStateMessage {
        private NetworkState state;
        private String msg;

        NetworkStateMessage(NetworkState state, String msg) {
            this.setMessage(state, msg);
        }

        public void setMessage(NetworkState state, String msg) {
            this.state = state;
            this.msg = msg;
        }

        public NetworkState getState() {
            return this.state;
        }

        public String getMessage() {
            return this.msg;
        }

        public String toString() {
            return "(" + (Object)((Object)this.state) + "; " + this.msg + ')';
        }
    }
}

