/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.SimpleDataStructure;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.data.router.RouterKeyGenerator;
import net.i2p.kademlia.XORComparator;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.FamilyKeyCrypto;
import net.i2p.router.peermanager.DBHistory;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.sybil.Analysis;
import net.i2p.router.sybil.Pair;
import net.i2p.router.sybil.PersistSybil;
import net.i2p.router.sybil.Points;
import net.i2p.router.sybil.Util;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.util.HashDistance;
import net.i2p.router.web.Messages;
import net.i2p.router.web.helpers.NetDbRenderer;
import net.i2p.util.ConvertToHash;
import net.i2p.util.Log;
import net.i2p.util.Translate;

public class SybilRenderer {
    private final RouterContext _context;
    private final Log _log;
    private final DecimalFormat fmt = new DecimalFormat("#0.00");
    private static final int PAIRMAX = 20;
    private static final int MAX = 10;
    private static final double MIN_CLOSE = 242.0;
    private static final double MIN_DISPLAY_POINTS = 12.01;
    private static final int[] HOURS;
    private static final int[] DAYS;

    static {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 6;
        nArray[2] = 24;
        nArray[3] = 168;
        nArray[4] = 720;
        HOURS = nArray;
        int[] nArray2 = new int[6];
        nArray2[0] = 2;
        nArray2[1] = 7;
        nArray2[2] = 30;
        nArray2[3] = 90;
        nArray2[4] = 365;
        DAYS = nArray2;
    }

    public SybilRenderer(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(SybilRenderer.class);
    }

    public String getNetDbSummary(Writer out, String nonce, int mode, long date) throws IOException {
        this.renderRouterInfoHTML(out, nonce, mode, date);
        return "";
    }

    private void renderRouterInfoHTML(Writer out, String nonce, int mode, long date) throws IOException {
        Hash us = this._context.routerHash();
        Analysis analysis = Analysis.getInstance(this._context);
        List<RouterInfo> ris = null;
        if (mode != 0 && mode < 12 && (ris = mode >= 2 && mode <= 6 ? analysis.getAllRouters(us) : analysis.getFloodfills(us)).isEmpty()) {
            out.write("<h3 class=\"sybils\">No known routers</h3>");
            return;
        }
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<p id=\"sybilinfo\"><b>This is an experimental network database tool for debugging and analysis. Do not panic even if you see warnings below. Possible \"threats\" are summarized, however these are unlikely to be real threats. If you see anything you would like to discuss with the devs, contact us on IRC #i2p-dev.</b></p><div id=\"sybilnav\"><ul><li><a href=\"netdb?f=3\">Review stored analysis</a></li><li><a href=\"netdb?f=3&amp;m=14\">Run new analysis</a></li><li><a href=\"netdb?f=3&amp;m=15\">Configure periodic analysis</a></li><li><a href=\"/profiles?f=3\">Review current bans</a></li><li><a href=\"netdb?f=3&amp;m=1\">Floodfill Summary</a></li><li><a href=\"netdb?f=3&amp;m=2\">Same Family</a></li><li><a href=\"netdb?f=3&amp;m=3\">IP close to us</a></li><li><a href=\"netdb?f=3&amp;m=4\">Same IP</a></li><li><a href=\"netdb?f=3&amp;m=5\">Same /24</a></li><li><a href=\"netdb?f=3&amp;m=6\">Same /16</a></li><li><a href=\"netdb?f=3&amp;m=7\">Pair distance</a></li><li><a href=\"netdb?f=3&amp;m=8\">Close to us</a></li><li><a href=\"netdb?f=3&amp;m=9\">Close to us tomorrow</a></li><li><a href=\"netdb?f=3&amp;m=10\">DHT neighbors</a></li><li><a href=\"netdb?f=3&amp;m=11\">Close to our destinations</a></li></ul></div>");
        SybilRenderer.writeBuf(out, buf);
        double avgMinDist = 0.0;
        if (mode == 1 || mode == 8 || mode == 9 || mode == 10 || mode == 11) {
            avgMinDist = analysis.getAvgMinDist(ris);
        }
        Map<Hash, Points> points = new HashMap<Hash, Points>(64);
        if (mode == 0) {
            this.renderOverview(out, buf, nonce, analysis);
        } else if (mode == 1) {
            this.renderFFSummary(out, buf, ris, avgMinDist);
        } else if (mode == 2) {
            this.renderFamilySummary(out, buf, analysis, ris, points);
        } else if (mode == 3) {
            this.renderIPUsSummary(out, buf, analysis, ris, points);
        } else if (mode == 4) {
            this.renderIP32Summary(out, buf, analysis, ris, points);
        } else if (mode == 5) {
            this.renderIP24Summary(out, buf, analysis, ris, points);
        } else if (mode == 6) {
            this.renderIP16Summary(out, buf, analysis, ris, points);
        } else if (mode == 7) {
            this.renderPairSummary(out, buf, analysis, ris, points);
        } else if (mode == 8) {
            this.renderCloseSummary(out, buf, analysis, avgMinDist, ris, points);
        } else if (mode == 9) {
            this.renderCloseTmrwSummary(out, buf, analysis, us, avgMinDist, ris, points);
        } else if (mode == 10) {
            this.renderDHTSummary(out, buf, analysis, us, avgMinDist, ris, points);
        } else if (mode == 11) {
            this.renderDestSummary(out, buf, analysis, avgMinDist, ris, points);
        } else if (mode == 12) {
            PersistSybil ps = analysis.getPersister();
            try {
                points = ps.load(date);
            }
            catch (IOException ioe) {
                this._log.error("loading stored analysis for date: " + date, (Throwable)ioe);
                out.write("<b>Failed to load analysis for " + DataHelper.formatTime((long)date) + "</b>: " + DataHelper.escapeHTML((String)ioe.toString()));
                return;
            }
            if (points.isEmpty()) {
                this._log.error("empty stored analysis or bad file format for date: " + date);
                out.write("<b>Corrupt analysis file for " + DataHelper.formatTime((long)date) + "</b>");
            } else {
                this.renderThreatsHTML(out, buf, date, points);
            }
        } else if (mode == 13 || mode == 16) {
            long now = this._context.clock().now();
            points = analysis.backgroundAnalysis(mode == 16);
            if (!points.isEmpty()) {
                PersistSybil ps = analysis.getPersister();
                try {
                    ps.store(now, points);
                }
                catch (IOException ioe) {
                    out.write("<b>Failed to store analysis: " + ioe + "</b>");
                }
            }
            this.renderThreatsHTML(out, buf, now, points);
        } else if (mode == 14) {
            SybilRenderer.renderRunForm(out, buf, nonce);
        } else if (mode == 15) {
            this.renderBackgroundForm(out, buf, nonce);
        } else {
            out.write("Unknown mode " + mode);
        }
        SybilRenderer.writeBuf(out, buf);
    }

    private void renderOverview(Writer out, StringBuilder buf, String nonce, Analysis analysis) throws IOException {
        PersistSybil ps = analysis.getPersister();
        List<Long> dates = ps.load();
        if (dates.isEmpty()) {
            out.write("No stored analysis");
        } else {
            buf.append("<form action=\"netdb\" method=\"POST\">\n<input type=\"hidden\" name=\"f\" value=\"3\">\n<input type=\"hidden\" name=\"m\" value=\"12\">\n<input type=\"hidden\" name=\"nonce\" value=\"").append(nonce).append("\" >\nSelect stored analysis: <select name=\"date\">\n");
            boolean first = true;
            for (Long date : dates) {
                buf.append("<option value=\"").append(date).append('\"');
                if (first) {
                    buf.append(" selected=\"selected\" ");
                    first = false;
                }
                buf.append('>').append(DataHelper.formatTime((long)date)).append("</option>\n");
            }
            buf.append("</select>\n<input type=\"submit\" name=\"action\" class=\"go\" value=\"Review analysis\" /></form>\n");
        }
        SybilRenderer.writeBuf(out, buf);
    }

    private static void renderRunForm(Writer out, StringBuilder buf, String nonce) throws IOException {
        buf.append("<form action=\"netdb\" method=\"POST\">\n<input type=\"hidden\" name=\"f\" value=\"3\">\n<input type=\"hidden\" name=\"m\" value=\"13\">\n<input type=\"hidden\" name=\"nonce\" value=\"").append(nonce).append("\" >\n<input type=\"submit\" name=\"action\" class=\"go\" value=\"Run new analysis\" />(floodfills only)</form><br>\n");
        buf.append("<form action=\"netdb\" method=\"POST\">\n<input type=\"hidden\" name=\"f\" value=\"3\">\n<input type=\"hidden\" name=\"m\" value=\"16\">\n<input type=\"hidden\" name=\"nonce\" value=\"").append(nonce).append("\" >\n<input type=\"submit\" name=\"action\" class=\"go\" value=\"Run new analysis\" />(all routers)</form>\n");
        SybilRenderer.writeBuf(out, buf);
    }

    private void renderBackgroundForm(Writer out, StringBuilder buf, String nonce) throws IOException {
        long freq = this._context.getProperty("router.sybilFrequency", 86400000L);
        buf.append("<form action=\"netdb\" method=\"POST\">\n<input type=\"hidden\" name=\"f\" value=\"3\">\n<input type=\"hidden\" name=\"m\" value=\"15\">\n<input type=\"hidden\" name=\"nonce\" value=\"").append(nonce).append("\" >\n<table><tr><td>Background analysis run frequency:</td><td><select name=\"runFrequency\">");
        int i = 0;
        while (i < HOURS.length) {
            buf.append("<option value=\"");
            buf.append(HOURS[i]);
            buf.append('\"');
            long time = (long)(HOURS[i] * 60 * 60) * 1000L;
            if (time == freq) {
                buf.append(" selected=\"selected\" ");
            }
            buf.append('>');
            if (HOURS[i] > 0) {
                buf.append(DataHelper.formatDuration2((long)time));
            } else {
                buf.append(this._t("Never"));
            }
            buf.append("</option>\n");
            ++i;
        }
        boolean auto = this._context.getProperty("router.sybilEnableBlocking", true);
        boolean nonff = this._context.getBooleanProperty("router.sybilAnalyzeAll");
        String thresh = this._context.getProperty("router.sybilThreshold", Double.toString(75.0));
        long days = this._context.getProperty("router.sybilBlockPeriod", 604800000L) / 86400000L;
        buf.append("</select></td></tr>\n<tr><td>Auto-block routers?</td><td><input type=\"checkbox\" class=\"optbox\" value=\"1\" name=\"block\" ");
        if (auto) {
            buf.append(" checked=\"checked\" ");
        }
        buf.append("></td></tr>\n<tr><td>Include non-floodfills?</td><td><input type=\"checkbox\" class=\"optbox\" value=\"1\" name=\"nonff\" ");
        if (nonff) {
            buf.append(" checked=\"checked\" ");
        }
        buf.append("></td></tr>\n<tr><td>Minimum threat points to block:</td><td><input type=\"text\" name=\"threshold\" value=\"").append(thresh).append("\"></td></tr>\n<tr><td>Days to block:</td><td><input type=\"text\" name=\"days\" value=\"").append(days).append("\"></td></tr>\n<tr><td>Delete stored analysis older than:</td><td><select name=\"deleteAge\">");
        long age = this._context.getProperty("router.sybilDeleteOld", 2592000000L);
        int i2 = 0;
        while (i2 < DAYS.length) {
            buf.append("<option value=\"");
            buf.append(DAYS[i2]);
            buf.append('\"');
            long time = (long)(DAYS[i2] * 24 * 60 * 60) * 1000L;
            if (time == age) {
                buf.append(" selected=\"selected\" ");
            }
            buf.append('>');
            if (DAYS[i2] > 0) {
                buf.append(DataHelper.formatDuration2((long)time));
            } else {
                buf.append(this._t("Never"));
            }
            buf.append("</option>\n");
            ++i2;
        }
        buf.append("</td></tr>\n<tr><td></td><td><input type=\"submit\" name=\"action\" class=\"accept\" value=\"Save\" /></td></tr></table></form>\n");
        SybilRenderer.writeBuf(out, buf);
    }

    private void renderFFSummary(Writer out, StringBuilder buf, List<RouterInfo> ris, double avgMinDist) throws IOException {
        this.renderRouterInfo(buf, this._context.router().getRouterInfo(), null, true, false);
        buf.append("<h3 id=\"known\" class=\"sybils\">Known Floodfills: ").append(ris.size()).append("</h3>");
        buf.append("<div id=\"sybils_summary\">\n<b>Average closest floodfill distance:</b> ").append(this.fmt.format(avgMinDist)).append("<br>\n<b>Routing Data:</b> \"").append(DataHelper.getUTF8((byte[])this._context.routerKeyGenerator().getModData())).append("\" <b>Last Changed:</b> ").append(DataHelper.formatTime((long)this._context.routerKeyGenerator().getLastChanged())).append("<br>\n<b>Next Routing Data:</b> \"").append(DataHelper.getUTF8((byte[])this._context.routerKeyGenerator().getNextModData())).append("\" <b>Rotates in:</b> ").append(DataHelper.formatDuration((long)this._context.routerKeyGenerator().getTimeTillMidnight())).append("\n</div>\n");
        SybilRenderer.writeBuf(out, buf);
    }

    private void renderFamilySummary(Writer out, StringBuilder buf, Analysis analysis, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        Map<String, List<RouterInfo>> fmap = analysis.calculateIPGroupsFamily(ris, points);
        this.renderIPGroupsFamily(out, buf, fmap);
    }

    private void renderIPUsSummary(Writer out, StringBuilder buf, Analysis analysis, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        ArrayList<RouterInfo> ri32 = new ArrayList<RouterInfo>(4);
        ArrayList<RouterInfo> ri24 = new ArrayList<RouterInfo>(4);
        ArrayList<RouterInfo> ri16 = new ArrayList<RouterInfo>(4);
        analysis.calculateIPGroupsUs(ris, points, ri32, ri24, ri16);
        this.renderIPGroupsUs(out, buf, ri32, ri24, ri16);
    }

    private void renderIP32Summary(Writer out, StringBuilder buf, Analysis analysis, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        Map<Integer, List<RouterInfo>> map = analysis.calculateIPGroups32(ris, points);
        this.renderIPGroups32(out, buf, map);
    }

    private void renderIP24Summary(Writer out, StringBuilder buf, Analysis analysis, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        Map<Integer, List<RouterInfo>> map = analysis.calculateIPGroups24(ris, points);
        this.renderIPGroups24(out, buf, map);
    }

    private void renderIP16Summary(Writer out, StringBuilder buf, Analysis analysis, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        Map<Integer, List<RouterInfo>> map = analysis.calculateIPGroups16(ris, points);
        this.renderIPGroups16(out, buf, map);
    }

    private void renderPairSummary(Writer out, StringBuilder buf, Analysis analysis, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        ArrayList<Pair> pairs = new ArrayList<Pair>(20);
        double avg = analysis.calculatePairDistance(ris, points, pairs);
        this.renderPairDistance(out, buf, pairs, avg);
    }

    private void renderCloseSummary(Writer out, StringBuilder buf, Analysis analysis, double avgMinDist, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        buf.append("<h3 id=\"ritoday\" class=\"sybils\">Closest Floodfills to Our Routing Key (Where we Store our RI)</h3>");
        buf.append("<p class=\"sybil_info\"><a href=\"/netdb?caps=f&amp;sybil\">See all</a></p>");
        Hash ourRKey = this._context.router().getRouterInfo().getRoutingKey();
        analysis.calculateRouterInfo(ourRKey, "our rkey", ris, points);
        this.renderRouterInfoHTML(out, buf, ourRKey, avgMinDist, ris);
    }

    private void renderCloseTmrwSummary(Writer out, StringBuilder buf, Analysis analysis, Hash us, double avgMinDist, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        RouterKeyGenerator rkgen = this._context.routerKeyGenerator();
        Hash nkey = rkgen.getNextRoutingKey(us);
        buf.append("<h3 id=\"ritmrw\" class=\"sybils\">Closest Floodfills to Tomorrow's Routing Key (Where we will Store our RI)</h3>");
        buf.append("<p class=\"sybil_info\"><a href=\"/netdb?caps=f&amp;sybil\">See all</a></p>");
        analysis.calculateRouterInfo(nkey, "our rkey (tomorrow)", ris, points);
        this.renderRouterInfoHTML(out, buf, nkey, avgMinDist, ris);
    }

    private void renderDHTSummary(Writer out, StringBuilder buf, Analysis analysis, Hash us, double avgMinDist, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        buf.append("<h3 id=\"dht\" class=\"sybils\">Closest Floodfills to Our Router Hash (DHT Neighbors if we are Floodfill)</h3>");
        analysis.calculateRouterInfo(us, "our router", ris, points);
        this.renderRouterInfoHTML(out, buf, us, avgMinDist, ris);
    }

    private void renderDestSummary(Writer out, StringBuilder buf, Analysis analysis, double avgMinDist, List<RouterInfo> ris, Map<Hash, Points> points) throws IOException {
        RouterKeyGenerator rkgen = this._context.routerKeyGenerator();
        buf.append("<h3 id=\"dest\" class=\"sybils\">Floodfills Close to Our Destinations</h3>");
        Map clientInboundPools = this._context.tunnelManager().getInboundClientPools();
        ArrayList destinations = new ArrayList(clientInboundPools.keySet());
        Iterator iter = destinations.iterator();
        while (iter.hasNext()) {
            Hash client = (Hash)iter.next();
            if (this._context.clientManager().isLocal(client) && this._context.clientManager().shouldPublishLeaseSet(client) && this._context.netDb().lookupLeaseSetLocally(client) != null) continue;
            iter.remove();
        }
        if (destinations.isEmpty()) {
            buf.append("<p class=\"notfound\">None</p>");
            SybilRenderer.writeBuf(out, buf);
            return;
        }
        for (Hash client : destinations) {
            LeaseSet ls = this._context.netDb().lookupLeaseSetLocally(client);
            if (ls == null) continue;
            Hash rkey = ls.getRoutingKey();
            TunnelPool in = (TunnelPool)clientInboundPools.get(client);
            String name = in != null ? DataHelper.escapeHTML((String)in.getSettings().getDestinationNickname()) : client.toBase64().substring(0, 4);
            buf.append("<h3 class=\"sybils\">Closest floodfills to the Routing Key for " + name + " (where we store our LS)</h3>");
            buf.append("<p class=\"sybil_info\"><a href=\"/netdb?caps=f&amp;sybil=" + ls.getHash().toBase64() + "\">See all</a></p>");
            analysis.calculateRouterInfo(rkey, name, ris, points);
            this.renderRouterInfoHTML(out, buf, rkey, avgMinDist, ris);
            Hash nkey = rkgen.getNextRoutingKey(ls.getHash());
            buf.append("<h3 class=\"sybils\">Closest floodfills to Tomorrow's Routing Key for " + name + " (where we will store our LS)</h3>");
            buf.append("<p class=\"sybil_info\"><a href=\"/netdb?caps=f&amp;sybil=" + ls.getHash().toBase64() + "\">See all</a></p>");
            analysis.calculateRouterInfo(nkey, String.valueOf(name) + " (tomorrow)", ris, points);
            this.renderRouterInfoHTML(out, buf, nkey, avgMinDist, ris);
        }
    }

    private void renderThreatsHTML(Writer out, StringBuilder buf, long date, Map<Hash, Points> points) throws IOException {
        if (!points.isEmpty()) {
            ArrayList<Hash> warns = new ArrayList<Hash>(points.keySet());
            Collections.sort(warns, new PointsComparator(points));
            ReasonComparator rcomp = new ReasonComparator();
            buf.append("<h3 id=\"threats\" class=\"sybils\">Routers with Most Threat Points as of " + DataHelper.formatTime((long)date) + "</h3>");
            for (Hash h : warns) {
                Points pp = points.get(h);
                double p = pp.getPoints();
                if (p < 12.01) break;
                buf.append("<p class=\"threatpoints\"><b>Threat Points: " + this.fmt.format(p) + "</b></p><ul>");
                List<String> reasons = pp.getReasons();
                if (reasons.size() > 1) {
                    Collections.sort(reasons, rcomp);
                }
                for (String s : reasons) {
                    int c = s.indexOf(58);
                    if (c <= 0) continue;
                    buf.append("<li><b>").append(s, 0, c + 1).append("</b>").append(s, c + 1, s.length()).append("</li>");
                }
                buf.append("</ul>");
                RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(h);
                if (ri != null) {
                    this.renderRouterInfo(buf, ri, null, false, false);
                    continue;
                }
                String hash = h.toBase64();
                buf.append("<a name=\"").append(hash, 0, 6).append("\"></a><table class=\"sybil_routerinfo\"><tr><th><b>" + this._t("Router") + ":</b> <code>").append(hash).append("</code></th><th><b>Router info not available</b></th><th></th></tr></table>\n");
            }
        }
        SybilRenderer.writeBuf(out, buf);
    }

    private void renderPairDistance(Writer out, StringBuilder buf, List<Pair> pairs, double avg) throws IOException {
        buf.append("<h3 class=\"sybils\">Average Floodfill Distance is ").append(this.fmt.format(avg)).append("</h3><h3 id=\"pairs\" class=\"sybils\">Closest Floodfill Pairs by Hash</h3>");
        for (Pair p : pairs) {
            double distance = Util.biLog2(p.dist);
            double point = 242.0 - distance;
            if (point < 2.0) break;
            buf.append("<p class=\"hashdist\"><b>Hash Distance: ").append(this.fmt.format(distance)).append("</b></p>");
            this.renderRouterInfo(buf, p.r1, null, false, false);
            this.renderRouterInfo(buf, p.r2, null, false, false);
        }
        SybilRenderer.writeBuf(out, buf);
    }

    private void renderIPGroupsUs(Writer out, StringBuilder buf, List<RouterInfo> ri32, List<RouterInfo> ri24, List<RouterInfo> ri16) throws IOException {
        buf.append("<h3 id=\"ourIP\" class=\"sybils\">Routers close to Our IP</h3>");
        boolean found = false;
        for (RouterInfo info : ri32) {
            buf.append("<p id=\"sybil_info\"><b>");
            buf.append("Same IP as us");
            buf.append(":</b></p>");
            this.renderRouterInfo(buf, info, null, false, false);
            found = true;
        }
        for (RouterInfo info : ri24) {
            buf.append("<p id=\"sybil_info\"><b>");
            buf.append("Same /24 as us");
            buf.append(":</b></p>");
            this.renderRouterInfo(buf, info, null, false, false);
            found = true;
        }
        for (RouterInfo info : ri16) {
            buf.append("<p id=\"sybil_info\"><b>");
            buf.append("Same /16 as us");
            buf.append(":</b></p>");
            this.renderRouterInfo(buf, info, null, false, false);
            found = true;
        }
        if (!found) {
            buf.append("<p class=\"notfound\">None</p>");
        }
        SybilRenderer.writeBuf(out, buf);
    }

    private void renderIPGroups32(Writer out, StringBuilder buf, Map<Integer, List<RouterInfo>> map) throws IOException {
        buf.append("<h3 id=\"sameIP\" class=\"sybils\">Routers with the Same IP</h3>");
        ArrayList<Integer> foo = new ArrayList<Integer>(map.keySet());
        Collections.sort(foo, new FooComparator(map));
        boolean found = false;
        for (Integer ii : foo) {
            List<RouterInfo> ris = map.get(ii);
            int count = ris.size();
            int i = ii;
            int i0 = i >> 24 & 0xFF;
            int i1 = i >> 16 & 0xFF;
            int i2 = i >> 8 & 0xFF;
            int i3 = i & 0xFF;
            String sip = String.valueOf(i0) + "." + i1 + '.' + i2 + '.' + i3;
            buf.append("<p class=\"sybil_info\"><b>").append(count).append(" routers with IP <a href=\"/netdb?ip=").append(sip).append("&amp;sybil\">").append(sip).append("</a>:</b></p>");
            for (RouterInfo info : ris) {
                found = true;
                this.renderRouterInfo(buf, info, null, false, false);
            }
        }
        if (!found) {
            buf.append("<p class=\"notfound\">None</p>");
        }
        SybilRenderer.writeBuf(out, buf);
    }

    private void renderIPGroups24(Writer out, StringBuilder buf, Map<Integer, List<RouterInfo>> map) throws IOException {
        buf.append("<h3 id=\"same24\" class=\"sybils\">Routers in the Same /24 (2 minimum)</h3>");
        ArrayList<Integer> foo = new ArrayList<Integer>(map.keySet());
        Collections.sort(foo, new FooComparator(map));
        boolean found = false;
        for (Integer ii : foo) {
            List<RouterInfo> ris = map.get(ii);
            int count = ris.size();
            int i = ii;
            int i0 = i >> 16;
            int i1 = i >> 8 & 0xFF;
            int i2 = i & 0xFF;
            String sip = String.valueOf(i0) + "." + i1 + '.' + i2 + ".0/24";
            buf.append("<p class=\"sybil_info\"><b>").append(count).append(" routers with IP <a href=\"/netdb?ip=").append(sip).append("&amp;sybil\">").append(sip).append("</a>:</b></p>");
            for (RouterInfo info : ris) {
                found = true;
                this.renderRouterInfo(buf, info, null, false, false);
            }
        }
        if (!found) {
            buf.append("<p class=\"notfound\">None</p>");
        }
        SybilRenderer.writeBuf(out, buf);
    }

    private void renderIPGroups16(Writer out, StringBuilder buf, Map<Integer, List<RouterInfo>> map) throws IOException {
        buf.append("<h3 id=\"same16\" class=\"sybils\">Routers in the Same /16 (4 minimum)</h3>");
        ArrayList<Integer> foo = new ArrayList<Integer>(map.keySet());
        Collections.sort(foo, new FooComparator(map));
        boolean found = false;
        for (Integer ii : foo) {
            List<RouterInfo> ris = map.get(ii);
            int count = ris.size();
            int i = ii;
            int i0 = i >> 8;
            int i1 = i & 0xFF;
            String sip = String.valueOf(i0) + "." + i1 + ".0.0/16";
            buf.append("<p class=\"sybil_info\"><b>").append(count).append(" routers with IP <a href=\"/netdb?ip=").append(sip).append("&amp;sybil\">").append(sip).append("</a></b></p>");
            for (RouterInfo info : ris) {
                found = true;
                this.renderRouterInfo(buf, info, null, false, false);
            }
        }
        if (!found) {
            buf.append("<p class=\"notfound\">None</p>");
        }
        SybilRenderer.writeBuf(out, buf);
    }

    private void renderIPGroupsFamily(Writer out, StringBuilder buf, Map<String, List<RouterInfo>> map) throws IOException {
        buf.append("<h3 id=\"samefamily\" class=\"sybils\">Routers in the same Family</h3><div class=\"sybil_container\">");
        ArrayList<String> foo = new ArrayList<String>(map.keySet());
        Collections.sort(foo, new FoofComparator(map));
        FamilyKeyCrypto fkc = this._context.router().getFamilyKeyCrypto();
        String ourFamily = fkc != null ? fkc.getOurFamilyName() : null;
        boolean found = false;
        for (String s : foo) {
            List<RouterInfo> list = map.get(s);
            int count = list.size();
            String ss = DataHelper.escapeHTML((String)s);
            if (count <= 1) continue;
            buf.append("<p class=\"family\"><b>").append(count).append(" routers in family: &nbsp;<a href=\"/netdb?fam=").append(ss).append("&amp;sybil\">").append(ss).append("</a></b></p>");
            found = true;
        }
        if (!found) {
            buf.append("<p class=\"notfound\">None</p>");
        }
        buf.append("</div>");
        SybilRenderer.writeBuf(out, buf);
    }

    private void renderRouterInfoHTML(Writer out, StringBuilder buf, Hash us, double avgMinDist, List<RouterInfo> ris) throws IOException {
        double min = 256.0;
        double max = 0.0;
        double tot = 0.0;
        double median = 0.0;
        int count = Math.min(10, ris.size());
        boolean isEven = count % 2 == 0;
        int medIdx = isEven ? count / 2 - 1 : count / 2;
        int i = 0;
        while (i < count) {
            RouterInfo ri = ris.get(i);
            double dist = this.renderRouterInfo(buf, ri, us, false, false);
            if (dist < 242.0) break;
            if (dist < avgMinDist && i != 0) {
                if (i == 1) {
                    buf.append("<p class=\"sybil_info\"><b>Not to worry, but above routers are closer than average minimum distance " + this.fmt.format(avgMinDist) + "</b></p>");
                } else if (i == 2) {
                    buf.append("<p class=\"sybil_info\"><b>Possible Sybil Warning - above routers are closer than average minimum distance " + this.fmt.format(avgMinDist) + "</b></p>");
                } else {
                    buf.append("<p class=\"sybil_info\"><b>Major Sybil Warning - above router is closer than average minimum distance " + this.fmt.format(avgMinDist) + "</b></p>");
                }
            }
            if (dist < min) {
                min = dist;
            }
            if (dist > max) {
                max = dist;
            }
            tot += dist;
            if (i == medIdx) {
                median = dist;
            } else if (i == medIdx + 1 && isEven) {
                median = (median + dist) / 2.0;
            }
            ++i;
        }
        double avg = tot / (double)count;
        buf.append("<p id=\"sybil_totals\"><b>Totals for " + count + " floodfills: &nbsp;</b><span class=\"netdb_name\">MIN:</span > " + this.fmt.format(min) + "&nbsp; <span class=\"netdb_name\">AVG:</span> " + this.fmt.format(avg) + "&nbsp; <span class=\"netdb_name\">MEDIAN:</span> " + this.fmt.format(median) + "&nbsp; <span class=\"netdb_name\">MAX:</span> " + this.fmt.format(max) + "</p>\n");
        SybilRenderer.writeBuf(out, buf);
    }

    private static void writeBuf(Writer out, StringBuilder buf) throws IOException {
        out.write(buf.toString());
        out.flush();
        buf.setLength(0);
    }

    private String getTranslatedCountry(String code) {
        String name = this._context.commSystem().getCountryName(code);
        return Translate.getString((String)name, (I2PAppContext)this._context, (String)"net.i2p.router.countries.messages");
    }

    private double renderRouterInfo(StringBuilder buf, RouterInfo info, Hash us, boolean isUs, boolean full) {
        PeerProfile prof;
        String fam;
        String kls;
        String hash = info.getIdentity().getHash().toBase64();
        buf.append("<a name=\"").append(hash, 0, 6).append("\"></a><table class=\"sybil_routerinfo\"><tr>");
        double distance = 0.0;
        if (isUs) {
            buf.append("<th colspan=\"2\"><a name=\"our-info\" ></a><b>" + this._t("Our info") + ":</b> <code>").append(hash).append("</code></th></tr>\n<tr><td class=\"sybilinfo_params\" colspan=\"2\"><div class=\"sybilinfo_container\">");
        } else {
            buf.append("<th><b>" + this._t("Router") + ":</b> <code>").append(hash).append("</code>\n");
            String country = this._context.commSystem().getCountry(info.getIdentity().getHash());
            buf.append("</th><th>");
            if (country != null) {
                buf.append("<a href=\"/netdb?c=").append(country).append("\"><img height=\"11\" width=\"16\" alt=\"").append(country.toUpperCase(Locale.US)).append("\" title=\"").append(this.getTranslatedCountry(country)).append("\" src=\"/flags.jsp?c=").append(country).append("\"> ").append("</a>");
            }
            if (!full) {
                buf.append("<a title=\"View extended router info\" class=\"viewfullentry\" href=\"netdb?r=").append(hash, 0, 6).append("\" >[").append(this._t("Full entry")).append("]</a>");
                buf.append("<a title=\"View profile data\" class=\"viewfullentry\" href=\"viewprofile?peer=").append(hash).append("\" >[").append(this._t("profile")).append("]</a>");
                buf.append("<a title=\"").append(this._t("Configure peer")).append("\" class=\"viewfullentry\" href=\"configpeer?peer=").append(hash).append("\" >+-</a></th><th>");
            }
            if (this._context.portMapper().isRegistered("imagegen")) {
                buf.append("<img src=\"/imagegen/id?s=32&amp;c=" + hash.replace("=", "%3d") + "\" height=\"32\" width=\"32\"> ");
            }
            buf.append("</th></tr>\n<tr><td class=\"sybilinfo_params\" colspan=\"3\"><div class=\"sybilinfo_container\">");
            if (us != null) {
                BigInteger dist = HashDistance.getDistance((Hash)us, (Hash)info.getHash());
                distance = Util.biLog2(dist);
                buf.append("<p><b>Hash Distance:</b> ").append(this.fmt.format(distance)).append("</p>\n");
            }
        }
        buf.append("<p><b>").append(this._t("Version")).append(":</b> ").append(DataHelper.stripHTML((String)info.getVersion())).append("</p>\n<p><b>").append("Caps").append(":</b> ").append(DataHelper.stripHTML((String)info.getCapabilities())).append("</p>\n");
        String kr = info.getOption("netdb.knownRouters");
        if (kr != null) {
            buf.append("<p><b>Routers:</b> ").append(DataHelper.stripHTML((String)kr)).append("</p>");
        }
        if ((kls = info.getOption("netdb.knownLeaseSets")) != null) {
            buf.append("<p class=\"sybilinfo_leasesets\"><b>").append(this._t("LeaseSets")).append(":</b> ").append(DataHelper.stripHTML((String)kls)).append("</p>\n");
        }
        if ((fam = info.getOption("family")) != null) {
            buf.append("<p><b>").append(this._t("Family")).append(":</b> <span class=\"sybilinfo_familyname\">").append(DataHelper.escapeHTML((String)fam)).append("</span></p>\n");
        }
        long now = this._context.clock().now();
        if (!isUs && (prof = this._context.profileOrganizer().getProfileNonblocking(info.getHash())) != null) {
            long age;
            long heard = prof.getFirstHeardAbout();
            if (heard > 0L) {
                age = Math.max(now - heard, 1L);
                buf.append("<p><b>First heard about:</b> ").append(this._t("{0} ago", DataHelper.formatDuration2((long)age))).append("</p>");
            } else {
                buf.append("<p class=\"sybil_filler\"><b>First heard about:</b> ").append(this._t("n/a")).append("</p>");
            }
            heard = prof.getLastHeardAbout();
            if (heard > 0L) {
                age = Math.max(now - heard, 1L);
                buf.append("<p><b>").append(this._t("Last Heard About")).append(":</b> ").append(this._t("{0} ago", DataHelper.formatDuration2((long)age))).append("</p>");
            } else {
                buf.append("<p class=\"sybil_filler\"><b>").append(this._t("Last Heard About")).append(":</b> ").append(this._t("n/a")).append("</p>");
            }
            heard = prof.getLastHeardFrom();
            if (heard > 0L) {
                age = Math.max(now - heard, 1L);
                buf.append("<p><b>").append(this._t("Last Heard From")).append("</b> ").append(this._t("{0} ago", DataHelper.formatDuration2((long)age))).append("</p>\n");
            } else {
                buf.append("<p class=\"sybil_filler\"><b>").append(this._t("Last Heard From")).append(":</b> ").append(this._t("n/a")).append("</p>");
            }
            DBHistory dbh = prof.getDBHistory();
            if (dbh != null) {
                long age2;
                heard = dbh.getLastLookupSuccessful();
                if (heard > 0L) {
                    age2 = Math.max(now - heard, 1L);
                    buf.append("<p><b>").append(this._t("Last Good Lookup")).append(":</b> ").append(this._t("{0} ago", DataHelper.formatDuration2((long)age2))).append("</p>");
                }
                if ((heard = dbh.getLastLookupFailed()) > 0L) {
                    age2 = Math.max(now - heard, 1L);
                    buf.append("<p><b>").append(this._t("Last Bad Lookup")).append(":</b> ").append(this._t("{0} ago", DataHelper.formatDuration2((long)age2))).append("</p>");
                }
                if ((heard = dbh.getLastStoreSuccessful()) > 0L) {
                    age2 = Math.max(now - heard, 1L);
                    buf.append("<p><b>").append(this._t("Last Good Store")).append(":</b> ").append(this._t("{0} ago", DataHelper.formatDuration2((long)age2))).append("</p>");
                }
                if ((heard = dbh.getLastStoreFailed()) > 0L) {
                    age2 = Math.max(now - heard, 1L);
                    buf.append("<p><b>").append(this._t("Last Bad Store")).append(":</b> ").append(this._t("{0} ago", DataHelper.formatDuration2((long)age2))).append("</p>");
                }
            }
        }
        long age = Math.max(now - info.getPublished(), 1L);
        if (isUs && this._context.router().isHidden()) {
            buf.append("<p><b>").append(this._t("Hidden")).append(", ").append(this._t("Updated")).append(":</b> ").append(this._t("{0} ago", DataHelper.formatDuration2((long)age))).append("</p>\n");
        } else {
            buf.append("<p><b>").append(this._t("Published")).append(":</b> ").append(this._t("{0} ago", DataHelper.formatDuration2((long)age))).append("</p>\n");
        }
        buf.append("<p><b>").append(this._t("Signing Key")).append(":</b> ").append(info.getIdentity().getSigningPublicKey().getType().toString()).append("</p>\n");
        buf.append("<p class=\"sybil_filler\">&nbsp;</p></div></td></tr><tr><td class=\"sybil_addresses\" colspan=\"3\"><table><tr><td><b>" + this._t("Addresses") + ":</b></td><td>");
        ArrayList addrs = info.getAddresses();
        if (addrs.size() > 1) {
            ArrayList laddrs = new ArrayList(addrs);
            Collections.sort(laddrs, new NetDbRenderer.RAComparator());
            addrs = laddrs;
        }
        for (RouterAddress addr : addrs) {
            String style = addr.getTransportStyle();
            buf.append("<br><b class=\"netdb_transport\">").append(DataHelper.stripHTML((String)style)).append(":</b> ");
            Map p = addr.getOptionsMap();
            for (Map.Entry e : p.entrySet()) {
                String name = (String)e.getKey();
                if (name.equals("key") || name.startsWith("ikey") || name.startsWith("itag") || name.startsWith("iport") || name.equals("mtu")) continue;
                String val = (String)e.getValue();
                buf.append(" <span class=\"nowrap\"><span class=\"netdb_name\">").append(this._t(DataHelper.stripHTML((String)name))).append(":</span> <span class=\"netdb_info\">");
                buf.append(DataHelper.stripHTML((String)val));
                buf.append("</span></span>&nbsp;");
            }
        }
        buf.append("</table></td></tr>\n</table>\n");
        return distance;
    }

    public static void renderSybilHTML(Writer out, RouterContext ctx, List<Hash> sybils, String victim) throws IOException {
        Hash v;
        if (sybils.isEmpty()) {
            return;
        }
        DecimalFormat fmt = new DecimalFormat("#0.00");
        XORComparator xor = new XORComparator((SimpleDataStructure)Hash.FAKE_HASH);
        out.write("<h3 class=\"tabletitle\">Group Distances</h3><table class=\"sybil_distance\"><tr><th>Hash<th>Distance from previous</tr>\n");
        Collections.sort(sybils, xor);
        Hash prev = null;
        for (Hash h : sybils) {
            String hh = h.toBase64();
            out.write("<tr><td><a href=\"#" + hh.substring(0, 6) + "\"><tt>" + hh + "</tt></a><td>");
            if (prev != null) {
                BigInteger dist = HashDistance.getDistance((Hash)prev, (Hash)h);
                SybilRenderer.writeDistance(out, fmt, dist);
            }
            prev = h;
            out.write("</tr>\n");
        }
        out.write("</table>\n");
        out.flush();
        RouterKeyGenerator rkgen = ctx.routerKeyGenerator();
        long now = ctx.clock().now();
        int start = -3;
        now += -259200000L;
        int days = 10;
        Hash from = ctx.routerHash();
        if (victim != null && (v = ConvertToHash.getHash((String)victim)) != null) {
            from = v;
        }
        out.write("<h3>Distance to " + from.toBase64() + "</h3>");
        prev = null;
        int limit = Math.min(10, sybils.size());
        DateFormat utcfmt = DateFormat.getDateInstance(2);
        int i = -3;
        while (i <= 10) {
            out.write("<h3 class=\"tabletitle\">Distance for " + utcfmt.format(new Date(now)) + "</h3><table class=\"sybil_distance\"><tr><th>Hash<th>Distance<th>Distance from previous</tr>\n");
            Hash rkey = rkgen.getRoutingKey(from, now);
            xor = new XORComparator((SimpleDataStructure)rkey);
            Collections.sort(sybils, xor);
            int j = 0;
            while (j < limit) {
                Hash h = sybils.get(j);
                String hh = h.toBase64();
                out.write("<tr><td><a href=\"#" + hh.substring(0, 6) + "\"><tt>" + hh + "</tt></a><td>");
                BigInteger dist = HashDistance.getDistance((Hash)rkey, (Hash)h);
                SybilRenderer.writeDistance(out, fmt, dist);
                out.write("<td>");
                if (prev != null) {
                    dist = HashDistance.getDistance((Hash)prev, (Hash)h);
                    SybilRenderer.writeDistance(out, fmt, dist);
                }
                prev = h;
                out.write("</tr>\n");
                ++j;
            }
            out.write("</table>\n");
            out.flush();
            now += 86400000L;
            prev = null;
            ++i;
        }
    }

    private static void writeDistance(Writer out, DecimalFormat fmt, BigInteger dist) throws IOException {
        double distance = Util.biLog2(dist);
        if (distance < 242.0) {
            out.write("<font color=\"red\">");
        }
        out.write(fmt.format(distance));
        if (distance < 242.0) {
            out.write("</font>");
        }
    }

    private String _t(String s) {
        return Messages.getString(s, (I2PAppContext)this._context);
    }

    private static final String _x(String s) {
        return s;
    }

    private String _t(String s, Object o) {
        return Messages.getString(s, o, (I2PAppContext)this._context);
    }

    private static class FooComparator
    implements Comparator<Integer>,
    Serializable {
        private final Map<Integer, List<RouterInfo>> _o;

        public FooComparator(Map<Integer, List<RouterInfo>> o) {
            this._o = o;
        }

        @Override
        public int compare(Integer l, Integer r) {
            int rv = this._o.get(r).size() - this._o.get(l).size();
            if (rv != 0) {
                return rv;
            }
            return l - r;
        }
    }

    private static class FoofComparator
    implements Comparator<String>,
    Serializable {
        private final Map<String, List<RouterInfo>> _o;
        private final Collator _comp = Collator.getInstance();

        public FoofComparator(Map<String, List<RouterInfo>> o) {
            this._o = o;
        }

        @Override
        public int compare(String l, String r) {
            int rv = this._o.get(r).size() - this._o.get(l).size();
            if (rv != 0) {
                return rv;
            }
            return this._comp.compare(l, r);
        }
    }

    private static class PointsComparator
    implements Comparator<Hash>,
    Serializable {
        private final Map<Hash, Points> _points;

        public PointsComparator(Map<Hash, Points> points) {
            this._points = points;
        }

        @Override
        public int compare(Hash l, Hash r) {
            return this._points.get(r).compareTo(this._points.get(l));
        }
    }

    private static class ReasonComparator
    implements Comparator<String>,
    Serializable {
        private ReasonComparator() {
        }

        @Override
        public int compare(String l, String r) {
            double rd;
            double ld;
            int lc = l.indexOf(58);
            int rc = r.indexOf(58);
            if (lc <= 0 || rc <= 0) {
                return 0;
            }
            try {
                ld = Double.parseDouble(l.substring(0, lc));
                rd = Double.parseDouble(r.substring(0, rc));
            }
            catch (NumberFormatException nfe) {
                return 0;
            }
            int rv = Double.compare(rd, ld);
            if (rv != 0) {
                return rv;
            }
            return l.compareTo(r);
        }
    }
}

