/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.web.Messages;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;

class TunnelRenderer {
    private final RouterContext _context;
    private static final int DISPLAY_LIMIT = 200;

    public TunnelRenderer(RouterContext ctx) {
        this._context = ctx;
    }

    public void renderStatusHTML(Writer out) throws IOException {
        TunnelPool ei = this._context.tunnelManager().getInboundExploratoryPool();
        TunnelPool eo = this._context.tunnelManager().getOutboundExploratoryPool();
        out.write("<h3 class=\"tabletitle\" id=\"exploratorytunnels\"><a name=\"exploratory\" ></a>" + this._t("Exploratory tunnels"));
        out.write(" <a href=\"/configtunnels#exploratory\" title=\"" + this._t("Configure tunnels") + "\">[" + this._t("configure") + "]</a>");
        this.writeGraphLinks(out, ei, eo);
        out.write("</h3>\n");
        this.renderPool(out, ei, eo);
        ArrayList destinations = null;
        Map clientInboundPools = this._context.tunnelManager().getInboundClientPools();
        Map clientOutboundPools = this._context.tunnelManager().getOutboundClientPools();
        destinations = new ArrayList(clientInboundPools.keySet());
        boolean debug = this._context.getBooleanProperty("routerconsole.advanced");
        int i = 0;
        while (i < destinations.size()) {
            Hash client = (Hash)destinations.get(i);
            boolean isLocal = this._context.clientManager().isLocal(client);
            if (isLocal || debug) {
                TunnelPool in = (TunnelPool)clientInboundPools.get(client);
                TunnelPool outPool = (TunnelPool)clientOutboundPools.get(client);
                if (!(in != null && in.getSettings().getAliasOf() != null || outPool != null && outPool.getSettings().getAliasOf() != null)) {
                    Set aliases;
                    String dname;
                    String name;
                    String string = name = in != null ? in.getSettings().getDestinationNickname() : null;
                    if (name == null && outPool != null) {
                        name = outPool.getSettings().getDestinationNickname();
                    }
                    String b64 = client.toBase64().substring(0, 4);
                    if (name == null) {
                        name = b64;
                        dname = client.toBase32();
                    } else {
                        dname = DataHelper.escapeHTML((String)this._t(name));
                    }
                    out.write("<h3 class=\"tabletitle\" id=\"" + b64 + "\" >" + this._t("Client tunnels for {0}", dname));
                    if (isLocal) {
                        out.write(" <a href=\"/configtunnels#" + b64 + "\" title=\"" + this._t("Configure tunnels for session") + "\">[" + this._t("configure") + "]</a>");
                        this.writeGraphLinks(out, in, outPool);
                        out.write("</h3>\n");
                    } else {
                        out.write(" (" + this._t("dead") + ")</h3>\n");
                    }
                    if (in != null && (aliases = in.getSettings().getAliases()) != null) {
                        for (Hash a : aliases) {
                            TunnelPool ain = (TunnelPool)clientInboundPools.get(a);
                            if (ain == null) continue;
                            String aname = ain.getSettings().getDestinationNickname();
                            String ab64 = a.toBase64().substring(0, 4);
                            if (aname == null) {
                                aname = ab64;
                            }
                            out.write("<h3 class=\"tabletitle\" id=\"" + ab64 + "\" >" + this._t("Client tunnels for {0}", DataHelper.escapeHTML((String)this._t(aname))));
                            if (isLocal) {
                                out.write(" <a href=\"/configtunnels#" + b64 + "\" title=\"" + this._t("Configure tunnels for session") + "\">[" + this._t("configure") + "]</a></h3>\n");
                                continue;
                            }
                            out.write(" (" + this._t("dead") + ")</h3>\n");
                        }
                    }
                    this.renderPool(out, in, outPool);
                }
            }
            ++i;
        }
        List participating = this._context.tunnelDispatcher().listParticipatingTunnels();
        out.write("<h3 class=\"tabletitle\" id=\"participating\">" + this._t("Participating tunnels") + "</h3>\n");
        int bwShare = this.getShareBandwidth();
        if (bwShare > 12) {
            if (!participating.isEmpty()) {
                DataHelper.sort((List)participating, (Comparator)new TunnelComparator());
                out.write("<table class=\"tunneldisplay tunnels_participating\"><tr><th>" + this._t("Receive on") + "</th><th>" + this._t("From") + "</th><th>" + this._t("Send on") + "</th><th>" + this._t("To") + "</th><th>" + this._t("Expiration") + "</th>" + "<th>" + this._t("Usage") + "</th><th>" + this._t("Rate") + "</th><th>" + this._t("Role") + "</th></tr>\n");
            }
            long processed = 0L;
            RateStat rs = this._context.statManager().getRate("tunnel.participatingMessageCount");
            if (rs != null) {
                processed = (long)rs.getRate(600000L).getLifetimeTotalValue();
            }
            int inactive = 0;
            int displayed = 0;
            int i2 = 0;
            while (i2 < participating.size()) {
                HopConfig cfg = (HopConfig)participating.get(i2);
                int count = cfg.getProcessedMessagesCount();
                if (count <= 0) {
                    ++inactive;
                } else {
                    processed += (long)cfg.getRecentMessagesCount();
                    if (++displayed <= 200) {
                        out.write("<tr>");
                        if (cfg.getReceiveTunnel() != null) {
                            out.write("<td class=\"cells\" align=\"center\" title=\"" + this._t("Tunnel identity") + "\"><span class=\"tunnel_id\">" + cfg.getReceiveTunnel().getTunnelId() + "</span></td>");
                        } else {
                            out.write("<td class=\"cells\" align=\"center\">n/a</td>");
                        }
                        if (cfg.getReceiveFrom() != null) {
                            out.write("<td class=\"cells\" align=\"center\"><span class=\"tunnel_peer\">" + this.netDbLink(cfg.getReceiveFrom()) + "</span></td>");
                        } else {
                            out.write("<td class=\"cells\">&nbsp;</td>");
                        }
                        if (cfg.getSendTunnel() != null) {
                            out.write("<td class=\"cells\" align=\"center\" title=\"" + this._t("Tunnel identity") + "\"><span class=\"tunnel_id\">" + cfg.getSendTunnel().getTunnelId() + "</span></td>");
                        } else {
                            out.write("<td class=\"cells\">&nbsp;</td>");
                        }
                        if (cfg.getSendTo() != null) {
                            out.write("<td class=\"cells\" align=\"center\"><span class=\"tunnel_peer\">" + this.netDbLink(cfg.getSendTo()) + "</span></td>");
                        } else {
                            out.write("<td class=\"cells\">&nbsp;</td>");
                        }
                        long timeLeft = cfg.getExpiration() - this._context.clock().now();
                        if (timeLeft > 0L) {
                            out.write("<td class=\"cells\" align=\"center\">" + DataHelper.formatDuration2((long)timeLeft) + "</td>");
                        } else {
                            out.write("<td class=\"cells\" align=\"center\">(" + this._t("grace period") + ")</td>");
                        }
                        out.write("<td class=\"cells\" align=\"center\">" + count * 1024 / 1000 + " KB</td>");
                        int lifetime = (int)((this._context.clock().now() - cfg.getCreation()) / 1000L);
                        if (lifetime <= 0) {
                            lifetime = 1;
                        }
                        if (lifetime > 600) {
                            lifetime = 600;
                        }
                        long bps = 1024L * (long)count / (long)lifetime;
                        out.write("<td class=\"cells\" align=\"center\">" + DataHelper.formatSize2Decimal((long)bps) + "Bps</td>");
                        if (cfg.getSendTo() == null) {
                            out.write("<td class=\"cells\" align=\"center\">" + this._t("Outbound Endpoint") + "</td>");
                        } else if (cfg.getReceiveFrom() == null) {
                            out.write("<td class=\"cells\" align=\"center\">" + this._t("Inbound Gateway") + "</td>");
                        } else {
                            out.write("<td class=\"cells\" align=\"center\">" + this._t("Participant") + "</td>");
                        }
                        out.write("</tr>\n");
                    }
                }
                ++i2;
            }
            if (!participating.isEmpty()) {
                out.write("</table>\n");
            }
            if (displayed > 200) {
                out.write("<div class=\"statusnotes\"><b>" + this._t("Limited display to the {0} tunnels with the highest usage", 200) + "</b></div>\n");
            }
            if (inactive > 0) {
                out.write("<div class=\"statusnotes\"><b>" + this._t("Inactive participating tunnels") + ":&nbsp;&nbsp;" + inactive + "</b></div>\n");
            } else if (displayed <= 0) {
                out.write("<div class=\"statusnotes\"><b>" + this._t("none") + "</b></div>\n");
            }
            out.write("<div class=\"statusnotes\"><b>" + this._t("Lifetime bandwidth usage") + ":&nbsp;&nbsp;" + DataHelper.formatSize2Decimal((long)(processed * 1024L)) + "B</b></div>\n");
        } else {
            out.write("<div class=\"statusnotes noparticipate\"><b>" + this._t("Not enough shared bandwidth to build participating tunnels.") + "</b> <a href=\"config\">[" + this._t("Configure") + "]</a></div>\n");
        }
        out.write("<h3 class=\"tabletitle\">" + this._t("Bandwidth Tiers") + "</h3>\n");
        out.write("<table id=\"tunnel_defs\"><tbody>");
        out.write("<tr><td>&nbsp;</td><td><span class=\"tunnel_cap\"><b>L</b></span></td><td>" + this._t("{0} shared bandwidth", TunnelRenderer.range(12, 48)) + "</td>" + "<td><span class=\"tunnel_cap\"><b>M</b></span></td><td>" + this._t("{0} shared bandwidth", TunnelRenderer.range(48, 64)) + "</td>" + "<td>&nbsp;</td></tr>");
        out.write("<tr><td>&nbsp;</td><td><span class=\"tunnel_cap\"><b>N</b></span></td><td>" + this._t("{0} shared bandwidth", TunnelRenderer.range(64, 128)) + "</td>" + "<td><span class=\"tunnel_cap\"><b>O</b></span></td><td>" + this._t("{0} shared bandwidth", TunnelRenderer.range(128, 256)) + "</td>" + "<td>&nbsp;</td></tr>");
        out.write("<tr><td>&nbsp;</td><td><span class=\"tunnel_cap\"><b>P</b></span></td><td>" + this._t("{0} shared bandwidth", TunnelRenderer.range(256, 2000)) + "</td>" + "<td><span class=\"tunnel_cap\"><b>X</b></span></td><td>" + this._t("Over {0} shared bandwidth", String.valueOf(Math.round(2048.0f)) + " KBps") + "</td>" + "<td>&nbsp;</td></tr>");
        out.write("</tbody></table>");
    }

    static String range(int f, int t) {
        return String.valueOf(Math.round((float)f * 1.024f)) + " - " + (Math.round((float)t * 1.024f) - 1) + " KBps";
    }

    private void writeGraphLinks(Writer out, TunnelPool in, TunnelPool outPool) throws IOException {
        if (in == null || outPool == null) {
            return;
        }
        String irname = in.getRateName();
        String orname = outPool.getRateName();
        RateStat irs = this._context.statManager().getRate(irname);
        RateStat ors = this._context.statManager().getRate(orname);
        if (irs == null || ors == null) {
            return;
        }
        Rate ir = irs.getRate(300000L);
        Rate or = ors.getRate(300000L);
        if (ir == null || or == null) {
            return;
        }
        String tgd = this._t("Graph Data");
        String tcg = this._t("Configure Graph Display");
        if (or.getSummaryListener() != null) {
            out.write("<a href=\"graph?stat=" + orname + ".300000&amp;w=600&amp;h=200\">" + "<img src=\"/themes/console/images/outbound.png\" alt=\"" + tgd + "\" title=\"" + tgd + "\"></a>");
        } else {
            out.write("<a href=\"configstats#" + orname + "\">" + "<img src=\"/themes/console/images/outbound.png\" alt=\"" + tcg + "\" title=\"" + tcg + "\"></a>");
        }
        if (ir.getSummaryListener() != null) {
            out.write("<a href=\"graph?stat=" + irname + ".300000&amp;w=600&amp;h=200\">" + "<img src=\"/themes/console/images/inbound.png\" alt=\"" + tgd + "\" title=\"" + tgd + "\"></a> ");
        } else {
            out.write("<a href=\"configstats#" + irname + "\">" + "<img src=\"/themes/console/images/inbound.png\" alt=\"" + tcg + "\" title=\"" + tcg + "\"></a>");
        }
    }

    private void renderPool(Writer out, TunnelPool in, TunnelPool outPool) throws IOException {
        List pending;
        ArrayList tunnels;
        TunnelInfoComparator comp = new TunnelInfoComparator();
        if (in == null) {
            tunnels = new ArrayList();
        } else {
            tunnels = in.listTunnels();
            Collections.sort(tunnels, comp);
        }
        if (outPool != null) {
            List otunnels = outPool.listTunnels();
            Collections.sort(otunnels, comp);
            tunnels.addAll(otunnels);
        }
        long processedIn = in != null ? in.getLifetimeProcessed() : 0L;
        long processedOut = outPool != null ? outPool.getLifetimeProcessed() : 0L;
        int live = 0;
        int maxLength = 1;
        int i = 0;
        while (i < tunnels.size()) {
            TunnelInfo info = (TunnelInfo)tunnels.get(i);
            int length = info.getLength();
            if (length > maxLength) {
                maxLength = length;
            }
            ++i;
        }
        out.write("<table class=\"tunneldisplay tunnels_client\"><tr><th title=\"" + this._t("Inbound or outbound?") + "\">" + this._t("In/Out") + "</th><th>" + this._t("Expiration") + "</th><th>" + this._t("Usage") + "</th><th>" + this._t("Gateway") + "</th>");
        if (maxLength > 3) {
            out.write("<th align=\"center\" colspan=\"" + (maxLength - 2));
            out.write("\">" + this._t("Participants") + "</th>");
        } else if (maxLength == 3) {
            out.write("<th>" + this._t("Participant") + "</th>");
        }
        if (maxLength > 1) {
            out.write("<th>" + this._t("Endpoint") + "</th>");
        }
        out.write("</tr>\n");
        String tib = this._t("Inbound");
        String tob = this._t("Outbound");
        int i2 = 0;
        while (i2 < tunnels.size()) {
            TunnelInfo info = (TunnelInfo)tunnels.get(i2);
            long timeLeft = info.getExpiration() - this._context.clock().now();
            if (timeLeft > 0L) {
                ++live;
                boolean isInbound = info.isInbound();
                if (isInbound) {
                    out.write("<tr><td class=\"cells\" align=\"center\"><img src=\"/themes/console/images/inbound.png\" alt=\"" + tib + "\" title=\"" + tib + "\"></td>");
                } else {
                    out.write("<tr><td class=\"cells\" align=\"center\"><img src=\"/themes/console/images/outbound.png\" alt=\"" + tob + "\" title=\"" + tob + "\"></td>");
                }
                out.write("<td class=\"cells\" align=\"center\">" + DataHelper.formatDuration2((long)timeLeft) + "</td>\n");
                int count = info.getProcessedMessagesCount() * 1024 / 1000;
                out.write("<td class=\"cells\" align=\"center\">" + count + " KB</td>\n");
                int length = info.getLength();
                int j = 0;
                while (j < length) {
                    int k;
                    TunnelId id;
                    Hash peer = info.getPeer(j);
                    TunnelId tunnelId = id = isInbound ? info.getReceiveTunnelId(j) : info.getSendTunnelId(j);
                    if (this._context.routerHash().equals((Object)peer)) {
                        if (length < maxLength && length == 1 && isInbound) {
                            k = 1;
                            while (k < maxLength) {
                                out.write("<td class=\"cells\" align=\"center\">&nbsp;</td>");
                                ++k;
                            }
                        }
                        out.write(" <td class=\"cells\" align=\"center\"><span class=\"tunnel_peer tunnel_local\" title=\"" + this._t("Locally hosted tunnel") + "\">" + this._t("Local") + "</span>&nbsp;<span class=\"tunnel_id\" title=\"" + this._t("Tunnel identity") + "\">" + (id == null ? "" : "" + id) + "</span><b class=\"tunnel_cap\" title=\"" + this._t("Bandwidth tier") + "\"></b></td>");
                    } else {
                        char cap = this.getCapacity(peer);
                        out.write(" <td class=\"cells\" align=\"center\"><span class=\"tunnel_peer\">" + this.netDbLink(peer) + "</span>&nbsp;<span class=\"nowrap\"><span class=\"tunnel_id\" title=\"" + this._t("Tunnel identity") + "\">" + (id == null ? "" : " " + id) + "</span><b class=\"tunnel_cap\" title=\"" + this._t("Bandwidth tier") + "\">" + cap + "</b></span></td>");
                    }
                    if (length < maxLength && (length == 1 && !isInbound || j == length - 2)) {
                        k = length;
                        while (k < maxLength) {
                            out.write("<td class=\"cells\" align=\"center\">&nbsp;</td>");
                            ++k;
                        }
                    }
                    ++j;
                }
                out.write("</tr>\n");
                if (info.isInbound()) {
                    processedIn += (long)count;
                } else {
                    processedOut += (long)count;
                }
            }
            ++i2;
        }
        out.write("</table>\n");
        if (in != null && !(pending = in.listPending()).isEmpty()) {
            out.write("<div class=\"statusnotes\"><center><b>" + this._t("Build in progress") + ":&nbsp;&nbsp;" + pending.size() + " " + tib + "</b></center></div>\n");
            live += pending.size();
        }
        if (outPool != null && !(pending = outPool.listPending()).isEmpty()) {
            out.write("<div class=\"statusnotes\"><center><b>" + this._t("Build in progress") + ":&nbsp;&nbsp;" + pending.size() + " " + tob + "</b></center></div>\n");
            live += pending.size();
        }
        if (live <= 0) {
            out.write("<div class=\"statusnotes\"><center><b>" + this._t("none") + "</b></center></div>\n");
        }
        out.write("<div class=\"statusnotes\"><center><b>" + this._t("Lifetime bandwidth usage") + ":&nbsp;&nbsp;" + DataHelper.formatSize2Decimal((long)(processedIn * 1024L)) + "B " + this._t("in") + ", " + DataHelper.formatSize2Decimal((long)(processedOut * 1024L)) + "B " + this._t("out") + "</b></center></div>");
    }

    private char getCapacity(Hash peer) {
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(peer);
        if (info != null) {
            String caps = info.getCapabilities();
            int i = 0;
            while (i < "XPONMLK".length()) {
                char c = "XPONMLK".charAt(i);
                if (caps.indexOf(c) >= 0) {
                    return c;
                }
                ++i;
            }
        }
        return ' ';
    }

    private String netDbLink(Hash peer) {
        return this._context.commSystem().renderPeerHTML(peer);
    }

    private int getShareBandwidth() {
        int irateKBps = this._context.bandwidthLimiter().getInboundKBytesPerSecond();
        int orateKBps = this._context.bandwidthLimiter().getOutboundKBytesPerSecond();
        double pct = this._context.router().getSharePercentage();
        if (irateKBps < 0 || orateKBps < 0) {
            return 12;
        }
        return (int)(pct * (double)Math.min(irateKBps, orateKBps));
    }

    private String _t(String s) {
        return Messages.getString(s, (I2PAppContext)this._context);
    }

    public String _t(String s, Object o) {
        return Messages.getString(s, o, (I2PAppContext)this._context);
    }

    private static class TunnelComparator
    implements Comparator<HopConfig>,
    Serializable {
        private TunnelComparator() {
        }

        @Override
        public int compare(HopConfig l, HopConfig r) {
            return r.getProcessedMessagesCount() - l.getProcessedMessagesCount();
        }
    }

    private static class TunnelInfoComparator
    implements Comparator<TunnelInfo>,
    Serializable {
        private TunnelInfoComparator() {
        }

        @Override
        public int compare(TunnelInfo l, TunnelInfo r) {
            long re;
            long le = l.getExpiration();
            if (le < (re = r.getExpiration())) {
                return -1;
            }
            if (le > re) {
                return 1;
            }
            return 0;
        }
    }
}

