/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.util.HashMap;
import java.util.Map;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.helpers.WizardHelper;

public class WizardHandler
extends FormHandler {
    private WizardHelper _helper;

    public void setWizardHelper(WizardHelper helper) {
        this._helper = helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processForm() {
        if (this.getJettyString("cancelbw") != null) {
            this.cancelNDT();
            int i = 0;
            while (i < 20 && !this._helper.isNDTComplete()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
            return;
        }
        if (this.getJettyString("next") == null) {
            return;
        }
        if (this._action.equals("blah")) {
            HashMap<String, String> changes;
            boolean updated;
            String page = this.getJettyString("page");
            if (this.getJettyString("lang") != null) {
                this.addFormNoticeNoEscape(this._t("Console language saved."));
            }
            if ("3".equals(page)) {
                this.startNDT();
            } else if ("4".equals(page)) {
                WizardHelper wizardHelper = this._helper;
                synchronized (wizardHelper) {
                    if (this._helper.isNDTSuccessful()) {
                        this.addFormNotice(this._t("Bandwidth test completed successfully"));
                    } else if (this._helper.isNDTComplete()) {
                        this.addFormError(this._t("Bandwidth test failed"));
                    } else if (this._helper.isNDTRunning()) {
                        this.addFormError(this._t("Bandwidth test did not complete"));
                    } else {
                        this.addFormError(this._t("Bandwidth test did not complete"));
                    }
                }
            } else if ("5".equals(page) && (updated = this.updateRates(changes = new HashMap<String, String>()))) {
                boolean saved = this._context.router().saveConfig(changes, null);
                this._context.bandwidthLimiter().reinitialize();
                if (saved) {
                    this.addFormNotice(this._t("Configuration saved successfully"));
                } else {
                    this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
                }
            }
        } else {
            this.addFormError(String.valueOf(this._t("Unsupported")) + ": " + this._action);
        }
    }

    private boolean updateRates(Map<String, String> changes) {
        float kb;
        String old;
        boolean updated = false;
        boolean bwUpdated = false;
        String sharePct = this.getJettyString("sharePercentage");
        String inboundRate = this.getJettyString("inboundrate");
        String outboundRate = this.getJettyString("outboundrate");
        if (!(sharePct == null || (old = this._context.router().getConfigSetting("router.sharePercentage")) != null && old.equals(sharePct))) {
            changes.put("router.sharePercentage", sharePct);
            this.addFormNotice(this._t("Updating bandwidth share percentage"));
            updated = true;
        }
        if (inboundRate != null && inboundRate.length() > 0 && !inboundRate.equals(this._context.getProperty("i2np.bandwidth.inboundBurstKBytesPerSecond", Integer.toString(300)))) {
            try {
                float rate = (float)Integer.parseInt(inboundRate) / 1.024f;
                kb = 20.0f * rate;
                changes.put("i2np.bandwidth.inboundBurstKBytesPerSecond", Integer.toString(Math.round(rate)));
                changes.put("i2np.bandwidth.inboundBurstKBytes", Integer.toString(Math.round(kb)));
                rate -= Math.min(rate * 10.0f / 100.0f, 50.0f);
                changes.put("i2np.bandwidth.inboundKBytesPerSecond", Integer.toString(Math.round(rate)));
                bwUpdated = true;
            }
            catch (NumberFormatException nfe) {
                this.addFormError(this._t("Invalid bandwidth"));
            }
        }
        if (outboundRate != null && outboundRate.length() > 0 && !outboundRate.equals(this._context.getProperty("i2np.bandwidth.outboundBurstKBytesPerSecond", Integer.toString(60)))) {
            try {
                float rate = (float)Integer.parseInt(outboundRate) / 1.024f;
                kb = 20.0f * rate;
                changes.put("i2np.bandwidth.outboundBurstKBytesPerSecond", Integer.toString(Math.round(rate)));
                changes.put("i2np.bandwidth.outboundBurstKBytes", Integer.toString(Math.round(kb)));
                rate -= Math.min(rate * 10.0f / 100.0f, 50.0f);
                changes.put("i2np.bandwidth.outboundKBytesPerSecond", Integer.toString(Math.round(rate)));
                bwUpdated = true;
            }
            catch (NumberFormatException nfe) {
                this.addFormError(this._t("Invalid bandwidth"));
            }
        }
        if (bwUpdated) {
            this.addFormNotice(this._t("Updated bandwidth limits"));
            updated = true;
        }
        return updated;
    }

    private void startNDT() {
        if (this._helper == null) {
            this.addFormError("Bad state for test");
        } else if (this._helper.startNDT()) {
            this.addFormNotice(this._t("Bandwidth test started"));
        } else {
            this.addFormError(this._t("Bandwidth test is already running"));
        }
    }

    private void cancelNDT() {
        if (this._helper == null) {
            this.addFormError("Bad state for test");
        } else if (this._helper.cancelNDT()) {
            this.addFormError(this._t("Bandwidth test cancelled"));
        } else {
            this.addFormError(this._t("Bandwidth test was not running"));
        }
    }
}

