/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.servlets;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.i2p.I2PAppContext;
import net.i2p.router.web.NavHelper;
import net.i2p.util.FileUtil;

public class CodedIconRendererServlet
extends HttpServlet {
    private static final long serialVersionUID = 16851750L;
    private static final String base = I2PAppContext.getGlobalContext().getBaseDir().getAbsolutePath();
    private static final String file = "docs" + File.separatorChar + "themes" + File.separatorChar + "console" + File.separatorChar + "images" + File.separatorChar + "plugin.png";

    protected void doGet(HttpServletRequest srq, HttpServletResponse srs) throws ServletException, IOException {
        String name = srq.getParameter("plugin");
        byte[] data = NavHelper.getBinary(name);
        srs.setContentType("image/png");
        srs.setHeader("X-Content-Type-Options", "nosniff");
        srs.setHeader("Accept-Ranges", "none");
        srs.setDateHeader("Expires", I2PAppContext.getGlobalContext().clock().now() + 86400000L);
        srs.setHeader("Cache-Control", "public, max-age=86400");
        ServletOutputStream os = srs.getOutputStream();
        if (data != null) {
            srs.setHeader("Content-Length", Integer.toString(data.length));
            int content = Arrays.hashCode(data);
            int chksum = srq.getIntHeader("If-None-Match");
            if (content != chksum) {
                srs.setIntHeader("ETag", content);
                try {
                    os.write(data);
                    os.flush();
                    os.close();
                }
                catch (IOException e) {
                    I2PAppContext.getGlobalContext().logManager().getLog(((Object)((Object)this)).getClass()).warn("Error writing binary image data for plugin", (Throwable)e);
                }
            } else {
                srs.setStatus(304);
                srs.getOutputStream().close();
            }
        } else {
            File pfile = new File(base, file);
            srs.setHeader("Content-Length", Long.toString(pfile.length()));
            try {
                long lastmod = pfile.lastModified();
                if (lastmod > 0L) {
                    long iflast = srq.getDateHeader("If-Modified-Since");
                    if (iflast >= lastmod / 1000L * 1000L) {
                        srs.sendError(304, "Not Modified");
                    } else {
                        srs.setDateHeader("Last-Modified", lastmod);
                        FileUtil.readFile((String)file, (String)base, (OutputStream)os);
                    }
                }
            }
            catch (IOException e) {
                if (!srs.isCommitted()) {
                    srs.sendError(403, e.toString());
                }
                I2PAppContext.getGlobalContext().logManager().getLog(((Object)((Object)this)).getClass()).warn("Error serving plugin.png", (Throwable)e);
                throw e;
            }
        }
    }
}

