/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.ndt;

import edu.internet2.ndt.JSONUtils;
import edu.internet2.ndt.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class Protocol {
    private final InputStream _ctlInStream;
    private final OutputStream _ctlOutStream;
    private boolean jsonSupport = true;

    public Protocol(Socket ctlSocketParam) throws IOException {
        this._ctlInStream = ctlSocketParam.getInputStream();
        this._ctlOutStream = ctlSocketParam.getOutputStream();
    }

    public void send_msg(byte bParamType, byte bParamToSend) throws IOException {
        byte[] tab = new byte[]{bParamToSend};
        this.send_msg(bParamType, tab);
    }

    public void send_json_msg(byte bParamType, byte bParamToSend) throws IOException {
        byte[] tab = new byte[]{bParamToSend};
        this.send_json_msg(bParamType, tab);
    }

    public void send_json_msg(byte bParamType, byte[] bParamToSend) throws IOException {
        if (this.jsonSupport) {
            this.send_msg(bParamType, JSONUtils.createJsonObj(bParamToSend));
        } else {
            this.send_msg(bParamType, bParamToSend);
        }
    }

    public void send_json_login_msg(byte bParamType, byte[] bParamToSend) throws IOException {
        if (this.jsonSupport) {
            byte[] ver = new byte[bParamToSend.length - 1];
            System.arraycopy(bParamToSend, 1, ver, 0, ver.length);
            this.send_msg(bParamType, JSONUtils.createJsonLoginObj(bParamToSend, bParamToSend[0]));
        } else {
            this.send_msg(bParamType, bParamToSend);
        }
    }

    public void send_msg(byte bParamType, byte[] bParamToSend) throws IOException {
        byte[] header = new byte[]{bParamType, (byte)(bParamToSend.length >> 8), (byte)bParamToSend.length};
        this._ctlOutStream.write(header);
        this._ctlOutStream.write(bParamToSend);
    }

    public int readn(Message msgParam, int iParamAmount) throws IOException {
        int read = 0;
        msgParam.initBodySize(iParamAmount);
        while (read != iParamAmount) {
            int tmp = this._ctlInStream.read(msgParam._yaBody, read, iParamAmount - read);
            if (tmp <= 0) {
                return read;
            }
            read += tmp;
        }
        return read;
    }

    public int recv_msg(Message msgParam) throws IOException {
        if (this.readn(msgParam, 3) != 3) {
            return 1;
        }
        byte[] yaMsgBody = msgParam.getBody();
        msgParam.setType(yaMsgBody[0]);
        int length = (yaMsgBody[1] & 0xFF) << 8;
        if (this.readn(msgParam, length += yaMsgBody[2] & 0xFF) != length) {
            return 3;
        }
        return 0;
    }

    public void close() {
        try {
            this._ctlInStream.close();
            this._ctlOutStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setJsonSupport(boolean jsonSupport) {
        this.jsonSupport = jsonSupport;
    }
}

