/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.news;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.DirKeyRing;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.crypto.SigType;
import net.i2p.crypto.SigUtil;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.router.news.RFC3339Date;
import net.i2p.util.Log;

public class BlocklistEntries {
    public final List<String> entries;
    public final List<String> removes;
    public String signer;
    public String sig;
    public String supdated;
    public long updated;
    private boolean verified;
    public static final int MAX_ENTRIES = 2000;
    private static final String CONTENT_ROUTER = "router";
    public static final long MAX_FUTURE = 172800000L;

    public BlocklistEntries(int capacity) {
        this.entries = new ArrayList<String>(capacity);
        this.removes = new ArrayList<String>(4);
    }

    public synchronized boolean isVerified() {
        return this.verified;
    }

    public synchronized boolean verify(I2PAppContext ctx) {
        SigningPublicKey spubkey;
        PublicKey pubkey;
        Signature ssig;
        if (this.verified) {
            return true;
        }
        if (this.signer == null || this.sig == null || this.supdated == null) {
            return false;
        }
        if (this.updated > ctx.clock().now() + 172800000L) {
            return false;
        }
        Log log = ctx.logManager().getLog(BlocklistEntries.class);
        String[] ss = DataHelper.split((String)this.sig, (String)":", (int)2);
        if (ss.length != 2) {
            log.error("blocklist feed bad sig: " + this.sig);
            return false;
        }
        SigType type = SigType.parseSigType((String)ss[0]);
        if (type == null) {
            log.error("blocklist feed bad sig: " + this.sig);
            return false;
        }
        if (!type.isAvailable()) {
            log.error("blocklist feed sigtype unavailable: " + this.sig);
            return false;
        }
        byte[] bsig = Base64.decode((String)ss[1]);
        if (bsig == null) {
            log.error("blocklist feed bad sig: " + this.sig);
            return false;
        }
        try {
            ssig = new Signature(type, bsig);
        }
        catch (IllegalArgumentException iae) {
            log.error("blocklist feed bad sig: " + this.sig);
            return false;
        }
        DirKeyRing ring = new DirKeyRing(new File(ctx.getBaseDir(), "certificates"));
        try {
            pubkey = ring.getKey(this.signer, CONTENT_ROUTER, type);
        }
        catch (IOException ioe) {
            log.error("blocklist feed error", (Throwable)ioe);
            return false;
        }
        catch (GeneralSecurityException gse) {
            log.error("blocklist feed error", (Throwable)gse);
            return false;
        }
        if (pubkey == null) {
            boolean diff = true;
            try {
                diff = !ctx.getBaseDir().getCanonicalPath().equals(ctx.getConfigDir().getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (diff) {
                ring = new DirKeyRing(new File(ctx.getConfigDir(), "certificates"));
                try {
                    pubkey = ring.getKey(this.signer, CONTENT_ROUTER, type);
                }
                catch (IOException ioe) {
                    log.error("blocklist feed error", (Throwable)ioe);
                    return false;
                }
                catch (GeneralSecurityException gse) {
                    log.error("blocklist feed error", (Throwable)gse);
                    return false;
                }
            }
            if (pubkey == null) {
                log.error("unknown signer for blocklist feed: " + this.signer);
                return false;
            }
        }
        try {
            spubkey = SigUtil.fromJavaKey((PublicKey)pubkey, (SigType)type);
        }
        catch (GeneralSecurityException gse) {
            log.error("blocklist feed bad sig: " + this.sig, (Throwable)gse);
            return false;
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append(this.supdated).append('\n');
        for (String s : this.entries) {
            buf.append(s).append('\n');
        }
        for (String s : this.removes) {
            buf.append('!').append(s).append('\n');
        }
        byte[] data = DataHelper.getUTF8((String)buf.toString());
        boolean rv = ctx.dsa().verifySignature(ssig, data, spubkey);
        if (rv) {
            log.info("blocklist feed sig ok");
        } else {
            log.error("blocklist feed sig verify fail: " + this.signer);
        }
        this.verified = rv;
        return rv;
    }

    public static void main(String[] args) {
        String date;
        StringBuilder buf;
        ArrayList<String> rlist;
        ArrayList<String> elist;
        I2PAppContext ctx;
        String signerName;
        String privateKeyFile;
        String inputFile;
        String kspass;
        block34: {
            int st;
            if (args.length < 3) {
                System.err.println("Usage: BlocklistEntries [-p keystorepw] input.txt keystore.ks you@mail.i2p");
                System.exit(1);
            }
            if (args[0].equals("-p")) {
                kspass = args[1];
                st = 2;
            } else {
                kspass = "changeit";
                st = 0;
            }
            inputFile = args[st++];
            privateKeyFile = args[st++];
            signerName = args[st];
            ctx = new I2PAppContext();
            elist = new ArrayList<String>(16);
            rlist = new ArrayList<String>(4);
            buf = new StringBuilder();
            long now = System.currentTimeMillis();
            date = RFC3339Date.to3339Date(now);
            buf.append(date).append('\n');
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-8"));
                    String s = null;
                    while ((s = br.readLine()) != null) {
                        int index = s.indexOf(35);
                        if (index == 0) continue;
                        if (index > 0) {
                            s = s.substring(0, index);
                        }
                        if ((s = s.trim()).length() < 7) {
                            if (s.length() <= 0) continue;
                            System.err.println("Bad line: " + s);
                            continue;
                        }
                        if (s.startsWith("!")) {
                            rlist.add(s.substring(1));
                            continue;
                        }
                        elist.add(s);
                        buf.append(s).append('\n');
                    }
                }
                catch (IOException ioe) {
                    System.err.println("load error from " + args[0]);
                    ioe.printStackTrace();
                    System.exit(1);
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (elist.isEmpty() && rlist.isEmpty()) {
            System.err.println("Signing empty blocklist");
        }
        if (elist.size() > 2000) {
            System.err.println("too many blocks, max is 2000");
            System.exit(1);
        }
        for (String s : rlist) {
            buf.append('!').append(s).append('\n');
        }
        SigningPrivateKey spk = null;
        try {
            String keypw = "";
            while (keypw.length() < 6) {
                System.err.print("Enter password for key \"" + signerName + "\": ");
                keypw = DataHelper.readLine((InputStream)System.in);
                if (keypw == null) {
                    System.out.println("\nEOF reading password");
                    System.exit(1);
                }
                if ((keypw = keypw.trim()).length() <= 0 || keypw.length() >= 6) continue;
                System.out.println("Key password must be at least 6 characters");
            }
            File pkfile = new File(privateKeyFile);
            PrivateKey pk = KeyStoreUtil.getPrivateKey((File)pkfile, (String)kspass, (String)signerName, (String)keypw);
            if (pk == null) {
                System.out.println("Private key for " + signerName + " not found in keystore " + privateKeyFile);
                System.exit(1);
            }
            spk = SigUtil.fromJavaKey((PrivateKey)pk);
        }
        catch (GeneralSecurityException gse) {
            System.out.println("Error signing input file '" + inputFile + "'");
            gse.printStackTrace();
            System.exit(1);
        }
        catch (IOException ioe) {
            System.out.println("Error signing input file '" + inputFile + "'");
            ioe.printStackTrace();
            System.exit(1);
        }
        SigType type = spk.getType();
        byte[] data = DataHelper.getUTF8((String)buf.toString());
        Signature ssig = ctx.dsa().sign(data, spk);
        if (ssig == null) {
            System.err.println("sign failed");
            System.exit(1);
        }
        String bsig = Base64.encode((byte[])ssig.getData());
        BlocklistEntries ble = new BlocklistEntries(elist.size());
        ble.entries.addAll(elist);
        ble.removes.addAll(rlist);
        ble.supdated = date;
        ble.signer = signerName;
        ble.sig = String.valueOf(type.getCode()) + ":" + bsig;
        boolean ok = ble.verify(ctx);
        if (!ok) {
            System.err.println("verify failed");
            System.exit(1);
        }
        System.out.println("  <i2p:blocklist signer=\"" + signerName + "\" sig=\"" + type.getCode() + ':' + bsig + "\">");
        System.out.println("    <updated>" + date + "</updated>");
        for (String e : elist) {
            System.out.println("    <i2p:block>" + e + "</i2p:block>");
        }
        for (String e : rlist) {
            System.out.println("    <i2p:unblock>" + e + "</i2p:unblock>");
        }
        System.out.println("  </i2p:blocklist>");
    }
}

