/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.NewsFetcher;
import net.i2p.router.update.UpdateHandler;
import net.i2p.router.web.ConfigUpdateHelper;
import net.i2p.update.Checker;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateTask;
import net.i2p.update.UpdateType;

class NewsHandler
extends UpdateHandler
implements Checker {
    private static final String BACKUP_NEWS_URL = "http://dn3tvalnjz432qkqsvpfdqrwpqkw3ye4n4i2uyfr4jexvo3sp5ka.b32.i2p/news/news.atom.xml";
    private static final String DEFAULT_BACKUP_NEWS_URL_SU3 = "http://dn3tvalnjz432qkqsvpfdqrwpqkw3ye4n4i2uyfr4jexvo3sp5ka.b32.i2p/news/news.su3";
    private static final String PROP_BACKUP_NEWS_URL_SU3 = "router.backupNewsURL";

    public NewsHandler(RouterContext ctx, ConsoleUpdateManager mgr) {
        super(ctx, mgr);
    }

    public UpdateTask check(UpdateType type, UpdateMethod method, String id, String currentVersion, long maxTime) {
        if (type != UpdateType.ROUTER_SIGNED && type != UpdateType.NEWS && type != UpdateType.NEWS_SU3 || method != UpdateMethod.HTTP) {
            return null;
        }
        ArrayList<URI> updateSources = new ArrayList<URI>(2);
        try {
            updateSources.add(new URI(ConfigUpdateHelper.getNewsURL((I2PAppContext)this._context)));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        try {
            updateSources.add(new URI(this._context.getProperty(PROP_BACKUP_NEWS_URL_SU3, DEFAULT_BACKUP_NEWS_URL_SU3)));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        NewsFetcher update = new NewsFetcher(this._context, this._mgr, updateSources);
        return update;
    }
}

