/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.atomic.AtomicBoolean;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientAppManager;
import net.i2p.app.NotificationService;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;

public class DeadlockDetector
extends SimpleTimer2.TimedEvent {
    private final RouterContext _context;
    private final Log _log;
    private static final String PROP_INTERVAL = "router.deadlockDetectIntervalHours";
    private static final long DEFAULT_INTERVAL = SystemVersion.isSlow() ? 12 : 4;
    private static final AtomicBoolean _isDeadlocked = new AtomicBoolean();

    public DeadlockDetector(RouterContext ctx) {
        super(ctx.simpleTimer2());
        this._context = ctx;
        this._log = this._context.logManager().getLog(DeadlockDetector.class);
        long interval = this.getInterval();
        if (interval > 0L) {
            this.schedule(interval);
        }
    }

    private long getInterval() {
        long rv = this._context.getProperty(PROP_INTERVAL, DEFAULT_INTERVAL);
        return rv * 60L * 60L * 1000L;
    }

    public void timeReached() {
        long start = System.currentTimeMillis();
        boolean detected = this.detect();
        if (!detected) {
            long interval;
            long time = System.currentTimeMillis() - start;
            if (this._log.shouldDebug()) {
                this._log.debug("No deadlocks detected, took " + time + "ms");
            }
            if ((interval = this.getInterval()) > 0L) {
                this.schedule(interval);
            }
        }
    }

    private boolean detect() {
        return DeadlockDetector.detect(this._context);
    }

    public static boolean detect(RouterContext ctx) {
        long[] ids;
        ThreadMXBean mxb;
        block10: {
            if (_isDeadlocked.get()) {
                return true;
            }
            mxb = ManagementFactory.getThreadMXBean();
            ids = mxb.findDeadlockedThreads();
            if (ids != null) break block10;
            return false;
        }
        try {
            NotificationService ns;
            ThreadInfo[] infos;
            try {
                infos = mxb.getThreadInfo(ids, true, true);
            }
            catch (UnsupportedOperationException e) {
                infos = mxb.getThreadInfo(ids, Integer.MAX_VALUE);
            }
            StringBuilder buf = new StringBuilder(2048);
            String msg1 = String.valueOf(Messages.getString("Deadlock detected", (I2PAppContext)ctx)) + " - " + Messages.getString("Please report", (I2PAppContext)ctx);
            buf.append(msg1).append("\n\n");
            int i = 0;
            while (i < infos.length) {
                ThreadInfo info = infos[i];
                if (info != null) {
                    buf.append("Thread ").append(i).append(':');
                    buf.append(info.toString());
                    StackTraceElement[] stes = info.getStackTrace();
                    buf.append("        Stack Trace:\n");
                    StackTraceElement[] stackTraceElementArray = stes;
                    int n = stes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StackTraceElement ste = stackTraceElementArray[n2];
                        buf.append("        at ").append(ste.toString()).append('\n');
                        ++n2;
                    }
                    buf.append('\n');
                }
                ++i;
            }
            String msg2 = Messages.getString("After reporting, please restart your router", (I2PAppContext)ctx);
            buf.append('\n').append(msg2).append('\n');
            Log log = ctx.logManager().getLog(DeadlockDetector.class);
            log.log(50, buf.toString());
            ctx.router().eventLog().addEvent("deadlock", String.valueOf(infos.length) + " threads");
            _isDeadlocked.set(true);
            ClientAppManager cmgr = ctx.clientAppManager();
            if (cmgr != null && (ns = (NotificationService)cmgr.getRegisteredApp("desktopgui")) != null) {
                ns.notify("Router", null, 50, Messages.getString("Router", (I2PAppContext)ctx), String.valueOf(msg1) + '\n' + msg2, null);
            }
        }
        catch (Throwable t) {
            Log log = ctx.logManager().getLog(DeadlockDetector.class);
            log.warn("fail", t);
            return false;
        }
        return true;
    }

    public static boolean isDeadlocked() {
        return _isDeadlocked.get();
    }
}

