/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.app.NavService;
import net.i2p.router.web.App;

public class NavHelper
implements NavService,
ClientApp {
    private final Map<String, App> _apps = new ConcurrentHashMap<String, App>(4);
    private final Map<String, byte[]> _binary = new ConcurrentHashMap<String, byte[]>(4);

    public void registerApp(String appName, String displayName, String path, String tooltip, String iconpath) {
        if (iconpath != null && !iconpath.startsWith("/")) {
            iconpath = null;
        }
        this._apps.put(appName, new App(displayName, tooltip, path, iconpath));
    }

    public void unregisterApp(String name) {
        this._apps.remove(name);
    }

    public byte[] getBinary(String name) {
        if (name != null) {
            return this._binary.get(name);
        }
        return null;
    }

    public void setBinary(String name, byte[] arr) {
        this._binary.put(name, arr);
    }

    public Map<String, String> getClientAppLinks() {
        if (this._apps.isEmpty()) {
            return null;
        }
        HashMap<String, String> rv = new HashMap<String, String>(this._apps.size());
        StringBuilder buf = new StringBuilder(128);
        for (Map.Entry<String, App> e : this._apps.entrySet()) {
            String appName = e.getKey();
            App app = e.getValue();
            String path = app.url;
            if (path == null) continue;
            String name = app.name;
            buf.setLength(0);
            buf.append("<tr><td>");
            this.getClientAppImg(buf, appName, app.icon);
            buf.append("</td><td align=\"left\"><a target=\"_blank\" href=\"").append(path).append("\" ");
            String tip = app.desc;
            if (tip != null) {
                buf.append("title=\"").append(tip).append("\" ");
            }
            buf.append('>').append(name.replace(" ", "&nbsp;")).append("</a></td></tr>\n");
            rv.put(name, buf.toString());
        }
        return rv;
    }

    private void getClientAppImg(StringBuilder buf, String name, String iconpath) {
        if (iconpath != null) {
            buf.append("<img src=\"").append(iconpath).append("\" height=\"16\" width=\"16\" alt=\"\">");
        } else if (name.equals("orchid")) {
            buf.append("<img src=\"/themes/console/light/images/flower.png\" alt=\"\">");
        } else if (name.equals("i2pbote")) {
            buf.append("<img src=\"/themes/console/light/images/mail_black.png\" alt=\"\">");
        } else {
            buf.append("<img src=\"/themes/console/images/plugin.png\" height=\"16\" width=\"16\" alt=\"\">");
        }
    }

    public List<App> getClientApps(I2PAppContext ctx) {
        if (this._apps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<App> rv = new ArrayList<App>(this._apps.size());
        for (Map.Entry<String, App> e : this._apps.entrySet()) {
            String icon;
            String name = e.getKey();
            App mapp = e.getValue();
            if (mapp.url == null) continue;
            String tip = mapp.desc;
            if (tip == null) {
                tip = "";
            }
            if ((icon = mapp.icon) == null) {
                icon = name.equals("i2pbote") ? "/themes/console/images/email.png" : "/themes/console/images/plugin.png";
            }
            App app = new App(mapp.name, tip, mapp.url, icon);
            rv.add(app);
        }
        return rv;
    }

    public static NavHelper getInstance() {
        return NavHelper.getInstance(I2PAppContext.getGlobalContext());
    }

    public static NavHelper getInstance(I2PAppContext ctx) {
        ClientAppManager cmgr = ctx.clientAppManager();
        if (cmgr != null) {
            return (NavHelper)cmgr.getRegisteredApp("NavHelper");
        }
        return null;
    }

    public void startup() {
    }

    public void shutdown(String[] args) {
        this._apps.clear();
        this._binary.clear();
    }

    public ClientAppState getState() {
        return ClientAppState.RUNNING;
    }

    public String getName() {
        return "NavHelper";
    }

    public String getDisplayName() {
        return "Nav Helper";
    }
}

