/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.Collections;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientAppManager;
import net.i2p.data.DataHelper;
import net.i2p.router.news.NewsEntry;
import net.i2p.router.news.NewsManager;
import net.i2p.router.web.HelperBase;

public class NewsFeedHelper
extends HelperBase {
    private int _start;
    private int _limit = 2;

    public void setLimit(int limit) {
        this._limit = limit;
    }

    public void setStart(int start) {
        this._start = start;
    }

    public String getEntries() {
        return NewsFeedHelper.getEntries((I2PAppContext)this._context, this._start, this._limit, 0L);
    }

    static String getEntries(I2PAppContext ctx, int start, int max, long ageLimit) {
        NewsManager nmgr;
        if (max <= 0) {
            max = Integer.MAX_VALUE;
        }
        StringBuilder buf = new StringBuilder(512);
        List<Object> entries = Collections.emptyList();
        ClientAppManager cmgr = ctx.clientAppManager();
        if (cmgr != null && (nmgr = (NewsManager)cmgr.getRegisteredApp("news")) != null) {
            entries = nmgr.getEntries();
            NewsEntry newsEntry = nmgr.getInitialNews();
            if (!(newsEntry == null || entries.size() == 1 && DataHelper.eq((Object)((NewsEntry)entries.get((int)0)).title, (Object)newsEntry.title))) {
                if (entries.isEmpty()) {
                    entries = Collections.singletonList(newsEntry);
                } else {
                    entries.add(newsEntry);
                }
            }
        }
        if (!entries.isEmpty()) {
            int i = 0;
            for (NewsEntry newsEntry : entries) {
                if (i < start) continue;
                if (i > start && newsEntry.updated > 0L && ageLimit > 0L && newsEntry.updated < ctx.clock().now() - ageLimit) break;
                buf.append("<div class=\"newsentry\"><h3>");
                if (newsEntry.updated > 0L) {
                    buf.append("<span class=\"newsDate\">").append(DataHelper.formatDate((long)newsEntry.updated)).append("</span> ");
                }
                if (newsEntry.link != null) {
                    buf.append("<a href=\"").append(DataHelper.escapeHTML((String)newsEntry.link)).append("\">");
                }
                buf.append(newsEntry.title);
                if (newsEntry.link != null) {
                    buf.append("</a>");
                }
                if (newsEntry.authorName != null) {
                    buf.append(" <span class=\"newsAuthor\" title=\"Post author\"><i>").append(DataHelper.escapeHTML((String)newsEntry.authorName)).append("</i></span>\n");
                }
                buf.append("</h3>\n<div class=\"newscontent\">\n").append(newsEntry.content).append("\n</div></div>\n");
                if (++i >= start + max) break;
            }
        }
        return buf.toString();
    }
}

