/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class ShellService
implements ClientApp {
    private static final String NAME_OPTION = "-shellservice.name";
    private static final String DISPLAY_NAME_OPTION = "-shellservice.displayname";
    private static final String PLUGIN_DIR = "plugins";
    private final Log _log;
    private final ProcessBuilder _pb;
    private final I2PAppContext _context;
    private final ClientAppManager _cmgr;
    private final String _commandPath;
    private final File _errorLog;
    private final File _outputLog;
    private ClientAppState _state = ClientAppState.UNINITIALIZED;
    private volatile String name = "unnamedClient";
    private volatile String displayName = "unnamedClient";
    private Process _p;

    public ShellService(I2PAppContext context, ClientAppManager listener, String[] args) {
        this._context = context;
        this._cmgr = listener;
        this._log = context.logManager().getLog(ShellService.class);
        ArrayList<String> procArgs = this.trimArgs(args);
        if (this._log.shouldLog(10)) {
            this._log.debug("ShellService: Process: " + procArgs.toString());
            this._log.debug("ShellService: Name: " + this.getName() + ", DisplayName: " + this.getDisplayName());
        }
        this._commandPath = procArgs.get(0);
        File exe = new File(this._commandPath);
        if (!exe.exists()) {
            if (this._log.shouldLog(40)) {
                this._log.error("ShellService: Command does not exist: " + this._commandPath);
            }
            throw new RuntimeException("Command does not exist: " + this._commandPath);
        }
        if (!exe.canExecute()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("ShellService: Command is not executable: " + this._commandPath + " marking it executable");
            }
            exe.setExecutable(true);
        }
        this._pb = new ProcessBuilder(procArgs);
        if (this._log.shouldDebug()) {
            this._log.debug("ShellService: ProcessBuilder: " + this._pb.command().toString() + " is built");
        }
        String tmp_name = this.getName();
        File pluginDir = new File(this._context.getConfigDir(), "plugins/" + tmp_name);
        if (!pluginDir.exists()) {
            pluginDir = new File(this._context.getConfigDir(), "plugins/" + tmp_name + "-" + SystemVersion.getOS() + "-" + SystemVersion.getArch());
            if (!pluginDir.exists()) {
                pluginDir = new File(this._context.getConfigDir(), "plugins/" + tmp_name + "-" + SystemVersion.getOS());
                if (!pluginDir.exists()) {
                    throw new RuntimeException("Plugin directory does not exist: " + pluginDir.getAbsolutePath());
                }
                this.name = String.valueOf(tmp_name) + "-" + SystemVersion.getOS();
                if (this._log.shouldDebug()) {
                    this._log.debug("ShellService: Plugin name revised to match directory: " + this.getName());
                }
            } else {
                this.name = String.valueOf(tmp_name) + "-" + SystemVersion.getOS() + "-" + SystemVersion.getArch();
                if (this._log.shouldDebug()) {
                    this._log.debug("ShellService: Plugin name revised to match directory: " + this.getName());
                }
            }
        }
        this._errorLog = new File(pluginDir, "error.log");
        this._outputLog = new File(pluginDir, "output.log");
        this._pb.redirectOutput(this._outputLog);
        this._pb.redirectError(this._errorLog);
        if (this._log.shouldLog(10)) {
            this._log.debug("ShellService: Logs: " + this._errorLog.getAbsolutePath() + ", " + this._outputLog.getAbsolutePath());
        }
        this._pb.directory(pluginDir);
        if (this._log.shouldDebug()) {
            this._log.debug("ShellService: ProcessBuilder: " + this._pb.directory() + " is set");
        }
        this.changeState(ClientAppState.INITIALIZED, "ShellService: " + this.getName() + " setup and initialized");
    }

    private ArrayList<String> trimArgs(String[] args) {
        ArrayList<String> newargs = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith(NAME_OPTION)) {
                if (args[i].contains("=")) {
                    this.name = args[i].split("=")[1];
                } else {
                    this.name = args[i + 1];
                    ++i;
                }
            } else if (args[i].startsWith(DISPLAY_NAME_OPTION)) {
                if (args[i].contains("=")) {
                    this.displayName = args[i].split("=")[1];
                } else {
                    this.displayName = args[i + 1];
                    ++i;
                }
            } else {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Adding arg: " + args[i]);
                }
                newargs.add(args[i]);
            }
            ++i;
        }
        if (this.getName() == null) {
            throw new IllegalArgumentException("ShellService: ShellService passed with args=" + Arrays.toString(args) + " must have a name");
        }
        if (this.getDisplayName() == null) {
            this.displayName = this.name;
        }
        return newargs;
    }

    private synchronized void changeState(ClientAppState newState, String message, Exception ex) {
        if (this._state != newState) {
            this._state = newState;
            this._cmgr.notify((ClientApp)this, newState, message, ex);
        }
    }

    private synchronized void changeState(ClientAppState newState, String message) {
        this.changeState(newState, message, null);
    }

    public synchronized void startup() throws Throwable {
        Boolean reg;
        File exe = new File(this._commandPath);
        if (!exe.exists()) {
            if (this._log.shouldLog(40)) {
                this._log.error("ShellService: Command does not exist: " + this._commandPath);
            }
            throw new RuntimeException("Command does not exist: " + this._commandPath);
        }
        if (!exe.canExecute()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("ShellService: Command is not executable: " + this._commandPath + " marking it executable");
            }
            exe.setExecutable(true);
        }
        if (this.getName().equals("unnamedClient")) {
            if (this._log.shouldLog(30)) {
                this._log.warn("ShellService: ShellService has no name, not starting");
            }
            return;
        }
        this.changeState(ClientAppState.STARTING, "ShellService: " + this.getName() + " starting");
        boolean start = this.isProcessStopped();
        if (start) {
            this._p = this._pb.start();
            if (!this._p.isAlive() && this._log.shouldLog(40)) {
                this._log.error("ShellService: Error getting Process of application from recently instantiated shellservice " + this._pb.command() + " " + this._p.exitValue());
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("ShellService: Started " + this.getName() + "process");
            }
        }
        if (this._p.isAlive()) {
            this.changeState(ClientAppState.RUNNING, "ShellService: " + this.getName() + " started");
        }
        if ((reg = Boolean.valueOf(this._cmgr.register((ClientApp)this))).booleanValue()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("ShellService: " + this.getName() + " registered with the router");
            }
        } else {
            if (this._log.shouldLog(30)) {
                this._log.warn("ShellService: " + this.getName() + " failed to register with the router");
            }
            this._cmgr.unregister((ClientApp)this);
            this._cmgr.register((ClientApp)this);
        }
    }

    public boolean isProcessStopped() {
        return !this.isProcessRunning();
    }

    public boolean isProcessRunning() {
        if (this._p == null) {
            return false;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("ShellService: Checking process status " + this.getName() + this._p.isAlive());
        }
        return this._p.isAlive();
    }

    public synchronized void shutdown(String[] args) throws Throwable {
        if (this.getName().equals("unnamedClient")) {
            if (this._log.shouldLog(30)) {
                this._log.warn("ShellService: ShellService has no name, not shutting down");
            }
            return;
        }
        this.changeState(ClientAppState.STOPPING, "ShellService: " + this.getName() + " stopping");
        if (this._p != null) {
            if (this._log.shouldLog(10)) {
                this._log.debug("ShellService: Stopping " + this.getName() + "process started with ShellService " + this.getName());
            }
            this._p.destroy();
        }
        this.changeState(ClientAppState.STOPPED, "ShellService: " + this.getName() + " stopped");
        this._cmgr.unregister((ClientApp)this);
    }

    public ClientAppState getState() {
        if (!this.isProcessRunning()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("ShellService: Process is not running " + this.getName());
            }
            this.changeState(ClientAppState.STOPPED, "ShellService: " + this.getName() + " stopped");
            this._cmgr.unregister((ClientApp)this);
        }
        return this._state;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

