/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.router.web.LocaleWebAppHandler;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.WebAppConfiguration;
import net.i2p.util.FileUtil;
import net.i2p.util.SecureDirectory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebAppStarter {
    private static final Map<String, Long> warModTimes = new ConcurrentHashMap<String, Long>();
    static final Map<String, String> INIT_PARAMS = new HashMap<String, String>(4);
    static final String PARAM_PLUGIN_NAME = "net.i2p.router.web.WebAppStarter.PLUGIN_NAME";
    private static final String CLASS_ANNOT = "org.eclipse.jetty.annotations.AnnotationConfiguration";
    private static final String CLASS_ANNOT2 = "org.eclipse.jetty.plus.annotation.LifeCycleCallback";
    private static final String CLASS_ANNOT3 = "org.objectweb.asm.Type";
    private static final String CLASS_ANNOT4 = "javax.annotation.security.RunAs";
    private static final String CLASS_CONFIG = "org.eclipse.jetty.webapp.JettyWebXmlConfiguration";
    private static final boolean HAS_ANNOTATION_CLASSES;
    private static final Set<String> BUILTINS;

    static {
        BUILTINS = new HashSet<String>(8);
        String pfx = "org.eclipse.jetty.servlet.Default.";
        INIT_PARAMS.put(String.valueOf(pfx) + "cacheControl", "max-age=86400");
        INIT_PARAMS.put(String.valueOf(pfx) + "dirAllowed", "false");
        boolean found = false;
        try {
            Class<?> cls = Class.forName(CLASS_ANNOT, false, ClassLoader.getSystemClassLoader());
            cls = Class.forName(CLASS_ANNOT2, false, ClassLoader.getSystemClassLoader());
            cls = Class.forName(CLASS_ANNOT3, false, ClassLoader.getSystemClassLoader());
            cls = Class.forName(CLASS_ANNOT4, false, ClassLoader.getSystemClassLoader());
            found = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        HAS_ANNOTATION_CLASSES = found;
        BUILTINS.addAll(Arrays.asList("i2psnark", "i2ptunnel", "imagegen", "jsonrpc", "routerconsole", "susidns", "susimail"));
    }

    public static void startWebApp(RouterContext ctx, ContextHandlerCollection server, String appName, String warPath) throws Exception {
        WebAppStarter.startWebApp(ctx, server, appName, warPath, null);
    }

    public static void startWebApp(RouterContext ctx, ContextHandlerCollection server, String appName, String warPath, String pluginName) throws Exception {
        SecureDirectory tmpdir = new SecureDirectory(ctx.getTempDir(), "jetty-work-" + appName + ctx.random().nextInt());
        WebAppContext wac = WebAppStarter.addWebApp(ctx, server, appName, warPath, (File)tmpdir);
        LocaleWebAppHandler.setInitParams(wac, INIT_PARAMS);
        if (pluginName != null) {
            wac.setInitParameter(PARAM_PLUGIN_NAME, pluginName);
        }
        wac.setThrowUnavailableOnStartupException(true);
        wac.start();
        int port = ctx.portMapper().getPort("console", 7657);
        String host = ctx.portMapper().getActualHost("console", "127.0.0.1");
        ctx.portMapper().register(appName, host, port);
    }

    static WebAppContext addWebApp(RouterContext ctx, ContextHandlerCollection server, String appName, String warPath, File tmpdir) throws IOException {
        try {
            WebAppStarter.stopWebApp(ctx, appName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        long newmod = new File(warPath).lastModified();
        if (newmod <= 0L) {
            throw new IOException("Web app " + warPath + " does not exist");
        }
        Long oldmod = warModTimes.get(warPath);
        if (oldmod == null) {
            warModTimes.put(warPath, newmod);
        } else if (oldmod < newmod) {
            SecureDirectory warTmpDir = new SecureDirectory(ctx.getTempDir(), "war-copy-" + appName + ctx.random().nextInt());
            warTmpDir.mkdir();
            String tmpPath = new File((File)warTmpDir, String.valueOf(appName) + ".war").getAbsolutePath();
            if (!FileUtil.copy((String)warPath, (String)tmpPath, (boolean)true)) {
                throw new IOException("Web app failed copy from " + warPath + " to " + tmpPath);
            }
            warPath = tmpPath;
        }
        WebAppContext wac = new WebAppContext(warPath, "/" + appName);
        tmpdir.mkdir();
        wac.setTempDirectory(tmpdir);
        boolean scanAnnotations = HAS_ANNOTATION_CLASSES && !BUILTINS.contains(appName);
        wac.setExtractWAR(scanAnnotations);
        RouterConsoleRunner.initialize(ctx, wac);
        WebAppStarter.setWebAppConfiguration(wac, scanAnnotations);
        server.addHandler((Handler)wac);
        server.mapContexts();
        return wac;
    }

    static void setWebAppConfiguration(WebAppContext wac, boolean scanAnnotations) {
        String[] classNames = wac.getConfigurationClasses();
        if (classNames.length == 0) {
            classNames = WebAppContext.getDefaultConfigurationClasses();
        }
        ArrayList<String> newClassNames = new ArrayList<String>(Arrays.asList(classNames));
        for (String name : newClassNames) {
            wac.prependServerClass("-" + name);
        }
        if (scanAnnotations && !newClassNames.contains(CLASS_ANNOT)) {
            int idx = newClassNames.indexOf(CLASS_CONFIG);
            if (idx >= 0) {
                newClassNames.add(idx, CLASS_ANNOT);
            } else {
                newClassNames.add(CLASS_ANNOT);
            }
        }
        newClassNames.add(WebAppConfiguration.class.getName());
        wac.setConfigurationClasses(newClassNames.toArray(new String[newClassNames.size()]));
    }

    public static void stopWebApp(RouterContext ctx, String appName) {
        ContextHandler wac = WebAppStarter.getWebApp((I2PAppContext)ctx, appName);
        if (wac == null) {
            return;
        }
        ctx.portMapper().unregister(appName);
        try {
            wac.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ContextHandlerCollection server = WebAppStarter.getConsoleServer((I2PAppContext)ctx);
        if (server == null) {
            return;
        }
        try {
            server.removeHandler((Handler)wac);
            server.mapContexts();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    static void stopWebApp(RouterContext ctx, Server s, String appName) {
        ContextHandlerCollection server = WebAppStarter.getConsoleServer(s);
        if (server == null) {
            return;
        }
        ContextHandler wac = WebAppStarter.getWebApp(server, appName);
        if (wac == null) {
            return;
        }
        ctx.portMapper().unregister(appName);
        try {
            wac.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            server.removeHandler((Handler)wac);
            server.mapContexts();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static boolean isWebAppRunning(I2PAppContext ctx, String appName) {
        ContextHandler wac = WebAppStarter.getWebApp(ctx, appName);
        if (wac == null) {
            return false;
        }
        return wac.isStarted();
    }

    static boolean isWebAppRunning(Server s, String appName) {
        ContextHandler wac = WebAppStarter.getWebApp(s, appName);
        if (wac == null) {
            return false;
        }
        return wac.isStarted();
    }

    static ContextHandler getWebApp(I2PAppContext ctx, String appName) {
        ContextHandlerCollection server = WebAppStarter.getConsoleServer(ctx);
        if (server == null) {
            return null;
        }
        return WebAppStarter.getWebApp(server, appName);
    }

    static ContextHandler getWebApp(Server s, String appName) {
        ContextHandlerCollection server = WebAppStarter.getConsoleServer(s);
        if (server == null) {
            return null;
        }
        return WebAppStarter.getWebApp(server, appName);
    }

    private static ContextHandler getWebApp(ContextHandlerCollection server, String appName) {
        Handler[] handlers = server.getHandlers();
        if (handlers == null) {
            return null;
        }
        String path = String.valueOf('/') + appName;
        int i = 0;
        while (i < handlers.length) {
            ContextHandler ch;
            if (handlers[i] instanceof ContextHandler && path.equals((ch = (ContextHandler)handlers[i]).getContextPath())) {
                return ch;
            }
            ++i;
        }
        return null;
    }

    public static ContextHandlerCollection getConsoleServer(I2PAppContext ctx) {
        Server s = RouterConsoleRunner.getConsoleServer(ctx);
        if (s == null) {
            return null;
        }
        return WebAppStarter.getConsoleServer(s);
    }

    private static ContextHandlerCollection getConsoleServer(Server s) {
        Handler h = s.getChildHandlerByClass(ContextHandlerCollection.class);
        if (h == null) {
            return null;
        }
        return (ContextHandlerCollection)h;
    }
}

