/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.Banlist;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;

class BanlistRenderer {
    private final RouterContext _context;

    public BanlistRenderer(RouterContext context) {
        this._context = context;
    }

    public void renderStatusHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        TreeMap entries = new TreeMap(new HashComparator());
        entries.putAll(this._context.banlist().getEntries());
        buf.append("<h3 id=\"bannedpeers\">").append(this._t("Banned Peers"));
        if (entries.isEmpty()) {
            buf.append("</h3><i>").append(this._t("none")).append("</i>");
            out.write(buf.toString());
            return;
        }
        buf.append(" (").append(entries.size()).append(")</h3>");
        buf.append("<ul id=\"banlist\">");
        String unban = this._t("unban now");
        for (Map.Entry e : entries.entrySet()) {
            Hash key = (Hash)e.getKey();
            Banlist.Entry entry = (Banlist.Entry)e.getValue();
            long expires = entry.expireOn - this._context.clock().now();
            if (expires <= 0L) continue;
            buf.append("<li>").append(this._context.commSystem().renderPeerHTML(key));
            buf.append(' ');
            String expireString = DataHelper.formatDuration2((long)expires);
            if (key.equals((Object)Hash.FAKE_HASH)) {
                buf.append(this._t("Permanently banned"));
            } else if (expires < 432000000L) {
                buf.append(this._t("Temporary ban expiring in {0}", expireString));
            } else {
                buf.append(this._t("Banned until restart or in {0}", expireString));
            }
            Set transports = entry.transports;
            if (transports != null && !transports.isEmpty()) {
                buf.append(" on the following transport: ").append(transports);
            }
            if (entry.cause != null) {
                buf.append("<br>\n");
                if (entry.causeCode != null) {
                    buf.append(this._t(entry.cause, entry.causeCode));
                } else {
                    buf.append(this._t(entry.cause));
                }
            }
            if (!key.equals((Object)Hash.FAKE_HASH)) {
                buf.append(" <a href=\"configpeer?peer=").append(key.toBase64()).append("#unsh\" title=\"").append(unban).append("\">[").append(unban).append("]</a>");
            }
            buf.append("</li>\n");
        }
        buf.append("</ul>\n");
        out.write(buf.toString());
        out.flush();
    }

    private String _t(String s) {
        return Messages.getString(s, (I2PAppContext)this._context);
    }

    private String _t(String s, Object o) {
        return Messages.getString(s, o, (I2PAppContext)this._context);
    }

    private static class HashComparator
    implements Comparator<Hash>,
    Serializable {
        private HashComparator() {
        }

        @Override
        public int compare(Hash l, Hash r) {
            return DataHelper.compareTo((byte[])l.getData(), (byte[])r.getData());
        }
    }
}

