/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.FileUtil;

public class CertHelper
extends HelperBase {
    private static final String DIR = "certificates";
    private static final String I2CP = "i2cp/i2cp.local.crt";
    private static final String CONSOLE = "console/console.local.crt";
    private static final String I2PTUNNEL_DIR = "i2ptunnel";
    private static final String SAM_DIR = "sam";
    private static final String EEPSITE_DIR = "eepsite";

    public String getSummary() {
        File dir = new File(this._context.getConfigDir(), DIR);
        try {
            String name;
            File f;
            int i;
            this._out.write("<h3>");
            this._out.write(this._t("Local SSL Certificates"));
            this._out.write("</h3>\n");
            this.output(this._t("Router Console"), new File(dir, CONSOLE));
            this.output(this._t("I2CP"), new File(dir, I2CP));
            File tunnelDir = new File(this._context.getConfigDir(), I2PTUNNEL_DIR);
            boolean hasTunnels = false;
            File[] tunnels = tunnelDir.listFiles((FileFilter)new FileSuffixFilter("i2ptunnel-", ".local.crt"));
            if (tunnels != null) {
                i = 0;
                while (i < tunnels.length) {
                    f = tunnels[i];
                    name = f.getName();
                    String b32 = name.substring(10, name.length() - 10);
                    this.output(String.valueOf(this._t("I2PTunnel")) + ' ' + b32, f);
                    hasTunnels = true;
                    ++i;
                }
            }
            if (!hasTunnels) {
                this.output(this._t("I2PTunnel"), null);
            }
            tunnelDir = new File(dir, SAM_DIR);
            hasTunnels = false;
            tunnels = tunnelDir.listFiles((FileFilter)new FileSuffixFilter("sam-", ".local.crt"));
            if (tunnels != null) {
                i = 0;
                while (i < tunnels.length) {
                    f = tunnels[i];
                    this.output(this._t("SAM"), f);
                    hasTunnels = true;
                    ++i;
                }
            }
            if (!hasTunnels) {
                this.output(this._t("SAM"), null);
            }
            tunnelDir = new File(dir, EEPSITE_DIR);
            hasTunnels = false;
            tunnels = tunnelDir.listFiles((FileFilter)new FileSuffixFilter(".crt"));
            if (tunnels != null) {
                i = 0;
                while (i < tunnels.length) {
                    f = tunnels[i];
                    name = f.getName();
                    this.output(String.valueOf(this._t("Website")) + ' ' + name.substring(0, name.length() - 4), f);
                    hasTunnels = true;
                    ++i;
                }
            }
            if (!hasTunnels) {
                this.output(this._t("Website"), null);
            }
            this._out.write("<h3>");
            this._out.write(this._t("Local Router Family Certificate"));
            this._out.write("</h3>\n");
            String family = this._context.getProperty("netdb.family.name");
            if (family != null) {
                f = new File(dir, "family");
                f = new File(f, String.valueOf(family) + ".crt");
                this.output(String.valueOf(this._t("Family")) + ": " + DataHelper.escapeHTML((String)family), f);
            } else {
                this._out.write("<p>");
                this._out.write(this._t("none"));
                this._out.write("</p>\n");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private void output(String name, File file) throws IOException {
        this._out.write("<p><h4>");
        this._out.write(name);
        this._out.write("</h4>");
        if (file != null && file.exists()) {
            String cert = FileUtil.readTextFile((String)file.toString(), (int)-1, (boolean)true);
            if (cert != null) {
                this._out.write("\n<textarea readonly=\"readonly\">\n");
                this._out.write(cert);
                this._out.write("</textarea>\n");
            } else {
                this._out.write(": read failure");
            }
        } else {
            this._out.write("<p>");
            this._out.write(this._t("none"));
            this._out.write("</p>\n");
        }
    }
}

