/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppState;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.WebAppStarter;
import net.i2p.util.Addresses;
import net.i2p.util.SystemVersion;

public class ConfigClientsHelper
extends HelperBase {
    private String _edit;
    public static final String BIND_ALL_INTERFACES = "i2cp.tcp.bindAllInterfaces";
    public static final String PROP_DISABLE_EXTERNAL = "i2cp.disableInterface";
    public static final String PROP_ENABLE_SSL = "i2cp.SSL";
    public static final String PROP_AUTH = "i2cp.auth";
    public static final String PROP_ENABLE_CLIENT_CHANGE = "routerconsole.enableClientChange";
    public static final String PROP_ENABLE_PLUGIN_INSTALL = "routerconsole.enablePluginInstall";
    private static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z2]{2,6}", 2);

    public boolean isClientChangeEnabled() {
        return this._context.getBooleanProperty(PROP_ENABLE_CLIENT_CHANGE) || this.isAdvanced();
    }

    public boolean isPluginInstallEnabled() {
        return PluginStarter.pluginsEnabled((I2PAppContext)this._context) && (this._context.getBooleanPropertyDefaultTrue(PROP_ENABLE_PLUGIN_INSTALL) || this.isAdvanced());
    }

    public boolean isPluginUpdateEnabled() {
        return !PluginStarter.getPlugins().isEmpty();
    }

    public String getPort() {
        return this._context.getProperty("i2cp.port", Integer.toString(7654));
    }

    public String i2cpModeChecked(int mode) {
        boolean disabled = this._context.getBooleanProperty(PROP_DISABLE_EXTERNAL);
        boolean ssl = this._context.getBooleanProperty(PROP_ENABLE_SSL);
        if (mode == 0 && disabled || mode == 1 && !disabled && !ssl || mode == 2 && !disabled && ssl) {
            return " checked=\"checked\" ";
        }
        return "";
    }

    public String getAuth() {
        boolean enabled = this._context.getBooleanProperty(PROP_AUTH);
        if (enabled) {
            return " checked=\"checked\" ";
        }
        return "";
    }

    public String[] intfcAddresses() {
        ArrayList al = new ArrayList(Addresses.getAddresses((boolean)true, (boolean)true, (boolean)true, (boolean)false));
        return al.toArray(new String[al.size()]);
    }

    public boolean isIFSelected(String addr) {
        boolean bindAll = this._context.getBooleanProperty(BIND_ALL_INTERFACES);
        if (bindAll && addr.equals("0.0.0.0") || addr.equals("::")) {
            return true;
        }
        String host = this._context.getProperty("i2cp.hostname", "127.0.0.1");
        return host.equals(addr);
    }

    public void setEdit(String edit) {
        if (edit == null) {
            return;
        }
        String xStart = this._t("Edit");
        if (edit.startsWith(String.valueOf(xStart) + "<span class=hide> ") && edit.endsWith("</span>")) {
            this._edit = edit.substring(xStart.length() + 18, edit.length() - 7);
        } else if (edit.startsWith("Edit ")) {
            this._edit = edit.substring(5);
        } else if (edit.startsWith(String.valueOf(xStart) + ' ')) {
            this._edit = edit.substring(xStart.length() + 1);
        } else if (this._t("Add Client").equals(edit)) {
            this._edit = "new";
        }
    }

    public String getForm1() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table id=\"clientconfig\">\n<tr><th align=\"right\">").append(this._t("Client")).append("</th><th>").append(this._t("Run at Startup?")).append("</th><th>").append(this._t("Control")).append("</th><th align=\"left\">").append(this._t("Class and arguments")).append("</th></tr>\n");
        boolean allowEdit = this.isClientChangeEnabled();
        List clients = ClientAppConfig.getClientApps((RouterContext)this._context);
        ArrayList<CAC> cacs = new ArrayList<CAC>(clients.size());
        int cur = 0;
        while (cur < clients.size()) {
            ClientAppConfig ca = (ClientAppConfig)clients.get(cur);
            String xname = ca.clientName;
            if (xname.length() > 0) {
                xname = this._t(xname);
            }
            cacs.add(new CAC(cur, ca, xname));
            ++cur;
        }
        Collections.sort(cacs, new CACComparator());
        for (CAC cac : cacs) {
            boolean showEdit;
            boolean showStop;
            boolean showStart;
            boolean isDisabledBrowser;
            ClientAppConfig ca = cac.config;
            int cur2 = cac.index;
            boolean isConsole = ca.className.equals("net.i2p.router.web.RouterConsoleRunner");
            boolean bl = isDisabledBrowser = SystemVersion.isService() && ca.className.equals("net.i2p.apps.systray.UrlLauncher");
            if (isConsole) {
                showStart = false;
                showStop = false;
                showEdit = true;
            } else if (isDisabledBrowser) {
                showStart = false;
                showStop = false;
                showEdit = false;
            } else {
                ClientApp clientApp = this._context.routerAppManager().getClientApp(ca.className, LoadClientAppsJob.parseArgs((String)ca.args));
                showStart = clientApp == null;
                showStop = clientApp != null && clientApp.getState() == ClientAppState.RUNNING;
                showEdit = !showStop && (clientApp == null || clientApp.getState() != ClientAppState.STARTING);
            }
            String scur = Integer.toString(cur2);
            this.renderForm(buf, scur, ca.clientName, false, !ca.disabled && !isDisabledBrowser, isDisabledBrowser, isConsole || isDisabledBrowser, DataHelper.escapeHTML((String)(String.valueOf(ca.className) + (ca.args != null ? " " + ca.args : ""))), allowEdit && scur.equals(this._edit), allowEdit && showEdit, false, showStop, allowEdit && !isConsole, showStart);
        }
        if (allowEdit && "new".equals(this._edit)) {
            this.renderForm(buf, Integer.toString(clients.size()), "", false, false, false, false, "", true, false, false, false, false, false);
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    public String getForm2() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table id=\"webappconfig\">\n<tr><th align=\"right\">").append(this._t("WebApp")).append("</th><th>").append(this._t("Run at Startup?")).append("</th><th>").append(this._t("Control")).append("</th><th align=\"left\">").append(this._t("Description")).append("</th></tr>\n");
        Properties props = RouterConsoleRunner.webAppProperties((I2PAppContext)this._context);
        TreeSet<String> keys = new TreeSet<String>(props.stringPropertyNames());
        for (String name : keys) {
            if (!name.startsWith("webapps.") || !name.endsWith(".startOnLoad")) continue;
            String app = name.substring("webapps.".length(), name.lastIndexOf(".startOnLoad"));
            String val = props.getProperty(name);
            boolean isRunning = WebAppStarter.isWebAppRunning((I2PAppContext)this._context, app);
            String desc = app.equals("routerconsole") ? this._t("I2P Router Console") : (app.equals("i2psnark") ? this._t("Torrents") : (app.equals("i2ptunnel") ? this._t("Hidden Services Manager") : (app.equals("imagegen") ? this._t("Identification Image Generator") : (app.equals("susidns") ? this._t("Address Book") : (app.equals("susimail") ? this._t("Email") : String.valueOf(DataHelper.escapeHTML((String)app)) + ".war")))));
            boolean isConsole = "routerconsole".equals(app);
            this.renderForm(buf, app, app, isConsole || isRunning && !"addressbook".equals(app), "true".equals(val), isConsole, isConsole, desc, false, false, false, isRunning, false, !isRunning);
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    public boolean showPlugins() {
        return PluginStarter.pluginsEnabled((I2PAppContext)this._context);
    }

    public String getForm3() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<table id=\"pluginconfig\">\n<tr><th align=\"right\">").append(this._t("Plugin")).append("</th><th>").append(this._t("Run at Startup?")).append("</th><th>").append(this._t("Control")).append("</th><th align=\"left\">").append(this._t("Description")).append("</th></tr>\n");
        Properties props = PluginStarter.pluginProperties();
        TreeSet<Object> keys = new TreeSet<Object>(Collator.getInstance());
        keys.addAll(props.stringPropertyNames());
        for (String string : keys) {
            String updateURL;
            Properties appProps;
            if (!string.startsWith("plugin.") || !string.endsWith(".startOnLoad")) continue;
            String app = string.substring("plugin.".length(), string.lastIndexOf(".startOnLoad"));
            String val = props.getProperty(string);
            if (val.equals("deleted") || (appProps = PluginStarter.pluginProperties((I2PAppContext)this._context, app)).isEmpty()) continue;
            StringBuilder desc = new StringBuilder(256);
            desc.append("<table border=\"0\">").append("<tr><td><b>").append(this._t("Version")).append("</b></td><td>").append(ConfigClientsHelper.stripHTML(appProps, "version")).append("<tr><td><b>").append(this._t("Signed by")).append("</b></td><td>");
            String s = ConfigClientsHelper.stripHTML(appProps, "signer");
            if (s != null) {
                if (s.indexOf(64) > 0) {
                    desc.append("<a href=\"mailto:").append(s).append("\">").append(s).append("</a>");
                } else {
                    desc.append(s);
                }
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "date")) != null) {
                long ms = 0L;
                try {
                    ms = Long.parseLong(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (ms > 0L) {
                    String date = DataHelper.formatTime((long)ms);
                    desc.append("<tr><td><b>").append(this._t("Date")).append("</b></td><td>").append(date);
                }
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "author")) != null) {
                String[] authors = DataHelper.split((String)s, (String)"[,; \r\n\t]");
                Matcher m = VALID_EMAIL_ADDRESS_REGEX.matcher(s);
                String author = m.find() ? m.group() : null;
                desc.append("<tr><td><b>").append(this._t("Author")).append("</b></td><td>");
                if (author != null) {
                    desc.append("<a href=\"mailto:").append(author).append("\">").append(s).append("</a>");
                } else {
                    desc.append(s);
                }
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "description_" + Messages.getLanguage((I2PAppContext)this._context))) == null) {
                s = ConfigClientsHelper.stripHTML(appProps, "description");
            }
            if (s != null) {
                desc.append("<tr><td><b>").append(this._t("Description")).append("</b></td><td>").append(s);
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "license")) != null) {
                desc.append("<tr><td><b>").append(this._t("License")).append("</b></td><td>").append(s);
            }
            if ((s = ConfigClientsHelper.stripHTML(appProps, "websiteURL")) != null) {
                desc.append("<tr><td><b>").append(this._t("Website")).append("</b></td><td><a href=\"").append(s).append("\" target=\"_blank\">").append(s).append("</a>");
            }
            if ((updateURL = ConfigClientsHelper.stripHTML(appProps, "updateURL.su3")) == null) {
                updateURL = ConfigClientsHelper.stripHTML(appProps, "updateURL");
            }
            if (updateURL != null) {
                desc.append("<tr><td><b>").append(this._t("Update link")).append("</b></td><td><a href=\"").append(updateURL).append("\">").append(updateURL).append("</a>");
            }
            desc.append("</table>");
            boolean isRunning = PluginStarter.isPluginRunning(app, this._context);
            boolean enableStop = isRunning && !Boolean.parseBoolean(appProps.getProperty("disableStop"));
            boolean enableStart = !isRunning;
            this.renderForm(buf, app, app, false, "true".equals(val), false, false, desc.toString(), false, false, updateURL != null, enableStop, true, enableStart);
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    private void renderForm(StringBuilder buf, String index, String name, boolean urlify, boolean enabled, boolean ro, boolean preventDisable, String escapedDesc, boolean edit, boolean showEditButton, boolean showUpdateButton, boolean showStopButton, boolean showDeleteButton, boolean showStartButton) {
        String escapedName = DataHelper.escapeHTML((String)name);
        buf.append("<tr><td align=\"right\">");
        if (urlify) {
            String link = "/";
            if (!"routerconsole".equals(name)) {
                link = String.valueOf(link) + escapedName + "/";
            }
            buf.append("<a href=\"").append(link).append("\">").append(this._t(escapedName)).append("</a>");
        } else if (edit && !ro) {
            buf.append("<input type=\"text\" name=\"nofilter_name").append(index).append("\" value=\"");
            if (name.length() > 0) {
                buf.append(this._t(escapedName));
            }
            buf.append("\" >");
        } else if (name.length() > 0) {
            buf.append("<label for=\"").append(index).append("\">").append(this._t(escapedName)).append("</label>");
        }
        buf.append("</td><td align=\"center\"><input type=\"checkbox\" class=\"optbox\" id=\"").append(index).append("\" name=\"").append(index).append(".enabled\"");
        if (enabled) {
            buf.append(" checked=\"checked\" ");
        }
        if (ro || preventDisable) {
            buf.append("disabled=\"disabled\" ");
        }
        buf.append("></td><td align=\"center\">");
        if (showStartButton && !ro && !edit) {
            buf.append("<button type=\"submit\" title=\"").append(this._t("Start")).append("\" class=\"control accept\" name=\"action\" value=\"Start ").append(index).append("\" >").append(this._t("Start")).append("<span class=hide> ").append(index).append("</span></button>");
        }
        if (showStopButton && !edit) {
            buf.append("<button type=\"submit\" title=\"").append(this._t("Stop")).append("\" class=\"control stop\" name=\"action\" value=\"Stop ").append(index).append("\" >").append(this._t("Stop")).append("<span class=hide> ").append(index).append("</span></button>");
        }
        if (this.isClientChangeEnabled() && showEditButton && !edit && !ro) {
            buf.append("<button type=\"submit\" title=\"").append(this._t("Edit")).append("\" class=\"control add\" name=\"edit\" value=\"Edit ").append(index).append("\" >").append(this._t("Edit")).append("<span class=hide> ").append(index).append("</span></button>");
        }
        if (showUpdateButton && !edit && !ro) {
            buf.append("<button type=\"submit\" title=\"").append(this._t("Check for updates")).append("\" class=\"control check\" name=\"action\" value=\"Check ").append(index).append("\" >").append(this._t("Check for updates")).append("<span class=hide> ").append(index).append("</span></button>");
            buf.append("<button type=\"submit\" title=\"").append(this._t("Update")).append("\" class=\"control download\" name=\"action\" value=\"Update ").append(index).append("\" >").append(this._t("Update")).append("<span class=hide> ").append(index).append("</span></button>");
        }
        if (showDeleteButton && !edit && !ro) {
            buf.append("<button type=\"submit\" title=\"").append(this._t("Delete")).append("\" class=\"control delete\" name=\"action\" value=\"Delete ").append(index).append("\" client=\"").append(this._t(escapedName)).append("\">").append(this._t("Delete")).append("<span class=hide> ").append(index).append("</span></button>");
        }
        buf.append("</td><td align=\"left\">");
        if (edit && !ro) {
            buf.append("<input type=\"text\" size=\"80\" spellcheck=\"false\" name=\"nofilter_desc").append(index).append("\" value=\"");
            buf.append(escapedDesc);
            buf.append("\" >");
        } else {
            buf.append(escapedDesc);
        }
        buf.append("</td></tr>\n");
    }

    public static String stripHTML(Properties props, String key) {
        return PluginStarter.stripHTML(props, key);
    }

    private static class CAC {
        public final int index;
        public final ClientAppConfig config;
        public final String xname;

        public CAC(int idx, ClientAppConfig cfg, String xn) {
            this.index = idx;
            this.config = cfg;
            this.xname = xn;
        }
    }

    private class CACComparator
    implements Comparator<CAC> {
        private static final long serialVersionUID = 1L;
        private final Collator coll;

        public CACComparator() {
            this.coll = Collator.getInstance(new Locale(Messages.getLanguage((I2PAppContext)ConfigClientsHelper.this._context)));
        }

        @Override
        public int compare(CAC l, CAC r) {
            return this.coll.compare(l.xname, r.xname);
        }
    }
}

