/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.i2p.crypto.CertUtil;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.web.FormHandler;
import net.i2p.util.SecureDirectory;

public class ConfigFamilyHandler
extends FormHandler {
    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void processForm() {
        block45: {
            if (!this._action.equals(this._t("Create Family"))) break block45;
            family = this.getJettyString("family");
            old = this._context.getProperty("netdb.family.name");
            if (family == null || family.trim().length() <= 0) {
                this.addFormError(this._t("You must enter a family name"));
                return;
            }
            if (old != null) {
                this.addFormError("Family already configured: " + family);
                return;
            }
            if (family.contains("/") || family.contains("\\")) {
                this.addFormError("Bad characters in Family: " + family);
                return;
            }
            if (family.length() > 32) {
                this.addFormError("Family too long, 32 chars max: " + family);
                return;
            }
            family = family.trim();
            ks = new SecureDirectory(this._context.getConfigDir(), "keystore");
            if ((ks = new File((File)ks, "family-" + family + ".ks")).exists()) {
                this.addFormError("Keystore for family " + family + " already exists! Delete or rename it first: " + ks);
                return;
            }
            var5_10 = this._context.netDb().getRouters().iterator();
            if (true) ** GOTO lbl104
        }
        if (this._action.equals(this._t("Join Family"))) {
            in = this._requestWrapper.getInputStream("file");
            try {
                if (in == null || in.available() <= 0) {
                    this.addFormError(this._t("You must enter a file"));
                    return;
                }
                pk = CertUtil.loadPrivateKey((InputStream)in);
                certs = CertUtil.loadCerts((InputStream)in);
                family = CertUtil.getSubjectValue((X509Certificate)((X509Certificate)certs.get(0)), (String)"CN");
                if (family == null) {
                    this.addFormError("Bad certificate - No Subject CN");
                    return;
                }
                if (family.contains("/") || family.contains("\\")) {
                    this.addFormError("Bad characters in Family: " + family);
                    return;
                }
                if (family.endsWith(".family.i2p.net") && family.length() > ".family.i2p.net".length()) {
                    family = family.substring(0, family.length() - ".family.i2p.net".length());
                }
                if (!(ks = new SecureDirectory(this._context.getConfigDir(), "keystore")).exists()) {
                    ks.mkdirs();
                }
                if ((ks = new File((File)ks, "family-" + family + ".ks")).exists()) {
                    this.addFormError("Keystore for family " + family + " already exists! Delete or rename it first: " + ks);
                    return;
                }
                keypw = KeyStoreUtil.randomString();
                KeyStoreUtil.storePrivateKey((File)ks, (String)"changeit", (String)family, (String)keypw, (PrivateKey)pk, (List)certs);
                cf /* !! */  = new SecureDirectory(this._context.getConfigDir(), "certificates");
                if (!cf /* !! */ .exists()) {
                    cf /* !! */ .mkdirs();
                }
                cf /* !! */  = new SecureDirectory((File)cf /* !! */ , "family");
                if (!ks.exists()) {
                    ks.mkdirs();
                }
                cf /* !! */  = new File((File)cf /* !! */ , String.valueOf(family) + ".crt");
                KeyStoreUtil.exportCert((File)ks, (String)"changeit", (String)family, (File)cf /* !! */ );
                changes = new HashMap<String, String>();
                changes.put("netdb.family.name", family);
                changes.put("netdb.family.keyPassword", keypw);
                changes.put("netdb.family.keystorePassword", "changeit");
                if (this._context.router().saveConfig(changes, null)) {
                    this.addFormNotice("Family key configured for router family: " + family);
                    this.addFormError(this._t("Restart required to take effect"));
                    return;
                }
                this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
                return;
            }
            catch (GeneralSecurityException gse) {
                this.addFormError(String.valueOf(this._t("Load from file failed")) + " - " + gse);
                return;
            }
            catch (IOException ioe) {
                this.addFormError(String.valueOf(this._t("Load from file failed")) + " - " + ioe);
                return;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException var10_19) {}
            }
        }
        if (this._action.equals(this._t("Leave Family")) == false) return;
        removes = new ArrayList<String>();
        removes.add("netdb.family.name");
        removes.add("netdb.family.keyPassword");
        removes.add("netdb.family.keystorePassword");
        if (this._context.router().saveConfig(null, removes)) {
            this.addFormNotice(this._t("Configuration saved successfully."));
            this.addFormError(this._t("Restart required to take effect"));
            return;
        }
        this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
        return;
        do {
            if (!family.equals((ri = (RouterInfo)var5_10.next()).getOption("family"))) continue;
            this.addFormError("The family name \"" + family + "\" is already in use by another router. Please select a different family name.");
            return;
lbl104:
            // 2 sources

        } while (var5_10.hasNext());
        if (this._context.router().saveConfig("netdb.family.name", family.trim())) {
            this.addFormNotice(this._t("Configuration saved successfully."));
            this.addFormError(this._t("Restart required to take effect"));
            return;
        }
        this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
    }
}

