/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import net.i2p.I2PAppContext;
import net.i2p.crypto.Blinding;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.BlindData;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.router.web.FormHandler;
import net.i2p.util.ConvertToHash;

public class ConfigKeyringHandler
extends FormHandler {
    private String _peer;
    private String _key;
    private String _secret;
    private String[] _revokes;
    private int _mode;

    @Override
    protected void processForm() {
        if (this._action.equals(this._t("Add key"))) {
            if (this._peer == null) {
                this.addFormError(this._t("You must enter a destination"));
                return;
            }
            Hash h = null;
            if (!this._peer.endsWith(".b32.i2p") || this._peer.length() <= 60) {
                h = ConvertToHash.getHash((String)this._peer);
            }
            byte[] b = null;
            if (this._mode == 1 || this._mode == 4 || this._mode == 5) {
                if (this._key == null) {
                    this.addFormError(this._t("You must enter a key"));
                    return;
                }
                b = Base64.decode((String)this._key);
                if (b == null || b.length != 32) {
                    this.addFormError(this._t("Invalid key"));
                    return;
                }
            }
            if (this._mode == 1) {
                if (h == null || h.getData() == null) {
                    this.addFormError(this._t("Invalid destination"));
                } else if (this._context.clientManager().isLocal(h)) {
                    this.addFormError("Cannot add key for local destination. Enable encryption in the Hidden Services Manager.");
                } else {
                    SessionKey sk = new SessionKey(b);
                    this._context.keyRing().put((Object)h, (Object)sk);
                    this.addFormNotice(this._t("Key for {0} added to keyring", h.toBase32()));
                }
            } else {
                PrivateKey pk;
                int atype;
                if ((this._mode == 3 || this._mode == 5 || this._mode == 7) && this._secret == null) {
                    this.addFormError(this._t("Lookup password required"));
                    return;
                }
                BlindData bdin = null;
                try {
                    bdin = Blinding.decode((I2PAppContext)this._context, (String)this._peer);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                SigningPublicKey spk = null;
                Destination d = null;
                if (!this._peer.endsWith(".b32.i2p")) {
                    d = this._context.namingService().lookup(this._peer);
                }
                if (d != null) {
                    spk = d.getSigningPublicKey();
                } else if (bdin != null) {
                    spk = bdin.getUnblindedPubKey();
                }
                if (spk == null) {
                    this.addFormError(this._t("Requires hostname, destination, or blinded Base32"));
                    return;
                }
                BlindData bdold = this._context.netDb().getBlindData(spk);
                if (bdold != null && d == null) {
                    d = bdold.getDestination();
                }
                if (d != null && this._context.clientManager().isLocal(d)) {
                    this.addFormError("Cannot add key for local destination. Enable encryption in the Hidden Services Manager.");
                    return;
                }
                SigType blindType = bdin != null ? bdin.getBlindedSigType() : (bdold != null ? bdold.getBlindedSigType() : Blinding.getDefaultBlindedType((SigType)spk.getType()));
                if (this._mode == 4 || this._mode == 5) {
                    atype = 3;
                    pk = new PrivateKey(EncType.ECIES_X25519, b);
                } else if (this._mode == 6 || this._mode == 7) {
                    atype = 1;
                    b = new byte[32];
                    this._context.random().nextBytes(b);
                    pk = new PrivateKey(EncType.ECIES_X25519, b);
                } else {
                    atype = 0;
                    pk = null;
                }
                if (this._mode == 2 || this._mode == 4 || this._mode == 6) {
                    this._secret = null;
                }
                if (bdin != null) {
                    if (bdin.getSecretRequired() && this._secret == null) {
                        this.addFormError(this._t("Destination requires lookup password"));
                        return;
                    }
                    if (!bdin.getSecretRequired() && this._secret != null) {
                        this.addFormError(this._t("Destination does not require lookup password"));
                        return;
                    }
                    if (bdin.getAuthRequired() && pk == null) {
                        this.addFormError(this._t("Destination requires encryption key"));
                        return;
                    }
                    if (!bdin.getAuthRequired() && pk != null) {
                        this.addFormError(this._t("Destination does not require encryption key"));
                        return;
                    }
                }
                BlindData bdout = d != null ? new BlindData((I2PAppContext)this._context, d, blindType, this._secret, atype, pk) : new BlindData((I2PAppContext)this._context, spk, blindType, this._secret, atype, pk);
                if (bdold != null && this._log.shouldDebug()) {
                    this._log.debug("already cached: " + bdold);
                }
                try {
                    this._context.netDb().setBlindData(bdout);
                    this.addFormNotice(this._t("Key for {0} added to keyring", bdout.toBase32()));
                    if (this._mode == 6 || this._mode == 7) {
                        this.addFormNotice(String.valueOf(this._t("Send key to server operator.")) + ' ' + pk.toPublic().toBase64());
                    }
                }
                catch (IllegalArgumentException iae) {
                    this.addFormError(String.valueOf(this._t("Invalid destination")) + ": " + iae.getLocalizedMessage());
                }
            }
        } else if (this._action.equals(this._t("Delete key")) && this._revokes != null) {
            String[] stringArray = this._revokes;
            int n = this._revokes.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                boolean removed = false;
                if (p.length() == 60) {
                    Hash h = ConvertToHash.getHash((String)p);
                    if (h != null) {
                        if (this._context.clientManager().isLocal(h)) {
                            this.addFormError("Cannot remove key for local destination. Disable encryption in the Hidden Services Manager.");
                        } else if (this._context.keyRing().remove((Object)h) != null) {
                            removed = true;
                        }
                    }
                } else if (p.length() > 60) {
                    try {
                        BlindData bd = Blinding.decode((I2PAppContext)this._context, (String)p);
                        if (bd != null) {
                            SigningPublicKey spk = bd.getUnblindedPubKey();
                            removed = this._context.netDb().removeBlindData(spk);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else {
                    this.addFormError(String.valueOf(this._t("Invalid destination")) + ": " + p);
                }
                if (removed) {
                    this.addFormNotice(this._t("Key for {0} removed from keyring", p));
                } else {
                    this.addFormError(this._t("Key for {0} not found in keyring", p));
                }
                ++n2;
            }
        }
    }

    public void setPeer(String peer) {
        if (peer != null) {
            this._peer = peer.trim();
        }
    }

    public void setKey(String key) {
        if (key != null) {
            this._key = key.trim();
        }
    }

    public void setNofilter_blindedPassword(String pw) {
        if (pw != null && (pw = pw.trim()).length() > 0) {
            this._secret = pw;
        }
    }

    public void setEncryptMode(String m) {
        try {
            this._mode = Integer.parseInt(m);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setRevokeClient(String[] revokes) {
        this._revokes = revokes;
    }
}

