/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;
import net.i2p.util.Log;
import net.i2p.util.Translate;

public class ConfigLoggingHelper
extends HelperBase {
    private static final String[] levels = new String[]{"CRIT", "ERROR", "WARN", "INFO", "DEBUG"};
    private static final String CORE_BUNDLE_NAME = "net.i2p.util.messages";

    public String getLogFilePattern() {
        return this._context.logManager().getBaseLogfilename();
    }

    public String getRecordPattern() {
        return new String(this._context.logManager().getFormat());
    }

    public String getDatePattern() {
        return this._context.logManager().getDateFormatPattern();
    }

    public String getMaxFileSize() {
        int bytes = this._context.logManager().getFileSize();
        if (bytes <= 0) {
            return "1.00 MiB";
        }
        return String.valueOf(DataHelper.formatSize2((long)bytes, (boolean)false)) + 'B';
    }

    public String getLogLevelTable() {
        StringBuilder buf = new StringBuilder(32768);
        Properties limits = this._context.logManager().getLimits();
        TreeSet<String> sortedLogs = new TreeSet<String>();
        for (String prefix : limits.stringPropertyNames()) {
            sortedLogs.add(prefix);
        }
        buf.append("<textarea name=\"levels\" rows=\"4\" cols=\"60\" wrap=\"off\" spellcheck=\"false\">");
        for (String prefix : sortedLogs) {
            String level = limits.getProperty(prefix);
            buf.append(prefix).append('=').append(level).append('\n');
        }
        buf.append("</textarea><br>\n<p>");
        buf.append(this._t("Add additional logging statements above (e.g. {0}).", "<b>net.i2p.router.tunnel=WARN</b>")).append("<br>").append(this._t("Valid log levels are {0}.", "<b>DEBUG, INFO, WARN, ERROR, CRIT</b>")).append("</p>\n");
        return buf.toString();
    }

    public String getDefaultLogLevelBox() {
        StringBuilder buf = new StringBuilder(128);
        String cur = this._context.logManager().getDefaultLimit();
        this.getLogLevelBox(buf, "defaultloglevel", cur, false);
        return buf.toString();
    }

    private void getLogLevelBox(StringBuilder buf, String name, String cur, boolean showRemove) {
        buf.append("<select name=\"").append(name).append("\">\n");
        int i = 0;
        while (i < levels.length) {
            String l = levels[i];
            buf.append("<option value=\"").append(l).append('\"');
            if (l.equals(cur)) {
                buf.append(" selected=\"selected\" ");
            }
            buf.append('>').append(this._c(l)).append("</option>\n");
            ++i;
        }
        buf.append("</select>\n");
    }

    public String getNewClassBox() {
        List logs = this._context.logManager().getLogs();
        Set<String> limits = this._context.logManager().getLimits().stringPropertyNames();
        TreeSet<String> sortedLogs = new TreeSet<String>();
        for (Log log : logs) {
            String name = log.getName();
            if (!limits.contains(name)) {
                sortedLogs.add(name);
            }
            int dots = 0;
            int lastdot = -1;
            int nextdot = 0;
            while ((nextdot = name.indexOf(46, lastdot + 1)) > 0) {
                if (++dots >= 3) {
                    String subst = name.substring(0, nextdot);
                    sortedLogs.add(String.valueOf(subst) + '.');
                }
                lastdot = nextdot;
            }
        }
        StringBuilder buf = new StringBuilder(65536);
        buf.append("<select name=\"newlogclass\">\n<option value=\"\" selected=\"selected\">").append(this._t("Select a class to add")).append("</option>\n");
        int groups = 0;
        for (String l : sortedLogs) {
            String d;
            if (l.endsWith(".")) {
                if (groups++ > 0) {
                    buf.append("</optgroup>\n");
                }
                l = l.substring(0, l.length() - 1);
                buf.append("<optgroup label=\"").append(l).append("\">\n");
                d = this._t("All classes in {0}", l);
            } else {
                int last = l.lastIndexOf(".");
                d = last > 0 ? l.substring(last + 1) : l;
            }
            buf.append("<option value=\"").append(l).append("\">").append(d).append("</option>\n");
        }
        if (groups > 0) {
            buf.append("</optgroup>\n");
        }
        buf.append("</select>\n");
        this.getLogLevelBox(buf, "newloglevel", "WARN", false);
        return buf.toString();
    }

    private String _c(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)CORE_BUNDLE_NAME);
    }
}

