/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.i2p.data.DataHelper;
import net.i2p.data.router.RouterAddress;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportManager;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.web.HelperBase;
import net.i2p.util.Addresses;

public class ConfigNetHelper
extends HelperBase {
    static final String PROP_I2NP_NTCP_HOSTNAME = "i2np.ntcp.hostname";
    static final String PROP_I2NP_NTCP_PORT = "i2np.ntcp.port";
    static final String PROP_I2NP_NTCP_AUTO_PORT = "i2np.ntcp.autoport";
    static final String PROP_I2NP_NTCP_AUTO_IP = "i2np.ntcp.autoip";
    public static final int DEFAULT_SHARE_KBPS = 12;

    public String getUdphostname() {
        return this._context.getProperty("i2np.udp.host", "");
    }

    public String getNtcphostname() {
        return this._context.getProperty(PROP_I2NP_NTCP_HOSTNAME, "");
    }

    public String getNtcpport() {
        return this._context.getProperty(PROP_I2NP_NTCP_PORT, "");
    }

    public String getUdpIP() {
        String rv;
        String s = this._context.getProperty("i2np.udp.ipv6");
        if (!"only".equals(s) && (rv = this._context.getProperty("i2np.lastIP")) != null) {
            return rv;
        }
        if (!"false".equals(s) && (rv = this._context.getProperty("i2np.lastIPv6")) != null) {
            return rv;
        }
        RouterAddress addr = this._context.router().getRouterInfo().getTargetAddress("SSU");
        if (addr != null && (rv = addr.getHost()) != null) {
            return rv;
        }
        addr = this._context.router().getRouterInfo().getTargetAddress("NTCP");
        if (addr != null && (rv = addr.getHost()) != null) {
            return rv;
        }
        return this._t("unknown");
    }

    public String getUdpPort() {
        return this.getConfiguredUdpPort();
    }

    public String getConfiguredUdpPort() {
        return this._context.getProperty("i2np.udp.internalPort", "unset");
    }

    public String getDynamicKeysChecked() {
        return this.getChecked("router.dynamicKeys");
    }

    public String getLaptopChecked() {
        return this.getChecked("i2np.laptopMode");
    }

    public String getIPv4FirewalledChecked() {
        return this.getChecked("i2np.ipv4.firewalled");
    }

    public String getIPv6FirewalledChecked() {
        return this.getChecked("i2np.ipv6.firewalled");
    }

    public String getTcpAutoPortChecked(int mode) {
        boolean specified;
        String port = this._context.getProperty(PROP_I2NP_NTCP_PORT);
        boolean bl = specified = port != null && port.length() > 0;
        if (mode == 1 && specified || mode == 2 && !specified) {
            return " checked=\"checked\" ";
        }
        return "";
    }

    public String getTcpAutoIPChecked(int mode) {
        boolean enabled = TransportManager.isNTCPEnabled((RouterContext)this._context);
        String hostname = this._context.getProperty(PROP_I2NP_NTCP_HOSTNAME);
        boolean specified = hostname != null && hostname.length() > 0;
        String auto = this._context.getProperty(PROP_I2NP_NTCP_AUTO_IP, "true");
        if (mode == 0 && !specified && auto.equals("false") && enabled || mode == 1 && specified && auto.equals("false") && enabled || mode == 2 && auto.equals("true") && enabled || mode == 3 && auto.equals("always") && enabled || mode == 4 && !enabled) {
            return " checked=\"checked\" ";
        }
        return "";
    }

    public String getUdpAutoIPChecked(int mode) {
        String hostname = this._context.getProperty("i2np.udp.host");
        boolean specified = hostname != null && hostname.length() > 0;
        boolean hidden = this._context.router().isHidden();
        String sources = this._context.getProperty("i2np.udp.addressSources", UDPTransport.DEFAULT_SOURCES);
        if (mode == 0 && sources.equals("ssu") && !hidden || mode == 1 && specified && !hidden || mode == 2 && hidden || mode == 3 && sources.equals("local,upnp,ssu") && !hidden || mode == 4 && sources.equals("local,ssu") && !hidden || mode == 5 && sources.equals("upnp,ssu") && !hidden) {
            return " checked=\"checked\" ";
        }
        return "";
    }

    public String getUpnpChecked() {
        if (this._context.getBooleanPropertyDefaultTrue("i2np.upnp.enable")) {
            return " checked=\"checked\" ";
        }
        return "";
    }

    public String getUdpDisabledChecked() {
        if (!this._context.getBooleanPropertyDefaultTrue("i2np.udp.enable")) {
            return " checked=\"checked\" ";
        }
        return "";
    }

    public String getUdpEnabledChecked() {
        if (this._context.getBooleanPropertyDefaultTrue("i2np.udp.enable")) {
            return " checked=\"checked\" ";
        }
        return "";
    }

    @Deprecated
    public String getRequireIntroductionsChecked() {
        CommSystemFacade.Status status = this._context.commSystem().getStatus();
        switch (status) {
            case OK: 
            case UNKNOWN: {
                return this.getChecked("i2np.udp.forceIntroducers");
            }
        }
        return " checked=\"checked\" ";
    }

    public String getIPv6Checked(String mode) {
        String s = this._context.getProperty("i2np.udp.ipv6");
        if (s == null && (s = this._context.getProperty("i2np.ntcp.ipv6")) == null) {
            s = TransportUtil.DEFAULT_IPV6_CONFIG.toConfigString();
        }
        if (s.equals(mode)) {
            return " checked=\"checked\" ";
        }
        return "";
    }

    public Set<String> getAddresses() {
        return Addresses.getAddresses((boolean)false, (boolean)false, (boolean)true, (boolean)false);
    }

    public String getAddressSelector() {
        Set configs;
        Set<String> addrs = this.getAddresses();
        Iterator<String> iter = addrs.iterator();
        while (iter.hasNext()) {
            byte[] ip = Addresses.getIP((String)iter.next());
            if (ip != null && TransportUtil.isPubliclyRoutable((byte[])ip, (boolean)true)) continue;
            iter.remove();
        }
        String cs = this.getUdphostname();
        if (cs.length() <= 0) {
            configs = Collections.emptySet();
        } else {
            configs = new HashSet(4);
            String[] ca = DataHelper.split((String)cs, (String)"[,; \r\n\t]");
            int i = 0;
            while (i < ca.length) {
                String c = ca[i];
                if (c.length() > 0) {
                    configs.add(c);
                    addrs.add(c);
                }
                ++i;
            }
        }
        StringBuilder buf = new StringBuilder(128);
        for (String addr : addrs) {
            buf.append("\n<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            buf.append("<input type=\"checkbox\" class=\"optbox\" value=\"foo\" name=\"addr_");
            buf.append(addr);
            buf.append('\"');
            if (addrs.size() == 1 || configs.contains(addr)) {
                buf.append(" checked=\"checked\" ");
            }
            buf.append("> ");
            buf.append(addr);
        }
        if (!addrs.isEmpty()) {
            buf.append("\n<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append(this._t("Add hostname or IP")).append(": ");
        }
        buf.append("<input name=\"udpHost1\" type=\"text\" size=\"16\" >");
        return buf.toString();
    }

    public String getInboundRate() {
        return Integer.toString(Math.round((float)this._context.bandwidthLimiter().getInboundKBytesPerSecond() * 1.024f));
    }

    public String getOutboundRate() {
        return Integer.toString(Math.round((float)this._context.bandwidthLimiter().getOutboundKBytesPerSecond() * 1.024f));
    }

    public String getInboundBurstRateBits() {
        return this.kbytesToBits(this._context.bandwidthLimiter().getInboundBurstKBytesPerSecond());
    }

    public String getOutboundBurstRateBits() {
        return this.kbytesToBits(this._context.bandwidthLimiter().getOutboundBurstKBytesPerSecond());
    }

    public String getShareRateBits() {
        return this.kbytesToBits(this.getShareBandwidth());
    }

    private String kbytesToBits(float kbytes) {
        return String.valueOf(DataHelper.formatSize2Decimal((long)((long)(kbytes * 8192.0f)))) + this._t("bits per second") + "; " + this._t("{0}Bytes per month maximum", DataHelper.formatSize2Decimal((long)((long)(kbytes * 2.7426816E9f))));
    }

    public String getInboundBurstRate() {
        return Integer.toString(Math.round((float)this._context.bandwidthLimiter().getInboundBurstKBytesPerSecond() * 1.024f));
    }

    public String getOutboundBurstRate() {
        return Integer.toString(Math.round((float)this._context.bandwidthLimiter().getOutboundBurstKBytesPerSecond() * 1.024f));
    }

    public String getSharePercentageBox() {
        int pct = (int)(100.0 * this._context.router().getSharePercentage());
        StringBuilder buf = new StringBuilder(256);
        buf.append("<select style=\"text-align: right !important;\" name=\"sharePercentage\">\n");
        boolean found = false;
        int i = 90;
        while (i >= -5) {
            int val = i;
            if (i == -5) {
                if (found) break;
                val = pct;
            }
            buf.append("<option style=\"text-align: right;\" value=\"").append(val).append("\" ");
            if (pct == val) {
                buf.append(" selected=\"selected\" ");
                found = true;
            }
            buf.append(">").append(val).append("%</option>\n");
            i -= 5;
        }
        buf.append("</select>\n");
        return buf.toString();
    }

    public int getShareBandwidth() {
        int irateKBps = this._context.bandwidthLimiter().getInboundKBytesPerSecond();
        int orateKBps = this._context.bandwidthLimiter().getOutboundKBytesPerSecond();
        if (irateKBps < 0 || orateKBps < 0) {
            return 12;
        }
        double pct = this._context.router().getSharePercentage();
        return (int)(pct * (double)Math.min(irateKBps, orateKBps));
    }
}

