/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.StringWriter;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import net.i2p.data.Hash;
import net.i2p.router.Blocklist;
import net.i2p.router.web.HelperBase;
import net.i2p.util.Addresses;

public class ConfigPeerHelper
extends HelperBase {
    private static final int MAX_DISPLAY = 1000;

    public String getBlocklistSummary() {
        StringWriter out = new StringWriter(4096);
        Blocklist bl = this._context.blocklist();
        out.write("<table id=\"bannedips\"><tr><td><table id=\"banneduntilrestart\"><tr><th align=\"center\"><b>");
        out.write(this._t("IPs Banned Until Restart"));
        List singles = bl.getTransientIPv4Blocks();
        List s6 = bl.getTransientIPv6Blocks();
        int sz = singles.size() + s6.size();
        if (sz > 0) {
            out.write(" (" + sz + ')');
        }
        out.write("</b></th></tr>");
        if (!singles.isEmpty() || !s6.isEmpty()) {
            int ip;
            if (!singles.isEmpty()) {
                Collections.sort(singles);
                out.write("<tr id=\"ipv4\" align=\"center\"><td><b>");
                out.write(this._t("IPv4 Addresses"));
                out.write("</b></td></tr>");
            }
            for (Integer ii : singles) {
                ip = ii;
                if (ip < 0 || bl.isPermanentlyBlocklisted(ip)) continue;
                out.write("<tr><td align=\"center\">");
                out.write(Blocklist.toStr((int)ip));
                out.write("</td></tr>\n");
            }
            for (Integer ii : singles) {
                ip = ii;
                if (ip >= 0) break;
                if (bl.isPermanentlyBlocklisted(ip)) continue;
                out.write("<tr><td align=\"center\">");
                out.write(Blocklist.toStr((int)ip));
                out.write("</td></tr>\n");
            }
            if (!s6.isEmpty()) {
                out.write("<tr id=\"ipv6\" align=\"center\"><td><b>");
                out.write(this._t("IPv6 Addresses"));
                out.write("</b></td></tr>");
                Collections.sort(s6);
                for (BigInteger bi : s6) {
                    out.write("<tr><td align=\"center\">");
                    out.write(Addresses.toString((byte[])ConfigPeerHelper.toIPBytes(bi)));
                    out.write("</td></tr>\n");
                }
            }
        } else {
            out.write("<tr><td><i>");
            out.write(this._t("none"));
            out.write("</i></td></tr>");
        }
        out.write("</table>");
        out.write("</td><td>");
        out.write("<table id=\"permabanned\"><tr><th align=\"center\" colspan=\"3\"><b>");
        out.write(this._t("IPs Permanently Banned"));
        out.write("</b></th></tr>");
        int blocklistSize = bl.getBlocklistSize();
        if (blocklistSize > 0) {
            int to;
            int from;
            out.write("<tr><td align=\"center\" width=\"49%\"><b>");
            out.write(this._t("From"));
            out.write("</b></td><td></td><td align=\"center\" width=\"49%\"><b>");
            out.write(this._t("To"));
            out.write("</b></td></tr>");
            long[] blocklist = bl.getPermanentBlocks(1000);
            int i = 0;
            while (i < blocklist.length) {
                from = Blocklist.getFrom((long)blocklist[i]);
                if (from >= 0) {
                    out.write("<tr><td align=\"center\" width=\"49%\">");
                    out.write(Blocklist.toStr((int)from));
                    out.write("</td>");
                    to = Blocklist.getTo((long)blocklist[i]);
                    if (to != from) {
                        out.write("<td align=\"center\">-</td><td align=\"center\" width=\"49%\">");
                        out.write(Blocklist.toStr((int)to));
                        out.write("</td></tr>\n");
                    } else {
                        out.write("<td></td><td width=\"49%\">&nbsp;</td></tr>\n");
                    }
                }
                ++i;
            }
            i = 0;
            while (i < blocklist.length) {
                from = Blocklist.getFrom((long)blocklist[i]);
                if (from >= 0) break;
                out.write("<tr><td align=\"center\" width=\"49%\">");
                out.write(Blocklist.toStr((int)from));
                out.write("</td>");
                to = Blocklist.getTo((long)blocklist[i]);
                if (to != from) {
                    out.write("<td align=\"center\">-</td><td align=\"center\" width=\"49%\">");
                    out.write(Blocklist.toStr((int)to));
                    out.write("</td></tr>\n");
                } else {
                    out.write("<td></td><td width=\"49%\">&nbsp;</td></tr>\n");
                }
                ++i;
            }
            if (blocklistSize > 1000) {
                out.write("<tr><th colspan=3>First 1000 displayed, see the blocklist.txt file for the full list</th></tr>");
            }
        } else {
            out.write("<tr><td><i>");
            out.write(this._t("none"));
            out.write("</i></td></tr>");
        }
        out.write("</table></td></tr></table>");
        return out.toString();
    }

    public boolean isBanned(Hash h) {
        return this._context.banlist().isBanlisted(h);
    }

    private static byte[] toIPBytes(BigInteger bi) {
        byte[] ba = bi.toByteArray();
        int len = ba.length;
        if (len == 16) {
            return ba;
        }
        byte[] rv = new byte[16];
        if (len < 16) {
            System.arraycopy(ba, 0, rv, 16 - len, len);
        } else {
            System.arraycopy(ba, len - 16, rv, 0, 16);
        }
        return rv;
    }
}

