/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import net.i2p.router.web.HelperBase;

public class ConfigReseedHelper
extends HelperBase {
    public String getPort() {
        return this._context.getProperty("router.reseedProxyPort", "");
    }

    public String getHost() {
        return this._context.getProperty("router.reseedProxyHost", "");
    }

    public String getUsername() {
        return this._context.getProperty("router.reseedProxy.username", "");
    }

    public String getNofilter_password() {
        return this._context.getProperty("router.reseedProxy.password", "");
    }

    public String getSport() {
        return this._context.getProperty("router.reseedSSLProxyPort", "");
    }

    public String getShost() {
        return this._context.getProperty("router.reseedSSLProxyHost", "");
    }

    public String getSusername() {
        return this._context.getProperty("router.reseedSSLProxy.username", "");
    }

    public String getNofilter_spassword() {
        return this._context.getProperty("router.reseedSSLProxy.password", "");
    }

    public String modeChecked(int mode) {
        boolean required = this._context.getBooleanPropertyDefaultTrue("router.reseedSSLRequired");
        boolean disabled = this._context.getBooleanProperty("router.reseedSSLDisable");
        if (mode == 0 && !disabled && !required || mode == 1 && !disabled && required || mode == 2 && disabled) {
            return " checked=\"checked\" ";
        }
        return "";
    }

    public String pmodeChecked(int mode) {
        boolean disabled;
        String c = this._context.getProperty("router.reseedSSLProxyType", "HTTP");
        boolean bl = disabled = !this._context.getBooleanProperty("router.reseedSSLProxyEnable");
        if (mode == 0 && disabled || mode == 1 && !disabled && c.equals("HTTP") || mode == 2 && !disabled && c.equals("SOCKS4") || mode == 3 && !disabled && c.equals("SOCKS5") || mode == 4 && !disabled && c.equals("INTERNAL")) {
            return " checked=\"checked\" ";
        }
        return "";
    }

    public String getEnable() {
        return this.getChecked("router.reseedProxyEnable");
    }

    public String getAuth() {
        return this.getChecked("router.reseedProxy.authEnable");
    }

    public String getSauth() {
        return this.getChecked("router.reseedSSLProxy.authEnable");
    }

    private List<String> reseedList() {
        String urls = this._context.getProperty("i2p.reseedURL", ",https://reseed-pl.i2pd.xyz/,https://reseed-fr.i2pd.xyz/,https://www2.mk16.de/,https://reseed2.i2p.net/,https://banana.incognet.io/,https://reseed.diva.exchange/,https://reseed.i2pgit.org/,https://i2p.novg.net/,https://i2pseed.creativecowpat.net:8443/,https://reseed.onion.im/,https://reseed.memcpy.io/");
        StringTokenizer tok = new StringTokenizer(urls, " ,\r\n");
        ArrayList<String> URLList = new ArrayList<String>(16);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken().trim();
            if (s.length() <= 0) continue;
            URLList.add(s);
        }
        return URLList;
    }

    public String getReseedURL() {
        List<String> URLList = this.reseedList();
        Collections.sort(URLList);
        StringBuilder buf = new StringBuilder();
        for (String s : URLList) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public boolean shouldShowSelect() {
        boolean http = false;
        boolean https = false;
        for (String u : this.reseedList()) {
            if (u.startsWith("https://")) {
                if (http) {
                    return true;
                }
                https = true;
                continue;
            }
            if (!u.startsWith("http://")) continue;
            if (https) {
                return true;
            }
            http = true;
        }
        return false;
    }

    public boolean shouldShowHTTPProxy() {
        for (String u : this.reseedList()) {
            if (!u.startsWith("http://")) continue;
            return true;
        }
        return false;
    }

    public boolean shouldShowHTTPSProxy() {
        for (String u : this.reseedList()) {
            if (!u.startsWith("https://")) continue;
            return true;
        }
        return false;
    }
}

