/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.jar.Attributes;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.router.web.CSSHelper;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.helpers.FileDumpHelper;
import net.i2p.util.Translate;
import net.i2p.util.UIMessages;

public class LogsHelper
extends HelperBase {
    private static final String _jstlVersion = LogsHelper.jstlVersion();
    private static final int MAX_WRAPPER_LINES = 250;
    private static final String PROP_LAST_WRAPPER = "routerconsole.lastWrapperLogEntry";
    private static final String NL = System.getProperty("line.separator");
    private static final String CORE_BUNDLE_NAME = "net.i2p.util.messages";

    public String getJettyVersion() {
        return RouterConsoleRunner.jettyVersion();
    }

    public String getUnavailableCrypto() {
        StringBuilder buf = new StringBuilder(128);
        SigType[] sigTypeArray = SigType.values();
        int n = sigTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SigType t = sigTypeArray[n2];
            if (!t.isAvailable()) {
                buf.append("<tr><td><b>Crypto:</b></td><td>").append(t.toString()).append(" unavailable</td></tr>");
            }
            ++n2;
        }
        return buf.toString();
    }

    public String getJstlVersion() {
        return _jstlVersion;
    }

    private static String jstlVersion() {
        String rv = "n/a";
        try {
            Class<?> cls = Class.forName("org.apache.taglibs.standard.Version", true, ClassLoader.getSystemClassLoader());
            Method getVersion = cls.getMethod("getVersion", new Class[0]);
            Object version = getVersion.invoke(null, null);
            rv = (String)version;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rv;
    }

    public String getLogs() {
        String str = this.formatMessages(this._context.logManager().getBuffer().getMostRecentMessages());
        return "<p>" + this._t("File location") + ": <a href=\"/router.log\" target=\"_blank\">" + DataHelper.escapeHTML((String)this._context.logManager().currentFile()) + "</a></p>" + str;
    }

    public String getCriticalLogs() {
        return this.formatMessages(this._context.logManager().getBuffer().getMostRecentCriticalMessages());
    }

    public int getLastMessageNumber() {
        UIMessages msgs = this._context.logManager().getBuffer().getUIMessages();
        if (msgs.isEmpty()) {
            return -1;
        }
        return msgs.getLastMessageID();
    }

    public int getLastCriticalMessageNumber() {
        this._context.logManager().flush();
        UIMessages msgs = this._context.logManager().getBuffer().getCriticalUIMessages();
        if (msgs.isEmpty()) {
            return -1;
        }
        return msgs.getLastMessageID();
    }

    public void clearThrough(int n, int crit, long wn, long wts, String wf, String consoleNonce) {
        String val;
        if (!CSSHelper.getNonce().equals(consoleNonce)) {
            return;
        }
        if (n >= 0) {
            this._context.logManager().getBuffer().getUIMessages().clearThrough(n);
        }
        if (crit >= 0) {
            this._context.logManager().getBuffer().getCriticalUIMessages().clearThrough(crit);
        }
        if (wn >= 0L && wts > 0L && wf != null && !(val = String.valueOf(wts) + "," + wn + "," + wf).equals(this._context.getProperty(PROP_LAST_WRAPPER))) {
            this._context.router().saveConfig(PROP_LAST_WRAPPER, val);
        }
    }

    public Object[] getServiceLogs(StringBuilder obuf) {
        String str;
        String[] vals;
        File f = ConfigServiceHandler.wrapperLogFile((I2PAppContext)this._context);
        long flastMod = f.lastModified();
        long lastMod = 0L;
        long toSkip = 0L;
        String prop = this._context.getProperty(PROP_LAST_WRAPPER);
        if (prop != null && (vals = DataHelper.split((String)prop, (String)",", (int)3)).length == 3) {
            if (vals[2].equals(f.getName())) {
                try {
                    lastMod = Long.parseLong(vals[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    toSkip = Long.parseLong(vals[1]);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                lastMod = 0L;
            }
        }
        if (lastMod > 0L && flastMod <= lastMod) {
            str = "";
            toSkip = -1L;
        } else {
            StringBuilder buf;
            boolean utf8 = !this._context.hasWrapper();
            long ntoSkip = LogsHelper.readTextFile(f, utf8, 250, toSkip, buf = new StringBuilder(20000));
            if (ntoSkip < toSkip) {
                str = ntoSkip < 0L ? null : "";
                if (prop != null) {
                    this._context.router().saveConfig(PROP_LAST_WRAPPER, null);
                }
            } else {
                str = buf.toString();
            }
            toSkip = ntoSkip;
        }
        String loc = DataHelper.escapeHTML((String)f.getAbsolutePath());
        if (str == null) {
            obuf.append("<p>").append(this._t("File not found")).append(": <b><code>").append(loc).append("</code></b></p>");
            toSkip = -1L;
        } else {
            obuf.append("<p>").append(this._t("File location")).append(": <a href=\"/wrapper.log\" target=\"_blank\">").append(loc).append("</a></p></td></tr>\n<tr><td>");
            if (str.length() > 0) {
                str = str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
                obuf.append("<pre id=\"servicelogs\">").append(str).append("</pre>");
            } else {
                obuf.append("<p><i>").append(this._t("No log messages")).append("</i></p></td></tr><td><tr>");
            }
        }
        Object[] rv = new Object[]{flastMod, toSkip, DataHelper.escapeHTML((String)f.getName()).replace(" ", "%20")};
        return rv;
    }

    public String getBuiltBy() {
        String s;
        File libDir = this._context.getLibDir();
        File f = new File(libDir, "i2p.jar");
        Attributes att = FileDumpHelper.attributes(f);
        if (att != null && (s = FileDumpHelper.getAtt(att, "Built-By")) != null) {
            return s;
        }
        return "Undefined";
    }

    private String formatMessages(List<String> msgs) {
        if (msgs.isEmpty()) {
            return "</td></tr><tr><td><p><i>" + this._t("No log messages") + "</i></p>";
        }
        boolean colorize = this._context.getBooleanPropertyDefaultTrue("routerconsole.logs.color");
        StringBuilder buf = new StringBuilder(16384);
        buf.append("</td></tr><tr><td><ul>");
        boolean displayed = false;
        int i = 0;
        while (i < msgs.size()) {
            String msg = msgs.get(i);
            if (displayed || !msg.contains("&uarr;")) {
                displayed = true;
                msg = msg.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
                if ((msg = msg.replace("&amp;uarr;", "&uarr;")).endsWith(NL)) {
                    msg = msg.substring(0, msg.length() - NL.length());
                }
                msg = msg.replace("\n", "<br>&nbsp;&nbsp;&nbsp;&nbsp;\n");
                buf.append("<li>");
                if (colorize) {
                    String color = msg.contains(this._c("CRIT")) ? "#cc0000" : (msg.contains(this._c("ERROR")) ? "#ff3300" : (msg.contains(this._c("WARN")) ? "#bf00df" : (msg.contains(this._c("INFO")) ? "#000099" : "#006600")));
                    buf.append("<font color=\"").append(color).append("\">");
                    buf.append(msg);
                    buf.append("</font>");
                } else {
                    buf.append(msg);
                }
                buf.append("</li>\n");
            }
            ++i;
        }
        buf.append("</ul>\n");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long readTextFile(File f, boolean utf8, int maxNumLines, long skipLines, StringBuilder buf) {
        if (!f.exists()) {
            return -1L;
        }
        in = null;
        try {
            in = utf8 != false ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8")) : new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            i = 0L;
            if (true) ** GOTO lbl34
        }
        catch (IOException ioe) {
            if (in == null) return -1L;
            try {
                in.close();
                return -1L;
            }
            catch (IOException var17_14) {
                // empty catch block
            }
            return -1L;
            catch (Throwable var14_20) {
                if (in == null) throw var14_20;
                try {
                    in.close();
                    throw var14_20;
                }
                catch (IOException var17_15) {
                    // empty catch block
                }
                throw var14_20;
            }
        }
lbl24:
        // 1 sources

        while (true) {
            try {
                in.close();
                return var15_10;
            }
            catch (IOException var17_12) {
                // empty catch block
            }
            return var15_10;
        }
        {
            block23: {
                do {
                    if (c != 10) continue;
                    ++i;
lbl34:
                    // 2 sources

                    if (i >= skipLines) break block23;
                } while ((c = in.read()) >= 0);
                var15_10 = i;
                if (in == null) return var15_10;
                ** continue;
            }
            var10_16 = lines = new ArrayBlockingQueue<String>(maxNumLines);
            synchronized (var10_16) {
                line = null;
                while ((line = in.readLine()) != null) {
                    ++i;
                    if (lines.size() >= maxNumLines) {
                        lines.poll();
                    }
                    lines.offer(line);
                }
                var13_18 = lines.iterator();
                while (true) {
                    if (!var13_18.hasNext()) {
                        break;
                    }
                    ln = (String)var13_18.next();
                    buf.append(ln).append('\n');
                }
            }
            var15_11 = i;
            if (in == null) return var15_11;
        }
        try {
            in.close();
            return var15_11;
        }
        catch (IOException var17_13) {
            // empty catch block
        }
        return var15_11;
    }

    private String _c(String s) {
        return Translate.getString((String)s, (I2PAppContext)this._context, (String)CORE_BUNDLE_NAME);
    }
}

