/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.IOException;
import java.text.Collator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.sybil.Analysis;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.Messages;
import net.i2p.router.web.helpers.NetDbRenderer;
import net.i2p.router.web.helpers.SybilRenderer;
import net.i2p.util.SystemVersion;

public class NetDbHelper
extends FormHandler {
    private String _routerPrefix;
    private String _version;
    private String _country;
    private String _family;
    private String _caps;
    private String _ip;
    private String _sybil;
    private String _mtu;
    private String _ssucaps;
    private String _ipv6;
    private String _transport;
    private int _full;
    private int _port;
    private int _cost;
    private int _page;
    private int _mode;
    private long _date;
    private int _limit = DEFAULT_LIMIT;
    private boolean _lease;
    private boolean _debug;
    private boolean _graphical;
    private SigType _type;
    private EncType _etype;
    private String _newNonce;
    private boolean _postOK;
    private static final int DEFAULT_LIMIT = SystemVersion.isARM() ? 250 : 500;
    private static final int DEFAULT_PAGE = 0;
    private static final String[] titles = new String[]{NetDbHelper._x("Summary"), NetDbHelper._x("Local Router"), NetDbHelper._x("Router Lookup"), NetDbHelper._x("All Routers"), NetDbHelper._x("All Routers with Full Stats"), NetDbHelper._x("LeaseSets"), "LeaseSet Debug", "Sybil", "Advanced Lookup"};
    private static final String[] links = new String[]{"", "?r=.", "", "?f=2", "?f=1", "?l=1", "?l=2", "?f=3", "?f=4"};

    public void setRouter(String r) {
        if (r != null && r.length() > 0) {
            this._routerPrefix = DataHelper.stripHTML((String)r);
        }
    }

    public void setVersion(String v) {
        if (v != null && v.length() > 0) {
            this._version = DataHelper.stripHTML((String)v);
        }
    }

    public void setCountry(String c) {
        if (c != null && c.length() > 0) {
            this._country = DataHelper.stripHTML((String)c);
        }
    }

    public void setFamily(String c) {
        if (c != null && c.length() > 0) {
            this._family = DataHelper.stripHTML((String)c);
        }
    }

    public void setCaps(String c) {
        if (c != null && c.length() > 0) {
            this._caps = DataHelper.stripHTML((String)c);
        }
    }

    public void setIp(String c) {
        if (c != null && c.length() > 0) {
            this._ip = DataHelper.stripHTML((String)c);
        }
    }

    public void setSybil(String c) {
        if (c != null) {
            this._sybil = DataHelper.stripHTML((String)c);
        }
    }

    public void setSybil2(String c) {
        if (c != null && c.length() > 0) {
            this._sybil = DataHelper.stripHTML((String)c);
        }
    }

    public void setPort(String f) {
        try {
            this._port = Integer.parseInt(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setType(String f) {
        if (f != null && f.length() > 0) {
            this._type = SigType.parseSigType((String)f);
        }
    }

    public void setEtype(String f) {
        if (f != null && f.length() > 0) {
            this._etype = EncType.parseEncType((String)f);
        }
    }

    public void setMtu(String f) {
        if (f != null && f.length() > 0) {
            this._mtu = DataHelper.stripHTML((String)f);
        }
    }

    public void setIpv6(String f) {
        if (f != null && f.length() > 0) {
            this._ipv6 = DataHelper.stripHTML((String)f);
            if (!this._ipv6.endsWith(":")) {
                this._ipv6 = String.valueOf(this._ipv6) + ':';
            }
        }
    }

    public void setSsucaps(String f) {
        if (f != null && f.length() > 0) {
            this._ssucaps = DataHelper.stripHTML((String)f);
        }
    }

    public void setTransport(String f) {
        if (f != null && f.length() > 0) {
            this._transport = DataHelper.stripHTML((String)f).toUpperCase(Locale.US);
        }
    }

    public void setCost(String f) {
        try {
            this._cost = Integer.parseInt(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setMode(String f) {
        try {
            this._mode = Integer.parseInt(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setDate(String f) {
        try {
            this._date = Long.parseLong(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setFull(String f) {
        try {
            this._full = Integer.parseInt(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setLease(String l) {
        this._debug = "2".equals(l);
        this._lease = this._debug || "1".equals(l);
    }

    public void setLimit(String f) {
        try {
            this._limit = Integer.parseInt(f);
            if (this._limit <= 0) {
                this._limit = Integer.MAX_VALUE;
            } else if (this._limit <= 10) {
                this._limit = 10;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setPage(String f) {
        try {
            this._page = Integer.parseInt(f) - 1;
            if (this._page < 0) {
                this._page = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void allowGraphical() {
        this._graphical = true;
    }

    @Override
    public String getNewNonce() {
        this._newNonce = super.getNewNonce();
        return this._newNonce;
    }

    @Override
    protected void processForm() {
        boolean bl = this._postOK = "Run new analysis".equals(this._action) || "Review analysis".equals(this._action);
        if ("Save".equals(this._action)) {
            try {
                String enable;
                String age;
                String days;
                String thresh;
                HashMap<String, String> toSave = new HashMap<String, String>(4);
                String newTime = this.getJettyString("runFrequency");
                if (newTime != null) {
                    long ntime = Long.parseLong(newTime) * 60L * 60L * 1000L;
                    toSave.put("router.sybilFrequency", Long.toString(ntime));
                }
                if ((thresh = this.getJettyString("threshold")) != null && thresh.length() > 0) {
                    float val = Math.max(Float.parseFloat(thresh), 12.01f);
                    toSave.put("router.sybilThreshold", Float.toString(val));
                }
                if ((days = this.getJettyString("days")) != null && days.length() > 0) {
                    long val = 86400000L * (long)Integer.parseInt(days);
                    toSave.put("router.sybilBlockPeriod", Long.toString(val));
                }
                if ((age = this.getJettyString("deleteAge")) != null && age.length() > 0) {
                    long val = 86400000L * (long)Integer.parseInt(age);
                    toSave.put("router.sybilDeleteOld", Long.toString(val));
                }
                toSave.put("router.sybilEnableBlocking", Boolean.toString((enable = this.getJettyString("block")) != null));
                String nonff = this.getJettyString("nonff");
                toSave.put("router.sybilAnalyzeAll", Boolean.toString(nonff != null));
                if (this._context.router().saveConfig(toSave, null)) {
                    this.addFormNotice(this._t("Configuration saved successfully."));
                } else {
                    this.addFormError("Error saving the configuration (applied but not saved) - please see the error logs");
                }
                Analysis.getInstance((RouterContext)this._context).schedule();
            }
            catch (NumberFormatException nfe) {
                this.addFormError("bad value");
            }
        }
    }

    public String getNetDbSummary() {
        NetDbRenderer renderer = new NetDbRenderer(this._context);
        try {
            this.renderNavBar();
            if (this._routerPrefix != null || this._version != null || this._country != null || this._family != null || this._caps != null || this._ip != null || this._sybil != null || this._port != 0 || this._type != null || this._mtu != null || this._ipv6 != null || this._ssucaps != null || this._transport != null || this._cost != 0 || this._etype != null) {
                renderer.renderRouterInfoHTML(this._out, this._limit, this._page, this._routerPrefix, this._version, this._country, this._family, this._caps, this._ip, this._sybil, this._port, this._type, this._etype, this._mtu, this._ipv6, this._ssucaps, this._transport, this._cost);
            } else if (this._lease) {
                renderer.renderLeaseSetHTML(this._out, this._debug);
            } else if (this._full == 3) {
                if (this._mode == 12 && !this._postOK) {
                    this._mode = 0;
                } else if (!(this._mode != 13 && this._mode != 16 || this._postOK)) {
                    this._mode = 14;
                }
                new SybilRenderer(this._context).getNetDbSummary(this._out, this._newNonce, this._mode, this._date);
            } else if (this._full == 4) {
                this.renderLookupForm();
            } else {
                renderer.renderStatusHTML(this._out, this._limit, this._page, this._full);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private int getTab() {
        if (this._debug) {
            return 6;
        }
        if (this._lease) {
            return 5;
        }
        if (".".equals(this._routerPrefix)) {
            return 1;
        }
        if (this._routerPrefix != null || this._version != null || this._country != null || this._family != null || this._caps != null || this._ip != null || this._sybil != null || this._port != 0 || this._type != null || this._mtu != null || this._ipv6 != null || this._ssucaps != null || this._transport != null || this._cost != 0 || this._etype != null) {
            return 2;
        }
        if (this._full == 2) {
            return 3;
        }
        if (this._full == 1) {
            return 4;
        }
        if (this._full == 3) {
            return 7;
        }
        if (this._full == 4) {
            return 8;
        }
        return 0;
    }

    private void renderNavBar() throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<div class=\"confignav\" id=\"confignav\">");
        boolean span = this._graphical;
        if (!span) {
            buf.append("<center>");
        }
        int tab = this.getTab();
        int i = 0;
        while (i < titles.length) {
            if (!(i == 2 && tab != 2 || i > 2 && i != tab && !this.isAdvanced())) {
                if (i == tab) {
                    if (span) {
                        buf.append("<span class=\"tab2\">");
                    }
                    buf.append(this._t(titles[i]));
                } else {
                    if (span) {
                        buf.append("<span class=\"tab\">");
                    }
                    buf.append("<a href=\"netdb").append(links[i]).append("\">").append(this._t(titles[i])).append("</a>");
                }
                if (span) {
                    buf.append("</span>\n");
                } else if (i != titles.length - 1) {
                    buf.append("&nbsp;&nbsp;\n");
                }
            }
            ++i;
        }
        if (!span) {
            buf.append("</center>");
        }
        buf.append("</div>\n");
        this._out.write(buf.toString());
    }

    private void renderLookupForm() throws IOException {
        this._out.write("<form action=\"/netdb\" method=\"POST\">\n<input type=\"hidden\" name=\"nonce\" value=\"" + this._newNonce + "\" >\n" + "<table id=\"netdblookup\"><tr><th colspan=\"3\">Network Database Search</th></tr>\n" + "<tr><td colspan=\"3\" class=\"subheading\"><b>Enter one search field <i>only</i>:</b></td></tr>\n" + "<tr><td>Capabilities:</td><td><input type=\"text\" name=\"caps\"></td><td>e.g. f or XOfR</td></tr>\n" + "<tr><td>Cost:</td><td><input type=\"text\" name=\"cost\"></td><td></td></tr>\n" + "<tr><td>Country:</td><td><select name=\"c\"><option value=\"\" selected=\"selected\"></option>");
        TreeMap<Object, String> sorted = new TreeMap<Object, String>(Collator.getInstance());
        for (Map.Entry entry : this._context.commSystem().getCountries().entrySet()) {
            String tr = Messages.getString((String)((String)entry.getValue()), (I2PAppContext)this._context, (String)"net.i2p.router.countries.messages");
            sorted.put(tr, (String)entry.getKey());
        }
        for (Map.Entry entry : sorted.entrySet()) {
            this._out.write("<option value=\"" + (String)entry.getValue() + "\">" + (String)entry.getKey() + "</option>\n");
        }
        this._out.write("</select></td><td></td></tr>\n<tr><td>Encryption Type:</td><td><select name=\"etype\"><option value=\"\" selected=\"selected\"></option>");
        for (EncType encType : EnumSet.allOf(EncType.class)) {
            this._out.write("<option value=\"" + encType + "\">" + encType + "</option>\n");
        }
        this._out.write("</select></td><td></td></tr>\n<tr><td>Router Family:</td><td><input type=\"text\" name=\"fam\"></td><td></td></tr>\n<tr><td>Hash Prefix:</td><td><input type=\"text\" name=\"r\"></td><td></td></tr>\n<tr><td>IP:</td><td><input type=\"text\" name=\"ip\"></td><td>IPv4 or IPv6, /24,/16,/8 suffixes optional for IPv4, prefix ok for IPv6</td></tr>\n<tr><td>IPv6 Prefix:</td><td><input type=\"text\" name=\"ipv6\"></td><td></td></tr>\n<tr><td>MTU:</td><td><input type=\"text\" name=\"mtu\"></td><td></td></tr>\n<tr><td>Port Number:</td><td><input type=\"text\" name=\"port\"></td><td></td></tr>\n<tr><td>Signature Type:</td><td><select name=\"type\"><option value=\"\" selected=\"selected\"></option>");
        for (SigType sigType : EnumSet.allOf(SigType.class)) {
            this._out.write("<option value=\"" + sigType + "\">" + sigType + "</option>\n");
        }
        this._out.write("</select></td><td></td></tr>\n<tr><td>Transport:</td><td><select name=\"tr\"><option value=\"\" selected=\"selected\"><option value=\"NTCP\">NTCP</option>\n<option value=\"NTCP_1\">NTCP (v1 only)</option>\n<option value=\"NTCP_2\">NTCP (v2 supported)</option>\n<option value=\"NTCP2\">NTCP2</option>\n<option value=\"SSU\">SSU</option>\n<option value=\"SSU_1\">SSU (v1 only)</option>\n<option value=\"SSU_2\">SSU (v2 supported)</option>\n<option value=\"SSU2\">SSU2</option>\n</select></td><td></td></tr>\n<tr><td>Transport Capabilities:</td><td><input type=\"text\" name=\"ssucaps\"></td><td></td></tr>\n<tr><td>Router Version:</td><td><input type=\"text\" name=\"v\"></td><td></td></tr>\n<tr><td colspan=\"3\" class=\"subheading\"><b>Add Sybil analysis (must pick one above):</b></td></tr>\n<tr><td>Sybil close to:</td><td><input type=\"text\" name=\"sybil2\"></td><td>Router hash, destination hash, b32, or from address book</td>\n<tr><td><label for=\"closetorouter\">or Sybil close to this router:</label></td><td><input type=\"checkbox\" class=\"optbox\" value=\"1\" name=\"sybil\" id=\"closetorouter\"></td><td></td></tr>\n<tr><td colspan=\"3\" class=\"optionsave\"><button type=\"reset\" class=\"cancel\" value=\"Cancel\">Cancel</button> <button type=\"submit\" class=\"search\" value=\"Lookup\">Lookup</button></td></tr>\n</table>\n</form>\n");
    }
}

