/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.router.RouterAddress;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.helpers.UDPSorters;

public class PeerHelper
extends HelperBase {
    private int _sortFlags;
    private String _urlBase;
    private String _transport;
    private boolean _graphical;
    private static final String[] titles = new String[]{PeerHelper._x("Addresses"), "NTCP", "SSU", PeerHelper._x("UPnP Status")};
    private static final String[] links = new String[]{"", "?tx=ntcp", "?tx=ssu", "?tx=upnp"};
    private static final String THINSP = " / ";
    private static final NumberFormat _rateFmt = new DecimalFormat("#,##0.00");
    private static final DecimalFormat _fmt = new DecimalFormat("#,##0.00");

    public void setSort(String flags) {
        if (flags != null) {
            try {
                this._sortFlags = Integer.parseInt(flags);
            }
            catch (NumberFormatException nfe) {
                this._sortFlags = 0;
            }
        } else {
            this._sortFlags = 0;
        }
    }

    public void setUrlBase(String base) {
        this._urlBase = base;
    }

    public void setTransport(String t) {
        this._transport = t;
    }

    public void allowGraphical() {
        this._graphical = true;
    }

    public String getPeerSummary() {
        try {
            this.renderStatusHTML(this._out, this._urlBase, this._sortFlags);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        if (this._context.commSystem().isDummy()) {
            out.write("<p>No peers, no transports, no UPnP: i2p.vmCommSystem=true</p>");
            return;
        }
        this.renderNavBar(out);
        if (this.isAdvanced() && this._transport == null) {
            out.write("<p id=\"upnpstatus\"><b>");
            out.write(this._t("Status"));
            out.write(": ");
            out.write(this._context.commSystem().getLocalizedStatusString());
            out.write("</b></p>");
        }
        SortedMap transports = this._context.commSystem().getTransports();
        if (this._transport != null && !this._transport.equals("upnp")) {
            boolean rendered = false;
            for (Map.Entry e : transports.entrySet()) {
                String style = (String)e.getKey();
                Transport t = (Transport)e.getValue();
                if (style.equals("NTCP") && "ntcp".equals(this._transport)) {
                    NTCPTransport nt = (NTCPTransport)t;
                    this.render(nt, out, urlBase, sortFlags);
                    rendered = true;
                    break;
                }
                if (style.equals("SSU") && "ssu".equals(this._transport)) {
                    UDPTransport ut = (UDPTransport)t;
                    this.render(ut, out, urlBase, sortFlags);
                    rendered = true;
                    break;
                }
                if (!style.equals(this._transport)) continue;
                t.renderStatusHTML(out, urlBase, sortFlags);
                rendered = true;
                break;
            }
            if (rendered) {
                out.write(this.getTransportsLegend());
            } else {
                out.write("<p class=\"infohelp\">Transport not enabled: " + DataHelper.escapeHTML((String)this._transport) + "</p>");
            }
        } else if (this._transport == null) {
            StringBuilder buf = new StringBuilder(4096);
            buf.append("<h3 id=\"transports\">").append(this._t("Router Transport Addresses")).append("</h3><pre id=\"transports\">\n");
            if (!transports.isEmpty()) {
                for (Transport t : transports.values()) {
                    if (t.hasCurrentAddress()) {
                        for (RouterAddress ra : t.getCurrentAddresses()) {
                            buf.append(ra.toString());
                            buf.append("\n\n");
                        }
                        continue;
                    }
                    buf.append(this._t("{0} is used for outbound connections only", t.getStyle()));
                    buf.append("\n\n");
                }
            } else {
                buf.append(this._t("none"));
            }
            buf.append("</pre>\n");
            out.write(buf.toString());
        } else if ("upnp".equals(this._transport)) {
            StringBuilder buf = new StringBuilder(512);
            buf.append("<h3>").append(this._t("UPnP Overview")).append("</h3><div id=\"upnpoverview\"><p>").append(this._t("UPnP is used to communicate with Internet Gateway Devices (IGDs) to detect the external IP address and forward ports.")).append(' ').append(this._t("If UPnP is not working, it may be for one of the following reasons:")).append("</p><ul id=\"upnphelp\"><li>").append(this._t("No UPnP-compatible device present")).append("</li>\n<li>").append(this._t("UPnP disabled on the device")).append("</li>\n<li>").append(this._t("Software firewall interference with UPnP")).append("</li>\n<li>").append(this._t("Bugs in the device's UPnP implementation")).append("</li>\n<li>").append(this._t("Multiple firewall/routers in the internet connection path")).append("</li>\n<li>").append(this._t("UPnP device change, reset, or address change")).append("</li>\n</ul><p>").append(this._t("UPnP may be enabled or disabled on the Network Configuration page, but a change requires a router restart to take effect.")).append("</p></div>");
            out.write(buf.toString());
            this._context.commSystem().renderStatusHTML(this._out, this._urlBase, this._sortFlags);
        }
        out.flush();
    }

    private int getTab() {
        if ("ntcp".equals(this._transport)) {
            return 1;
        }
        if ("ssu".equals(this._transport)) {
            return 2;
        }
        if ("upnp".equals(this._transport)) {
            return 3;
        }
        return 0;
    }

    private void renderNavBar(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<div class=\"confignav\" id=\"confignav\">");
        boolean span = this._graphical;
        if (!span) {
            buf.append("<center>");
        }
        int tab = this.getTab();
        int i = 0;
        while (i < titles.length) {
            block13: {
                block12: {
                    block11: {
                        if (i != tab) break block11;
                        if (span) {
                            buf.append("<span class=\"tab2\">");
                        }
                        buf.append(this._t(titles[i]));
                        break block12;
                    }
                    if (i != 1 ? i == 2 && !this._context.getBooleanPropertyDefaultTrue("i2np.udp.enable") : !this._context.getBooleanPropertyDefaultTrue("i2np.ntcp.enable")) break block13;
                    if (span) {
                        buf.append("<span class=\"tab\">");
                    }
                    buf.append("<a href=\"peers").append(links[i]).append("\">").append(this._t(titles[i])).append("</a>");
                }
                if (span) {
                    buf.append("</span>\n");
                } else if (i != titles.length - 1) {
                    buf.append("&nbsp;&nbsp;\n");
                }
            }
            ++i;
        }
        if (!span) {
            buf.append("</center>");
        }
        buf.append("</div>");
        out.write(buf.toString());
    }

    private final String getTransportsLegend() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<p class=\"infohelp\">").append(this._t("Your transport connection limits are automatically set based on your configured bandwidth.")).append('\n').append(this._t("To override these limits, add the settings i2np.ntcp.maxConnections=nnn and i2np.udp.maxConnections=nnn on the advanced configuration page.")).append("</p>\n");
        buf.append("<h3 class=\"tabletitle\">").append(this._t("Definitions")).append("</h3>").append("<table id=\"peerdefs\">\n").append("<tr><td><b id=\"def.peer\">").append(this._t("Peer")).append("</b></td><td>").append(this._t("The remote peer, identified by router hash")).append("</td></tr>\n").append("<tr><td><b id=\"def.dir\">").append(this._t("Dir")).append("</b></td><td><span class=\"peer_arrow\"><img alt=\"Inbound\" src=\"/themes/console/images/inbound.png\"></span> ").append(this._t("Inbound connection")).append("<br>\n").append("<span class=\"peer_arrow\"><img alt=\"Outbound\" src=\"/themes/console/images/outbound.png\"></span> ").append(this._t("Outbound connection")).append("<br>\n").append("<span class=\"peer_arrow\"><img src=\"/themes/console/images/inbound.png\" alt=\"V\" height=\"8\" width=\"12\"></span> ").append(this._t("They offered to introduce us (help other peers traverse our firewall)")).append("<br>\n").append("<span class=\"peer_arrow\"><img src=\"/themes/console/images/outbound.png\" alt=\"^\" height=\"8\" width=\"12\"></span> ").append(this._t("We offered to introduce them (help other peers traverse their firewall)")).append("</td></tr>\n").append("<tr><td><b id=\"def.idle\">").append(this._t("Idle")).append("</b></td><td>").append(this._t("How long since a packet has been received / sent")).append("</td></tr>\n").append("<tr><td><b id=\"def.rate\">").append(this._t("In/Out")).append("</b></td><td>").append(this._t("The smoothed inbound / outbound transfer rate (KBytes per second)")).append("</td></tr>\n").append("<tr><td><b id=\"def.up\">").append(this._t("Up")).append("</b></td><td>").append(this._t("How long ago this connection was established")).append("</td></tr>\n").append("<tr><td><b id=\"def.skew\">").append(this._t("Skew")).append("</b></td><td>").append(this._t("The difference between the peer's clock and your own")).append("</td></tr>\n");
        if (this.isAdvanced()) {
            buf.append("<tr><td><b id=\"def.cwnd\">CWND</b></td><td>").append(this._t("The congestion window, which is how many bytes can be sent without an acknowledgment")).append(" /<br>\n").append(this._t("The number of sent messages awaiting acknowledgment")).append(" /<br>\n").append(this._t("The maximum number of concurrent messages to send")).append(" /<br>\n").append(this._t("The number of pending sends which exceed congestion window")).append("</td></tr>\n").append("<tr><td><b id=\"def.ssthresh\">SST</b></td><td>").append(this._t("The slow start threshold")).append("</td></tr>\n").append("<tr><td><b id=\"def.rtt\">RTT</b></td><td>").append(this._t("The round trip time in milliseconds")).append("</td></tr>\n").append("<tr><td><b id=\"def.rto\">RTO</b></td><td>").append(this._t("The retransmit timeout in milliseconds")).append("</td></tr>\n").append("<tr><td><b id=\"def.mtu\">MTU</b></td><td>").append(this._t("Maximum receive / send packet size (bytes)")).append("</td></tr>\n");
        }
        buf.append("<tr><td><b id=\"def.recv\">").append(this._t("RX")).append("</b></td><td>").append(this._t("The total number of messages received from the peer")).append("</td></tr>\n").append("<tr><td><b id=\"def.send\">").append(this._t("TX")).append("</b></td><td>").append(this._t("The total number of messages sent to the peer")).append("</td></tr>\n").append("<tr><td><b id=\"def.dupRecv\">").append(this._t("Dup RX")).append("</b></td><td>").append(this._t("The total number of duplicate packets received from the peer")).append("</td></tr>\n").append("<tr><td><b id=\"def.resent\">").append(this._t("Dup TX")).append("</b></td><td>").append(this._t("The total number of packets retransmitted to the peer")).append("</td></tr>\n").append("</table>");
        return buf.toString();
    }

    private void render(NTCPTransport nt, Writer out, String urlBase, int sortFlags) throws IOException {
        TreeSet<NTCPConnection> peers = new TreeSet<NTCPConnection>(this.getNTCPComparator(sortFlags));
        peers.addAll(nt.getPeers());
        long offsetTotal = 0L;
        float bpsSend = 0.0f;
        float bpsRecv = 0.0f;
        long totalUptime = 0L;
        long totalSend = 0L;
        long totalRecv = 0L;
        if (!this.isAdvanced()) {
            Iterator<NTCPConnection> iter = peers.iterator();
            while (iter.hasNext()) {
                if (iter.next().isEstablished()) continue;
                iter.remove();
            }
        }
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<h3 id=\"ntcpcon\">").append(this._t("NTCP connections")).append(": ").append(peers.size());
        buf.append(". ").append(this._t("Limit")).append(": ").append(nt.getMaxConnections());
        if (this.isAdvanced()) {
            buf.append(". ").append(this._t("Status")).append(": ").append(nt.getReachabilityStatus().toLocalizedStatusString((I2PAppContext)this._context));
        }
        buf.append(".</h3>\n<div class=\"widescroll\"><table id=\"ntcpconnections\">\n<tr><th><a href=\"#def.peer\">").append(this._t("Peer")).append("</a></th><th><a href=\"#def.dir\" title=\"").append(this._t("Direction/Introduction")).append("\">").append(this._t("Dir")).append("</a></th><th>").append(this._t("IPv6")).append("</th><th>").append(this._t("Version")).append("</th><th align=\"right\"><a href=\"#def.idle\">").append(this._t("Idle")).append("</a></th><th align=\"right\"><a href=\"#def.rate\">").append(this._t("In/Out")).append("</a></th><th align=\"right\"><a href=\"#def.up\">").append(this._t("Up")).append("</a></th><th align=\"right\"><a href=\"#def.skew\">").append(this._t("Skew")).append("</a></th><th align=\"right\"><a href=\"#def.recv\">").append(this._t("RX")).append("</a></th><th align=\"right\"><a href=\"#def.send\">").append(this._t("TX")).append("</a></th><th>").append(this._t("Out Queue")).append("</th><th title=\"").append(this._t("Is peer backlogged?")).append("\">").append(this._t("Backlogged?")).append("</th> </tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        long now = this._context.clock().now();
        for (NTCPConnection con : peers) {
            float r;
            buf.append("<tr><td class=\"cells\" align=\"left\" nowrap>");
            buf.append(this._context.commSystem().renderPeerHTML(con.getRemotePeer().calculateHash()));
            buf.append("</td><td class=\"cells\" align=\"center\">");
            if (con.isInbound()) {
                buf.append("<img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"").append(this._t("Inbound")).append("\"/>");
            } else {
                buf.append("<img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"").append(this._t("Outbound")).append("\"/>");
            }
            buf.append("</td><td class=\"cells peeripv6\" align=\"center\">");
            if (con.isIPv6()) {
                buf.append("<span class=\"backlogged\">&#x2713;</span>");
            } else {
                buf.append("");
            }
            buf.append("</td><td class=\"cells peeripv6\" align=\"center\">").append(con.getVersion());
            buf.append("</td><td class=\"cells\" align=\"center\"><span class=\"right\">");
            buf.append(DataHelper.formatDuration2((long)con.getTimeSinceReceive(now)));
            buf.append("</span>").append(THINSP).append("<span class=\"left\">").append(DataHelper.formatDuration2((long)con.getTimeSinceSend(now)));
            buf.append("</span></td><td class=\"cells\" align=\"center\"><span class=\"right\">");
            if (con.getTimeSinceReceive(now) < 120000L) {
                r = con.getRecvRate();
                buf.append(PeerHelper.formatRate(r / 1000.0f));
                bpsRecv += r;
            } else {
                buf.append(PeerHelper.formatRate(0.0f));
            }
            buf.append("</span>").append(THINSP).append("<span class=\"left\">");
            if (con.getTimeSinceSend(now) < 120000L) {
                r = con.getSendRate();
                buf.append(PeerHelper.formatRate(r / 1000.0f));
                bpsSend += r;
            } else {
                buf.append(PeerHelper.formatRate(0.0f));
            }
            buf.append("</span></td><td class=\"cells\" align=\"right\">").append(DataHelper.formatDuration2((long)con.getUptime()));
            totalUptime += con.getUptime();
            offsetTotal += con.getClockSkew();
            buf.append("</td><td class=\"cells\" align=\"right\">").append(DataHelper.formatDuration2((long)(1000L * con.getClockSkew())));
            buf.append("</td><td class=\"cells\" align=\"right\">").append(con.getMessagesReceived());
            totalRecv += (long)con.getMessagesReceived();
            buf.append("</td><td class=\"cells\" align=\"right\">").append(con.getMessagesSent());
            totalSend += (long)con.getMessagesSent();
            long outQueue = con.getOutboundQueueSize();
            buf.append("</td><td class=\"cells\" align=\"center\">").append(outQueue);
            buf.append("</td><td class=\"cells\" align=\"center\">");
            if (con.isBacklogged()) {
                buf.append("<span class=\"backlogged\">&#x2713;</span>");
            } else {
                buf.append("&nbsp;");
            }
            buf.append("</td></tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        if (!peers.isEmpty()) {
            buf.append("<tr class=\"tablefooter\"><td colspan=\"5\" align=\"left\"><b>").append(this.ngettext("{0} peer", "{0} peers", peers.size()));
            buf.append("</b></td><td align=\"center\" nowrap><span class=\"right\"><b>").append(PeerHelper.formatRate(bpsRecv / 1000.0f)).append("</b></span>");
            buf.append(THINSP).append("<span class=\"left\"><b>").append(PeerHelper.formatRate(bpsSend / 1000.0f)).append("</b></span>");
            buf.append("</td><td align=\"right\"><b>").append(DataHelper.formatDuration2((long)(totalUptime / (long)peers.size())));
            buf.append("</b></td><td align=\"right\"><b>").append(DataHelper.formatDuration2((long)(offsetTotal * 1000L / (long)peers.size())));
            buf.append("</b></td><td align=\"right\"><b>").append(totalRecv).append("</b></td><td align=\"right\"><b>").append(totalSend);
            buf.append("</b></td><td>&nbsp;</td><td>&nbsp;</td></tr>\n");
        }
        buf.append("</table></div>\n");
        out.write(buf.toString());
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatRate(float rate) {
        NumberFormat numberFormat = _rateFmt;
        synchronized (numberFormat) {
            return _rateFmt.format(rate);
        }
    }

    private Comparator<NTCPConnection> getNTCPComparator(int sortFlags) {
        Comparator<NTCPConnection> rv = null;
        Math.abs(sortFlags);
        rv = AlphaComparator.instance();
        if (sortFlags < 0) {
            rv = Collections.reverseOrder(rv);
        }
        return rv;
    }

    private void render(UDPTransport ut, Writer out, String urlBase, int sortFlags) throws IOException {
        TreeSet<PeerState> peers = new TreeSet<PeerState>(UDPSorters.getComparator(sortFlags));
        peers.addAll(ut.getPeers());
        long offsetTotal = 0L;
        int bpsIn = 0;
        int bpsOut = 0;
        long uptimeMsTotal = 0L;
        long cwinTotal = 0L;
        long rttTotal = 0L;
        long rtoTotal = 0L;
        long sendTotal = 0L;
        long recvTotal = 0L;
        long resentTotal = 0L;
        long dupRecvTotal = 0L;
        int numPeers = 0;
        int numRTTPeers = 0;
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<h3 id=\"udpcon\">").append(this._t("UDP connections")).append(": ").append(peers.size());
        buf.append(". ").append(this._t("Limit")).append(": ").append(ut.getMaxConnections());
        boolean isAdvanced = this.isAdvanced();
        if (isAdvanced) {
            buf.append(". ").append(this._t("Status")).append(": ").append(ut.getReachabilityStatus().toLocalizedStatusString((I2PAppContext)this._context));
        }
        buf.append(".</h3>\n");
        buf.append("<div class=\"widescroll\"><table id=\"udpconnections\">\n");
        buf.append("<tr class=\"smallhead\"><th nowrap><a href=\"#def.peer\">").append(this._t("Peer")).append("</a><br>");
        if (sortFlags != 0) {
            UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by peer hash"), 0);
        }
        buf.append("</th><th nowrap><a href=\"#def.dir\" title=\"").append(this._t("Direction/Introduction")).append("\">").append(this._t("Dir")).append("</a></th><th nowrap>").append(this._t("IPv6")).append("</th><th nowrap>").append(this._t("Version")).append("</th><th nowrap><a href=\"#def.idle\">").append(this._t("Idle")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by idle inbound"), 1);
        buf.append(THINSP);
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by idle outbound"), 2);
        buf.append("</th>");
        buf.append("<th nowrap><a href=\"#def.rate\">").append(this._t("In/Out")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by inbound rate"), 3);
        buf.append(THINSP);
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by outbound rate"), 4);
        buf.append("</th>\n");
        buf.append("<th nowrap><span class=\"peersort\"><a href=\"#def.up\">").append(this._t("Up")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by connection uptime"), 16);
        buf.append("</span></th><th nowrap><span class=\"peersort\"><a href=\"#def.skew\">").append(this._t("Skew")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by clock skew"), 5);
        buf.append("</span></th>\n");
        if (isAdvanced) {
            buf.append("<th nowrap><a href=\"#def.cwnd\">CWND</a><br>");
            UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by congestion window"), 6);
            buf.append("</th><th nowrap><span class=\"peersort\"><a href=\"#def.ssthresh\">SST</a><br>");
            UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by slow start threshold"), 7);
            buf.append("</span></th>\n");
            buf.append("<th nowrap><span class=\"peersort\"><a href=\"#def.rtt\">RTT</a><br>");
            UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by round trip time"), 8);
            buf.append("</span></th><th nowrap><span class=\"peersort\"><a href=\"#def.rto\">RTO</a><br>");
            UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by retransmission timeout"), 10);
            buf.append("</span></th>\n");
            buf.append("<th nowrap><a href=\"#def.mtu\">MTU</a><br>");
            UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by outbound maximum transmit unit"), 11);
            buf.append("</th>");
        }
        buf.append("</span></th><th nowrap><span class=\"peersort\"><a href=\"#def.recv\">").append(this._t("RX")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by packets received"), 13);
        buf.append("<th nowrap><span class=\"peersort\"><a href=\"#def.send\">").append(this._t("TX")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by packets sent"), 12);
        buf.append("</span></th>\n");
        buf.append("</span></th><th nowrap><span class=\"peersort\"><a href=\"#def.dupRecv\">").append(this._t("Dup RX")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by packets received more than once"), 15);
        buf.append("<th nowrap><span class=\"peersort\"><a href=\"#def.resent\">").append(this._t("Dup TX")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by packets retransmitted"), 14);
        buf.append("</span></th></tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        long now = this._context.clock().now();
        for (PeerState peer : peers) {
            if (now - peer.getLastReceiveTime() > 3600000L) continue;
            buf.append("<tr><td class=\"cells\" align=\"left\" nowrap>");
            buf.append(this._context.commSystem().renderPeerHTML(peer.getRemotePeer()));
            buf.append("</td><td class=\"cells\" nowrap align=\"left\">");
            if (peer.isInbound()) {
                buf.append("<img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"").append(this._t("Inbound"));
            } else {
                buf.append("<img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"").append(this._t("Outbound"));
            }
            buf.append("\">");
            if (peer.getWeRelayToThemAs() > 0L) {
                buf.append("&nbsp;&nbsp;<img src=\"/themes/console/images/outbound.png\" height=\"8\" width=\"12\" alt=\"^\" title=\"").append(this._t("We offered to introduce them")).append("\">");
            }
            if (peer.getTheyRelayToUsAs() > 0L) {
                buf.append("&nbsp;&nbsp;<img src=\"/themes/console/images/inbound.png\" height=\"8\" width=\"12\" alt=\"V\" title=\"").append(this._t("They offered to introduce us")).append("\">");
            }
            if (isAdvanced) {
                boolean appended = false;
                int cfs = peer.getConsecutiveFailedSends();
                if (cfs > 0) {
                    if (!appended) {
                        buf.append("<br>");
                    }
                    buf.append(" <i>");
                    buf.append(this.ngettext("{0} fail", "{0} fails", cfs));
                    buf.append("</i>");
                    appended = true;
                }
                if (this._context.banlist().isBanlisted(peer.getRemotePeer(), "SSU")) {
                    if (!appended) {
                        buf.append("<br>");
                    }
                    buf.append(" <i>").append(this._t("Banned")).append("</i>");
                }
            }
            buf.append("</td>");
            buf.append("<td class=\"cells peeripv6\" align=\"center\">");
            if (peer.isIPv6()) {
                buf.append("&#x2713;");
            } else {
                buf.append("");
            }
            buf.append("</td>");
            buf.append("<td class=\"cells peeripv6\" align=\"center\">");
            buf.append(peer.getVersion());
            buf.append("</td>");
            long idleIn = Math.max(now - peer.getLastReceiveTime(), 0L);
            long idleOut = Math.max(now - peer.getLastSendTime(), 0L);
            buf.append("<td class=\"cells\" align=\"center\"><span class=\"right\">");
            buf.append(DataHelper.formatDuration2((long)idleIn));
            buf.append("</span>").append(THINSP);
            buf.append("<span class=\"left\">").append(DataHelper.formatDuration2((long)idleOut));
            buf.append("</span></td>");
            int recvBps = idleIn > 15000L ? 0 : peer.getReceiveBps();
            int sendBps = idleOut > 15000L ? 0 : peer.getSendBps();
            buf.append("<td class=\"cells\" align=\"center\" nowrap><span class=\"right\">");
            buf.append(PeerHelper.formatKBps(recvBps));
            buf.append("</span>").append(THINSP);
            buf.append("<span class=\"left\">").append(PeerHelper.formatKBps(sendBps));
            buf.append("</span></td>");
            long uptime = now - peer.getKeyEstablishedTime();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2((long)uptime));
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            long skew = peer.getClockSkew();
            buf.append(DataHelper.formatDuration2((long)skew));
            buf.append("</td>");
            offsetTotal += skew;
            int rtt = 0;
            int rto = 0;
            if (isAdvanced) {
                int sendWindow = peer.getSendWindowBytes();
                cwinTotal += (long)sendWindow;
                buf.append("<td class=\"cells cwnd\" align=\"center\"><span class=\"right\">");
                buf.append(DataHelper.formatSize2((long)sendWindow));
                buf.append("B");
                buf.append("</span>").append(THINSP).append("<span class=\"right\">").append(peer.getConcurrentSends());
                buf.append("</span>").append(THINSP).append("<span class=\"right\">").append(peer.getConcurrentSendWindow());
                buf.append("</span>").append(THINSP).append("<span class=\"left\">").append(peer.getConsecutiveSendRejections());
                buf.append("</span>");
                if (peer.isBacklogged()) {
                    buf.append("<br><i>").append(this._t("backlogged")).append("</i>");
                }
                buf.append("</td>");
                buf.append("<td class=\"cells\" align=\"right\">");
                buf.append(DataHelper.formatSize2((long)peer.getSlowStartThreshold()));
                buf.append("B</td>");
                rtt = peer.getRTT();
                rto = peer.getRTO();
                buf.append("<td class=\"cells\" align=\"right\">");
                if (rtt > 0) {
                    buf.append(DataHelper.formatDuration2((long)rtt));
                } else {
                    buf.append("n/a");
                }
                buf.append("</td>");
                buf.append("<td class=\"cells\" align=\"right\">");
                buf.append(DataHelper.formatDuration2((long)rto));
                buf.append("</td>");
                buf.append("<td class=\"cells\" align=\"center\"><span class=\"right\">");
                buf.append(peer.getReceiveMTU()).append("</span>").append(THINSP);
                buf.append("<span class=\"left\">").append(peer.getMTU());
                buf.append("</span></td>");
            }
            long sent = peer.getMessagesSent();
            long recv = peer.getMessagesReceived();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(recv);
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(sent);
            buf.append("</td>");
            long resent = peer.getPacketsRetransmitted();
            long dupRecv = peer.getPacketsReceivedDuplicate();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(dupRecv);
            buf.append("</td><td class=\"cells\" align=\"right\">");
            buf.append(resent);
            buf.append("</td></tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
            bpsIn += recvBps;
            bpsOut += sendBps;
            uptimeMsTotal += uptime;
            if (rtt > 0) {
                rttTotal += (long)rtt;
                ++numRTTPeers;
            }
            rtoTotal += (long)rto;
            sendTotal += sent;
            recvTotal += recv;
            resentTotal += resent;
            dupRecvTotal += dupRecv;
            ++numPeers;
        }
        if (numPeers > 0) {
            buf.append("<tr class=\"tablefooter\"><td colspan=\"5\" align=\"left\"><b>").append(this.ngettext("{0} peer", "{0} peers", peers.size())).append("</b></td><td align=\"center\" nowrap><span class=\"right\"><b>");
            buf.append(PeerHelper.formatKBps(bpsIn)).append("</b></span>").append(THINSP);
            buf.append("<span class=\"left\"><b>").append(PeerHelper.formatKBps(bpsOut));
            long x = uptimeMsTotal / (long)numPeers;
            buf.append("</b></span></td><td align=\"right\"><b>").append(DataHelper.formatDuration2((long)x));
            x = offsetTotal / (long)numPeers;
            buf.append("</b></td><td align=\"right\"><b>").append(DataHelper.formatDuration2((long)x)).append("</b></td>\n");
            if (isAdvanced) {
                buf.append("<td align=\"center\"><b>");
                buf.append(String.valueOf(cwinTotal / (long)(numPeers * 1024)) + "K");
                buf.append("</b></td><td>&nbsp;</td>\n<td align=\"right\"><b>");
                if (numRTTPeers > 0) {
                    buf.append(DataHelper.formatDuration2((long)(rttTotal / (long)numRTTPeers)));
                } else {
                    buf.append("n/a");
                }
                buf.append("</b></td><td align=\"right\"><b>");
                buf.append(DataHelper.formatDuration2((long)(rtoTotal / (long)numPeers)));
                buf.append("</b></td><td align=\"center\"><b>").append(ut.getMTU(false)).append("</b></td>");
            }
            buf.append("<td align=\"right\"><b>");
            buf.append(recvTotal).append("</b></td><td align=\"right\"><b>").append(sendTotal).append("</b></td>\n<td align=\"right\"><b>").append(dupRecvTotal);
            buf.append("</b></td><td align=\"right\"><b>").append(resentTotal).append("</b></td></tr>\n");
        }
        buf.append("</table></div>\n");
        out.write(buf.toString());
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String formatKBps(int bps) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format((float)bps / 1000.0f);
        }
    }

    private static class AlphaComparator
    extends PeerComparator {
        private static final AlphaComparator _instance = new AlphaComparator();

        private AlphaComparator() {
        }

        public static final AlphaComparator instance() {
            return _instance;
        }
    }

    private static class PeerComparator
    implements Comparator<NTCPConnection>,
    Serializable {
        private PeerComparator() {
        }

        @Override
        public int compare(NTCPConnection l, NTCPConnection r) {
            if (l == null || r == null) {
                throw new IllegalArgumentException();
            }
            return l.getRemotePeer().calculateHash().toBase64().compareTo(r.getRemotePeer().calculateHash().toBase64());
        }
    }
}

