/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import net.i2p.data.DataHelper;
import net.i2p.router.transport.udp.PeerState;

class UDPSorters {
    static final int FLAG_ALPHA = 0;
    static final int FLAG_IDLE_IN = 1;
    static final int FLAG_IDLE_OUT = 2;
    static final int FLAG_RATE_IN = 3;
    static final int FLAG_RATE_OUT = 4;
    static final int FLAG_SKEW = 5;
    static final int FLAG_CWND = 6;
    static final int FLAG_SSTHRESH = 7;
    static final int FLAG_RTT = 8;
    static final int FLAG_RTO = 10;
    static final int FLAG_MTU = 11;
    static final int FLAG_SEND = 12;
    static final int FLAG_RECV = 13;
    static final int FLAG_RESEND = 14;
    static final int FLAG_DUP = 15;
    static final int FLAG_UPTIME = 16;
    static final int FLAG_DEBUG = 99;

    UDPSorters() {
    }

    static Comparator<PeerState> getComparator(int sortFlags) {
        Comparator<PeerState> rv;
        switch (Math.abs(sortFlags)) {
            case 1: {
                rv = new IdleInComparator();
                break;
            }
            case 2: {
                rv = new IdleOutComparator();
                break;
            }
            case 3: {
                rv = new RateInComparator();
                break;
            }
            case 4: {
                rv = new RateOutComparator();
                break;
            }
            case 16: {
                rv = new UptimeComparator();
                break;
            }
            case 5: {
                rv = new SkewComparator();
                break;
            }
            case 6: {
                rv = new CwndComparator();
                break;
            }
            case 7: {
                rv = new SsthreshComparator();
                break;
            }
            case 8: {
                rv = new RTTComparator();
                break;
            }
            case 10: {
                rv = new RTOComparator();
                break;
            }
            case 11: {
                rv = new MTUComparator();
                break;
            }
            case 12: {
                rv = new SendCountComparator();
                break;
            }
            case 13: {
                rv = new RecvCountComparator();
                break;
            }
            case 14: {
                rv = new ResendComparator();
                break;
            }
            case 15: {
                rv = new DupComparator();
                break;
            }
            default: {
                rv = new AlphaComparator();
            }
        }
        if (sortFlags < 0) {
            rv = Collections.reverseOrder(rv);
        }
        return rv;
    }

    static void appendSortLinks(StringBuilder buf, String urlBase, int sortFlags, String descr, int ascending) {
        if (ascending == 0) {
            buf.append("<span class=\"sortdown\"><a href=\"").append(urlBase).append("?tx=ssu&amp;sort=0\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/inbound.png\" alt=\"V\"></a></span>");
        } else if (sortFlags == ascending) {
            buf.append(" <span class=\"sortdown\"><a href=\"").append(urlBase).append("?tx=ssu&amp;sort=").append(0 - ascending);
            buf.append("\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/inbound.png\" alt=\"V\"></a></span><span class=\"sortupactive\"><b><img src=\"/themes/console/images/outbound.png\" alt=\"^\"></b></span>");
        } else if (sortFlags == 0 - ascending) {
            buf.append(" <span class=\"sortdownactive\"><b><img src=\"/themes/console/images/inbound.png\" alt=\"V\"></b></span><span class=\"sortup\"><a href=\"").append(urlBase).append("?tx=ssu&amp;sort=").append(ascending);
            buf.append("\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/outbound.png\" alt=\"^\"></a></span>");
        } else {
            buf.append(" <span class=\"sortdown\"><a href=\"").append(urlBase).append("?tx=ssu&amp;sort=").append(0 - ascending);
            buf.append("\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/inbound.png\" alt=\"V\"></a></span><span class=\"sortup\"><a href=\"").append(urlBase).append("?tx=ssu&amp;sort=").append(ascending);
            buf.append("\" title=\"").append(descr).append("\"><img src=\"/themes/console/images/outbound.png\" alt=\"^\"></a></span>");
        }
    }

    static class AlphaComparator
    extends PeerComparator {
        AlphaComparator() {
        }
    }

    static class CwndComparator
    extends PeerComparator {
        CwndComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            int rv = l.getSendWindowBytes() - r.getSendWindowBytes();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    static class DupComparator
    extends PeerComparator {
        DupComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsReceivedDuplicate() - r.getPacketsReceivedDuplicate();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    static class IdleInComparator
    extends PeerComparator {
        IdleInComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            long rv = r.getLastReceiveTime() - l.getLastReceiveTime();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    static class IdleOutComparator
    extends PeerComparator {
        IdleOutComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            long rv = r.getLastSendTime() - l.getLastSendTime();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    static class MTUComparator
    extends PeerComparator {
        MTUComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            int rv = l.getMTU() - r.getMTU();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    static class PeerComparator
    implements Comparator<PeerState>,
    Serializable {
        PeerComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            return DataHelper.compareTo((byte[])l.getRemotePeer().getData(), (byte[])r.getRemotePeer().getData());
        }
    }

    static class RTOComparator
    extends PeerComparator {
        RTOComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            int rv = l.getRTO() - r.getRTO();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    static class RTTComparator
    extends PeerComparator {
        RTTComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            int rv = l.getRTT() - r.getRTT();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    static class RateInComparator
    extends PeerComparator {
        RateInComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            int rv = l.getReceiveBps() - r.getReceiveBps();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    static class RateOutComparator
    extends PeerComparator {
        RateOutComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            int rv = l.getSendBps() - r.getSendBps();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    static class RecvCountComparator
    extends PeerComparator {
        RecvCountComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            long rv = l.getMessagesReceived() - r.getMessagesReceived();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    static class ResendComparator
    extends PeerComparator {
        ResendComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            long rv = l.getPacketsRetransmitted() - r.getPacketsRetransmitted();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    static class SendCountComparator
    extends PeerComparator {
        SendCountComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            long rv = l.getMessagesSent() - r.getMessagesSent();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    static class SkewComparator
    extends PeerComparator {
        SkewComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            long rv = Math.abs(l.getClockSkew()) - Math.abs(r.getClockSkew());
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }

    static class SsthreshComparator
    extends PeerComparator {
        SsthreshComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            int rv = l.getSlowStartThreshold() - r.getSlowStartThreshold();
            if (rv == 0) {
                return super.compare(l, r);
            }
            return rv;
        }
    }

    static class UptimeComparator
    extends PeerComparator {
        UptimeComparator() {
        }

        @Override
        public int compare(PeerState l, PeerState r) {
            long rv = r.getKeyEstablishedTime() - l.getKeyEstablishedTime();
            if (rv == 0L) {
                return super.compare(l, r);
            }
            return (int)rv;
        }
    }
}

