/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web.helpers;

import com.vuze.plugins.mlab.MLabRunner;
import java.util.HashMap;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;

public class WizardHelper
extends HelperBase {
    public static final String PROP_COMPLETE = "routerconsole.welcomeWizardComplete";
    public static final float BW_SCALE = 0.75f;
    public static final int PAGE_LANG = 1;
    public static final int PAGE_THEME = 2;
    public static final int PAGE_CHECK = 3;
    public static final int PAGE_TEST = 4;
    public static final int PAGE_RESULTS = 5;
    public static final int PAGE_BROWSER = 6;
    public static final int PAGE_DONE = 7;
    private static final float MIN_DOWN_BW = 32.0f;
    private static final float MIN_UP_BW = 12.0f;
    private MLabRunner _mlab;
    private TestListener _listener;
    private MLabRunner.ToolRun _runner;
    private String _lastTestStatus;
    private int _lastTestCount;

    @Override
    public void setContextId(String contextId) {
        if (this._context == null) {
            super.setContextId(contextId);
            this._mlab = MLabRunner.getInstance((I2PAppContext)this._context);
        }
    }

    public void complete() {
        this._context.router().saveConfig(PROP_COMPLETE, "true");
    }

    public synchronized boolean isNDTComplete() {
        return this._listener != null && this._listener.isComplete();
    }

    public synchronized boolean isNDTRunning() {
        return this._listener != null && !this._listener.isComplete();
    }

    public synchronized boolean isNDTSuccessful() {
        return this.isNDTComplete() && this.getUpBandwidth() > 0L && this.getDownBandwidth() > 0L;
    }

    public synchronized String getTestStatus() {
        String s;
        String rv = "";
        if (this._runner != null && (s = this._runner.getStatus()) != null) {
            rv = DataHelper.escapeHTML((String)s);
            if (rv.equals(this._lastTestStatus)) {
                ++this._lastTestCount;
                int mod = this._lastTestCount & 3;
                if (mod == 1) {
                    rv = String.valueOf(rv) + ".";
                } else if (mod == 2) {
                    rv = String.valueOf(rv) + "..";
                } else if (mod == 3) {
                    rv = String.valueOf(rv) + "...";
                }
            } else {
                this._lastTestCount = 0;
                this._lastTestStatus = rv;
            }
        }
        return rv;
    }

    public synchronized String getCompletionStatus() {
        String s;
        String rv = "";
        if (this._listener != null && (s = this._listener.getSummary()) != null) {
            rv = DataHelper.escapeHTML((String)s);
        }
        return rv;
    }

    public synchronized String getDetailStatus() {
        String s;
        String rv = "";
        if (this._listener != null && (s = this._listener.getDetail()) != null) {
            rv = DataHelper.escapeHTML((String)s);
        }
        return rv;
    }

    public long getUpBandwidth() {
        return this.getLongResult("up");
    }

    public long getDownBandwidth() {
        return this.getLongResult("down");
    }

    public String getServerLocation() {
        StringBuilder buf = new StringBuilder(64);
        String s = this.getStringResult("server_city");
        if (s != null) {
            buf.append(s).append(' ');
        }
        if ((s = this.getStringResult("server_country")) != null) {
            buf.append(s).append(' ');
        }
        if ((s = this.getStringResult("server_host")) != null) {
            buf.append(s);
        }
        return DataHelper.escapeHTML((String)buf.toString());
    }

    private synchronized long getLongResult(String key) {
        Long v;
        Map<String, Object> results;
        if (this._listener != null && (results = this._listener.getResults()) != null && (v = (Long)results.get(key)) != null) {
            return v;
        }
        return 0L;
    }

    private synchronized String getStringResult(String key) {
        Map<String, Object> results;
        if (this._listener != null && (results = this._listener.getResults()) != null) {
            return (String)results.get(key);
        }
        return null;
    }

    public String getInboundBurstRate() {
        long result = this.getDownBandwidth();
        float bw = result > 0L ? Math.max(32.0f, 0.75f * (float)result / 1000.0f) : (float)this._context.bandwidthLimiter().getInboundBurstKBytesPerSecond() * 1.024f;
        return Integer.toString(Math.round(bw));
    }

    public String getOutboundBurstRate() {
        long result = this.getUpBandwidth();
        float bw = result > 0L ? Math.max(12.0f, 0.75f * (float)result / 1000.0f) : (float)this._context.bandwidthLimiter().getOutboundBurstKBytesPerSecond() * 1.024f;
        return Integer.toString(Math.round(bw));
    }

    public String getInboundBurstRateBits() {
        return this.kbytesToBits(this._context.bandwidthLimiter().getInboundBurstKBytesPerSecond());
    }

    public String getOutboundBurstRateBits() {
        return this.kbytesToBits(this._context.bandwidthLimiter().getOutboundBurstKBytesPerSecond());
    }

    public String getShareRateBits() {
        return this.kbytesToBits(this.getShareBandwidth());
    }

    private String kbytesToBits(float kbytes) {
        return String.valueOf(DataHelper.formatSize2Decimal((long)((long)(kbytes * 8192.0f)))) + this._t("bits per second") + "; " + this._t("{0}Bytes per month maximum", DataHelper.formatSize2Decimal((long)((long)(kbytes * 2.7426816E9f))));
    }

    public int getShareBandwidth() {
        long result = this.getDownBandwidth();
        float irateKBps = result > 0L ? Math.max(32.0f, 0.75f * (float)result / 1024.0f) : (float)this._context.bandwidthLimiter().getInboundKBytesPerSecond();
        result = this.getUpBandwidth();
        float orateKBps = result > 0L ? Math.max(12.0f, 0.75f * (float)result / 1024.0f) : (float)this._context.bandwidthLimiter().getOutboundKBytesPerSecond();
        if (irateKBps < 0.0f || orateKBps < 0.0f) {
            return 12;
        }
        double pct = this._context.router().getSharePercentage();
        return (int)(pct * (double)Math.min(irateKBps, orateKBps));
    }

    synchronized boolean startNDT() {
        boolean rv;
        if (this._mlab.isRunning() || this._listener != null && !this._listener.isComplete()) {
            return false;
        }
        TestListener lsnr = new TestListener();
        this._runner = this._mlab.runNDT(lsnr);
        boolean bl = rv = this._runner != null;
        if (!rv) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            lsnr.complete(map);
        }
        this._listener = lsnr;
        return rv;
    }

    synchronized boolean cancelNDT() {
        boolean rv;
        if (!this._mlab.isRunning()) {
            return false;
        }
        boolean bl = rv = this._runner != null;
        if (rv) {
            this._runner.cancel();
            this._runner = null;
        }
        return rv;
    }

    private static class TestListener
    implements MLabRunner.ToolListener {
        private String _summary;
        private String _detail;
        private Map<String, Object> _results;

        private TestListener() {
        }

        @Override
        public synchronized void reportSummary(String str) {
            this._summary = str;
        }

        @Override
        public synchronized void reportDetail(String str) {
            this._detail = str;
        }

        @Override
        public synchronized void complete(Map<String, Object> results) {
            this._results = results;
        }

        public synchronized boolean isComplete() {
            return this._results != null;
        }

        public synchronized String getSummary() {
            return this._summary;
        }

        public synchronized String getDetail() {
            return this._detail;
        }

        public synchronized Map<String, Object> getResults() {
            return this._results;
        }
    }
}

