/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.desktopgui;

import java.awt.Image;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.SwingUtilities;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.app.NotificationService;
import net.i2p.desktopgui.ExternalTrayManager;
import net.i2p.desktopgui.TrayManager;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

public class ExternalMain
implements ClientApp,
NotificationService {
    private final I2PAppContext _appContext;
    private final ClientAppManager _mgr;
    private final Log log;
    private TrayManager _trayManager;
    private static final String PROP_SWING = "desktopgui.swing";

    public ExternalMain(I2PAppContext ctx, ClientAppManager mgr, String[] args) {
        this._appContext = ctx;
        this._mgr = mgr;
        this.log = this._appContext.logManager().getLog(ExternalMain.class);
    }

    public ExternalMain() {
        this._appContext = I2PAppContext.getGlobalContext();
        this._mgr = this._appContext.clientAppManager();
        this.log = this._appContext.logManager().getLog(ExternalMain.class);
    }

    public static void main(String[] args) {
        if (!SystemTray.isSupported()) {
            System.err.println("SystemTray not supported");
            return;
        }
        ExternalMain main = new ExternalMain();
        main.beginStartup(args);
    }

    private synchronized void startUp() throws Exception {
        boolean useSwingDefault = !SystemVersion.isWindows() && !SystemVersion.isMac();
        boolean useSwing = this._appContext.getProperty(PROP_SWING, useSwingDefault);
        this._trayManager = new ExternalTrayManager(this._appContext, useSwing);
        this._trayManager.startManager();
        if (this._mgr != null) {
            this._mgr.register((ClientApp)this);
        }
    }

    private void beginStartup(String[] args) {
        String headless = System.getProperty("java.awt.headless");
        boolean isHeadless = Boolean.parseBoolean(headless);
        if (isHeadless) {
            this.log.warn("Headless environment: not starting desktopgui!");
            return;
        }
        if (SystemVersion.isMac()) {
            this.setMacTrayIcon();
        }
        ExternalMain.launchForeverLoop();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ExternalMain.this.startUp();
                }
                catch (Exception e) {
                    ExternalMain.this.log.error("Failed while running desktopgui!", (Throwable)e);
                }
            }
        });
    }

    private void setMacTrayIcon() {
        block3: {
            File f = new File(this._appContext.getBaseDir(), "docs/themes/console/images/itoopie_sm.png");
            if (!f.exists()) {
                return;
            }
            try {
                Class<?> util = Class.forName("com.apple.eawt.Application");
                Method getApplication = util.getMethod("getApplication", new Class[0]);
                Object application = getApplication.invoke(util, new Object[0]);
                Class[] params = new Class[]{Image.class};
                Method setDockIconImage = util.getMethod("setDockIconImage", params);
                URL url = f.toURI().toURL();
                Image image = Toolkit.getDefaultToolkit().getImage(url);
                setDockIconImage.invoke(application, image);
            }
            catch (Exception e) {
                if (!this.log.shouldWarn()) break block3;
                this.log.warn("Can't set OSX Dock icon", (Throwable)e);
            }
        }
    }

    private static void launchForeverLoop() {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object o;
                    Object object = o = new Object();
                    synchronized (object) {
                        o.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(r, "DesktopGUI spinner");
        t.setDaemon(false);
        t.start();
    }

    public int notify(String source, String category, int priority, String title, String message, String path) {
        TrayManager tm = this._trayManager;
        if (tm == null) {
            return -1;
        }
        return tm.displayMessage(priority, title, message, path);
    }

    public boolean cancel(int id) {
        return false;
    }

    public boolean update(int id, String title, String message, String path) {
        return false;
    }

    public synchronized void startup() {
        this.beginStartup(null);
    }

    public synchronized void shutdown(String[] args) {
        if (this._trayManager != null) {
            this._trayManager.stopManager();
        }
    }

    public ClientAppState getState() {
        return ClientAppState.INITIALIZED;
    }

    public String getName() {
        return "desktopgui";
    }

    public String getDisplayName() {
        return "Desktop GUI";
    }
}

