package gjava;

/* 
 * GJava Java application (version 1.08)
 * GMGuru - Concept, Original text
 * BZGaming 20060715 - Original Design
 * IsmAvatar 20060715 - Complete Recoding, Spell Checked text
 * The GJava community - Fixed typos, found bugs, etc etc.
 */

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Properties;

import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GJava extends JFrame implements ActionListener
	{
	private static final long serialVersionUID = 1L;

	public static String Fontdir = "";

	private static JCheckBox CBLook;

	public static JButton BConvert, BCompile;

	private JProgressBar PBConvert;

	public static JTextField TFGm6, TFJc;

	private JRadioButton RBPopup, RBEmbed;// , RBOther;

	// Globally used vars
	public String Gm6File, JcFile;

	private static String dataFile = "GJava.ini";

	private JFileChooser fc = new JFileChooser();

	public static boolean GMreg;

	public static boolean CompileReady = false;

	public static String sfilename = "", FileFolder, gametype = "";

	public static String folder;

	public GJava()
		{
		super("G-java 1.08");
		folder = "" + GM6.class.getProtectionDomain().getCodeSource().getLocation().getPath();

		//folder = folder.replaceAll("GJava.jar","");
		int location = folder.lastIndexOf("/");
		folder = folder.substring(0,location+1);
		folder = folder.replaceAll("file://","");
		folder = folder.replaceAll("%20"," ");
		folder = folder.substring(1);
		folder = folder.replace("/","\\");
		

		getContentPane().setLayout(new FlowLayout());

		JLabel t;
		t = new JLabel(
				"<html>Welcome to G-java! This program converts your .gm6 files to .java files and compiles them into a single .jar file. First, select the .gm6 file you wish to convert:");
		t.setPreferredSize(new Dimension(370,48));
		getContentPane().add(t);

		TFGm6 = new JTextField();
		TFGm6.setPreferredSize(new Dimension(285,24));
		TFGm6.setEditable(false);
		TFGm6.setBackground(new JTextField().getBackground());
		getContentPane().add(TFGm6);
		makeButton("Browse","Browse for .gm6 file to convert","gm6");

		t = new JLabel(
				"<html>Now that you have located the gm6 file, you have to choose what to convert it to. \"Popup\" will create a new window for the applet while \"Embed\" keeps the applet embedded in the webpage.");
		t.setPreferredSize(new Dimension(370,48));
		getContentPane().add(t);

		// RadioButtons
		ButtonGroup g = new ButtonGroup();

		RBEmbed = new JRadioButton("Embed(Recommended)",true);
		RBEmbed.setPreferredSize(new Dimension(170,20));
		g.add(RBEmbed);
		getContentPane().add(RBEmbed);
		RBPopup = new JRadioButton("Popup");
		RBPopup.setPreferredSize(new Dimension(103,20));
		g.add(RBPopup);
		getContentPane().add(RBPopup);

		// ProgressBar
		JLabel l = new JLabel("<html><b>Progress:");
		l.setPreferredSize(new Dimension(375,20));
		getContentPane().add(l);
		PBConvert = new JProgressBar(0,100);
		PBConvert.setPreferredSize(new Dimension(280,24));
		PBConvert.setStringPainted(true);

		getContentPane().add(PBConvert);

		BConvert = makeButton("Convert","Convert the current .gm6 file","cnv");

		//t = new JLabel(
		//		"<html>Well done, you have now converted your program to java! But before you can run your program, you have to compile it. If you have not installed the java sdk yet, please get it by clicking the \"Get JavaC\" button below. Once installed, locate your javac.exe file below:");
		//t.setPreferredSize(new Dimension(370,74));
		//getContentPane().add(t);

		//TFJc = new JTextField();
		//TFJc.setPreferredSize(new Dimension(285,24));
		//TFJc.setEditable(false);
		//TFJc.setBackground(new JTextField().getBackground());
		//getContentPane().add(TFJc);

		//makeButton("Browse","Browse for javac.exe","jc");

		//BCompile = makeButton("Compile","Compile current game","cmp");
		//BCompile.setEnabled(false);
		//makeButton("Get Javac","Download JavaC from the internet","gjc");

		t = new JLabel("<html>Game maker : Not Registered!");

		check_if_reg(t);

		t.setPreferredSize(new Dimension(370,12));
		getContentPane().add(t);

		CBLook = new JCheckBox("Use Platform Look");
		CBLook.setPreferredSize(new Dimension(370,24));
		CBLook.addActionListener(this);
		CBLook.setActionCommand("plook");
		getContentPane().add(CBLook);

		makeButton("Advanced","Advanced settings","adv");
		makeButton("Help","Need help?","help");
		makeButton("Exit","Exit the program","exit");

		loadDataFile();

		if (TFGm6.getText().equals("") || TFGm6.getText().equals("Browse for a GM6"))
			BConvert.setEnabled(false);
		else
			{
			BConvert.setEnabled(true);
			Gm6File = TFGm6.getText();
			}
		setSize(390,322);
		setLocationRelativeTo(null);
		setResizable(false);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setIconImage(new ImageIcon(getClass().getResource("GJava.png")).getImage());
		setVisible(true);
		try
			{
			boolean empty = GML.createfunctionlist();
			}
		catch (IOException e)
			{
			e.printStackTrace();
			}
		}

	public void actionPerformed(ActionEvent e)
		{
		String c = e.getActionCommand();
		if (c.equals("gm6"))
			{
			fc.resetChoosableFileFilters();
			JFileFilter filter = new JFileFilter(".*\\.gm6","Game Maker 6 Files (*.gm6)");
			fc.addChoosableFileFilter(filter);
			fc.addChoosableFileFilter(new JFileFilter(".*\\.gmd","Old Game maker Files (*.gmd)"));
			fc.setFileFilter(filter);
			if (fc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
				{
				File f = fc.getSelectedFile();
				if (!f.exists())
					{
					JOptionPane.showMessageDialog(this,"File not found","G-Java",0);
					return;
					}
				Gm6File = f.getPath();

				TFGm6.setText(Gm6File);
				saveDataFile();
				BConvert.setEnabled(true);
				//BCompile.setEnabled(false);
				}
			return;
			}
		if (c.equals("cnv"))
			{
			createFolders();

			// openbrowser(folder+FileFolder);
			if (RBPopup.isSelected())
				gametype = "Popup";
			else
				gametype = "Embed";
			/*
			 * if (!GM6.convert(Gm6File,PBConvert)) { JOptionPane.showMessageDialog(this,"Convert
			 * Failed","G-Java",0); return; }
			 */
			GM6.convert(Gm6File,PBConvert);

			// JOptionPane.showMessageDialog(this,"Converted","G-Java",1);
			CompileReady = true;
			// if (!TFJc.getText().equals("")) BCompile.setEnabled(true);
			BConvert.setEnabled(false);
			fc.setEnabled(false);
			copyFiles();
			return;
			}
		if (c.equals("jc"))
			{
			fc.resetChoosableFileFilters();
			JFileFilter filter = new JFileFilter("javac.exe","Javac.exe");
			fc.setFileFilter(filter);
			if (fc.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
				{
				File f = fc.getSelectedFile();
				if (!f.exists())
					{
					JOptionPane.showMessageDialog(this,"File not found","G-Java",0);
					return;
					}
				JcFile = f.getPath();
				if (CompileReady) BCompile.setEnabled(true);
				TFJc.setText(JcFile);
				saveDataFile();
				}
			return;
			}
		if (c.equals("plook"))
			{
			setPlatformLook();
			saveDataFile();
			return;
			}
		
		if (c.equals("help"))
			{
			openbrowser("http://wiki.g-java.com");
			}
		if (c.equals("adv"))
			{
		Advoptions advo = new Advoptions();
			}
		
		if (c.equals("exit"))
			{
			this.dispose();
			return;
			}
		/*if (c.equals("cmp"))
			{
			GJavaCompiler compiler = new GJavaCompiler();

			return;
			}*/
		if (c.equals("gjc"))
			{
			// JOptionPane.showMessageDialog(this,"Download Javac at http://javac.g-java.com","G-java",1);
			openbrowser("http://javac.g-java.com/");
			return;
			}
		}

	public JButton makeButton(String text,String tip,String command)
		{
		JButton b = new JButton(text);
		b.setToolTipText(tip);
		b.addActionListener(this);
		b.setActionCommand(command);
		return (JButton) getContentPane().add(b);
		}

	/*
	 * public void givePlatformLook () { UIManager.LookAndFeelInfo[] looks =
	 * UIManager.getInstalledLookAndFeels(); try{ UIManager.setLookAndFeel(looks[2].getClassName());
	 * SwingUtilities.updateComponentTreeUI(getContentPane()); }catch(Exception e){} }
	 */

	private void loadDataFile()
		{
		String Gm6File = "";
		String JcFile = "";
		if (new File(dataFile).exists())
			{
			Properties p = new Properties();
			try
				{
				p.load(new FileInputStream(dataFile));
				}
			catch (Exception e)
				{
				}
			Fontdir = p.getProperty("Fontdir","");
			if (Fontdir.equals(null))
				{
				Fontdir = JOptionPane
						.showInputDialog("What is the location of your fonts folder? (e.g : C:\\WINDOWS\\Fonts)")
						+ File.separator;
				}
			Gm6File = p.getProperty("Gm6File","");
			if (!new File(Gm6File).exists()) Gm6File = "";
			TFGm6.setText(Gm6File.equals("") ? "Browse for a GM6" : Gm6File);
			JcFile = p.getProperty("Javac","");
			//TFJc.setText(JcFile.equals("") ? "Browse for javac.exe" : JcFile);
			CBLook.setSelected(p.getProperty("usePlatformLook","").equalsIgnoreCase("true"));
			Advoptions.convertpng = p.getProperty("ConvertToPNG").equalsIgnoreCase("true");
			}
		else
			{
			CBLook.setSelected(true);
			}
		setPlatformLook();
		if (new File(JcFile).exists()) return;
		JcFile = "";
		if (System.getProperty("os.name").startsWith("Windows"))
			{
			String loc = "HKLM\\SOFTWARE\\JavaSoft\\Java Development Kit";
			loc += "\\" + WinReg.getSZ(loc,"CurrentVersion");
			JcFile = WinReg.getSZ(loc,"JavaHome").replace("\\","/") + "/bin/javac.exe";
			}
		//if (!new File(JcFile).exists()) JcFile = "";
		//TFJc.setText(JcFile);

		saveDataFile();
		}

	public void check_if_reg(JLabel t)
		{
		if (System.getProperty("os.name").startsWith("Windows"))
			{
			String loc = "HKLM\\SOFTWARE\\softpop23";
			String color = WinReg.getSZ(loc,"Color");
			if (color.equals(""))
				{
				loc = "HKCU\\SOFTWARE\\softpop23";
				color = WinReg.getSZ(loc,"Color");
				}

			if (!(color.equals("")))
				{
				// gm is reg
				t.setText("Game maker: Registered!"); // 416C617364616972204D6F727269736F6E
				GMreg = true;
				}

			}
		}

	public void setPlatformLook()
		{
		UIManager.LookAndFeelInfo[] looks = UIManager.getInstalledLookAndFeels();
		try
			{
			UIManager.setLookAndFeel(looks[(CBLook.isSelected() ? 2 : 0)].getClassName());
			SwingUtilities.updateComponentTreeUI(getContentPane());
			TFGm6.setBackground(new JTextField().getBackground());
			TFJc.setBackground(new JTextField().getBackground());
			}
		catch (Exception e)
			{
			}
		}

	public static class WinReg extends Thread
		{
		private InputStream is;

		private static StringWriter sw;

		public static String getSZ(String loc,String v)
			{
			Process p;
			try
				{
				p = Runtime.getRuntime().exec("reg query \"" + loc + "\" /v " + v);
				WinReg sr = new WinReg(p.getInputStream());
				sr.start();
				p.waitFor();
				sr.join();
				String result = sw.toString();
				int pos = result.indexOf("REG_SZ");
				if (pos == -1) return "";
				return result.substring(pos + 6).trim();
				}
			catch (Exception e)
				{
				return "";
				}
			}

		private WinReg(InputStream is)
			{
			this.is = is;
			sw = new StringWriter();
			}

		public void run()
			{
			try
				{
				int c;
				while ((c = is.read()) != -1)
					sw.write(c);
				}
			catch (Exception e)
				{
				}
			}
		}

	public static void saveDataFile()
		{
		Properties p = new Properties();
		p.put("Gm6File",TFGm6.getText());
		if (Fontdir.equals(""))
			{
			Fontdir = JOptionPane
					.showInputDialog("What is the location of your fonts folder? (e.g : C:\\WINDOWS\\Fonts)")
					+ File.separator;
			}
		p.put("Fontdir","" + GJava.Fontdir);
		//p.put("Javac",TFJc.getText());
		p.put("usePlatformLook",CBLook.isSelected() ? "true" : "false");
		p.put("ConvertToPNG",Advoptions.convertpng ? "true" : "false");
		try
			{
			p.store(new FileOutputStream(dataFile),null);
			}
		catch (Exception e)
			{
			}
		}

	public void createFolders()
		{
		File f1;
		f1 = new File(Gm6File);
		sfilename = f1.getName();
		sfilename = GM6.remove_invalid(sfilename);
		sfilename = sfilename.replaceAll(".gm6","");
		f1 = new File("Projects" + File.separator + sfilename + File.separator + "gjava" + File.separator
				+ "runner");
		FileFolder = "Projects" + File.separator + sfilename + File.separator;
		f1.mkdirs();

		}

	public static void main(String[] args)
		{
		new GJava();

		}

	public static void openbrowser(String location)
		{
		if (System.getProperty("os.name").indexOf("Windows") == 0)
			{
			try
				{
				Runtime.getRuntime().exec("explorer.exe " + location);
				}
			catch (IOException e)
				{
				e.printStackTrace();
				}
			}
		else
			{
			// Unsupported OS for opening the browser
			}
		}

	private void copy(String from,String to,boolean relativepath) throws Exception
		{
		InputStream in;
		if (relativepath == true)
			in = this.getClass().getResourceAsStream(from);
		else
			in = new FileInputStream(new File(from));
		OutputStream out = new FileOutputStream(new File(to));

		byte[] b = new byte[1024];
		int len;
		while ((len = in.read(b)) > 0)
			{
			out.write(b,0,len);
			}
		in.close();
		out.close();

		}

	private void copyFiles()
		{

		// move the files one by one
		try
			{
			String path = FileFolder + File.separator + "gjava" + File.separator + "runner" + File.separator;
			copy("runner/dialog.png",path + "dialog.png",true);
			copy("runner/sprite.class",path + "sprite.class",true);
			copy("runner/Path.class",path + "Path.class",true);
			copy("runner/loading.png",path + "loading.png",true);
			copy("runner/StartPanel.class",path + "StartPanel.class",true);
			copy("runner/font.class",path + "font.class",true);
			copy("runner/Background.class",path + "Background.class",true);
			copy("runner/Functions.class",path + "Functions.class",true);
			copy("runner/Objects.class",path + "Objects.class",true);
			copy("runner/Runner.class",path + "Runner.class",true);
			copy("runner/sound.class",path + "sound.class",true);
			copy("runner/Room.class",path + "Room.class",true);
			copy("runner/MessageBox.class",path + "MessageBox.class",true);
			copy("runner/RoomPanel.class",path + "RoomPanel.class",true);
			copy("runner/tile.class",path + "tile.class",true);
			copy("runner/ImageCanvas.class",path + "ImageCanvas.class",true);
			copy("runner/basicgame.class",path + "basicgame.class",true);
			copy("runner/Game_Information.class",path + "Game_Information.class",true);
			copy("runner/TimedAudioClip.class",path + "TimedAudioClip.class",true);
			copy("runner/Timeline.class",path + "Timeline.class",true);
			copy("runner/Variable.class",path + "Variable.class",true);
			}
		catch (Exception e)
			{
			e.printStackTrace();
			}

		}

	}