package gjava;

/* 
 * GM6.java (version 1.08)
 * GM_guru 20060715 - Original Coding and Concept, getZlib method
 * IsmAvatar 20060716 - Complete recoding, efficiency, error checking, organization
 * GM_guru 2006/09/23 - Added popBasInt for convenience.
 */

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Vector;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class GM6 implements Runnable
	{
	private static String[] args = new String[9];
	
	public static GML gml = new GML();

	public static String currentevent;

	private static int empty, NextResource;

	private static int event;

	private static String eventtype;

	public static BufferedWriter GMLFunctions_java, Gamesettings, Basicgame, Global_java, Filename_java;

	private static FileStream gm6file;

	private static String initres = "", strResourceTitle, Oldname = "", Newname = "", ResourceCreate = "";

	private static int no_of_actions;

	private static JProgressBar prog;

	private static int LetF1ShowGameInformation;

	private static boolean end_animation_event = false;

	private static int[] type;

	public static String currentobject;

	private static JProgressBar pb;

	private static String filename;

	public static Vector roomNames = new Vector(), scriptNames = new Vector();

	private static boolean checkVersion()
		{
		try
			{
			if (pop() != 1234321)
				{
				throw new Exception("This is not a Game Maker file!");
				}
			if (pop() != 600)
				{
				throw new Exception("This was not made in GM 6.0/6.1!");
				}
			}
		catch (Exception e)
			{
			msgbox("File Error: " + e.getMessage(),0);
			close();
			return false;
			}
		return true;
		}

	private static boolean close()
		{
		try
			{
			gm6file.close();
			}
		catch (Exception e)
			{
			return false;
			}
		return true;
		}

	private static boolean closeJava()
		{
		try
			{
			// Close Game Settings
			print(Gamesettings,"}");
			Gamesettings.close();
			
			//code GMLFunctions
			print(GMLFunctions_java,"}");
			GMLFunctions_java.close();
			
			// close filename
			Filename_java.close();

			// Close Basicgame
			Basicgame.close();
			// Now replace stuff
			finishBasicgame();

			// Close Global_java
			print(Global_java,"}");
			Global_java.close();
			
			}
		catch (Exception e)
			{
			return false;
			}
		return true;
		}

	public static void convert(String filename,JProgressBar pb)
		{
		GM6.pb = pb;
		GM6.filename = filename;
		GM6 gm6 = new GM6();
		Thread th = new Thread(gm6);
		// start this thread
		th.start();
		// return GM6.result;
		}

	private void showError()
		{
		msgbox("Convert failed :(",0);
		}

	public void run()
		{
		prog = pb;
		prog.setValue(0);
		gm6file = new FileStream();
		try
			{
			gm6file.open(filename,false);
			}
		catch (Exception e)
			{
			msgbox("Error opening input file. " + e.getMessage(),0);
			showError();
			}
		prog.setValue(5);
		if (!checkVersion()) showError();
		if (!writeHeader()) showError();
		try
			{
			createFilenameJava();
			}
		catch (IOException e)
			{
			e.printStackTrace();
			}
		if (!writeSettings()) showError();
		prog.setValue(10);

		try
			{
			if (!extractSounds()) showError();
			}
		catch (Exception e3)
			{
			e3.printStackTrace();
			}

		prog.setValue(20);
		prog.setString("Converting images, please wait...");
		prog.repaint();
		try
			{
			if (!extractImages()) showError();
			}
		catch (Exception e2)
			{
			e2.printStackTrace();
			}
		prog.setValue(40);
		try
			{
			if (!extractPaths()) showError();

			prog.setValue(50);
			if (!extractScripts()) showError();
			prog.setValue(60);
			if (!extractFonts()) showError();
			prog.setValue(65);

			if (!extractTimelines()) showError();

			prog.setValue(70);

			if (!extractObjects()) showError();

			prog.setValue(80);

			if (!extractRooms()) showError();

			prog.setValue(90);

			if (!extractGameInformation()) showError();

			}
		catch (Exception e)
			{
			e.printStackTrace();
			showError();
			}
		// Close all the java files
		closeJava();
		prog.setValue(100);
		if (!close()) showError();

		GJavaCompiler compiler = new GJavaCompiler();
		prog.setString("Finished, please wait while G-java compiles it!");
		}

	private static void createFilenameJava() throws IOException
		{
		print(Filename_java,"// " + GJava.sfilename + ".java");
		print(Filename_java,"// by G-java");
		print(Filename_java,"");
		print(Filename_java,"/*");
		print(Filename_java,"/ Made in Game Maker 6.0 www.gamemaker.nl");
		print(Filename_java,"/ Converted using G-java 1.08+ www.g-java.com");
		print(Filename_java,"/ This program can be run as an applet or an application!");
		print(Filename_java,"*/");
		print(Filename_java,"");
		print(Filename_java,"import gjava.runner.basicgame;");
		print(Filename_java,"import java.awt.*;");
		print(Filename_java,"import javax.swing.*;");
		print(Filename_java,"import java.net.*;");
		print(Filename_java,"");
		print(Filename_java,"public class " + GJava.sfilename + " extends JApplet  {");
		print(Filename_java,"");
		print(Filename_java,"boolean loading = true;");
		print(Filename_java,"public Image loadingImage;");
		print(Filename_java,"");

		if (GJava.gametype == "Popup")
			{
			print(Filename_java,"    public void stop() {");
			print(Filename_java,"      basicgame.close_sounds();");
			print(Filename_java,"    }");
			print(Filename_java,"    public void init() {");
			print(Filename_java,"    showStatus( \"Made in G-java - www.g-java.com\");");
			print(Filename_java,"        if(!isGreaterThanJDK14())");
			print(Filename_java,"        {");
			print(Filename_java,"            URL upgradeTarget;");
			print(Filename_java,"            try{");
			print(Filename_java,
					"                String targetURL = \"http://www.netsoc.tcd.ie/~duncan/dev/java/upgrade.html\";");
			print(
					Filename_java,
					"                 System.out.println(\"Sorry you need java version 1.4+ to run this program. Redirecting to \"+targetURL+\" for a later version of java\");");
			print(Filename_java,"                 getAppletContext().showDocument(new URL(targetURL));");
			print(Filename_java,"");
			print(Filename_java,"             }catch(MalformedURLException mfe)");
			print(Filename_java,"             {");
			print(Filename_java,"                 System.err.println(\"Malformed URL exception caught:\"+mfe);");
			print(Filename_java,"             }");
			print(Filename_java,"");
			print(Filename_java,"         }");
			print(Filename_java,"         ");
			print(Filename_java,"         URL u = getDocumentBase();");
			print(Filename_java,"                ");
			print(Filename_java,"         new basicgame(u);");
			print(Filename_java,"         ");
			print(Filename_java,"     }");
			print(Filename_java,"");
			print(Filename_java,"    public static void main(String args[]) {");
			print(Filename_java,"    ");
			print(Filename_java,"        // check if the user is using 1.4 or higher");
			print(Filename_java,"        if(!isGreaterThanJDK14())");
			print(Filename_java,"        {");
			print(Filename_java,
					"        JOptionPane.showMessageDialog(null,\"Please download the latest version of java.\");");
			print(Filename_java,"");
			print(Filename_java,"        }");
			print(Filename_java,"        ");
			print(Filename_java,"        new basicgame();");
			print(Filename_java,"        ");
			print(Filename_java,"    }");
			print(Filename_java," public void paint( Graphics g ) {");
			print(Filename_java,
					"  loadingImage  = new ImageIcon(getClass().getResource(\"gjava / runner / loading.png\")).getImage();");
			print(Filename_java,"  //if the game is loading");
			print(Filename_java,"       g.drawImage(loadingImage,0,0, null);");
			print(Filename_java,"     if (loading) {");
			print(Filename_java,"     }");
			print(Filename_java,"  }");
			}

		if (GJava.gametype == "Embed")
			{
			print(Filename_java,"    public void init() {");
			print(Filename_java,"showStatus( \"Made in G-java - www.g-java.com\");");
			print(Filename_java,"        if(!isGreaterThanJDK14())");
			print(Filename_java,"        {");
			print(Filename_java,"            URL upgradeTarget;");
			print(Filename_java,"            try{");
			print(Filename_java,
					"                String targetURL = \"http://www.netsoc.tcd.ie/~duncan/dev/java/upgrade.html\";");
			print(
					Filename_java,
					"                 System.out.println(\"Sorry you need java version 1.4+ to run this program. Redirecting to \"+targetURL+\" for a later version of java\");");
			print(Filename_java,"                 getAppletContext().showDocument(new URL(targetURL));");
			print(Filename_java,"");
			print(Filename_java,"             }catch(MalformedURLException mfe)");
			print(Filename_java,"             {");
			print(Filename_java,"                 System.err.println(\"Malformed URL exception caught:\"+mfe);");
			print(Filename_java,"             }");
			print(Filename_java,"");
			print(Filename_java,"         }");
			print(Filename_java,"         ");
			print(Filename_java,"     }");
			print(Filename_java,"");
			print(Filename_java,"    public static void main(String args[]) {");
			print(Filename_java,"    ");
			print(Filename_java,"        // check if the user is using 1.4 or higher");
			print(Filename_java,"        if(!isGreaterThanJDK14())");
			print(Filename_java,"        {");
			print(Filename_java,
					"        JOptionPane.showMessageDialog(null,\"Please download the latest version of java.\");");
			print(Filename_java,"");
			print(Filename_java,"        }");
			print(Filename_java,"        ");
			print(Filename_java,"        basicgame gme = new basicgame();");
			print(Filename_java,"        ");
			print(Filename_java,"    }");
			print(Filename_java,"public void paint( Graphics g ) {");
			print(Filename_java,
					"         loadingImage  = new ImageIcon(getClass().getResource(\"gjava/runner/loading.png\")).getImage();");
			print(Filename_java,"      g.drawImage(loadingImage,0,0, null);");
			print(Filename_java," //if the game is loading");
			print(Filename_java,"    if (loading) {");
			print(Filename_java,"         //load the sprites");
			print(Filename_java,"         basicgame.load_Sprites();");
			print(Filename_java,"         //load the sounds");
			print(Filename_java,"         basicgame.load_Sounds();");
			print(Filename_java,"         // load all backgrounds here");
			print(Filename_java,"         basicgame.load_Backgrounds();");
			print(Filename_java,"         // load all paths here");
			print(Filename_java,"         basicgame.load_Paths();");
			print(Filename_java,"         // load all fonts here");
			print(Filename_java,"         basicgame.load_Fonts();");
			print(Filename_java,"         // load all timelines here");
			print(Filename_java,"         basicgame.load_Timelines();");
			print(Filename_java,"         loading = false;");
			print(Filename_java,"         URL u = getDocumentBase();");
			print(Filename_java,"                ");
			print(Filename_java,"         basicgame gme = new basicgame(u,this);");
			print(Filename_java,"    }");
			print(Filename_java," }");
			}
		print(Filename_java,"    private static boolean isGreaterThanJDK14()");
		print(Filename_java,"    {");
		print(Filename_java,"        /*");
		print(
				Filename_java,
				"            (taken from http://h21007.www2.hp.com/dspp/tech/tech_TechDocumentDetailPage_IDX/1,1701,2156,00.html):");
		print(Filename_java,"");
		print(Filename_java,"            java.class.version property values:");
		print(Filename_java,"        ");
		print(Filename_java,"            JDK 1.1 45.3");
		print(Filename_java,"            JDK 1.2 46.0");
		print(Filename_java,"            JDK 1.3 47.0");
		print(Filename_java,"            JDK 1.4 48.0");
		print(Filename_java,"");
		print(Filename_java,"        */");
		print(Filename_java,"        String v = System.getProperty(\"java.class.version\");");
		print(Filename_java,"        String v2 = System.getProperty(\"java.version\");");
		print(Filename_java,"        System.out.println(\"java.class.version:\"+v);");
		print(Filename_java,"        System.out.println(\"java.version:\"+v2);");
		print(Filename_java,"        System.out.println(\"Made in G-java : WwW.G-jAvA.CoM\");");
		print(Filename_java,"        try{");
		print(Filename_java,"            return (Double.valueOf(v).doubleValue() >= 47.0);");
		print(Filename_java,"        }catch(NumberFormatException nfe)");
		print(Filename_java,"        {");
		print(Filename_java,"        }");
		print(Filename_java,"        return false;");
		print(Filename_java,"");
		print(Filename_java,"    }");
		print(Filename_java,"}");
		}

	private static boolean extractActions() throws IOException
		{
		empty = pop();

		empty = pop(); // Library ID
		pop(); // Action ID
		int Kind = pop(); // Action Kind
		empty = pop(); // Can be Relative?
		empty = pop(); // Question?
		empty = pop(); // Applies?
		int Type = pop(); // Type (0=Nothing, 1=Function, 2=Code)

		String function = popStr();

		String code = popStr();

		empty = pop();
		empty = pop();
		type = new int[empty + 1];
		for (int subi = 1; subi <= empty; subi++)
			{
			type[subi] = pop();
			}
		int Applies = pop(); // "Applies to" Object Index (dec: -1 for Self, -2 for Other)
		int Relative = pop();

		empty = pop();

		
		
		for (int subi = 1; subi <= empty; subi++)
			{
			args[subi] = popStr();
		
			
			if (type[subi] == 0)
				{
				try
					{
					args[subi] = gml.parse_args(args[subi]);
					}
				catch (Exception e)
					{
					// TODO Auto-generated catch block
					e.printStackTrace();
					}//GML.parse_args(args[subi]); // code
				}
			else if (type[subi] == 1)
				args[subi].replaceAll("\"","\"+new String(new Character((char)34).toString())+\"");
			else if ((type[subi] == 2) && (args[subi].indexOf("\"") == 0))
				args[subi] = gml.parse_args(args[subi]); // since the both is overrided by the "
			else if ((type[subi] == 2) && (args[subi].indexOf("'") == 0))
				args[subi] = gml.parse_args(args[subi]);
			else if (type[subi] == 2)
				args[subi].replaceAll("\"","\"+new String(new Character((char)34).toString())+\"");

			}
		empty = pop(); // NOT

		boolean done = true;
		
		prog.setString(function + " is being converted");

		if (Type == 1)
			done = GML.convertFunctions(function,Applies,Relative,args,Basicgame);
		// if (Type == 2) done = GML.convertCode();
		else
			{
			if (Kind == 1) GM6.print(Basicgame,"{");
			if (Kind == 2) GM6.print(Basicgame,"}");
			if (Kind == 3) GM6.print(Basicgame," else ");
			if (Kind == 4) GM6.print(Basicgame,"return;");
			if (Kind == 5) GM6.print(Basicgame," for (int iii=0; iii <=" + args[1] + "; iii++)");

			if (Kind == 6)
				{
				// Set the value of a variable
				try
					{
					args[1]=gjava.parser.gmltojavaParser.parsearg(args[1]).replaceAll(".getDouble\\(\\)","").replaceAll(".getValue","\\(\\)");
					}
					
				catch (Exception e)
					{
					e.printStackTrace();
					}
				
				if (Relative == 1)
					GM6.print(Basicgame,args[1] + ".plusEquals(\"\"+ (" + args[2] + "));");
				else
					GM6.print(Basicgame,args[1] + ".setValue(\"\"+ (" + args[2] + "));");
				}

			if (Kind == 7) 
				{
				GM6.print(Basicgame,"//code action"); 
				try
					{
					gjava.parser.gmltojavaParser.parsecode(args[1]);
					}
				catch (Exception e)
					{
					e.printStackTrace();
					}
				}
			}
		if (done == false) return false;
		return true;
		}

	private static boolean extractFonts()
		{
		ResourceCreate = ResourceCreate + "public static void load_Fonts() {\n";
		ResourceCreate = ResourceCreate + "//load all the Fonts here \n";
		// Font ResouceHeader
		empty = pop();
		int sNumber = pop();

		for (int i = 0; i < sNumber; i++)
			{
			NextResource = pop();
			if ((NextResource != 0) && (NextResource != 1))
				{
				msgbox("Error to far! G-java has extracted too many scripts!",0);
				return false;
				}

			if (NextResource == 1)
				{
				// This is valid so get all the data
				strResourceTitle = popStr();

				// remember old name
				Oldname = Oldname + strResourceTitle;

				// remove invalid characters from name:
				strResourceTitle = remove_invalid(strResourceTitle);

				// add fon_if not already
				if (strResourceTitle.indexOf("fon_") != 0) strResourceTitle = "fon_" + strResourceTitle;

				// remember new name
				Newname = Newname + strResourceTitle;

				empty = pop();
				String Realfontname = popStr();
				ResourceCreate = ResourceCreate + "font[0] = new font(\"" + strResourceTitle + "\",\"" + Realfontname
						+ "\"," + pop() + ");\n";

				empty = pop(); // Bold
				empty = pop(); // Italic
				empty = pop(); // Character Range Begin
				empty = pop(); // Character Range End

				String extension = "";
				try
					{

					File f = new File(GJava.Fontdir + Realfontname + ".ttf");
					if (f.exists())
						extension = ".ttf";
					else
						{
						f = new File(GJava.Fontdir + Realfontname + ".TTF");
						if (f.exists())
							extension = ".TTF";
						else
							extension = ".FON";
						}
					copy(GJava.Fontdir + Realfontname + extension,GJava.FileFolder + File.separator + "gjava"
							+ File.separator + "runner" + File.separator + strResourceTitle + ".gjf");

					}
				catch (Exception e)
					{
					// TODO Auto-generated catch block
					e.printStackTrace();
					}

				}

			}
		initres = initres + "public static font[] font = new font[" + sNumber + 1 + "];\n";
		ResourceCreate = ResourceCreate + "}\n\n";
		return true;
		}

	private static void copy(String from,String to) throws Exception
		{
		InputStream in;

		in = new FileInputStream(new File(from));
		OutputStream out = new FileOutputStream(new File(to));

		byte[] b = new byte[1024];
		int len;
		while ((len = in.read(b)) > 0)
			{
			out.write(b,0,len);
			}
		in.close();
		out.close();

		}

	private static boolean extractImages() throws IOException,DataFormatException
		{
		ResourceCreate = ResourceCreate + "public static void load_Sprites() {\n";
		ResourceCreate = ResourceCreate + "//load all the sprites here \n";

		// Sprites ResouceHeader
		empty = pop();
		int sNumber = pop();

		for (int i = 0; i < sNumber; i++)
			{
			NextResource = pop();
			if ((NextResource != 0) && (NextResource != 1))
				{
				msgbox("Error to far! G-java has extracted too many sprites!",0);
				return false;
				}

			if (NextResource == 1)
				{
				// This is valid so get all the data
				strResourceTitle = popStr();

				// remember old name
				Oldname = Oldname + strResourceTitle;

				// remove invalid characters from name:
				strResourceTitle = remove_invalid(strResourceTitle);

				// add spr_if not already
				if (strResourceTitle.indexOf("spr_") != 0) strResourceTitle = "spr_" + strResourceTitle;

				// remember new name
				Newname = Newname + strResourceTitle;

				prog.setString(strResourceTitle + " is being converted to png...");

				empty = pop();
				int transparent;
				ResourceCreate = ResourceCreate + "sprite[" + i + "] = new sprite(\"" + strResourceTitle + "\","
						+ pop() + "," + pop() + "," + pop() + "," + pop() + "," + pop() + "," + pop() + ","
						+ (transparent = pop()) + "," + pop() + "," + pop() + "," + pop() + "," + pop() + "," + pop()
						+ "," + pop() + "\n";

				int subimages = pop();

				if (subimages != 0)
					{
					for (int subi = 0; subi < subimages; subi++)
						{
						empty = pop();
						if (Advoptions.convertpng)
							{
							getZlib(GJava.FileFolder + strResourceTitle + "N" + subi + ".bmp");

							try
								{
								File image = new File(GJava.FileFolder + strResourceTitle + "N" + subi + ".bmp");
								BufferedImage img = ImageIO.read(image);
								int tpixel = img.getRGB(img.getMinX(),img.getHeight() - 1);

								BufferedImage timage;
								if (transparent == 1)
									{
									timage = Transparency.makeColorTransparent(img,new Color(tpixel));
									}
								else
									{
									timage = img;
									}
								// create new png
								ImageIO.write(timage,"png",new File(GJava.FileFolder + "gjava" + File.separator + "runner"
										+ File.separator + strResourceTitle + "N" + subi + ".png"));
								image.delete();
								}
							catch (IOException e)
								{
								msgbox("Error writing " + GJava.FileFolder + strResourceTitle + "N" + subi
										+ ".bmp Seek help at http://www.g-java.com",0);
								return false;
								}
							}
						else
							{
							popStr();
							}
						}
					}
				ResourceCreate = ResourceCreate + "," + subimages + ");\n";
				}
			}
		initres = initres + "public static sprite[] sprite = new sprite[" + sNumber + 1 + "];\n";
		ResourceCreate = ResourceCreate + "}\n";

		// Backgrounds ResouceHeader
		empty = pop();
		sNumber = pop();
		ResourceCreate = ResourceCreate + "public static void load_Backgrounds() {\n";
		ResourceCreate = ResourceCreate + "//load all the Backgrounds here \n";

		for (int i = 0; i < sNumber; i++)
			{
			NextResource = pop();
			if ((NextResource != 0) && (NextResource != 1))
				{
				msgbox("Error to far! G-java has extracted too many Backgrounds!",0);
				return false;
				}

			if (NextResource == 1)
				{
				// This is valid so get all the data
				strResourceTitle = popStr();

				// remember old name
				Oldname = Oldname + strResourceTitle;

				// remove invalid characters from name:
				strResourceTitle = remove_invalid(strResourceTitle);

				// add bkg_if not already
				if (strResourceTitle.indexOf("bkg_") != 0) strResourceTitle = "bkg_" + strResourceTitle;

				// remember new name
				Newname = Newname + strResourceTitle;

				empty = pop();
				int transparent;
				ResourceCreate = ResourceCreate + "background[" + i + "] = new Background(\"" + strResourceTitle
						+ "\"," + pop() + "," + pop() + "," + (transparent = pop()) + "," + pop() + "," + pop() + ","
						+ pop() + "," + pop() + "," + pop() + "," + pop() + "," + pop() + "," + pop() + "," + pop()
						+ ");\n";

				empty = pop();
				if (empty == 1)
					{
					empty = pop();
					getZlib(GJava.FileFolder + strResourceTitle + ".bmp");
					try
						{
						File image = new File(GJava.FileFolder + strResourceTitle + ".bmp");
						BufferedImage img = ImageIO.read(image);
						int tpixel = img.getRGB(img.getMinX(),img.getHeight() - 1);

						BufferedImage timage;
						if (transparent == 1)
							{
							timage = Transparency.makeColorTransparent(img,new Color(tpixel));
							}
						else
							{
							timage = img;
							}
						// create new png
						ImageIO.write(timage,"png",new File(GJava.FileFolder + "gjava" + File.separator + "runner"
								+ File.separator + strResourceTitle + ".png"));
						image.delete();
						}
					catch (IOException e)
						{
						}
					}
				}
			}

		initres = initres + "public static Background[] background = new Background[" + sNumber + 1 + "];\n";
		ResourceCreate = ResourceCreate + "}\n";
		return true;
		}

	private static boolean extractObjects() throws IOException
		{
		ResourceCreate = ResourceCreate
				+ "public static Objects load_Objects(int objectid, double X, double Y, double id) {\n";
		ResourceCreate = ResourceCreate + "//load all the Objects here \n";
		// Objects ResouceHeader
		empty = pop();
		int sNumber = pop();

		for (int i = 0; i < sNumber; i++)
			{
			NextResource = pop();
			if ((NextResource != 0) && (NextResource != 1))
				{
				msgbox("Error to far! G-java has extracted too many objects!",0);
				return false;
				}

			if (NextResource == 1)
				{
				// This is valid so get all the data
				strResourceTitle = popStr();
				prog.setString(strResourceTitle + " is being converted");

				// remember old name
				Oldname = Oldname + strResourceTitle;

				// remove invalid characters from name:
				strResourceTitle = remove_invalid(strResourceTitle);

				// add obj_ if not already
				if (strResourceTitle.indexOf("obj_") != 0) strResourceTitle = "obj_" + strResourceTitle;

				// remember new name
				Newname = Newname + strResourceTitle;

				currentobject = strResourceTitle;
				empty = pop();

				ResourceCreate = ResourceCreate + "obj[" + i + "] = new " + strResourceTitle + "((int)X,(int)Y," + i
						+ ",id);\n";

				// Write the objects class
				print(Basicgame,"class " + strResourceTitle + " extends Objects {");
				print(Basicgame,"      " + strResourceTitle + "(int X, int Y, int objid, double instance_id) {");
				print(Basicgame,"      super(objid,\"" + strResourceTitle + "\"," + pop() + "," + pop() + "," + pop()
						+ "," + pop() + "," + pop() + "," + pop() + "," + pop() + ");");
				print(Basicgame,"      this.X = X;");
				print(Basicgame,"      this.Y = Y;");
				print(Basicgame,"      this.xstart = X;");
				print(Basicgame,"      this.ystart = Y;");
				print(Basicgame,"      this.instance_id = instance_id;");
				print(Basicgame,"      }");

				empty = pop();

				/*
				 * Create Event
				 */
				currentevent = "Create Event";
				empty = pop();
				if (empty != -1)
					{

					print(Basicgame,"    public void Create_event() {");

					empty = pop();
					no_of_actions = pop(); // Number of actions
					for (int subi = 0; subi < no_of_actions; subi++)
						{
						extractActions();
						}
					empty = pop();
					print(Basicgame,"    }");
					}

				/*
				 * Destory Event
				 */
				currentevent = "Destory Event";
				empty = pop();
				if (empty != -1)
					{

					print(Basicgame,"    public void Destory_event() {");

					empty = pop();
					no_of_actions = pop(); // Number of actions
					for (int subi = 0; subi < no_of_actions; subi++)
						{
						extractActions();
						}
					print(Basicgame,"    }");
					empty = pop();
					}

				/*
				 * Alarm Event
				 */
				currentevent = "Alarm Event";
				event = pop();
				print(Basicgame,"    public void Alarm() {");
				while (event != -1)
					{
					print(Basicgame,"    	if (G_JAVA_alarm[" + event + "] == 0) {");
					empty = pop();
					no_of_actions = pop(); // Number of actions
					for (int subi = 0; subi < no_of_actions; subi++)
						{
						extractActions();
						}
					print(Basicgame,"    	}");
					event = pop();
					}
				print(Basicgame,"    }");

				/*
				 * Step Event
				 */
				currentevent = "Step Event";
				event = pop();

				while (event != -1)
					{
					if (event == 0) print(Basicgame,"    public void Step() {");
					if (event == 1) print(Basicgame,"    public void Begin_Step_event() {");
					if (event == 2) print(Basicgame,"    public void End_Step_event() {");
					empty = pop();
					no_of_actions = pop(); // Number of actions
					for (int subi = 0; subi < no_of_actions; subi++)
						{
						extractActions();
						}
					print(Basicgame,"    }");
					event = pop();
					}

				/*
				 * Collision Event
				 */
				currentevent = "Collision Event";
				event = pop();
				print(Basicgame,"    public void Collision_event() {");
				print(Basicgame,"    Rectangle thisBounds = getBounds(X,Y);");
				print(Basicgame,"    int G_JAVA_GJCollisionii = 0;");
				print(Basicgame,"    		while (G_JAVA_GJCollisionii < basicgame.Current_room.instances.size()) {");
				print(Basicgame,"    		Objects G_JAVA_o = (Objects)basicgame.Current_room.instances.get(G_JAVA_GJCollisionii);");
				print(Basicgame,"    		G_JAVA_r1 = G_JAVA_o.getBounds(G_JAVA_o.X,G_JAVA_o.Y);");
				while (event != -1)
					{
					print(Basicgame,"    		if ((G_JAVA_o.id == " + event + " || G_JAVA_o.parent == " + event
							+ " ) && (G_JAVA_r1.intersects(thisBounds))) {");
					print(Basicgame,"    			if (this.solid == 1 || G_JAVA_o.solid == 1) {");
					print(Basicgame,"    				X = xprevious;");
					print(Basicgame,"    				Y = yprevious;");
					print(Basicgame,"    			}");
					empty = pop();
					no_of_actions = pop(); // Number of actions
					for (int subi = 0; subi < no_of_actions; subi++)
						{
						extractActions();
						}
					print(Basicgame,"    }");
					event = pop();
					}
				print(Basicgame,"    	G_JAVA_GJCollisionii++;");
				print(Basicgame,"    	}");
				print(Basicgame,"    }");

				/*
				 * keyboard Event
				 */
				currentevent = "Keyboard Event";
				event = pop();
				print(Basicgame,"    public void Keyboard_event() {");
				print(Basicgame,"    	if (G_JAVA_keyboard.size() == 0) G_JAVA_keyboard.add(0, new Integer(0));");
				print(Basicgame,"     	G_JAVA_ii = 0;");
				print(Basicgame,"    		while (G_JAVA_ii < G_JAVA_keyboard.size()) {");
				print(Basicgame,"    		Integer G_JAVA_ojs = (Integer)G_JAVA_keyboard.get(G_JAVA_ii);");
				while (event != -1)
					{
					print(Basicgame,"    		if (G_JAVA_ojs.intValue() == " + event + ") {");
					empty = pop();
					no_of_actions = pop(); // Number of actions
					for (int subi = 0; subi < no_of_actions; subi++)
						{
						extractActions();
						}
					print(Basicgame,"    		}");
					event = pop();
					}
				print(Basicgame,"    G_JAVA_ii++;");
				print(Basicgame,"    }");
				// Remove no key event
				print(Basicgame,"    if (G_JAVA_keyboard.size() == 1) {");
				print(Basicgame,"			Integer G_JAVA_o = (Integer)G_JAVA_keyboard.get(0);");
				print(Basicgame,"     if (G_JAVA_o.intValue() == 0) {");
				print(Basicgame,"        G_JAVA_keyboard.remove(0);");
				print(Basicgame,"     }");
				print(Basicgame,"    }");
				print(Basicgame,"}");

				/*
				 * Mouse Event TODO
				 */
				currentevent = "Mouse Event";
				event = pop();
				while (event != -1)
					{
					// if (event == 4 || event == 5 || event == 6) print(Basicgame," public void mouse_Pressed(int
					// keycode, int xx, int yy) {");

					empty = pop();
					no_of_actions = pop(); // Number of actions
					for (int subi = 0; subi < no_of_actions; subi++)
						{
						extractActions();
						}

					event = pop();
					}

				/*
				 * Other Event TODO Add more events
				 */
				currentevent = "Other Event";
				event = pop();
				while (event != -1)
					{
					if (event == 0)
						eventtype = "Outside";
					else if (event == 7)
						{
						eventtype = "End_animation";
						end_animation_event = true;
						}
					else
						eventtype = "OTHEREVENT_" + event;

					print(Basicgame,"    public void " + eventtype + "() {");

					empty = pop();
					no_of_actions = pop(); // Number of actions
					for (int subi = 0; subi < no_of_actions; subi++)
						{
						extractActions();
						}
					print(Basicgame,"    }");
					event = pop();
					}

				/*
				 * Draw Event
				 */
				currentevent = "Draw Event";
				event = pop();

				while (event != -1)
					{
					print(Basicgame,"    public void Draw_event(Graphics g) {");
					print(Basicgame,"			if (G_JAVA_Object_visible == 1) {");
					print(Basicgame,"				Graphics comp2D = (Graphics2D)g;");
					print(Basicgame,"				g.setColor( Color.black );");
					empty = pop();
					no_of_actions = pop(); // Number of actions
					for (int subi = 0; subi < no_of_actions; subi++)
						{
						extractActions();
						}

					event = pop();
					print(Basicgame,"    }");
					print(Basicgame,"    }");
					}

				/*
				 * KeyPress Event
				 */
				currentevent = "keyP Event";
				event = pop();
				print(Basicgame,"    public void Key_Pressed(int G_JAVA_keycode) {");
				print(Basicgame,"			if (!G_JAVA_keyboard.contains(new Integer(G_JAVA_keycode))) {");
				print(Basicgame,"				G_JAVA_keyboard.add(0, new Integer(G_JAVA_keycode));");
				print(Basicgame,"			}");
				print(Basicgame,"			// any key");
				print(Basicgame,"			if (!G_JAVA_keyboard.contains(new Integer(1))) {");
				print(Basicgame,"					G_JAVA_keyboard.add(0, new Integer(1));");
				print(Basicgame,"			}");

				while (event != -1)
					{
					print(Basicgame,"			if (G_JAVA_keycode == " + event + ") {");
					empty = pop();
					no_of_actions = pop(); // Number of actions
					for (int subi = 0; subi < no_of_actions; subi++)
						{
						extractActions();
						}
					print(Basicgame,"     }");
					event = pop();
					}
				print(Basicgame,"    }");

				/*
				 * KeyRelease Event
				 */
				currentevent = "KeyR Event";
				event = pop();
				print(Basicgame,"    public void Key_Released(int G_JAVA_keycode) {");
				print(Basicgame,"				// remove keyboard");
				print(Basicgame,"				G_JAVA_ii = G_JAVA_keyboard.size()-1;");
				print(Basicgame,"				while (G_JAVA_ii > -1) {");
				print(Basicgame,"					Integer G_JAVA_o = (Integer)G_JAVA_keyboard.get(G_JAVA_ii);");
				print(Basicgame,"					if (G_JAVA_o.intValue() == G_JAVA_keycode) {");
				print(Basicgame,"						G_JAVA_keyboard.remove(G_JAVA_ii);");
				print(Basicgame,"					}");
				print(Basicgame,"					G_JAVA_ii--;");
				print(Basicgame,"				}");
				print(Basicgame,"				if (G_JAVA_keyboard.size() == 1) {");
				print(Basicgame,"    			G_JAVA_keyboard.remove(0);");
				print(Basicgame,"    		}");

				while (event != -1)
					{
					print(Basicgame,"			if (G_JAVA_keycode == " + event + ") {");
					empty = pop();
					no_of_actions = pop(); // Number of actions
					for (int subi = 0; subi < no_of_actions; subi++)
						{
						extractActions();
						}
					print(Basicgame,"     }");
					event = pop();
					}
				print(Basicgame,"    }");

				// close the object class
				print(Basicgame,"}");

				// end events
				}

			}
		initres = initres + "public static Objects[] obj = new Objects[" + sNumber + 1 + "];\n";
		ResourceCreate = ResourceCreate + "return obj[objectid];\n";
		ResourceCreate = ResourceCreate + "}\n\n";
		return true;
		}

	private static boolean extractPaths() throws IOException
		{
		ResourceCreate = ResourceCreate + "public static void load_Paths() {\n";
		ResourceCreate = ResourceCreate + "//load all the paths here \n";

		empty = pop(); // Path ResouceHeader
		int sNumber = pop();

		for (int i = 0; i < sNumber; i++)
			{
			NextResource = pop();
			if ((NextResource != 0) && (NextResource != 1))
				{
				msgbox("Error to far! G-java has extracted too many paths!",0);
				return false;
				}

			if (NextResource == 1)
				{
				// This is valid so get all the data
				strResourceTitle = popStr();

				// remember old name
				Oldname = Oldname + strResourceTitle;

				// remove invalid characters from name:
				strResourceTitle = remove_invalid(strResourceTitle);

				// add snd_if not already
				if (strResourceTitle.indexOf("pth_") != 1) strResourceTitle = "pth_" + strResourceTitle;

				// remember new name
				Newname = Newname + strResourceTitle;

				print(Basicgame," ");
				print(Basicgame,"class " + strResourceTitle + " extends Path {");
				print(Basicgame," ");
				print(Basicgame,strResourceTitle + "(int size) {");
				print(Basicgame,"super(size);");
				print(Basicgame,"}");
				print(Basicgame," ");
				print(Basicgame,"public void setup_path() {");

				empty = pop();
				print(Basicgame," connection_kind = " + pop() + ";");
				print(Basicgame," closed = " + pop() + ";");
				print(Basicgame," precision = " + pop() + ";");

				empty = pop(); // Room Index to show as Background (-1dec for none)
				empty = pop(); // Snap X
				empty = pop(); // Snap Y
				int points = pop(); // How many Points there are
				print(Basicgame," points = " + points + ";");
				for (int i2 = 0; i2 < points; i2++)
					{
					print(Basicgame,"x.add(" + i2 + "," + popD() + ");");
					print(Basicgame,"y.add(" + i2 + "," + popD() + ");");
					print(Basicgame,"speed.add(" + i2 + "," + popD() + ");");

					}
				print(Basicgame,"}");
				print(Basicgame,"}");
				ResourceCreate = ResourceCreate + "paths[" + i + "] = new " + strResourceTitle + "(" + points
						+ ");\n";

				}

			}
		initres = initres + "public static Path[] paths = new Path[" + sNumber + 1 + "];\n";
		ResourceCreate = ResourceCreate + "}\n";
		return true;
		}

	private static boolean extractRooms() throws IOException
		{
		// Room ResouceHeader
		empty = pop();
		int sNumber = pop();

		for (int i = 0; i < sNumber; i++)
			{
			NextResource = pop();
			if ((NextResource != 0) && (NextResource != 1))
				{
				msgbox("Error to far! G-java has extracted too many rooms!",0);
				return false;
				}

			if (NextResource == 1)
				{
				// This is valid so get all the data
				strResourceTitle = popStr();

				prog.setString(strResourceTitle + " is being converted...");

				// remember old name
				Oldname = Oldname + strResourceTitle;

				// remove invalid characters from name:
				strResourceTitle = remove_invalid(strResourceTitle);

				// add rm_if not already
				if (strResourceTitle.indexOf("rm_") != 0) strResourceTitle = "rm_" + strResourceTitle;

				// remember new name
				Newname = Newname + strResourceTitle;
				roomNames.setSize(i + 1);
				roomNames.add(i,strResourceTitle);

				empty = pop();
				String room_caption = popStr(); // The caption

				print(Basicgame,"class " + strResourceTitle
						+ " extends RoomPanel implements KeyListener,MouseListener {");
				print(Basicgame,"");
				print(Basicgame," public Objects o;");
				print(Basicgame,"public int roomsetup=0;");
				print(Basicgame," private int ii, dd;");
				print(Basicgame," JFrame R;");
				print(Basicgame,"public static   Vector backgrounds = new Vector();");

				print(Basicgame,strResourceTitle + " (JFrame R, int id,int roomid) {");

				int Width = pop();
				int Height = pop();
				int SnapY = pop();
				int SnapX = pop();
				int GridType = pop();
				int Speed = pop();
				int Persistent = pop();

				int red = popBasInt();
				int green = popBasInt();
				int blue = popBasInt();

				popB();
				int DrawBackroundColor = pop();
				if (DrawBackroundColor == 1)
					print(Basicgame,"super(R, \"" + room_caption + "\", " + Speed + ", " + Width + ", " + Height
							+ ", new Color(" + red + "," + green + "," + blue + "));");
				else
					print(Basicgame,"super(R, \"" + room_caption + "\", " + Speed + ", " + Width + ", " + Height
							+ ", Color.black);");

				print(Basicgame,"this.R = R;");
				print(Basicgame,"this.id = id;");
				print(Basicgame,"this.roomid = roomid;");
				print(Basicgame,"if (basicgame.Runningas != \"EApplet\") {");
				print(Basicgame,"R.addKeyListener(this);");
				print(Basicgame,"R.addMouseListener(this);");
				print(Basicgame,"} else {");
				print(Basicgame,"basicgame.Eapplet.addKeyListener(this);");
				print(Basicgame,"basicgame.Eapplet.addMouseListener(this);");
				print(Basicgame,"}");
				print(Basicgame,"}");

				String creation_code = popStr();

				print(Basicgame,"public void setup_Room() {");

				empty = pop();

				for (int subi = 0; subi < empty; subi++)
					{
					int VisibleWhenRoomStarts = pop();
					print(Basicgame,"visible[" + subi + "] = " + VisibleWhenRoomStarts + ";");
					int ForeGroundImageChecked = pop();
					int Image = pop();
					print(Basicgame,"Rbackgrounds[" + subi + "] = " + Image + ";");
					int Xpos = pop();
					print(Basicgame,"Xpos[" + subi + "] = " + Xpos + ";");
					int Ypos = pop();
					print(Basicgame,"Ypos[" + subi + "] = " + Ypos + ";");
					int TileH = pop();
					print(Basicgame,"TileH[" + subi + "] = " + TileH + ";");
					int TileV = pop();
					print(Basicgame,"TileV[" + subi + "] = " + TileV + ";");
					int HSpeed = pop();
					print(Basicgame,"hspeed[" + subi + "] = " + HSpeed + ";");
					int VSpeed = pop();
					print(Basicgame,"vspeed[" + subi + "] = " + VSpeed + ";");
					int Stretch = pop();
					}

				pop();
				empty = pop();
				for (int subi = 0; subi < empty; subi++)
					{
					// TODO java code of views
					int VisibleWhenRoomStarts = pop();
					int ViewX = pop();
					int ViewY = pop();
					int ViewW = pop();
					int ViewH = pop();
					int PortX = pop();
					int PortY = pop();
					int PortW = pop();
					int PortH = pop();
					int Hbor = pop();
					int Vbor = pop();
					int Hsp = pop();
					int Vsp = pop();
					int FollowObject = pop();

					}

				int instances = pop();
				print(Basicgame,"instances = new Vector(" + instances + ");");
				for (int subi = 0; subi < instances; subi++)
					{

					int X = pop();
					int Y = pop();
					int object = pop();
					int id = pop();
					String creationcode = popStr();
					int Locked = pop();
					print(Basicgame,"instances.add(0, basicgame.load_Objects(" + object + "," + X + "," + Y + "," + id
							+ "));");
					}

				print(Basicgame,"instances.trimToSize();");
				print(Basicgame,"roomsetup = 1;");

				int tiles = pop();

				for (int subi = 0; subi < tiles; subi++)
					{
					int X = pop();
					int Y = pop();
					int tileset = pop();
					int tileX = pop();
					int tileY = pop();
					int tileW = pop();
					int tileH = pop();
					int layer = pop();
					int id = pop();
					pop(); //Locked is not needed for g-java
					print(Basicgame,"depth.add(0, new tile(" + X + "," + Y + "," + tileX + "," + tileY + "," + tileW + "," + tileH + "," + layer + "," + id + "," + tileset + "));");
					}
				print(Basicgame,"SortDepth();");
				pop(); // Remember the Room Editor size (true/false)
				pop(); // Room Editor Width
				pop(); // Room Editor Height
				pop();
				pop();
				pop();
				pop();
				pop();
				pop();
				pop();
				pop();
				pop();
				pop();
				pop();
				// close setup room
				print(Basicgame,"}");
				print(Basicgame,"public synchronized void keyPressed(KeyEvent evt) {");
				print(Basicgame,"    int keycode = evt.getKeyCode();");

				print(Basicgame,"    // call key press events");
				if (LetF1ShowGameInformation == 1)
					{
					print(Basicgame,"    if (keycode == 112) {");
					print(Basicgame,"        Game_Information mainFrame  = new Game_Information();");
					print(Basicgame,"        mainFrame.setVisible( true );");
					print(Basicgame,"    }");
					}
				print(Basicgame,"ii = 0;");
				print(Basicgame,"while (ii < (instances.size())) {");
				print(Basicgame,"");
				print(Basicgame,"Objects o = (Objects)instances.get(ii);");
				print(Basicgame,"");
				print(Basicgame,"o.Key_Pressed(keycode);");
				print(Basicgame,"ii++;");
				print(Basicgame,"}");
				print(Basicgame,"}");
				print(Basicgame,"");
				print(Basicgame,"public synchronized void keyReleased(KeyEvent evt) {");
				print(Basicgame,"    int keycode = evt.getKeyCode();");
				print(Basicgame,"    // call key Released events");
				print(Basicgame,"ii = 0;");
				print(Basicgame,"while (ii < (instances.size())) {");
				print(Basicgame,"");
				print(Basicgame,"Objects o = (Objects)instances.get(ii);");
				print(Basicgame,"");
				print(Basicgame,"o.Key_Released(keycode);");
				print(Basicgame,"ii++;");
				print(Basicgame,"}");
				print(Basicgame,"}");
				print(Basicgame,"");
				print(Basicgame,"public synchronized void keyTyped(KeyEvent evt) {");
				print(Basicgame,"}");

				print(Basicgame,"   public void mouseClicked(MouseEvent evt) {");
				print(Basicgame,"");
				print(Basicgame,"  }");
				print(Basicgame," public void mouseEntered(MouseEvent evt) {");
				print(Basicgame,"// called when the pointer enters the room's rectangular area");
				print(Basicgame,"     }");
				print(Basicgame,"");
				print(Basicgame,"public void mouseExited(MouseEvent evt) {");
				print(Basicgame,"// called when the pointer leaves the room's rectangular area");
				print(Basicgame,"}");
				print(Basicgame,"");
				print(Basicgame,"public void mousePressed(MouseEvent evt) {");
				print(Basicgame,"");
				print(Basicgame,"    int keycode = evt.getButton();");
				print(Basicgame,"    // call mouse press events");
				print(Basicgame,"ii = 0;");
				print(Basicgame,"while (ii < (instances.size())) {");
				print(Basicgame,"");
				print(Basicgame,"Objects o = (Objects)instances.get(ii);");
				print(Basicgame,"");
				print(Basicgame,"o.mouse_Pressed(keycode,evt.getX(),evt.getY());");
				print(Basicgame,"ii++;");
				print(Basicgame,"}");

				print(Basicgame,"}");
				print(Basicgame,"");
				print(Basicgame,"public void mouseReleased(MouseEvent evt) {");
				print(Basicgame,"");
				print(Basicgame,"}");

				print(Basicgame,"public  void paint(Graphics g) {");
				print(Basicgame,"// The main game loop    ");
				print(Basicgame,"");
				print(Basicgame,"Font f = new Font(\"Arial Narrow\",Font.PLAIN,16);");
				print(Basicgame,"g.setFont(f);");
				print(Basicgame,"// Clear the drawing buffer to the background color");
				print(Basicgame,"g.setColor( backcolor );");
				print(Basicgame,"g.fillRect( 0, 0, ScreenWidth, ScreenHeight );");
				print(Basicgame,"");
				print(Basicgame,"// draw backgrounds");

				// TODO background code
				print(Basicgame,"for (int subi = 0; subi<8;subi++)");
				print(Basicgame,"if ((Rbackgrounds[subi] != -1)&&(visible[subi] == 1))");
				print(Basicgame,"{");
				print(Basicgame,"if ((TileH[subi] == 0) && (TileV[subi] == 0))");
				print(Basicgame,"	{");
				print(
						Basicgame,
						" g.drawImage(basicgame.background[Rbackgrounds[subi]].show(),Xpos[subi],Ypos[subi],basicgame.background[Rbackgrounds[subi]].back_width,basicgame.background[Rbackgrounds[subi]].back_height,this);");
				print(Basicgame," }");
				print(Basicgame,"else");
				print(Basicgame," {");
				print(Basicgame,"do");
				print(Basicgame,"{");
				print(Basicgame," if ((Xpos[subi]-basicgame.background[Rbackgrounds[subi]].back_width)>0)");
				print(Basicgame," Xpos[subi]-=basicgame.background[Rbackgrounds[subi]].back_width;");
				print(Basicgame," } while ((Xpos[subi]-basicgame.background[Rbackgrounds[subi]].back_width)>0);");
				print(Basicgame," do");
				print(Basicgame,"{");
				print(Basicgame,"if ((Ypos[subi]-basicgame.background[Rbackgrounds[subi]].back_height)>0)");
				print(Basicgame,"Ypos[subi]-=basicgame.background[Rbackgrounds[subi]].back_height;");
				print(Basicgame,"} while ((Ypos[subi]-basicgame.background[Rbackgrounds[subi]].back_height)>0);");
				print(Basicgame,"  ");
				print(Basicgame,"if (basicgame.Runningas != \"EApplet\") {");
				print(Basicgame,
						" NumberX = 1 + ((int)R.getWidth()+Xpos[subi])/ basicgame.background[Rbackgrounds[subi]].back_width;");
				print(Basicgame,
						" NumberY = 1 + ((int)R.getHeight()+Ypos[subi]) / basicgame.background[Rbackgrounds[subi]].back_height;");
				print(Basicgame,"} else {");
				print(
						Basicgame,
						" NumberX = 1 + ((int)basicgame.Eapplet.getWidth()+Xpos[subi])/ basicgame.background[Rbackgrounds[subi]].back_width;");
				print(
						Basicgame,
						" NumberY = 1 + ((int)basicgame.Eapplet.getHeight()+Ypos[subi]) / basicgame.background[Rbackgrounds[subi]].back_height;");
				print(Basicgame,"}");
				print(Basicgame,"  ");
				print(Basicgame,"if (TileH[subi] == 1) { ");
				print(Basicgame,"");
				print(
						Basicgame,
						"Image row = createImage(ScreenWidth+basicgame.background[Rbackgrounds[subi]].back_width,basicgame.background[Rbackgrounds[subi]].back_height);");
				print(Basicgame,"Graphics rowg = row.getGraphics();");
				print(Basicgame,"for (int j = 0;j <= NumberX; j++) {");
				print(
						Basicgame,
						"rowg.drawImage(basicgame.background[Rbackgrounds[subi]].show(),j*basicgame.background[Rbackgrounds[subi]].back_width,0,basicgame.background[Rbackgrounds[subi]].back_width,basicgame.background[Rbackgrounds[subi]].back_height,this);");
				print(Basicgame,"}");
				print(Basicgame,"if (TileV[subi] == 0) {");
				print(
						Basicgame,
						"g.drawImage(row,Xpos[subi]-basicgame.background[Rbackgrounds[subi]].back_width,Ypos[subi],row.getWidth(null),row.getHeight(null),this);");
				print(Basicgame,"} else {");
				print(Basicgame,"");
				print(Basicgame,"for (int i = 0;i <= NumberY; i++)");
				print(Basicgame,"{");
				print(
						Basicgame,
						"g.drawImage(row,Xpos[subi],i*basicgame.background[Rbackgrounds[subi]].back_height + Ypos[subi],ScreenWidth+basicgame.background[Rbackgrounds[subi]].back_width,basicgame.background[Rbackgrounds[subi]].back_height,this);");
				print(Basicgame,"}");
				print(Basicgame,"}");
				print(Basicgame," } else if  (TileV[subi] == 1)  {");
				print(Basicgame,"for (int i = 0;i <= NumberY; i++)");
				print(Basicgame,"{");
				print(
						Basicgame,
						"g.drawImage(basicgame.background[Rbackgrounds[subi]].show(),Xpos[subi],i*basicgame.background[Rbackgrounds[subi]].back_height + Ypos[subi],basicgame.background[Rbackgrounds[subi]].back_width,basicgame.background[Rbackgrounds[subi]].back_height,this);");
				print(Basicgame,"}");
				print(Basicgame,"}");
				print(Basicgame," }");
				print(Basicgame,"}");

				// instances
				print(Basicgame,"");
				print(Basicgame,"dd = 0;");
				print(Basicgame,"while (dd < instances.size()) {");
				print(Basicgame,"this.instance_id = dd;");
				print(Basicgame,"Objects o = (Objects)instances.get(dd);");
				print(Basicgame,"o.Begin_Step_event();");
				print(Basicgame,"if (o.G_JAVA_timeline != null)");
				print(Basicgame,"o.G_JAVA_timeline.runTimeline();");
				print(Basicgame,"o.Alarm();");
				print(Basicgame,"o.Keyboard_event();");
				print(Basicgame,"o.Step();");
				print(
						Basicgame,
						"if((o.X <= -1) || (o.X >= basicgame.Current_room.Width+1) || (o.Y <= -1) || (o.Y >= basicgame.Current_room.Height+1)) {");
				print(Basicgame,"    o.Outside();");
				print(Basicgame,"}");
				if (end_animation_event == true)
					{
					print(Basicgame,"if (o.G_JAVA_Object_sprite != null) {");
					print(Basicgame,"if (o.csubimage == o.G_JAVA_Object_sprite.subimages)");
					print(Basicgame,"o.End_animation();");
					print(Basicgame,"}");
					}
				print(Basicgame,"o.Move();");
				print(Basicgame,"o.Collision_event();");
				print(Basicgame,"o.End_Step_event();");
				print(Basicgame,"// decrease the alarms");
				print(Basicgame,"o.decrease_alarms();");
				print(Basicgame," dd = this.instance_id;");
				print(Basicgame,"dd++;");
				print(Basicgame,"}");

				// draw everything
				print(Basicgame,"dd = 0;");
				print(Basicgame,"while (dd < depth.size() ) {");
				print(Basicgame,"tile t = (tile)depth.get(dd);");
				print(Basicgame,"t.Draw_event(g);");
				print(Basicgame,"dd++;");
				print(Basicgame,"}");
				print(Basicgame,"dd = 0;");

				print(Basicgame,"");
				print(Basicgame,"");
				print(Basicgame,"}");
				print(Basicgame,"}");
				}

			}

		print(Global_java,"public static double instance_id = " + pop() + ";\n public static double tile_id = "
				+ pop() + ";\n");

		return true;
		}

	private static boolean extractGameInformation() throws IOException
		{
		pop();
		print(Gamesettings,"public static Color Gameinfoback = new Color(" + popB() + " ," + popB() + " ,"
				+ popB() + ");");
		popB();
		pop(); // "Mimic the main game window"
		String Caption = popStr();
		pop();
		pop();
		pop();
		pop();
		pop();
		pop();
		pop();
		pop(); // "Stop the game while showing help"

		FileWriter GameInfoFW = new FileWriter(GJava.FileFolder + File.separator + "gjava" + File.separator
				+ "runner" + File.separator + "gameinformation.rtf");
		BufferedWriter Gameinfo = new BufferedWriter(GameInfoFW);
		String rtftext = popStr();
		print(Gameinfo,"" + rtftext);
		Gameinfo.close();
		// lib vars
		pop();
		int nooflibs = pop();
		// msgbox(""+nooflibs,0);
		for (int subi = 0; subi < nooflibs; subi++)
			popStr();
		pop();
		// pop();

		// room indexes in tree order
		String roomstr = "", eroomstr = "", firstroom = "", lastroom = "", currentroom, roomarray = "public static int getroom[]= {";
		int rooms = pop();
		for (int subi = 0; subi < rooms; subi++)
			{
			roomstr = roomstr + "    if (roomid ==  " + subi + ") {\n\n";
			eroomstr = eroomstr + "    if (roomid ==  " + subi + ") {\n\n";
			int roomno = pop();
			currentroom = "" + roomno;

			roomstr = roomstr + "rooms[" + currentroom + "] = new " + roomNames.elementAt(roomno) + "(Room,"
					+ currentroom + ",roomid);\n basicgame.Current_room = rooms[" + currentroom
					+ "];\n Room.setSize(rooms[" + currentroom + "].Width,rooms[" + currentroom
					+ "].Height);\n Room.getContentPane().add( rooms[" + currentroom + "]);\n Room.validate();\n }";
			eroomstr = eroomstr + "rooms[" + currentroom + "] = new " + roomNames.elementAt(roomno) + "(Room,"
					+ currentroom + ",roomid);\n basicgame.Current_room = rooms[" + currentroom
					+ "];\n maingamep.getContentPane().add( rooms[" + currentroom + "]);\n }";

			if (subi == 0)
				{
				firstroom = "" + roomno;
				if (subi == rooms - 1) lastroom = "" + roomno;
				roomarray = roomarray + firstroom;

				}
			else if (subi == rooms - 1)
				{
				lastroom = "" + roomno;
				roomarray = roomarray + "," + lastroom;
				}
			else
				{
				roomarray = roomarray + "," + currentroom;

				}
			}

		// write load_rooms
		print(Basicgame,"");
		print(Basicgame,"class load_Rooms {");
		print(Basicgame,"public static JFrame Room;");
		print(Basicgame,"public static int firstroom = " + firstroom + "; ");
		print(Basicgame,"public static int lastroom = " + lastroom + "; ");
		print(Basicgame,"public static JApplet maingamep;");
		print(Basicgame,"public static RoomPanel[] rooms = new RoomPanel[" + rooms + "];");
		print(Basicgame,"public static int roomid;");
		print(Basicgame,"public static Image GIcon;");
		print(Basicgame,roomarray + "};");
		print(Basicgame,"");
		print(Basicgame,"load_Rooms(int roomid) {");
		print(Basicgame,"    JFrame room = new Room(332,92,true, Color.black);");
		print(Basicgame,"if (basicgame.Runningas == \"Application\") {");

		print(Basicgame,"    StartPanel.loadingframe.dispose();");
		print(Basicgame,"}");
		print(Basicgame,"//GIcon = new ImageIcon(getClass().getResource(\"icon.png\") ).getImage();");
		print(Basicgame,"//room.setIconImage(GIcon);");
		print(Basicgame,"");
		print(Basicgame,"    room.setVisible(true);");
		print(Basicgame,"    this.Room = room;");
		print(Basicgame,"    this.roomid = roomid;");
		print(Basicgame,"    change_room(roomid);");
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"load_Rooms(int roomid,JApplet maingamep) {");
		print(Basicgame,"//it is embedded");
		print(Basicgame,"this.maingamep = maingamep;");
		print(Basicgame,"change_room(roomid,maingamep);");
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"public static boolean if_prev_room(int roomid) {");
		print(Basicgame,"if (roomid == firstroom) { return false; } else { return true; }");
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"public static boolean if_next_room(int roomid) {");
		print(Basicgame,"if (roomid == lastroom) { return false; } else { return true; }");
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"public static void prev_room(int roomid,JApplet maingamep) {");
		print(Basicgame,"        int gjavai = 0;");
		print(Basicgame,"        while (gjavai < getroom.length) {");
		print(Basicgame,
				"        if (getroom[gjavai] == roomid) { change_room(getroom[gjavai-1],maingamep); } gjavai++;");
		print(Basicgame,"    }");
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"public static void prev_room(int roomid) {");
		print(Basicgame,"        int gjavai = 0;");
		print(Basicgame,"        while (gjavai < getroom.length) {");
		print(Basicgame,"        if (getroom[gjavai] == roomid) { change_room(getroom[gjavai-1]); } gjavai++;");
		print(Basicgame,"    }");
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"public static void restart_room(int roomid,JApplet maingamep) {");
		print(Basicgame,"int locali = basicgame.Current_room.roomid;");
		print(Basicgame,"        remove_room(basicgame.Current_room.id);");
		print(Basicgame,"        change_room(locali,maingamep);");
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"public static void restart_room(int roomid) {");
		print(Basicgame,"int locali = basicgame.Current_room.roomid;");
		print(Basicgame,"        remove_room(basicgame.Current_room.id);");
		print(Basicgame,"        change_room(locali);");
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"public static void next_room(int roomid,JApplet maingamep) {");
		print(Basicgame,"        int gjavai = 0;");
		print(Basicgame,"        while (gjavai < getroom.length) {");
		print(Basicgame,
				"        if (getroom[gjavai] == roomid) { change_room(getroom[gjavai+1],maingamep); } gjavai++;");
		print(Basicgame,"    }");
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"public static void next_room(int roomid) {");
		print(Basicgame,"        int gjavai = 0;");
		print(Basicgame,"        while (gjavai < getroom.length) {");
		print(Basicgame,"        if (getroom[gjavai] == roomid) { change_room(getroom[gjavai+1]); } gjavai++;");
		print(Basicgame,"    }");
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"public static void change_room(int roomid,JApplet maingamep) {");
		print(Basicgame,eroomstr);
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"");
		print(Basicgame,"");
		print(Basicgame,"public static void remove_room(int roomid) {");
		print(Basicgame,"basicgame.close_sounds();");
		print(Basicgame,"if (basicgame.Runningas != \"EApplet\") {");
		print(Basicgame,"Room.removeKeyListener((KeyListener)rooms[roomid]);");
		print(Basicgame,"Room.removeMouseListener((MouseListener)rooms[roomid]);");
		print(Basicgame,"Room.remove(rooms[roomid]);");
		print(Basicgame,"} else {");
		print(Basicgame,"  // remove from embeded applet");
		print(Basicgame,"maingamep.removeKeyListener((KeyListener)rooms[roomid]);");
		print(Basicgame,"maingamep.removeMouseListener((MouseListener)rooms[roomid]);");
		print(Basicgame,"maingamep.remove(rooms[roomid]);");
		print(Basicgame,"}");
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"public static void change_room(int roomid) {");
		print(Basicgame,roomstr);
		print(Basicgame,"");
		print(Basicgame,"");
		print(Basicgame,"}");
		print(Basicgame,"");
		print(Basicgame,"");
		print(Basicgame,"}");

		return true;
		}

	private static boolean extractScripts() throws IOException
		{
		// Script ResouceHeader
		empty = pop();
		int sNumber = pop();

		print(Basicgame," ");
		print(Basicgame,"class Scripts {");
		print(Basicgame," public static Global global = new Global();");
		
		gjava.parser.gmltojavaParser.addwriter(Basicgame);

		for (int i = 0; i < sNumber; i++)
			{
			NextResource = pop();
			if ((NextResource != 0) && (NextResource != 1))
				{
				msgbox("Error to far! G-java has extracted too many scripts!",0);
				return false;
				}

			if (NextResource == 1)
				{
				// This is valid so get all the data
				strResourceTitle = popStr();

				// remember old name
				Oldname = Oldname + strResourceTitle;

				// remove invalid characters from name:
				strResourceTitle = remove_invalid(strResourceTitle);

				// add scr_if not already
				if (strResourceTitle.indexOf("scr_") != 0) strResourceTitle = "scr_" + strResourceTitle;

				// remember new name
				Newname = Newname + strResourceTitle;
				
				scriptNames.setSize(i+1);
				scriptNames.add(i,strResourceTitle);
				
				print(Basicgame,"public static void " + strResourceTitle + "(String arguments[]) {");

				empty = pop();
				
				try
					{
					gjava.parser.gmltojavaParser.parsecode(popStr());
					}
				catch (Exception e)
					{
					e.printStackTrace();
					}
				print(Basicgame,"}");
				}

			}
		print(Basicgame,"}");
		return true;
		}

	private static boolean extractSounds() throws IOException,DataFormatException
		{
		// Sounds ResouceHeader
		ResourceCreate = "public static void load_Sounds() {\n";
		ResourceCreate = ResourceCreate + "//load all the Sounds here \n";
		String close_sounds;
		close_sounds = " public static void close_sounds() {\n";
		empty = pop();
		int sNumber = pop();
		if (sNumber < 0) msgbox("Error: This file seems to be corrupt number of sounds <0!",1);

		for (int i = 0; i < sNumber; i++)
			{
			NextResource = pop();
			if ((NextResource != 0) && (NextResource != 1))
				{
				msgbox("Error to far! G-java has extracted too many sounds!",0);
				return false;
				}

			if (NextResource == 1)
				{
				// This is a valid sound so get all the data
				strResourceTitle = popStr();

				// remember old name
				Oldname = Oldname + strResourceTitle;

				// remove invalid characters from name:
				strResourceTitle = remove_invalid(strResourceTitle);

				// add snd_if not already
				if (strResourceTitle.indexOf("snd_") != 1) strResourceTitle = "snd_" + strResourceTitle;

				// remember new name
				Newname = Newname + strResourceTitle;

				empty = pop();
				empty = pop(); // SoundKind (not really needed)

				String extension = popStr();
				if (extension == ".mp3")
					msgbox("Please convert the mp3 " + strResourceTitle + " to .wav (hopefully a compressed wav)",1);

				popStr(); // strResFilename
				empty = pop();

				if (empty == 1)
					getZlib(GJava.FileFolder + "gjava" + File.separator + "runner" + File.separator + strResourceTitle
							+ extension);

				ResourceCreate = ResourceCreate + "sound[" + i + "] = new sound(\"" + strResourceTitle + extension
						+ "\"," + pop() + "," + popD() + "," + popD() + "," + pop() + ");\n";
				close_sounds = close_sounds + "sound[" + i + "].stop();\n";

				}

			}
		try
			{
			print(Basicgame,"}");
			}
		catch (IOException e)
			{
			// TODO Auto-generated catch block
			e.printStackTrace();
			}
		initres = "public static sound[] sound = new sound[" + sNumber + 1 + "];\n";
		ResourceCreate = ResourceCreate + "}\n\n" + close_sounds + "\n}\n\n";
		return true;
		}

	private static boolean extractTimelines() throws IOException
		{
		ResourceCreate = ResourceCreate + "public static void load_Timelines() {\n";
		ResourceCreate = ResourceCreate + "//load all the timelines here \n";
		// Timelines ResouceHeader
		empty = pop();
		int sNumber = pop();

		for (int i = 0; i < sNumber; i++)
			{
			NextResource = pop();
			if ((NextResource != 0) && (NextResource != 1))
				{
				msgbox("Error to far! G-java has extracted too many timelines!",0);
				return false;
				}

			if (NextResource == 1)
				{
				// This is valid so get all the data
				strResourceTitle = popStr();

				// remember old name
				Oldname = Oldname + strResourceTitle;

				// remove invalid characters from name:
				strResourceTitle = remove_invalid(strResourceTitle);

				// add tml_if not already
				if (strResourceTitle.indexOf("tml_") != 0) strResourceTitle = "tml_" + strResourceTitle;

				// remember new name
				Newname = Newname + strResourceTitle;

				ResourceCreate = ResourceCreate + "timelines[" + i + "] = new " + strResourceTitle + "();\n";

				print(Basicgame," ");
				print(Basicgame,"class " + strResourceTitle + " extends Timeline {");
				print(Basicgame," ");
				print(Basicgame,"public void runTimeline() {");

				empty = pop();
				int moments = pop(); // How many Moments there are
				print(Basicgame," if (step <= " + moments + ")");
				print(Basicgame,"{");
				int noofactions;
				for (int i2 = 0; i2 < moments; i2++)
					{
					empty = pop(); // Postion
					print(Basicgame,"if (step == " + empty + ")");
					print(Basicgame,"{");
					pop();
					noofactions = pop();
					for (int i3 = 0; i3 < noofactions; i3++)
						extractActions();

					print(Basicgame,"}");
					}
				print(Basicgame,"step++;");
				print(Basicgame,"}");
				print(Basicgame,"}");
				print(Basicgame,"}");
				print(Basicgame," ");
				}

			}
		initres = initres + "public static Timeline[] timelines = new Timeline[" + sNumber + 1 + "];\n";
		ResourceCreate = ResourceCreate + "}\n";
		return true;
		}

	private static void finishBasicgame()
		{
		readReplace(GJava.FileFolder + File.separator + "gjava" + File.separator + "runner" + File.separator
				+ "basicgame.java","//  G-java replace with res \\*\\*101\\*\\*",initres + "\n\n");
		readReplace(GJava.FileFolder + File.separator + "gjava" + File.separator + "runner" + File.separator
				+ "basicgame.java","// Replace with ResourceCreate",ResourceCreate + "\n\n");

		}

	// end gm6 class

	private static void getIcon()
		{
		// get the icon image
		int length = pop();
		if (length == -1) return;

		try
			{
			byte[] b = new byte[length];
			// now read the bytes
			gm6file.f.readFully(b);
			// Write the file
			FileOutputStream file = new FileOutputStream(GJava.FileFolder + "game.ico");
			file.write(b);
			file.close();
			}
		catch (Exception e)
			{
			System.out.println(e.toString());
			}
		}

	// Get zlib and uncompress it
	private static void getZlib(String filename) throws IOException,DataFormatException
		{
		int length = pop();

		byte[] b = new byte[length];
		gm6file.f.readFully(b);

		Inflater decompresser = new Inflater();
		decompresser.setInput(b);
		byte[] buffer = new byte[5000];
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		while (!decompresser.finished())
			{
			int len = decompresser.inflate(buffer);
			baos.write(buffer,0,len);
			}
		decompresser.end();

		FileOutputStream file = new FileOutputStream(filename);
		file.write(baos.toByteArray());
		file.close();

		}

	public static void msgbox(String message,int icon)
		{
		JOptionPane.showMessageDialog(null,message,"G-java",icon);
		}

	// Retrieve a 4 Byte int from file
	private static int pop()
		{
		try
			{
			return gm6file.readInt();
			}
		catch (Exception e)
			{
			return 0;
			}
		}

	// Retrieve a 2 Byte short from file
	private static short pop(int notneeded)
		{
		try
			{
			return gm6file.readShort();
			}
		catch (Exception e)
			{
			return 0;
			}
		}

	// Retrieve a Byte from file
	private static byte popB()
		{
		try
			{
			byte b = gm6file.readByte();
			return b;
			}
		catch (Exception e)
			{
			return 0;
			}
		}

	// Retrieve a Byte from file and return as int
	private static int popBasInt()
		{
		try
			{
			int b = gm6file.readByte();
			if (b < 0) b = 256 + b;
			return b;
			}
		catch (Exception e)
			{
			return -2;
			}
		}

	// Retrieve a double from file
	private static double popD()
		{
		try
			{
			return gm6file.readDouble();
			}
		catch (Exception e)
			{
			return 0;
			}
		}

	// Retrieve a String from file
	private static String popStr()
		{
		try
			{
			return gm6file.readStr();
			}
		catch (Exception e)
			{
			return null;
			}
		}

	// Print a line to the bufferedwriter
	public static void print(BufferedWriter file,String printString) throws IOException
		{
		// printString.replaceAll("\n",""+(char)10);
		file.write(printString);
		file.newLine();
		}

	public static void readReplace(String fname,String oldPattern,String replPattern)
		{
		String line;
		StringBuffer sb = new StringBuffer();
		try
			{
			FileInputStream fis = new FileInputStream(fname);
			BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
			while ((line = reader.readLine()) != null)
				{
				line = line.replaceAll(oldPattern,replPattern);
				sb.append(line + "\n");
				}
			reader.close();
			BufferedWriter out = new BufferedWriter(new FileWriter(fname));
			out.write(sb.toString());
			out.close();
			fis.close();
			}
		catch (Throwable e)
			{
			System.err.println("*** exception in readReplace ***" + e.getMessage());
			}
		}

	public static String remove_invalid(String s)
		{
		s = s.replaceAll(" ","_");
		s = s.replaceAll("-","_");
		s = s.replaceAll("/","_");
		s = s.replaceAll("!","_");
		// s = s.replaceAll("*","_");
		// s = s.replaceAll("\\","_");
		if ((s.indexOf("0") == 0) || (s.indexOf("0") == 1) || (s.indexOf("0") == 2) || (s.indexOf("0") == 3)
				|| (s.indexOf("0") == 4) || (s.indexOf("0") == 5) || (s.indexOf("0") == 6) || (s.indexOf("0") == 7)
				|| (s.indexOf("0") == 8) || (s.indexOf("0") == 9)) s = "GJava__" + s;
		return s;
		}

	// Skip a number of Bytes (java int,GM long) And return the no of bytes skipped
	private static void skip(int numbertoskip)
		{
		try
			{
			gm6file.skip(numbertoskip);
			}
		catch (Exception e)
			{
			}
		}

	// create the main class called Basicgame DON'T REMOVE
	private static void writeBasicgame()
		{
		try
			{
			print(Basicgame,"public basicgame(URL u) {");
			print(Basicgame,"    // if it is an applet");
			print(Basicgame,"    this.Runningas = \"Applet\";");
			print(Basicgame," this.mouse = 30;");
			print(Basicgame,"");
			print(Basicgame,"    this.u = u;");
			print(Basicgame,"     // load Functions");
			print(Basicgame,"     Functions func = new Functions();");
			print(Basicgame,"     // create a new frame that will be the game window");
			print(Basicgame,"new load_Rooms(load_Rooms.firstroom);");
			print(Basicgame," }");

			print(Basicgame,"");
			print(Basicgame,"public basicgame(URL u, JApplet embed) {");
			print(Basicgame,"    // if it is an embedded applet");
			print(Basicgame,"    this.Runningas = \"EApplet\"; ");
			print(Basicgame," this.mouse = 0;");
			print(Basicgame,"    Eapplet = embed;");
			print(Basicgame,"    this.u = u;");
			print(Basicgame,"     // load Functions");
			print(Basicgame,"     Functions func = new Functions();");
			print(Basicgame,"");
			print(Basicgame,"new load_Rooms(load_Rooms.firstroom,embed);");
			print(Basicgame,"   ");
			print(Basicgame," }");

			print(Basicgame,"");
			print(Basicgame,"public basicgame() {");
			print(Basicgame,"");
			print(Basicgame,"    // if it is an application");
			print(Basicgame,"    this.Runningas = \"Application\";");
			print(Basicgame," this.mouse = 30;");
			print(Basicgame,"     // load Functions");
			print(Basicgame,"     Functions func = new Functions();");
			print(Basicgame,"   // create a new frame that will be the game window");
			print(Basicgame,"   JFrame f = new Room(332,92, false, gs.Outsidecolor);");
			print(Basicgame,"");
			print(Basicgame,"   // center the room onscreen");
			print(Basicgame,"   Room.center(f);");
			print(Basicgame,"");
			print(Basicgame,"   f.getContentPane().add(\"Center\",new StartPanel(f, gs.loading_image));");
			print(Basicgame,"   f.setVisible(true);");
			print(Basicgame,"}");
			print(Basicgame,"");
			print(Basicgame,"// Replace with ResourceCreate");
			// print(Basicgame,"}");
			}
		catch (IOException e)
			{
			// TODO Auto-generated catch block
			e.printStackTrace();
			}
		}

	private static boolean writeHeader()
		{
		FileWriter GMLFunctions_javaFW = null, GamesettingsFW = null, BasicgameFW = null, Global_javaFW = null, Filename_javaFW;
		try
			{
			GamesettingsFW = new FileWriter(GJava.FileFolder + "gjava" + File.separator + "runner"
					+ File.separator + "GameSettings.java");
			BasicgameFW = new FileWriter(GJava.FileFolder + "gjava" + File.separator + "runner"
					+ File.separator + "basicgame.java");
			Global_javaFW = new FileWriter(GJava.FileFolder + "gjava" + File.separator + "runner"
					+ File.separator + "Global.java");
			GMLFunctions_javaFW = new FileWriter(GJava.FileFolder + "gjava" + File.separator + "runner"
					+ File.separator + "GMLFunctions.java");
			Filename_javaFW = new FileWriter(GJava.FileFolder + GJava.sfilename + ".java");

			}
		catch (Exception e)
			{
			msgbox("Error opening output file. " + e.getMessage(),0);
			close();
			return false;
			}
		Gamesettings = new BufferedWriter(GamesettingsFW);
		Basicgame = new BufferedWriter(BasicgameFW);
		Global_java = new BufferedWriter(Global_javaFW);
		Filename_java = new BufferedWriter(Filename_javaFW);
		GMLFunctions_java = new BufferedWriter(GMLFunctions_javaFW);
		try
			{
			// Write Gamesettings header
			print(Gamesettings,"/*");
			print(Gamesettings," *  GameSettings.java");
			print(Gamesettings," *  Written by GM_guru (http://www.gm-school.com)");
			print(Gamesettings," *  Created using G-java (http://www.g-java.com)");
			print(Gamesettings," */");
			print(Gamesettings,"package gjava.runner;");
			print(Gamesettings,"import java.awt.*;");
			print(Gamesettings,"import javax.swing.*;");
			print(Gamesettings,"");
			print(Gamesettings,"public class GameSettings {");
			print(Gamesettings,"");
			print(Gamesettings,"     //caption settings");
			print(Gamesettings,
					"     public static boolean show_score = true, show_lives = false, show_health = false;");
			print(Gamesettings,"     //room captions");
			print(Gamesettings,"     public static String score_caption = \"score:\","
					+ "lives_caption = \"lives:\", health_caption = \"health:\";");
			print(Gamesettings,"");

			// Write Basicgame header
			print(Basicgame,"");
			print(Basicgame,"// basicgame.java");
			print(Basicgame,"// by GM_guru");
			print(Basicgame,"");
			print(Basicgame,"// import the required classes");
			print(Basicgame,"package gjava.runner;");
			print(Basicgame,"import java.awt.*;");
			print(Basicgame,"import java.awt.event.*;");
			print(Basicgame,"import javax.swing.*;");
			print(Basicgame,"import java.io.*;");
			print(Basicgame,"import java.util.*;");
			print(Basicgame,"import java.net.*;");
			print(Basicgame,"import java.applet.*;");
			print(Basicgame,"import java.lang.reflect.InvocationTargetException;");
			print(Basicgame,"");
			print(Basicgame,"");
			print(Basicgame,"");
			print(Basicgame,"// the main class");
			print(Basicgame,"public class basicgame {");
			print(Basicgame,"");
			print(Basicgame,"//The Game Settings");
			print(Basicgame,"GameSettings gs = new GameSettings();");
			print(Basicgame,"");
			print(Basicgame,"public static JFrame f;");
			print(Basicgame,"public static URL u;");
			print(Basicgame,"public static String Runningas;");
			print(Basicgame,"public static RoomPanel Current_room;");
			print(Basicgame,"public static JApplet Eapplet;");
			print(Basicgame,"public static int mouse;");
			print(Basicgame,"");
			print(Basicgame,"// Declare the reasources");
			print(Basicgame,"//  G-java replace with res **101**");
			writeBasicgame();

			// Write Global Header
			print(Global_java,"/////////////////////////////////");
			print(Global_java,"// Global.java by TGMG (http:\\www.g-java.com)");
			print(Global_java,"// written for g-java 1.08+");
			print(Global_java,"/////////////////////////////////");
			print(Global_java,"package gjava.runner;");
			print(Global_java,"public class Global {");
			print(Global_java,"    // all global variables here");
			
			//Write GMLFunctions Header
			print(GMLFunctions_java,"/////////////////////////////////");
			print(GMLFunctions_java,"// GMLFunctions.java by TGMG (http:\\www.g-java.com)");
			print(GMLFunctions_java,"// written for g-java 1.08+");
			print(GMLFunctions_java,"/////////////////////////////////");
			print(GMLFunctions_java,"package gjava.runner;");
			print(GMLFunctions_java,"public class GMLFunctions {");
			}
		catch (Exception e)
			{
			msgbox("Error writing to output file. " + e.getMessage(),0);
			closeJava();
			close();
			return false;
			}
		return true;
		}

	private static boolean writeSettings()
		{
		// Now write the data to the Gamesettings.java file
		String psi = "     public static int ";
		try
			{
			print(Gamesettings,psi + "GameId = " + pop() + ";");
			skip(20);
			print(Gamesettings,psi + "FullScreenMode = " + pop() + ";");
			print(Gamesettings,psi + "InterpolateColorsBetweenPixels = " + pop() + ";");
			print(Gamesettings,psi + "NoBorderWindowMode = " + pop() + ";");
			int DisplayCursor = pop();
			if ((DisplayCursor == 1) || (DisplayCursor == 0))
				print(Gamesettings,psi + "DisplayCursor = " + DisplayCursor + ";");
			else
				{
				msgbox(
						DisplayCursor
								+ " You are trying to open an example that came with GM. If you want to continue loading this file you will have to open it in GM and save as a different filename.",
						0);
				return false;
				}
			print(Gamesettings,psi + "FixedScalePercent = " + pop(1) + ";"); // short
			print(Gamesettings,psi + "AspectRatio = " + pop(1) + ";"); // short
			print(Gamesettings,psi + "AllowResizeGameWindow = " + pop() + ";");
			print(Gamesettings,psi + "GameWindowAlwaysonTop = " + pop() + ";");
			print(Gamesettings,"Color Outsidecolor = new Color (" + popB() + "," + popB() + "," + popB() + ");");
			popB();
			print(Gamesettings,psi + "SetResolutionofScreen = " + pop() + ";");
			print(Gamesettings,psi + "ColorDepth = " + pop() + ";");
			print(Gamesettings,psi + "Resoultion = " + pop() + ";");
			print(Gamesettings,psi + "Frequency = " + pop() + ";");
			print(Gamesettings,psi + "NoButtonsWindowCaption = " + pop() + ";");
			print(Gamesettings,psi + "UseSynchronization = " + pop() + ";");
			print(Gamesettings,psi + "LetF4SwitchBetweenGameModes = " + pop() + ";");
			LetF1ShowGameInformation = pop();
			print(Gamesettings,psi + "LetF1ShowGameInformation = " + LetF1ShowGameInformation + ";");
			print(Gamesettings,psi + "LetEscapeEndGame = " + pop() + ";");
			print(Gamesettings,psi + "LetF5F6SaveLoadGame = " + pop() + ";");
			print(Gamesettings,psi + "ProcessPriority = " + pop() + ";");
			print(Gamesettings,psi + "FreezeGame = " + pop() + ";");

			int ProgressBar = pop(); // 0 = none, 1 = default, 2 = custom

			if (ProgressBar == 2)
				{
				// Front Image
				byte ProgressBarBack = popB();
				ProgressBarBack = popB();
				ProgressBarBack = popB();
				ProgressBarBack = popB();
				if (ProgressBarBack != 255) getZlib(GJava.FileFolder + "ProgressFront.bmp");

				// back Image
				ProgressBarBack = popB();
				ProgressBarBack = popB();
				ProgressBarBack = popB();
				ProgressBarBack = popB();
				if (ProgressBarBack != 255) getZlib(GJava.FileFolder + "ProgressFront.bmp");
				}

			// ShowYourOwnImageWhileLoading
			int ShowYourOwnImageWhileLoading = pop();
			int ImagePartialTransperant = pop(); // Used Later, DON'T REMOVE
			if (ShowYourOwnImageWhileLoading != 0)
				{
				getZlib(GJava.FileFolder + "Loading.bmp");
				empty = pop();
				}

			print(Gamesettings,"  boolean loading_image = true;");

			print(Gamesettings,"//" + psi + "MakeTransAlphaValue = " + pop() + ";");
			print(Gamesettings,"//" + psi + "ScaleProgressBarImage = " + pop() + ";");

			// Get the icon
			getIcon();

			// Error messages tab (Not needed for G-java right now but useful to keep info)
			print(Gamesettings,"//" + psi + "DisplayErrorMessages = " + pop() + ";");
			print(Gamesettings,"//" + psi + "WriteErrorMessageToLog = " + pop() + ";");
			print(Gamesettings,"//" + psi + "AbortOnallErrorMessages = " + pop() + ";");
			print(Gamesettings,"//" + psi + "TreatUnintializedValuesZero = " + pop() + ";");

			// Info Tab
			print(Gamesettings,"public static String Author = \"" + popStr() + "\";");
			print(Gamesettings,"public static String Version = \"" + pop() + "\";");
			print(Gamesettings,"public static double DateTime = " + popD() + ";");
			print(Gamesettings,"public static String Information = \"" + popStr() + "\";");

			int NumberOfConstants = pop();
			print(Gamesettings,psi + "NumberOfConstants = " + NumberOfConstants + ";");
			if (NumberOfConstants != 0)
				{
				for (int i = 0; i < NumberOfConstants; i++)
					{
					print(Gamesettings,"public static String " + popStr() + " = \"" + popStr() + "\";");
					}
				}

			// Process Included files
			int NumberOfIncludeFiles = pop();
			for (int i = 0; i < NumberOfIncludeFiles; i++)
				{
				String IncludeName = popStr();
				// Copy file IncludeName still todo! DON'T REMOVE
				}
			// Print include settings
			print(Gamesettings,psi + " TemporaryFolder = " + pop() + ";");
			print(Gamesettings,psi + " OverWriteExistingFiles = " + pop() + ";");
			print(Gamesettings,psi + " RemoveAtGameEnd = " + pop() + ";");

			// Finish off
			print(Gamesettings,"public static boolean injar = true;");

			}
		catch (Exception e)
			{
			msgbox("Error writing to output file. " + e.getMessage(),0);
			return false;
			}
		return true;
		}
	}

class Transparency
	{
	public static BufferedImage makeColorTransparent(Image im,final Color color)
		{
		ImageFilter filter = new RGBImageFilter()
			{
				// the color we are looking for... Alpha bits are set to opaque
				public int markerRGB = color.getRGB() | 0xFF000000;

				public final int filterRGB(int x,int y,int rgb)
					{
					if ((rgb | 0xFF000000) == markerRGB)
						{
						// Mark the alpha bits as zero - transparent
						return 0x00FFFFFF & rgb;
						}
					else
						{
						// nothing to do
						return rgb;
						}
					}
			};
		ImageProducer ip = new FilteredImageSource(im.getSource(),filter);
		return createBufferedImage(Toolkit.getDefaultToolkit().createImage(ip));
		}

	private static BufferedImage createBufferedImage(Image image)
		{
		BufferedImage bi = new BufferedImage(image.getWidth(null),image.getHeight(null),
				BufferedImage.TYPE_INT_ARGB);
		Graphics2D g = bi.createGraphics();
		g.drawImage(image,0,0,null);

		return bi;
		}
	
	
	}