/*
 * Decompiled with CFR 0.152.
 */
package net.iharder.dnd;

import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import net.iharder.dnd.FileDrop;
import net.iharder.dnd.FileDropEvent;
import net.iharder.dnd.FileDropListener;

public class FileDropBean
implements Serializable {
    private EventListenerList listenerList = new EventListenerList();

    public void addFileDropTarget(Component comp) {
        FileDrop.Listener listener = new FileDrop.Listener(){

            public void filesDropped(File[] files) {
                FileDropBean.this.fireFileDropHappened(files);
            }
        };
        boolean recursive = true;
        new FileDrop(comp, recursive, listener);
    }

    public boolean removeFileDropTarget(Component comp) {
        return FileDrop.remove(comp);
    }

    public void addFileDropListener(FileDropListener listener) {
        this.listenerList.add(FileDropListener.class, listener);
    }

    public void removeFileDropListener(FileDropListener listener) {
        this.listenerList.remove(FileDropListener.class, listener);
    }

    protected void fireFileDropHappened(File[] files) {
        FileDropEvent evt = new FileDropEvent(files, this);
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != FileDropListener.class) continue;
            ((FileDropListener)listeners[i + 1]).filesDropped(evt);
        }
    }
}

