/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.autocomplete;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.gcreator.autocomplete.AutocompleteFrame;
import org.gcreator.autocomplete.impl.CKeywordSuggestion;
import org.gcreator.autocomplete.impl.ClassSuggestion;
import org.gcreator.autocomplete.impl.FunctionSuggestion;
import org.gcreator.autocomplete.impl.KeywordSuggestion;
import org.gcreator.autocomplete.impl.NKeywordSuggestion;
import org.gcreator.autocomplete.impl.Suggestion;
import org.gcreator.autocomplete.impl.SuggestionCellRenderer;
import org.gcreator.autocomplete.impl.VKeywordSuggestion;
import org.gcreator.components.SyntaxHighlighter;
import org.gcreator.components.impl.VectorListModel;
import org.gcreator.fileclass.Project;
import org.gcreator.units.ObjectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCLAutocomplete
extends AutocompleteFrame {
    int selstart;
    int selend;
    SyntaxHighlighter editor;
    String prevWord;
    String context;
    boolean requestDie = false;
    Project p;
    Vector<String> actorTypes = new Vector();
    Vector<String> spriteTypes = new Vector();
    Vector<Suggestion> v = new Vector();

    public GCLAutocomplete(final int selstart, final int selend, final SyntaxHighlighter editor, Project p) {
        super("GCL Autocomplete...");
        this.selstart = selstart;
        this.selend = selend;
        this.editor = editor;
        this.p = p;
        this.context = this.getContext();
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 40) {
                    if (!GCLAutocomplete.this.list.isSelectionEmpty()) {
                        int sh = GCLAutocomplete.this.list.getCellRenderer().getListCellRendererComponent(GCLAutocomplete.this.list, GCLAutocomplete.this.list.getSelectedValue(), (int)GCLAutocomplete.this.list.getSelectedIndex(), (boolean)false, (boolean)false).getPreferredSize().height;
                        JScrollBar bar = GCLAutocomplete.this.scroll.getVerticalScrollBar();
                        bar.setValue(bar.getValue() + sh);
                    }
                    GCLAutocomplete.this.list.setSelectedIndex(GCLAutocomplete.this.list.getSelectedIndex() + 1);
                } else if (evt.getKeyCode() == 38) {
                    if (!GCLAutocomplete.this.list.isSelectionEmpty()) {
                        int sh = GCLAutocomplete.this.list.getCellRenderer().getListCellRendererComponent(GCLAutocomplete.this.list, GCLAutocomplete.this.list.getSelectedValue(), (int)GCLAutocomplete.this.list.getSelectedIndex(), (boolean)false, (boolean)false).getPreferredSize().height;
                        JScrollBar bar = GCLAutocomplete.this.scroll.getVerticalScrollBar();
                        bar.setValue(bar.getValue() - sh);
                    }
                    GCLAutocomplete.this.list.setSelectedIndex(GCLAutocomplete.this.list.getSelectedIndex() - 1);
                } else if (evt.getKeyCode() == 37) {
                    editor.setSelectionStart(selstart - 1);
                    editor.setSelectionEnd(selstart - 1);
                    GCLAutocomplete.this.dispose();
                } else if (evt.getKeyCode() == 39) {
                    editor.setSelectionStart(selend + 1);
                    editor.setSelectionEnd(selend + 1);
                    GCLAutocomplete.this.dispose();
                } else if (evt.getKeyCode() == 10) {
                    GCLAutocomplete.this.confirm();
                } else if (evt.getKeyChar() != '\uffff' && evt.getKeyChar() != '\b') {
                    System.out.println((int)evt.getKeyChar());
                    editor.insert(selstart, selend, "" + evt.getKeyChar());
                    editor.setSelectionStart(selstart + 1);
                    editor.setSelectionEnd(selstart + 1);
                    GCLAutocomplete.this.dispose();
                    editor.callAutocomplete();
                } else if (evt.getKeyChar() == '\b') {
                    if (selstart == selend) {
                        editor.insert(selstart - 1, selstart, "");
                    } else {
                        editor.insert(selstart, selend, "");
                    }
                    GCLAutocomplete.this.dispose();
                    editor.callAutocomplete();
                    editor.setSelectionEnd(selstart);
                }
            }

            public void keyReleased(KeyEvent evt) {
            }

            public void keyTyped(KeyEvent evt) {
            }
        });
        this.useContext();
    }

    @Override
    public boolean requestDie() {
        return this.requestDie;
    }

    private void confirm() {
        if (this.list.isSelectionEmpty()) {
            this.editor.insert(this.selstart, this.selend, "\n");
        } else {
            Suggestion s = (Suggestion)this.list.getSelectedValue();
            String t = s.confirm(this.context, this.prevWord);
            this.editor.insert(this.selstart, this.selend, t);
            this.editor.setSelectionStart(this.selstart + t.length() - s.retreat());
            this.editor.setSelectionEnd(this.selstart + t.length() - s.retreat());
        }
        this.dispose();
    }

    private void applyClass(String val) {
        String res = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            res = i == val.length() - 1 ? "(" + val.charAt(i) + ")?" : "(" + val.charAt(i) + res + ")?";
        }
        res = "^" + res + "$";
        if (this.context.matches(res)) {
            this.v.add(new ClassSuggestion(val));
        }
    }

    private void applyClassVector(Vector<String> vals) {
        for (String s : vals) {
            this.applyClass(s);
        }
    }

    private void applyKeyword(String val) {
        String res = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            res = i == val.length() - 1 ? "(" + val.charAt(i) + ")?" : "(" + val.charAt(i) + res + ")?";
        }
        res = "^" + res + "$";
        if (this.context.matches(res)) {
            this.v.add(new KeywordSuggestion(val));
        }
    }

    private void applyCKeyword(String val) {
        String res = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            res = i == val.length() - 1 ? "(" + val.charAt(i) + ")?" : "(" + val.charAt(i) + res + ")?";
        }
        res = "^" + res + "$";
        if (this.context.matches(res)) {
            this.v.add(new CKeywordSuggestion(val));
        }
    }

    private void applyVKeyword(String val) {
        String res = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            res = i == val.length() - 1 ? "(" + val.charAt(i) + ")?" : "(" + val.charAt(i) + res + ")?";
        }
        res = "^" + res + "$";
        if (this.context.matches(res)) {
            this.v.add(new VKeywordSuggestion(val));
        }
    }

    private void applyNKeyword(String val) {
        String res = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            res = i == val.length() - 1 ? "(" + val.charAt(i) + ")?" : "(" + val.charAt(i) + res + ")?";
        }
        res = "^" + res + "$";
        if (this.context.matches(res)) {
            this.v.add(new NKeywordSuggestion(val));
        }
    }

    private void useContext() {
        Object o;
        this.scroll = new JScrollPane();
        this.scroll.setFocusable(false);
        this.scroll.setVisible(true);
        this.list = new JList();
        this.list.setFocusable(false);
        this.list.setVisible(true);
        this.scroll.setViewportView(this.list);
        this.add("Center", this.scroll);
        if (this.context == null) {
            this.dispose();
            return;
        }
        this.actorTypes.add("Actor");
        Enumeration e = this.p.getEnum("actor");
        while (e.hasMoreElements()) {
            o = e.nextElement();
            this.actorTypes.add(((ObjectNode)o).object.name);
        }
        this.actorTypes.add("Sprite");
        e = this.p.getEnum("sprite");
        while (e.hasMoreElements()) {
            o = e.nextElement();
            this.spriteTypes.add(((ObjectNode)o).object.name);
        }
        this.applyClassVector(this.actorTypes);
        this.applyClassVector(this.spriteTypes);
        this.applyKeyword("char");
        this.applyClass("Clipboard");
        this.applyClass("Common");
        if (this.context.matches("^Common\\.(S(c(e(n(e)?)?)?)?)?$")) {
            this.v.add(new ClassSuggestion("Scene"));
        }
        this.applyKeyword("do");
        this.applyKeyword("else");
        this.applyCKeyword("for");
        this.applyKeyword("getter");
        if (this.context.matches("^Clipboard\\.(g(e(t(T(e(x(t)?)?)?)?)?)?)?$")) {
            this.v.add(new FunctionSuggestion("getText", ""));
        }
        this.applyCKeyword("if");
        this.applyKeyword("int");
        this.applyVKeyword("false");
        this.applyKeyword("float");
        if (this.context.matches("^Clipboard\\.(h(a(s(T(e(x(t)?)?)?)?)?)?)?$")) {
            this.v.add(new FunctionSuggestion("hasText", ""));
        }
        this.applyNKeyword("native");
        this.applyKeyword("new");
        this.applyVKeyword("null");
        this.applyKeyword("private");
        this.applyKeyword("protected");
        this.applyKeyword("public");
        if (this.context.matches("^Clipboard\\.(s(e(t(T(e(x(t)?)?)?)?)?)?)?$")) {
            this.v.add(new FunctionSuggestion("setText", "text"));
        }
        this.applyKeyword("return ");
        this.applyKeyword("static");
        this.applyVKeyword("this");
        this.applyVKeyword("true");
        if (this.context.matches("^Common\\.Scene\\.(g(o(t(o(N(e(x(t)?)?)?)?)?)?)?)?$")) {
            this.v.add(new FunctionSuggestion("gotoNext", ""));
        }
        if (this.context.matches("^Common\\.Scene\\.(g(o(t(o(P(r(e(v(i(o(u(s)?)?)?)?)?)?)?)?)?)?)?)?$")) {
            this.v.add(new FunctionSuggestion("gotoNext", ""));
        }
        this.applyKeyword("void");
        this.applyCKeyword("while");
        Collections.sort(this.v);
        this.list.setModel(new VectorListModel(this.v));
        this.list.setCellRenderer(new SuggestionCellRenderer());
        if (this.v.size() == 1) {
            this.list.setSelectedIndex(0);
            String t = ((Suggestion)this.list.getSelectedValue()).confirm(this.context, this.prevWord);
            this.editor.insert(this.selstart, this.selend, t);
            this.editor.setSelectionStart(this.selstart + t.length());
            this.editor.setSelectionEnd(this.selstart + t.length());
            this.dispose();
            this.requestDie = true;
        }
    }

    private String getContext() {
        boolean NULL = false;
        boolean SCOMMENT = true;
        int MCOMMENT = 2;
        int STRING = 3;
        int BSTRING = 4;
        int CHAR = 5;
        int BCHAR = 6;
        int situation = 0;
        String word = "";
        String x = this.editor.getText();
        int selection = this.selend;
        this.prevWord = "";
        if (selection < 0 || selection > x.length()) {
            return null;
        }
        for (int i = 0; i < selection; ++i) {
            try {
                if (situation == 0) {
                    if (x.charAt(i) == '/' && x.charAt(i + 1) == '/') {
                        if (!word.equals("")) {
                            this.prevWord = word;
                        }
                        word = "";
                        situation = 1;
                        continue;
                    }
                    if (x.charAt(i) == '/' && x.charAt(i + 1) == '*') {
                        if (!word.equals("")) {
                            this.prevWord = word;
                        }
                        word = "";
                        situation = 2;
                        continue;
                    }
                    if (x.charAt(i) == '\"') {
                        if (!word.equals("")) {
                            this.prevWord = word;
                        }
                        word = "";
                        situation = 3;
                        continue;
                    }
                    if (x.charAt(i) == '\'') {
                        if (!word.equals("")) {
                            this.prevWord = word;
                        }
                        word = "";
                        situation = 5;
                        continue;
                    }
                    if (x.charAt(i) == ' ' || x.charAt(i) == '\t' || x.charAt(i) == '\n' || x.charAt(i) == '+' || x.charAt(i) == '-' || x.charAt(i) == '*' || x.charAt(i) == '/' || x.charAt(i) == '%' || x.charAt(i) == '&' || x.charAt(i) == '|' || x.charAt(i) == '(' || x.charAt(i) == ')' || x.charAt(i) == '{' || x.charAt(i) == '}' || x.charAt(i) == '!' || x.charAt(i) == '^' || x.charAt(i) == ',' || x.charAt(i) == ';' || x.charAt(i) == '<' || x.charAt(i) == '>' || x.charAt(i) == '=' || x.charAt(i) == '?' || x.charAt(i) == ':') {
                        if (!word.equals("")) {
                            this.prevWord = word;
                        }
                        word = "";
                        continue;
                    }
                    word = word + x.charAt(i);
                    continue;
                }
                if (situation == 1 && x.charAt(i) == '\n') {
                    situation = 0;
                    continue;
                }
                if (situation == 2 && x.charAt(i) == '*' && x.charAt(i + 1) == '/') {
                    situation = 0;
                    continue;
                }
                if (situation == 3) {
                    if (x.charAt(i) == '\\') {
                        situation = 4;
                        continue;
                    }
                    if (x.charAt(i) == '\"') {
                        situation = 0;
                        continue;
                    }
                }
                if (situation == 4) {
                    situation = 3;
                    continue;
                }
                if (situation == 5) {
                    if (x.charAt(i) == '\\') {
                        situation = 6;
                        continue;
                    }
                    if (x.charAt(i) == '\"') {
                        situation = 0;
                        continue;
                    }
                }
                if (situation != 6) continue;
                situation = 5;
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        if (situation == 0) {
            return word;
        }
        return null;
    }
}

