/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.autocomplete;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JScrollBar;
import org.gcreator.autocomplete.AutocompleteFrame;
import org.gcreator.autocomplete.impl.CKeywordSuggestion;
import org.gcreator.autocomplete.impl.ClassSuggestion;
import org.gcreator.autocomplete.impl.FunctionSuggestion;
import org.gcreator.autocomplete.impl.KeywordSuggestion;
import org.gcreator.autocomplete.impl.NKeywordSuggestion;
import org.gcreator.autocomplete.impl.Suggestion;
import org.gcreator.autocomplete.impl.SuggestionCellRenderer;
import org.gcreator.autocomplete.impl.VKeywordSuggestion;
import org.gcreator.components.SyntaxHighlighter;
import org.gcreator.components.impl.VectorListModel;
import org.gcreator.fileclass.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSAutocomplete
extends AutocompleteFrame {
    int selstart;
    int selend;
    SyntaxHighlighter editor;
    String prevWord;
    String context;
    boolean requestDie = false;
    Project p;
    Vector<Suggestion> v = new Vector();

    public GSAutocomplete(final int selstart, final int selend, final SyntaxHighlighter editor, Project p) {
        super("GS Autocomplete...");
        this.selstart = selstart;
        this.selend = selend;
        this.editor = editor;
        this.p = p;
        this.context = this.getContext();
        this.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 40) {
                    if (!GSAutocomplete.this.list.isSelectionEmpty()) {
                        int sh = GSAutocomplete.this.list.getCellRenderer().getListCellRendererComponent(GSAutocomplete.this.list, GSAutocomplete.this.list.getSelectedValue(), (int)GSAutocomplete.this.list.getSelectedIndex(), (boolean)false, (boolean)false).getPreferredSize().height;
                        JScrollBar bar = GSAutocomplete.this.scroll.getVerticalScrollBar();
                        bar.setValue(bar.getValue() + sh);
                    }
                    GSAutocomplete.this.list.setSelectedIndex(GSAutocomplete.this.list.getSelectedIndex() + 1);
                } else if (evt.getKeyCode() == 38) {
                    if (!GSAutocomplete.this.list.isSelectionEmpty()) {
                        int sh = GSAutocomplete.this.list.getCellRenderer().getListCellRendererComponent(GSAutocomplete.this.list, GSAutocomplete.this.list.getSelectedValue(), (int)GSAutocomplete.this.list.getSelectedIndex(), (boolean)false, (boolean)false).getPreferredSize().height;
                        JScrollBar bar = GSAutocomplete.this.scroll.getVerticalScrollBar();
                        bar.setValue(bar.getValue() - sh);
                    }
                    GSAutocomplete.this.list.setSelectedIndex(GSAutocomplete.this.list.getSelectedIndex() - 1);
                } else if (evt.getKeyCode() == 37) {
                    editor.setSelectionStart(selstart - 1);
                    editor.setSelectionEnd(selstart - 1);
                    GSAutocomplete.this.dispose();
                } else if (evt.getKeyCode() == 39) {
                    editor.setSelectionStart(selend + 1);
                    editor.setSelectionEnd(selend + 1);
                    GSAutocomplete.this.dispose();
                } else if (evt.getKeyCode() == 10) {
                    GSAutocomplete.this.confirm();
                } else if (evt.getKeyChar() != '\uffff' && evt.getKeyChar() != '\b') {
                    System.out.println((int)evt.getKeyChar());
                    editor.insert(selstart, selend, "" + evt.getKeyChar());
                    editor.setSelectionStart(selstart + 1);
                    editor.setSelectionEnd(selstart + 1);
                    GSAutocomplete.this.dispose();
                    editor.callAutocomplete();
                } else if (evt.getKeyChar() == '\b') {
                    if (selstart == selend) {
                        editor.insert(selstart - 1, selstart, "");
                    } else {
                        editor.insert(selstart, selend, "");
                    }
                    GSAutocomplete.this.dispose();
                    editor.callAutocomplete();
                    editor.setSelectionEnd(selstart);
                }
            }

            public void keyReleased(KeyEvent evt) {
            }

            public void keyTyped(KeyEvent evt) {
            }
        });
        this.useContext();
    }

    @Override
    public boolean requestDie() {
        return this.requestDie;
    }

    private void confirm() {
        if (this.list.isSelectionEmpty()) {
            this.editor.insert(this.selstart, this.selend, "\n");
        } else {
            Suggestion s = (Suggestion)this.list.getSelectedValue();
            String t = s.confirm(this.context, this.prevWord);
            this.editor.insert(this.selstart, this.selend, t);
            this.editor.setSelectionStart(this.selstart + t.length() - s.retreat());
            this.editor.setSelectionEnd(this.selstart + t.length() - s.retreat());
        }
        this.dispose();
    }

    private void applyClass(String val) {
        String res = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            res = i == val.length() - 1 ? "(" + val.charAt(i) + ")?" : "(" + val.charAt(i) + res + ")?";
        }
        res = "^" + res + "$";
        if (this.context.matches(res)) {
            this.v.add(new ClassSuggestion(val));
        }
    }

    private void applyClassVector(Vector<String> vals) {
        for (String s : vals) {
            this.applyClass(s);
        }
    }

    private void applyKeyword(String val) {
        String res = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            res = i == val.length() - 1 ? "(" + val.charAt(i) + ")?" : "(" + val.charAt(i) + res + ")?";
        }
        res = "^" + res + "$";
        if (this.context.matches(res)) {
            this.v.add(new KeywordSuggestion(val));
        }
    }

    private void applyCKeyword(String val) {
        String res = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            res = i == val.length() - 1 ? "(" + val.charAt(i) + ")?" : "(" + val.charAt(i) + res + ")?";
        }
        res = "^" + res + "$";
        if (this.context.matches(res)) {
            this.v.add(new CKeywordSuggestion(val));
        }
    }

    private void applyVKeyword(String val) {
        String res = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            res = i == val.length() - 1 ? "(" + val.charAt(i) + ")?" : "(" + val.charAt(i) + res + ")?";
        }
        res = "^" + res + "$";
        if (this.context.matches(res)) {
            this.v.add(new VKeywordSuggestion(val));
        }
    }

    private void applyNKeyword(String val) {
        String res = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            res = i == val.length() - 1 ? "(" + val.charAt(i) + ")?" : "(" + val.charAt(i) + res + ")?";
        }
        res = "^" + res + "$";
        if (this.context.matches(res)) {
            this.v.add(new NKeywordSuggestion(val));
        }
    }

    private void applyFunction(String val, String args) {
        String res = "";
        for (int i = val.length() - 1; i >= 0; --i) {
            res = i == val.length() - 1 ? "(" + val.charAt(i) + ")?" : "(" + val.charAt(i) + res + ")?";
        }
        res = "^" + res + "$";
        if (this.context.matches(res)) {
            this.v.add(new FunctionSuggestion(val, args));
        }
    }

    private void useContext() {
        if (this.context == null) {
            this.dispose();
            return;
        }
        this.applyCKeyword("if");
        this.applyCKeyword("while");
        this.applyCKeyword("for");
        this.applyKeyword("else");
        this.applyKeyword("do");
        this.applyKeyword("var");
        this.applyFunction("room_goto_next", "");
        this.applyFunction("room_goto_previous", "");
        this.applyFunction("scene_goto_next", "");
        this.applyFunction("scene_goto_previous", "");
        this.applyFunction("random", "max");
        this.applyFunction("abs", "x");
        this.applyFunction("sign", "x");
        this.applyFunction("round", "x");
        this.applyFunction("floor", "x");
        this.applyFunction("ceil", "x");
        this.applyFunction("frac", "x");
        this.applyFunction("sqrt", "x");
        this.applyFunction("sqr", "x");
        this.applyFunction("power", "x");
        this.applyFunction("exp", "x");
        this.applyFunction("ln", "x");
        this.applyFunction("log2", "x");
        this.applyFunction("log10", "x");
        this.applyFunction("logn", "n, x");
        this.applyFunction("sin", "x");
        this.applyFunction("cos", "x");
        this.applyFunction("tan", "x");
        this.applyFunction("arcsin", "x");
        this.applyFunction("arccos", "x");
        this.applyFunction("arctan", "x");
        this.applyFunction("arctan2", "y, x");
        this.applyFunction("degtorad", "degrees");
        this.applyFunction("radtodeg", "radians");
        this.applyFunction("point_distance", "x1, y1, x2, y2");
        this.applyFunction("lengthdir_x", "len, dir");
        this.applyFunction("lengthdir_y", "len, dir");
        this.applyFunction("is_real", "x");
        this.applyFunction("is_string", "x");
        this.applyFunction("point_direction", "x1, y1, x2, y2");
        this.applyFunction("real", "str");
        this.applyFunction("string", "value");
        this.applyFunction("chr", "value");
        this.applyFunction("ord", "char");
        this.applyFunction("string_length", "text");
        this.applyFunction("string_pos", "substring, text");
        this.applyFunction("string_copy", "text, index, count");
        this.applyFunction("string_char_at", "text, index");
        this.applyFunction("string_delete", "text, index, count");
        this.applyFunction("string_insert", "substring, text, index");
        this.applyFunction("string_lower", "text");
        this.applyFunction("string_upper", "text");
        this.applyFunction("string_repeat", "text, times");
        this.applyFunction("string_letters", "text");
        this.applyFunction("string_digits", "text");
        this.applyFunction("string_lettersdigits", "text");
        this.applyFunction("string_replace", "text, find, replace");
        this.applyFunction("string_replaceall", "text, find, replace");
        this.applyFunction("string_count", "substring, text");
        this.applyFunction("string_format", "val, total, dec");
        this.applyFunction("clipboard_has_text", "");
        this.applyFunction("clipboard_get_text", "");
        this.applyFunction("clipboard_set_text", "text");
        this.applyFunction("date_current_date", "");
        this.applyFunction("move_snap", "hsnap, vsnap");
        this.applyFunction("place_snapped", "hsnap, vsnap");
        this.applyFunction("move_random", "hsnap, vsnap");
        this.applyFunction("move_wrap", "hsnap, vsnap");
        this.applyFunction("move_towards_point", "x, y, sp");
        this.applyFunction("distance_to_point", "x, y");
        this.applyFunction("sleep", "millisecond");
        this.applyFunction("game_end", "");
        this.applyFunction("draw_sprite", "sprite, subimg, x, y");
        this.applyFunction("draw_sprite_stretched", "sprite, subimg, x, y, w, h");
        this.applyFunction("draw_clear", "color");
        this.applyFunction("draw_point", "x, y");
        this.applyFunction("draw_line", "x1, y1, x2, y2");
        this.applyFunction("draw_rectangle", "x1, y1, x2, y2, outline");
        this.applyFunction("draw_roundrect", "x1, y1, x2, y2, outline");
        this.applyFunction("draw_set_color", "color");
        this.applyFunction("draw_get_color", "");
        this.applyFunction("draw_get_red", "");
        this.applyFunction("draw_get_green", "");
        this.applyFunction("draw_get_blue", "");
        this.applyFunction("make_color_rgb", "red, green, blue");
        this.applyFunction("draw_text", "x, y, string");
        this.applyFunction("surface_create", "w, h");
        this.applyFunction("surface_get_width", "id");
        this.applyFunction("surface_get_height", "id");
        this.applyFunction("surface_set_target", "id");
        this.applyFunction("surface_reset_target", "id");
        this.applyFunction("surface_save", "id, fname");
        this.applyFunction("draw_surface", "id, x, y");
        this.applyFunction("display_get_width", "");
        this.applyFunction("display_get_height", "");
        this.applyFunction("display_get_frequency", "");
        this.applyFunction("display_get_colordepth", "");
        this.applyFunction("show_message", "text");
        this.applyFunction("show_error", "text, abort");
        this.applyFunction("file_text_open_read", "fname");
        this.applyFunction("file_text_open_write", "fname");
        this.applyFunction("file_text_close", "fileid");
        this.applyFunction("file_text_write_string", "fileid, str");
        this.applyFunction("file_text_write_real", "fileid, x");
        this.applyFunction("file_text_read_string", "fileid");
        this.applyFunction("ds_stack_create", "");
        this.applyFunction("ds_stack_destroy", "id");
        this.applyFunction("ds_stack_clear", "id");
        this.applyFunction("ds_stack_size", "id");
        this.applyFunction("ds_stack_empty", "id");
        this.applyFunction("ds_stack_push", "id, value");
        this.applyFunction("ds_stack_pop", "id");
        this.applyFunction("ds_stack_top", "id");
        this.applyFunction("ds_queue_create", "");
        this.applyFunction("ds_queue_destroy", "id");
        this.applyFunction("ds_queue_clear", "id");
        this.applyFunction("ds_queue_size", "id");
        this.applyFunction("ds_queue_empty", "id");
        this.applyFunction("ds_queue_enqueue", "id, val");
        this.applyFunction("ds_queue_dequeue", "id");
        this.applyFunction("ds_queue_head", "id");
        this.applyFunction("ds_queue_tail", "id");
        this.applyFunction("window_set_visible", "visible");
        this.applyFunction("window_get_visible", "");
        this.applyFunction("window_set_fullscreen", "fullscreen");
        this.applyFunction("window_get_fullscreen", "");
        this.applyFunction("window_set_showborder", "showborder");
        this.applyFunction("window_get_showborder", "");
        this.applyFunction("window_set_sizeable", "sizeable");
        this.applyFunction("window_get_sizeable", "");
        this.applyFunction("window_set_caption", "caption");
        this.applyFunction("window_get_caption", "");
        Collections.sort(this.v);
        this.list.setModel(new VectorListModel(this.v));
        this.list.setCellRenderer(new SuggestionCellRenderer());
        if (this.v.size() == 1) {
            this.list.setSelectedIndex(0);
            String t = ((Suggestion)this.list.getSelectedValue()).confirm(this.context, this.prevWord);
            this.editor.insert(this.selstart, this.selend, t);
            this.editor.setSelectionStart(this.selstart + t.length());
            this.editor.setSelectionEnd(this.selstart + t.length());
            this.dispose();
            this.requestDie = true;
        }
    }

    private String getContext() {
        boolean NULL = false;
        boolean SCOMMENT = true;
        int MCOMMENT = 2;
        int STRING = 3;
        int BSTRING = 4;
        int CHAR = 5;
        int BCHAR = 6;
        int situation = 0;
        String word = "";
        String x = this.editor.getText();
        int selection = this.selend;
        this.prevWord = "";
        if (selection < 0 || selection > x.length()) {
            return null;
        }
        for (int i = 0; i < selection; ++i) {
            try {
                if (situation == 0) {
                    if (x.charAt(i) == '/' && x.charAt(i + 1) == '/') {
                        if (!word.equals("")) {
                            this.prevWord = word;
                        }
                        word = "";
                        situation = 1;
                        continue;
                    }
                    if (x.charAt(i) == '/' && x.charAt(i + 1) == '*') {
                        if (!word.equals("")) {
                            this.prevWord = word;
                        }
                        word = "";
                        situation = 2;
                        continue;
                    }
                    if (x.charAt(i) == '\"') {
                        if (!word.equals("")) {
                            this.prevWord = word;
                        }
                        word = "";
                        situation = 3;
                        continue;
                    }
                    if (x.charAt(i) == '\'') {
                        if (!word.equals("")) {
                            this.prevWord = word;
                        }
                        word = "";
                        situation = 5;
                        continue;
                    }
                    if (x.charAt(i) == ' ' || x.charAt(i) == '\t' || x.charAt(i) == '\n' || x.charAt(i) == '+' || x.charAt(i) == '-' || x.charAt(i) == '*' || x.charAt(i) == '/' || x.charAt(i) == '%' || x.charAt(i) == '&' || x.charAt(i) == '|' || x.charAt(i) == '(' || x.charAt(i) == ')' || x.charAt(i) == '{' || x.charAt(i) == '}' || x.charAt(i) == '!' || x.charAt(i) == '^' || x.charAt(i) == ',' || x.charAt(i) == ';' || x.charAt(i) == '<' || x.charAt(i) == '>' || x.charAt(i) == '=' || x.charAt(i) == '?' || x.charAt(i) == ':') {
                        if (!word.equals("")) {
                            this.prevWord = word;
                        }
                        word = "";
                        continue;
                    }
                    word = word + x.charAt(i);
                    continue;
                }
                if (situation == 1 && x.charAt(i) == '\n') {
                    situation = 0;
                    continue;
                }
                if (situation == 2 && x.charAt(i) == '*' && x.charAt(i + 1) == '/') {
                    situation = 0;
                    continue;
                }
                if (situation == 3) {
                    if (x.charAt(i) == '\\') {
                        situation = 4;
                        continue;
                    }
                    if (x.charAt(i) == '\"') {
                        situation = 0;
                        continue;
                    }
                }
                if (situation == 4) {
                    situation = 3;
                    continue;
                }
                if (situation == 5) {
                    if (x.charAt(i) == '\\') {
                        situation = 6;
                        continue;
                    }
                    if (x.charAt(i) == '\"') {
                        situation = 0;
                        continue;
                    }
                }
                if (situation != 6) continue;
                situation = 5;
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        if (situation == 0) {
            return word;
        }
        return null;
    }
}

