/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;
import org.gcreator.components.TabPanel;
import org.gcreator.core.gcreator;

public class ButtonTabComponent
extends JPanel {
    private final JTabbedPane pane;
    public static ImageIcon close = new ImageIcon(ButtonTabComponent.class.getResource("/org/gcreator/resources/close.png"));
    public static ImageIcon closehover = new ImageIcon(ButtonTabComponent.class.getResource("/org/gcreator/resources/closehover.png"));
    public static ImageIcon closepressed = new ImageIcon(ButtonTabComponent.class.getResource("/org/gcreator/resources/closepressed.png"));
    private MouseListener buttonMouseListener = new MouseAdapter(){

        public void mouseEntered(MouseEvent e) {
            ButtonTabComponent.this.hover();
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent e) {
            ButtonTabComponent.this.out();
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public ButtonTabComponent(final JTabbedPane pane) {
        super(new FlowLayout(0, 0, 0));
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = pane;
        this.setOpaque(false);
        JLabel label = new JLabel(){

            public String getText() {
                int i;
                int ver = Integer.parseInt(gcreator.getJavaVersion().replaceAll("1\\.([0-9])\\..*", "$1"));
                if (ver >= 6 && (i = pane.indexOfTabComponent(ButtonTabComponent.this)) != -1) {
                    return pane.getTitleAt(i);
                }
                return null;
            }

            public Icon getIcon() {
                int i;
                int ver = Integer.parseInt(gcreator.getJavaVersion().replaceAll("1\\.([0-9])\\..*", "$1"));
                if (ver >= 6 && (i = pane.indexOfTabComponent(ButtonTabComponent.this)) != -1) {
                    return pane.getIconAt(i);
                }
                return null;
            }
        };
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        TabButton button = new TabButton();
        button.addActionListener(button);
        this.add(button);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    public void hover() {
    }

    public void out() {
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText("Close this tab");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(true);
            this.setBorder(null);
            this.addMouseListener(ButtonTabComponent.this.buttonMouseListener);
            this.setRolloverEnabled(true);
        }

        public void actionPerformed(ActionEvent e) {
            int i;
            int ver = Integer.parseInt(gcreator.getJavaVersion().replaceAll("1\\.([0-9])\\..*", "$1"));
            if (ver >= 6 && (i = ButtonTabComponent.this.pane.indexOfTabComponent(ButtonTabComponent.this)) != -1) {
                TabPanel panel = (TabPanel)ButtonTabComponent.this.pane.getComponentAt(i);
                panel.dispose();
            }
        }

        public void updateUI() {
        }

        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            if (this.getModel().isRollover()) {
                this.setBorder(BorderFactory.createEtchedBorder());
            } else {
                this.setBorder(null);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(Color.BLACK);
            int delta = 6;
            g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.dispose();
        }
    }
}

