/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.components;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gcreator.components.IconList;
import org.gcreator.components.impl.CustomFileFilter;
import org.gcreator.plugins.Plugin;
import org.gcreator.plugins.PluginList;
import org.jdesktop.layout.GroupLayout;

public class PluginDialog
extends JDialog {
    public IconList list;
    private static JFileChooser fc = new JFileChooser();
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    public PluginDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.list = new IconList();
        this.list.setColumnWidth(100);
        this.list.setColumnHeight(100);
        this.list.setColumns(5);
        this.jScrollPane1.setViewportView(this.list);
        for (Plugin plugin : PluginList.stdlist.plugins) {
            System.out.println("Plugin: " + plugin.name);
            this.list.addElement(plugin.name, plugin.image, plugin);
        }
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Plugin Manager");
        this.setResizable(false);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jButton1.setText("Install new plugin");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Uninstall plugin");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PluginDialog.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(2).add(1, this.jButton2, -1, 194, Short.MAX_VALUE).add(1, this.jButton1, -1, 194, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jButton1).addPreferredGap(0).add(this.jButton2).addContainerGap(254, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel1, "West");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle("Choose the file");
        fc.setApproveButtonText("OK");
        fc.setFileFilter(new CustomFileFilter(".jar", "Plugin archives (*.jar)"));
        fc.showOpenDialog(this);
        File f = fc.getSelectedFile();
        if (f == null) {
            return;
        }
        if (!f.exists()) {
            return;
        }
        this.addPlugin(f);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        Object o = this.list.getSelectedExtraContent();
        if (o == null) {
            return;
        }
        if (o instanceof Plugin) {
            this.uninstall((Plugin)o);
            this.list.removeElement(this.list.getSelectedIndex());
        }
    }

    public void uninstall(Plugin plugin) {
        System.out.println("Uninstall " + plugin.name);
        String s = "[G-Creator Plugin List]\n";
        for (Plugin plug : PluginList.stdlist.plugins) {
            if (plug == plugin) continue;
            s = s + "[~Plugin~]\n";
            for (String author : plug.authors) {
                s = s + "Author=" + author + "\n";
            }
            s = s + "Core=" + plug.value.getClass().getName() + "\n";
            s = s + "License=" + plug.licenseLocation + "\n";
            s = s + "Name=" + plug.name + "\n";
            s = s + "Version=" + plug.version + "\n";
            s = s + "Image=" + plug.img_loc + "\n";
            for (String file : plug.files) {
                s = s + "File=" + file + "\n";
            }
        }
        File f = new File("./settings/pluglist");
        FileOutputStream stream = null;
        try {
            if (f.exists()) {
                f.delete();
            }
            stream = new FileOutputStream(f);
            BufferedOutputStream bstream = new BufferedOutputStream(stream);
            bstream.write(s.getBytes());
            bstream.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void addPlugin(File f) {
        FileInputStream istream = null;
        ZipInputStream in = null;
        File f2 = new File("./settings/pluglist");
        FileOutputStream f2stream = null;
        String files = "";
        try {
            if (!f2.exists()) {
                f2.createNewFile();
                f2stream = new FileOutputStream(f2);
                BufferedOutputStream s = new BufferedOutputStream(f2stream);
                s.write("[G-Creator Plugin List]\n".getBytes());
                s.close();
                f2stream = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            f2stream = new FileOutputStream(f2, true);
            istream = new FileInputStream(f);
            in = new ZipInputStream(istream);
        }
        catch (Exception e) {
            return;
        }
        try {
            ZipEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                int len;
                if (entry.getName().equals("PLUGIN")) {
                    int len2;
                    while ((len2 = in.read()) != -1) {
                        f2stream.write(len2);
                    }
                    f2stream.write(10);
                    continue;
                }
                if (entry.isDirectory()) {
                    new File("./plugins/" + entry.getName()).mkdirs();
                    continue;
                }
                File f3 = new File("./plugins/" + entry.getName());
                FileOutputStream ost = new FileOutputStream(f3);
                while ((len = in.read()) != -1) {
                    ost.write(len);
                }
                ost.close();
                files = files + "File=" + entry.getName() + "\n";
            }
            f2stream.write(files.getBytes());
            f2stream.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

