/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.Reader;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.gcreator.autocomplete.AutocompleteFrame;
import org.gcreator.components.impl.Token;
import org.gcreator.components.scanning.Scanner;
import org.gcreator.fileclass.Project;
import publicdomain.TokenTypes;

public class SyntaxHighlighter
extends JTextPane
implements DocumentListener,
TokenTypes {
    private StyledDocument doc;
    private Scanner scanner;
    private int height;
    private int width;
    private Project project;
    Style[] styles;
    Segment text = new Segment();
    int firstRehighlightToken;
    int smallAmount = 100;

    public SyntaxHighlighter(int height, int width, final Scanner scanner, Project project) {
        super(new DefaultStyledDocument());
        this.doc = (StyledDocument)this.getDocument();
        this.height = height;
        this.width = width;
        this.scanner = scanner;
        this.doc.addDocumentListener(this);
        Font font = new Font("Monospaced", 0, this.getFont().getSize());
        this.changeFont(font);
        this.initStyles();
        this.setBackground(Color.WHITE);
        this.project = project;
        this.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent evt) {
            }

            public void keyPressed(KeyEvent evt) {
            }

            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == ' ' && evt.isControlDown()) {
                    SyntaxHighlighter.this.callAutocomplete();
                }
                if (!evt.isControlDown() && scanner != null) {
                    int selstart = SyntaxHighlighter.this.getSelectionStart();
                    int selend = SyntaxHighlighter.this.getSelectionEnd();
                    SyntaxHighlighter.this.insert(selstart, selend, scanner.symbolCompletion(evt.getKeyChar()));
                    SyntaxHighlighter.this.setSelectionStart(selstart);
                    SyntaxHighlighter.this.setSelectionEnd(selend);
                }
            }
        });
    }

    public void callAutocomplete() {
        AutocompleteFrame f = this.scanner.callAutocomplete(this.getSelectionStart(), this.getSelectionEnd(), this, this.project);
        if (f != null && !f.requestDie()) {
            int lh;
            f.setVisible(true);
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int x = 0;
            int y = lh = fm.getHeight();
            int w = this.getWidth();
            String d = this.getText();
            for (int i = 0; i < this.getSelectionEnd(); ++i) {
                char t = d.charAt(i);
                if (t == '\r' || t == '\n' && (i == 0 || d.charAt(i - 1) != '\r')) {
                    x = 0;
                    y += lh;
                    continue;
                }
                int cw = t != '\t' ? fm.charWidth(t) : fm.charWidth(' ') * 10;
                if (x + cw > w) {
                    x = cw;
                    y += lh;
                    continue;
                }
                x += cw;
            }
            f.setLocation(this.getLocationOnScreen().x + x, this.getLocationOnScreen().y + y);
        }
    }

    public void changeFont(Font font) {
        int borderOfJTextPane = 3;
        this.setFont(font);
        FontMetrics metrics = this.getFontMetrics(font);
        int paneWidth = this.width * metrics.charWidth('m') + 2 * borderOfJTextPane;
        int paneHeight = this.height * metrics.getHeight() + 2 * borderOfJTextPane;
        Dimension size = new Dimension(paneWidth, paneHeight);
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.invalidate();
    }

    public void read(Reader in, Object desc) throws IOException {
        int oldLength = this.getDocument().getLength();
        this.doc.removeDocumentListener(this);
        super.read(in, desc);
        this.doc = (StyledDocument)this.getDocument();
        this.doc.addDocumentListener(this);
        int newLength = this.getDocument().getLength();
        this.firstRehighlightToken = this.scanner.change(0, oldLength, newLength);
        this.repaint();
    }

    private void initStyles() {
        this.styles = new Style[typeNames.length];
        this.changeStyle(0, Color.red);
        this.changeStyle(1, Color.black);
        this.changeStyle(2, Color.black);
        this.changeStyle(3, Color.orange.darker());
        this.changeStyle(4, Color.orange.darker());
        this.changeStyle(5, Color.green.darker());
        this.changeStyle(6, Color.green.darker());
        this.changeStyle(7, Color.green.darker());
        this.changeStyle(8, Color.green.darker());
        this.changeStyle(9, Color.blue);
        this.changeStyle(10, Color.blue);
        this.changeStyle(11, Color.blue);
        this.changeStyle(12, Color.blue);
        this.changeStyle(13, Color.black);
        this.changeStyle(14, Color.blue);
        this.changeStyle(15, Color.red);
        this.changeStyle(16, Color.magenta);
        this.changeStyle(17, Color.black);
        this.changeStyle(18, Color.DARK_GRAY);
        this.changeStyle(19, Color.orange.darker());
        this.changeStyle(20, Color.blue.darker());
        for (int i = 0; i < this.styles.length; ++i) {
            if (this.styles[i] != null) continue;
            this.styles[i] = this.styles[1];
        }
    }

    public void changeStyle(int type, Color color) {
        Style style = this.addStyle(typeNames[type], null);
        StyleConstants.setForeground(style, color);
        this.styles[type] = style;
    }

    public void changeStyle(int type, Color color, boolean underlined) {
        Style style = this.addStyle(typeNames[type], null);
        StyleConstants.setForeground(style, color);
        StyleConstants.setUnderline(style, underlined);
        this.styles[type] = style;
    }

    public void changeStyle(int type, Color color, int fontStyle) {
        Style style = this.addStyle(typeNames[type], null);
        StyleConstants.setForeground(style, color);
        if ((fontStyle & 1) != 0) {
            StyleConstants.setBold(style, true);
        }
        if ((fontStyle & 2) != 0) {
            StyleConstants.setItalic(style, true);
        }
        this.styles[type] = style;
    }

    public void insertUpdate(DocumentEvent e) {
        int offset = e.getOffset();
        int length = e.getLength();
        this.firstRehighlightToken = this.scanner.change(offset, 0, length);
        this.repaint();
    }

    public void removeUpdate(DocumentEvent e) {
        int offset = e.getOffset();
        int length = e.getLength();
        this.firstRehighlightToken = this.scanner.change(offset, length, 0);
        this.repaint();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int offset = this.scanner.position();
        if (offset < 0) {
            return;
        }
        int tokensToRedo = 0;
        int amount = this.smallAmount;
        while (tokensToRedo == 0 && offset >= 0) {
            int length = this.doc.getLength() - offset;
            if (length > amount) {
                length = amount;
            }
            try {
                this.doc.getText(offset, length, this.text);
            }
            catch (BadLocationException e) {
                return;
            }
            tokensToRedo = this.scanner.scan(this.text.array, this.text.offset, this.text.count);
            offset = this.scanner.position();
            amount = 2 * amount;
        }
        for (int i = 0; i < tokensToRedo; ++i) {
            Token t = this.scanner.getToken(this.firstRehighlightToken + i);
            int length = t.symbol.name.length();
            int type = t.symbol.type;
            if (type < 0) {
                type = 0;
            }
            this.doc.setCharacterAttributes(t.position, length, this.styles[type], false);
        }
        this.firstRehighlightToken += tokensToRedo;
        if (offset >= 0) {
            this.repaint(2L);
        }
    }

    public void insert(int selstart, int selend, String text) {
        String content = this.getText();
        String before = content.substring(0, selstart);
        String after = content.substring(selend);
        this.setText(before + text + after);
    }
}

