/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.gcreator.editors.TilesetEditor;
import org.gcreator.fileclass.GFile;
import org.gcreator.fileclass.res.GImage;

public class TilesetPreviewer
extends JComponent {
    private TilesetEditor editor;

    public TilesetPreviewer(TilesetEditor editor) {
        this.editor = editor;
    }

    private ImageIcon getSourceImage() {
        if (this.editor == null) {
            return null;
        }
        if (this.editor.value.image == null) {
            return null;
        }
        GFile imgFile = this.editor.value.image;
        if (imgFile == null) {
            return null;
        }
        return ((GImage)imgFile.value).image;
    }

    public int getPreferredWidth() {
        int w = 0;
        try {
            w = this.getSourceImage().getIconWidth();
        }
        catch (NullPointerException e) {
            return 0;
        }
        int hsepcount = (w -= this.editor.value.startx) % this.editor.value.tilew == 0 ? w / this.editor.value.tilew : w / this.editor.value.tilew + 1;
        return w + hsepcount * 2;
    }

    public int getPreferredHeight() {
        int h = 0;
        try {
            h = this.getSourceImage().getIconHeight();
        }
        catch (NullPointerException e) {
            return 0;
        }
        int vsepcount = (h -= this.editor.value.starty) % this.editor.value.tileh == 0 ? h / this.editor.value.tileh : h / this.editor.value.tileh + 1;
        return h + vsepcount * 2;
    }

    public int getWidth() {
        return this.getPreferredWidth();
    }

    public int getHeight() {
        return this.getPreferredHeight();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getPreferredWidth(), this.getPreferredHeight());
    }

    public void paint(Graphics g) {
        ImageIcon img = this.getSourceImage();
        g.clearRect(0, 0, this.getPreferredWidth(), this.getPreferredHeight());
        if (img == null) {
            return;
        }
        int imgw = img.getIconWidth();
        int imgh = img.getIconHeight();
        int bw = this.editor.value.bwidth;
        int bh = this.editor.value.bheight;
        g.drawImage(img.getImage(), 0, 0, ((GImage)this.editor.value.image.value).transparentColor, img.getImageObserver());
        g.setColor(Color.WHITE);
        g.setXORMode(Color.BLACK);
        int i = this.editor.value.startx;
        int times = 0;
        while (i + bh * times < imgw - 1) {
            g.drawLine(i + bh * times, 0, i + bh * times, imgh - 1);
            if (bh > 0 && i + bh * (times + 1) < imgw - 1) {
                g.drawLine(i + bh * (times + 1), 0, i + bh * (times + 1), imgh - 1);
            }
            i += this.editor.value.tilew;
            ++times;
        }
        i = this.editor.value.starty;
        times = 0;
        while (i + bw * times < imgh - 1) {
            g.drawLine(0, i + bw * times, imgw - 1, i + bw * times);
            if (bw > 0 && i + bw * (times + 1) < imgh - 1) {
                g.drawLine(0, i + bw * (times + 1), imgw - 1, i + bw * (times + 1));
            }
            i += this.editor.value.tileh;
            ++times;
        }
    }
}

