/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.components.resource;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.gcreator.components.impl.WorkspaceCellRenderer;
import org.gcreator.components.resource.FileMenuItem;
import org.gcreator.components.resource.FolderMenuItem;
import org.gcreator.core.Aurwindow;
import org.gcreator.fileclass.Folder;
import org.gcreator.fileclass.GFile;
import org.gcreator.fileclass.GObject;
import org.gcreator.fileclass.Project;

class FileLabel
extends JComponent
implements MouseListener {
    private GFile file = null;
    private Project p;
    private String key;
    private Vector<ActionListener> a = new Vector();

    public FileLabel(Project p, String key) {
        this.p = p;
        this.key = key;
        this.addMouseListener(this);
    }

    public void folderToPopup(Project p, Folder f, JPopupMenu pop) {
        Vector v = f.getChildren();
        for (Object o : v) {
            JMenuItem i;
            GObject g = (GObject)o;
            System.out.println("Object " + g.name);
            if (!p.validOfType(g, this.key)) continue;
            System.out.println("Valid");
            if (g instanceof GFile) {
                i = new FileMenuItem(this);
                i.setVisible(true);
                ((FileMenuItem)i).file = (GFile)g;
                pop.add(i);
            }
            if (!(g instanceof Folder)) continue;
            i = new FolderMenuItem();
            i.setVisible(true);
            ((FolderMenuItem)i).file = (Folder)g;
            this.folderToPopup(p, (Folder)g, i);
            pop.add(i);
        }
    }

    public void folderToPopup(Project p, Folder f, JMenuItem pop) {
        Vector v = f.getChildren();
        for (Object o : v) {
            JMenuItem i;
            GObject g = (GObject)o;
            System.out.println("Object " + g.name);
            if (!p.validOfType(g, this.key)) continue;
            System.out.println("Valid");
            if (g instanceof GFile) {
                i = new FileMenuItem(this);
                i.setVisible(true);
                ((FileMenuItem)i).file = (GFile)g;
                pop.add(i);
            }
            if (!(g instanceof Folder)) continue;
            i = new FolderMenuItem();
            i.setVisible(true);
            ((FolderMenuItem)i).file = (Folder)g;
            pop.add(i);
            this.folderToPopup(p, (Folder)g, i);
        }
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        Folder f = this.p.getFolderFor(this.key);
        if (f == null) {
            return;
        }
        JPopupMenu pop = new JPopupMenu();
        FileMenuItem i = new FileMenuItem(this);
        i.setVisible(true);
        i.file = null;
        pop.add(i);
        this.folderToPopup(this.p, f, pop);
        pop.show(this, evt.getX(), evt.getY());
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void setFile(GFile file) {
        this.setFile(file, false);
    }

    public void setFile(GFile file, boolean trigger) {
        this.file = file;
        this.repaint();
        if (trigger) {
            for (ActionListener al : this.a) {
                al.actionPerformed(null);
            }
        }
    }

    public GFile getFile() {
        return this.file;
    }

    public void addActionListener(ActionListener a) {
        this.a.add(a);
    }

    public void paint(Graphics g) {
        super.paint(g);
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        Color c = this.getForeground();
        g.setColor(c);
        g.setFont(f);
        if (this.file == null) {
            g.drawString("<none>", 1, fm.getHeight() + 1);
            return;
        }
        int x = 1;
        try {
            WorkspaceCellRenderer r = (WorkspaceCellRenderer)Aurwindow.workspace.getCellRenderer();
            ImageIcon i = r.getImageFor(this.file.node);
            g.drawImage(i.getImage(), x, 1, i.getImageObserver());
            x += i.getIconWidth() + 1;
        }
        catch (Exception e) {
            // empty catch block
        }
        g.drawString(this.file.name, x, fm.getHeight() + 1);
    }
}

