/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.externproject;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gcreator.core.utilities;
import org.gcreator.fileclass.Folder;
import org.gcreator.fileclass.GFile;
import org.gcreator.fileclass.GObject;
import org.gcreator.fileclass.Project;

public class ProjectExporter {
    private static int a;

    public static boolean export(Project project, String filename) {
        String config = ProjectExporter.getConfigFile(project);
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(filename));
        }
        catch (Exception e) {
            System.out.println("ProjectExport: " + e.getLocalizedMessage());
            return false;
        }
        out.setLevel(9);
        try {
            out.putNextEntry(new ZipEntry("config"));
            for (int i = 0; i < config.length(); ++i) {
                out.write(config.charAt(i));
            }
            out.closeEntry();
        }
        catch (Exception e) {
            System.out.println("ProjectExport: " + e.getLocalizedMessage());
        }
        a = 1;
        ProjectExporter.putFolder(project, "", out);
        try {
            out.close();
        }
        catch (Exception e) {
            System.out.println("ProjectExport: " + e.getLocalizedMessage());
        }
        utilities.addStringMessage("Saved");
        return false;
    }

    public static void putFolder(Folder folder, String prefix, ZipOutputStream out) {
        for (int i = 0; i < folder.getChildArrayNum(); ++i) {
            GObject childNode = folder.childAt(i);
            if (childNode == null) continue;
            if (childNode instanceof GFile) {
                try {
                    out.putNextEntry(new ZipEntry("src/_" + a++ + "." + ((GFile)childNode).type));
                    ((GFile)childNode).writeToBuffer(out);
                    out.closeEntry();
                }
                catch (IOException e) {
                    System.out.println("ProjectExport: " + e.getLocalizedMessage());
                }
                continue;
            }
            if (!(childNode instanceof Folder)) continue;
            ProjectExporter.putFolder((Folder)childNode, prefix + childNode.name + "/", out);
        }
    }

    public static String getConfigFile(Project project) {
        String config = "<?xml version=\"1.0\"?>\n";
        config = config + "<project>";
        config = config + "<type>" + project.getClass().getName() + "</type>";
        config = config + "<content>";
        config = config + ProjectExporter.getContent("", project);
        config = config + "</content>";
        config = config + "</project>";
        return config;
    }

    public static String getContent(String prefix, Folder folder) {
        String content = "";
        for (int i = 0; i < folder.getChildArrayNum(); ++i) {
            GObject childNode = folder.childAt(i);
            if (childNode == null) continue;
            content = content + "<file type=\"" + childNode.getClass().getName() + "\">" + prefix + childNode.name;
            if (childNode instanceof GFile) {
                content = content + "." + ((GFile)childNode).type;
            }
            content = content + "</file>";
            if (!(childNode instanceof Folder)) continue;
            content = content + ProjectExporter.getContent(prefix + childNode.name + "/", (Folder)childNode);
        }
        return content;
    }
}

