/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.fileclass;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.gcreator.exceptions.NoSuchFolderException;
import org.gcreator.fileclass.GFile;
import org.gcreator.fileclass.GObject;
import org.gcreator.fileclass.Group;

public class Folder
extends GObject
implements Serializable {
    protected Vector<GObject> childNodes;
    static final long serialVersionUID = 1L;

    public Folder() {
    }

    public Folder(String name) {
        super(name);
        this.childNodes = new Vector();
    }

    public Vector getChildren() {
        return this.childNodes;
    }

    public boolean add(GObject node) {
        boolean i = false;
        return this.childNodes.add(node);
    }

    public Folder magicAddition(GFile file) {
        return this.magicAddition(file.type);
    }

    public Folder magicAddition(String type) {
        if (this.allowsFileType(type)) {
            return this;
        }
        return null;
    }

    public Folder magicAddition(Group folder) {
        if (this.allowsGroup(folder)) {
            return this;
        }
        return null;
    }

    public int find(GObject search) {
        if (this.childNodes == null) {
            return -1;
        }
        for (int i = 0; i < this.childNodes.size(); ++i) {
            if (this.childNodes.get(i) != search) continue;
            return i;
        }
        return -1;
    }

    public int findFromName(String search) {
        if (this.childNodes == null) {
            return -1;
        }
        for (int i = 0; i < this.childNodes.size(); ++i) {
            if (this.childNodes.get(i) == null || !this.childNodes.get((int)i).name.equals(search)) continue;
            return i;
        }
        return -1;
    }

    public GObject childAt(int pos) {
        return this.childNodes.get(pos);
    }

    public int getChildNum() {
        int num = 0;
        for (int i = 0; i < this.childNodes.size(); ++i) {
            if (this.childNodes.get(i) == null) continue;
            ++num;
        }
        return num;
    }

    public int getChildArrayNum() {
        return this.childNodes.size();
    }

    public boolean allowsFileType(String format) {
        return true;
    }

    public boolean allowsGroup(Group group) {
        return true;
    }

    public boolean allowsDelete(GObject o) {
        return true;
    }

    public void remove(GObject o) {
        this.childNodes.remove(o);
    }

    public Group newGroup(String name) {
        Group group = new Group(this, name);
        this.add(group);
        return group;
    }

    public Folder findFolder(String name) throws NoSuchFolderException {
        if (name == null) {
            throw new NoSuchFolderException();
        }
        if (name.equals("") || name.equals("/")) {
            return this;
        }
        if (name.charAt(0) == '/') {
            name = name.substring(1);
        }
        if (name.indexOf("/") == -1) {
            if (!name.equals(this.name)) {
                throw new NoSuchFolderException();
            }
            return this;
        }
        if (!name.substring(name.indexOf("/")).equals(name)) {
            throw new NoSuchFolderException();
        }
        for (int i = 0; i < this.childNodes.size(); ++i) {
            GObject o = this.childNodes.get(i);
            if (o == null || !(o instanceof Folder)) continue;
            try {
                Folder a = ((Folder)o).findFolder(name.substring(name.indexOf(name)));
                return a;
            }
            catch (NoSuchFolderException e) {
                // empty catch block
            }
        }
        throw new NoSuchFolderException("Folder");
    }

    public String getObjectType() {
        return "Folder";
    }

    public ImageIcon getImage() {
        return null;
    }
}

