/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.fileclass;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.gcreator.components.TabPanel;
import org.gcreator.fileclass.Folder;
import org.gcreator.fileclass.GObject;
import org.gcreator.fileclass.Project;
import org.gcreator.fileclass.res.Resource;
import sun.awt.image.ToolkitImage;

public class GFile
extends GObject
implements Transferable {
    static final long serialVersionUID = 1L;
    public static final DataFlavor NODE_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "Node");
    private static DataFlavor[] flavors = new DataFlavor[]{NODE_FLAVOR};
    public Folder root;
    public String type;
    public TabPanel tabPanel;
    public Object value;
    public String xml = "";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("type", String.class), new ObjectStreamField("value", Object.class)};

    public GFile(Folder root, String name, String type, GObject value) {
        super(name);
        this.root = root;
        this.type = type;
        this.value = value;
        root.add(this);
    }

    private GFile(String name, String type) {
        super(name);
        this.type = type;
    }

    public String getObjectType() {
        return "File";
    }

    public void writeToBuffer(ZipOutputStream out) throws IOException {
        if (this.value != null) {
            if (this.value instanceof String) {
                out.write(this.value.toString().getBytes());
            } else if (this.value instanceof ImageIcon) {
                ImageIcon img = (ImageIcon)this.value;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedImage ii = null;
                try {
                    if (img.getImage() instanceof ToolkitImage) {
                        System.out.println("Toolkit");
                        ii = ((ToolkitImage)img.getImage()).getBufferedImage();
                    } else {
                        ii = (BufferedImage)img.getImage();
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception " + e.getMessage());
                    ii = (BufferedImage)img.getImage();
                }
                ImageIO.write((RenderedImage)ii, this.type, baos);
                out.write(baos.toByteArray());
            } else {
                ObjectOutputStream s = new ObjectOutputStream(out);
                s.writeObject(this.value);
                s.flush();
            }
        }
    }

    public static ImageIcon getScaledIcon(ImageIcon ii) {
        ImageIcon iii = new ImageIcon();
        if (ii != null) {
            Image i = ii.getImage().getScaledInstance(16, 16, 1);
            iii.setImage(i);
            return iii;
        }
        return null;
    }

    public GObject clone() {
        GFile o = new GFile(this.name, this.type);
        o.value = this.value instanceof Resource ? ((Resource)this.value).clone() : (this.value instanceof ImageIcon ? this.value : this.value);
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == NODE_FLAVOR;
    }

    public GObject getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor != NODE_FLAVOR) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this;
    }

    public String getPath() {
        return this.root.getPath() + "/" + super.getPath();
    }

    public Project getProject() {
        return this.root.getProject();
    }
}

