/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.fileclass;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;
import org.gcreator.fileclass.ActorGroup;
import org.gcreator.fileclass.EGMLGroup;
import org.gcreator.fileclass.Folder;
import org.gcreator.fileclass.GFile;
import org.gcreator.fileclass.GObject;
import org.gcreator.fileclass.Group;
import org.gcreator.fileclass.ImageGroup;
import org.gcreator.fileclass.Project;
import org.gcreator.fileclass.SceneGroup;
import org.gcreator.fileclass.SoundGroup;
import org.gcreator.fileclass.SpriteGroup;
import org.gcreator.fileclass.TilesetGroup;
import org.gcreator.fileclass.TimelineGroup;
import org.gcreator.fileclass.res.SettingsValues;
import org.gcreator.units.ObjectNode;

public class GameProject
extends Project {
    public int images = 1;
    public int sprites = 1;
    public int tilesets = 1;
    public int sounds = 1;
    public int timelines = 1;
    public int actors = 1;
    public int scenes = 1;
    public int classes = 1;
    public int scripts = 1;
    private ImageIcon project_game = new ImageIcon(this.getClass().getResource("/org/gcreator/resources/toolbar/new_game_sm.png"));

    public GameProject(String name, String location) {
        super(name, location);
    }

    public GameProject() {
    }

    public String getType() {
        return "Game";
    }

    public static GameProject balance() {
        return (GameProject)GameProject.balancedCreation();
    }

    public Enumeration getEnum(String key) {
        Enumeration<? extends TreeNode> e = null;
        if (key.equals("actor")) {
            e = this.node.getChildAt(5).children();
        } else if (key.equals("scene")) {
            e = this.node.getChildAt(6).children();
        } else if (key.equals("timeline")) {
            e = this.node.getChildAt(4).children();
        } else if (key.equals("image")) {
            e = this.node.getChildAt(0).children();
        } else if (key.equals("sprite")) {
            e = this.node.getChildAt(1).children();
        } else if (key.equals("tileset")) {
            e = this.node.getChildAt(2).children();
        } else if (key.equals("sound")) {
            e = this.node.getChildAt(3).children();
        } else if (key.equals("class")) {
            e = this.node.getChildAt(7).children();
        }
        return e;
    }

    public Folder getFolderFor(String key) {
        if (key.equals("actor")) {
            return (Folder)((ObjectNode)this.node.getChildAt((int)5)).object;
        }
        if (key.equals("scene")) {
            return (Folder)((ObjectNode)this.node.getChildAt((int)6)).object;
        }
        if (key.equals("timeline")) {
            return (Folder)((ObjectNode)this.node.getChildAt((int)4)).object;
        }
        if (key.equals("image")) {
            return (Folder)((ObjectNode)this.node.getChildAt((int)0)).object;
        }
        if (key.equals("sprite")) {
            return (Folder)((ObjectNode)this.node.getChildAt((int)1)).object;
        }
        if (key.equals("tileset")) {
            return (Folder)((ObjectNode)this.node.getChildAt((int)2)).object;
        }
        if (key.equals("sound")) {
            return (Folder)((ObjectNode)this.node.getChildAt((int)3)).object;
        }
        if (key.equals("class")) {
            return (Folder)((ObjectNode)this.node.getChildAt((int)7)).object;
        }
        return null;
    }

    public boolean validOfType(GObject obj, String key) {
        Vector v = this.childNodes;
        if (key.equals("parent")) {
            return v.contains(obj);
        }
        if (v.contains(obj)) {
            return false;
        }
        if (obj instanceof GFile) {
            GFile f = (GFile)obj;
            if (f.type.equals("actor") || f.type.equals("scene") || f.type.equals("timeline") || f.type.equals("sprite") || f.type.equals("tileset")) {
                return key.equals(f.type);
            }
            if (key.equals("image")) {
                return f.type.equals("png") || f.type.equals("gif") || f.type.equals("jpg");
            }
            if (key.equals("class")) {
                return f.type.equals("egml") || f.type.equals("gcl") || f.type.equals("struct") || f.type.equals("gs");
            }
            return false;
        }
        if (obj instanceof Group) {
            if (key.equals("actor")) {
                return obj instanceof ActorGroup;
            }
            if (key.equals("scene")) {
                return obj instanceof SceneGroup;
            }
            if (key.equals("sprite")) {
                return obj instanceof SpriteGroup;
            }
            if (key.equals("timeline")) {
                return obj instanceof TimelineGroup;
            }
            if (key.equals("tileset")) {
                return obj instanceof TilesetGroup;
            }
            if (key.equals("image")) {
                return obj instanceof ImageGroup;
            }
            if (key.equals("class")) {
                return obj instanceof EGMLGroup;
            }
            if (key.equals("sound")) {
                return obj instanceof SoundGroup;
            }
        }
        return false;
    }

    public Folder magicAddition(String file) {
        try {
            if (file.equals("png") || file.equals("gif") || file.equals("jpg")) {
                return this.findFolder("$209");
            }
            if (file.equals("sprite")) {
                return this.findFolder("$210");
            }
            if (file.equals("tileset")) {
                return this.findFolder("$211");
            }
            if (file.equals("actor")) {
                return this.findFolder("$214");
            }
            if (file.equals("scene")) {
                return this.findFolder("$215");
            }
            if (file.equals("egml") || file.equals("gcl") || file.equals("struct") || file.equals("gs")) {
                return this.findFolder("$216");
            }
            if (file.equals("mp3") || file.equals("ogg") || file.equals("wav") || file.equals("mid") || file.equals("midi")) {
                return this.findFolder("$212");
            }
            if (file.equals("timeline")) {
                return this.findFolder("$213");
            }
            return this.findFolder("$217");
        }
        catch (Exception e) {
            return null;
        }
    }

    public Folder magicAddition(Group folder) {
        try {
            if (folder instanceof ImageGroup) {
                return this.findFolder("$209");
            }
            if (folder instanceof SpriteGroup) {
                return this.findFolder("$210");
            }
            if (folder instanceof ActorGroup) {
                return this.findFolder("$214");
            }
            if (folder instanceof SceneGroup) {
                return this.findFolder("$215");
            }
            if (folder instanceof TilesetGroup) {
                return this.findFolder("$211");
            }
            if (folder instanceof SoundGroup) {
                return this.findFolder("$212");
            }
            if (folder instanceof TimelineGroup) {
                return this.findFolder("$213");
            }
            if (folder instanceof EGMLGroup) {
                return this.findFolder("$216");
            }
            return this.findFolder("Distribution");
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Project balancedCreation() {
        GameProject project = new GameProject();
        project.add(new ImageGroup(project, "$209"));
        project.add(new SpriteGroup(project, "$210"));
        project.add(new TilesetGroup(project, "$211"));
        project.add(new SoundGroup(project, "$212"));
        project.add(new TimelineGroup(project, "$213"));
        project.add(new ActorGroup(project, "$214"));
        project.add(new SceneGroup(project, "$215"));
        project.add(new EGMLGroup(project, "$216"));
        project.add(new Group(project, "$217"));
        GFile a = new GFile(project, "$218", "settings", null);
        a.editable = false;
        a.value = new SettingsValues();
        return project;
    }

    public boolean allowsFileType(String format) {
        return false;
    }

    public boolean allowsGroup(Group group) {
        return false;
    }

    public Group newGroup(String name) {
        return null;
    }

    public boolean allowsDelete(GObject o) {
        return false;
    }

    public String getObjectType() {
        return "GameProject";
    }

    public ImageIcon getImage() {
        return this.project_game;
    }
}

