/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.fileclass.res;

import java.awt.Color;
import java.util.Vector;
import org.gcreator.fileclass.res.Resource;

public class Scene
extends Resource {
    static final long serialVersionUID = 1L;
    public String caption = "";
    public String code = "//Do nothing";
    public int width = 640;
    public int height = 480;
    public int speed = 60;
    public int snapX = 16;
    public int snapY = 16;
    public boolean persistant;
    public boolean grid = true;
    public boolean isometric;
    public boolean drawbackcolor = true;
    public Vector views;
    public Vector actors;
    public Vector tiles;
    public Vector backgrounds;
    public Color background = Color.lightGray;

    public Scene(String name) {
        this.name = name;
        this.actors = new Vector();
        this.tiles = new Vector();
        this.views = new Vector();
        this.backgrounds = new Vector();
    }

    public String writeXml() {
        String xml = "<scene version=\"1.0\">\n";
        return xml;
    }

    public void readXml(String xml) {
        String[] str = xml.split("\n");
        if (str[0] == null || !str[0].equals("<scene version=\"1.0\">")) {
            return;
        }
        for (int i = 1; i < str.length; ++i) {
            String line = str[i];
            System.out.println("line: " + line);
            if (line == null || line.equals("")) continue;
            if (line.matches("<caption>.*</caption>")) {
                this.caption = line.replaceAll("<caption>(.*)</caption>", "$1").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&apos;", "'").replaceAll("&LINEBREAK;", "\n").replaceAll("&amp;", "&");
                continue;
            }
            if (line.matches("<code>.*</code>")) {
                this.code = line.replaceAll("<code>(.*)</code>", "$1").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&apos;", "'").replaceAll("&LINEBREAK;", "\n").replaceAll("&amp;", "&");
                continue;
            }
            if (line.matches("<dimensions>[0-9]+, [0-9]+</dimensions>")) {
                this.width = Integer.parseInt(line.replaceAll("<dimensions>([0-9]+), [0-9]+</dimensions>", "$1"));
                this.height = Integer.parseInt(line.replaceAll("<dimensions>[0-9]+, ([0-9]+)</dimensions>", "$1"));
                continue;
            }
            if (line.matches("<bgcolor>[0-9]+, [0-9]+, [0-9]+</bgcolor>")) {
                this.drawbackcolor = true;
                int r = Integer.parseInt(line.replaceAll("<bgcolor>([0-9]+), [0-9]+, [0-9]+</bgcolor>", "$1"));
                int g = Integer.parseInt(line.replaceAll("<bgcolor>[0-9]+, ([0-9]+), [0-9]+</bgcolor>", "$1"));
                int b = Integer.parseInt(line.replaceAll("<bgcolor>[0-9]+, [0-9]+, ([0-9]+)</bgcolor>", "$1"));
                this.background = new Color(r, g, b);
                continue;
            }
            if (line.matches("<bgcolor>-</bgcolor>")) {
                this.drawbackcolor = false;
            }
            if (line.matches("<fps>[0-9]+</fps>")) {
                this.speed = Integer.parseInt(line.replaceAll("<fps>([0-9]+)</fps>", "$1"));
                continue;
            }
            if (line.matches("<snap>[0-9]+, [0-9]+</snap>")) {
                this.snapX = Integer.parseInt(line.replaceAll("<snap>([0-9]+), [0-9]+</snap>", "$1"));
                this.snapY = Integer.parseInt(line.replaceAll("<snap>[0-9]+, ([0-9]+)</snap>", "$1"));
                continue;
            }
            if (!line.matches("<grid>(Visible|Hidden) (Standard|Isometric)</grid>")) continue;
            String x = line.replaceAll("<grid>(Visible|Hidden) (Standard|Isometric)</grid>", "$1");
            String y = line.replaceAll("<grid>(Visible|Hidden) (Standard|Isometric)</grid>", "$2");
            this.grid = x.equals("Visible");
            this.isometric = !y.equals("Standard");
        }
    }

    public String exportToHtml(boolean xhtml) {
        return "";
    }

    public Object clone() {
        Scene a = new Scene(this.name);
        Object obj = this.actors.clone();
        a.actors = obj == null ? null : (Vector)obj;
        a.caption = this.caption;
        a.code = this.code;
        a.grid = this.grid;
        a.height = this.height;
        a.isometric = this.isometric;
        a.persistant = this.persistant;
        a.snapX = this.snapX;
        a.snapY = this.snapY;
        a.speed = this.speed;
        a.views = this.views;
        a.width = this.width;
        return a;
    }
}

