/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.managers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JTextPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcreator.core.Aurwindow;
import org.gcreator.core.gcreator;
import org.gcreator.managers.LangSupporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SettingsIO {
    public static JTextPane console;

    private static void addError(int message) {
        SettingsIO.addFormatedMessage(message, "red", true);
    }

    private static void addStringMessage(String message) {
        SettingsIO.addStringFormatedMessage(message, null, false);
    }

    private static void addFormatedMessage(int message, String color, boolean bold) {
        SettingsIO.addStringFormatedMessage(LangSupporter.activeLang.getEntry(message), color, bold);
    }

    private static void addStringFormatedMessage(String message, String color, boolean bold) {
        String out = "";
        if (color != null) {
            out = out + "<font color='" + color + "'>";
        }
        if (bold) {
            out = out + "<b>";
        }
        out = out + message;
        if (bold) {
            out = out + "</b>";
        }
        if (color != null) {
            out = out + "</font>";
        }
        out = out + "<br/>";
        if ((gcreator.output = gcreator.output + out) != null && console != null) {
            console.setText(gcreator.output);
        }
    }

    public static void saveSettings(int look, boolean istabs, boolean scrollvisible) {
        File a = new File("settings.xml");
        if (!a.exists()) {
            try {
                a.createNewFile();
            }
            catch (IOException e) {
                SettingsIO.addError(30);
            }
        }
        try {
            FileWriter b = new FileWriter("settings.xml");
            BufferedWriter out = new BufferedWriter(b);
            out.write("<?xml version = \"1.0\"?>\n");
            out.write("<settings>");
            out.write("<style>");
            if (look == 0) {
                out.write("Native");
            } else if (look == 1) {
                out.write("Cross-platform");
            } else if (look == 2) {
                out.write("Motif");
            } else if (look == 3) {
                out.write("Metal");
            } else {
                out.write("Unknown");
            }
            out.write("</style>");
            out.write("<desktop>");
            if (istabs) {
                out.write("Tabs ");
                if (Aurwindow.tabs.getTabPlacement() == 1) {
                    out.write("(Top)");
                } else if (Aurwindow.tabs.getTabPlacement() == 2) {
                    out.write("(Left)");
                } else if (Aurwindow.tabs.getTabPlacement() == 3) {
                    out.write("(Bottom)");
                } else {
                    out.write("(Right)");
                }
            } else {
                out.write("MDI");
            }
            out.write("</desktop>");
            out.write("<console>");
            out.write(scrollvisible ? "Visible" : "Hidden");
            out.write("</console>");
            out.write("<language>");
            out.write(Aurwindow.lang);
            out.write("</language>");
            out.write("<toolbar>");
            out.write(Aurwindow.showToolbars ? "Visible" : "Hidden");
            out.write("</toolbar>");
            out.write("<tree>");
            if (gcreator.window.splitter2.getLeftComponent() == Aurwindow.treescroll) {
                out.write("Left");
            } else if (gcreator.window.splitter2.getRightComponent() == Aurwindow.treescroll) {
                out.write("Right");
            } else {
                SettingsIO.addStringFormatedMessage("Invalid tree position-setting to Left", "red", false);
                out.write("Left");
            }
            out.write("</tree>");
            out.write("<size>");
            out.write(gcreator.window.getWidth() + ", " + gcreator.window.getHeight());
            out.write("</size>");
            out.write("</settings>");
            out.close();
        }
        catch (IOException e) {
            SettingsIO.addError(31);
            SettingsIO.addStringFormatedMessage(e.getMessage(), null, false);
        }
    }

    public static String[] loadSettings() {
        File target = new File("./settings.xml");
        if (!target.exists()) {
            SettingsIO.addStringFormatedMessage(target.getAbsolutePath() + " does not exist", null, false);
            try {
                target.createNewFile();
            }
            catch (Exception e) {
                // empty catch block
            }
            return null;
        }
        String[] a = new String[]{null, null, null, null, null, null, null};
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = fact.newDocumentBuilder();
            Document doc = builder.parse("settings.xml");
            Element node = doc.getDocumentElement();
            String root = node.getNodeName();
            if (!root.equals("settings")) {
                SettingsIO.addError(33);
                return null;
            }
            NodeList childs = node.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node child = childs.item(i);
                String name = child.getNodeName();
                int id = -1;
                if (name.equals("style")) {
                    id = 0;
                } else if (name.equals("desktop")) {
                    id = 1;
                } else if (name.equals("console")) {
                    id = 2;
                } else if (name.equals("language")) {
                    id = 3;
                } else if (name.equals("toolbar")) {
                    id = 4;
                } else if (name.equals("tree")) {
                    id = 5;
                } else if (name.equals("size")) {
                    id = 6;
                }
                if (id == -1) {
                    SettingsIO.addError(33);
                    SettingsIO.addStringFormatedMessage(name, null, true);
                    return null;
                }
                if (a[id] != null) {
                    SettingsIO.addError(34);
                }
                a[id] = child.getTextContent();
            }
            if (a[0] == null || a[1] == null || a[2] == null || a[3] == null || a[4] == null || a[5] == null || a[6] == null) {
                SettingsIO.addError(35);
            }
            return a;
        }
        catch (Exception e) {
            return null;
        }
    }
}

