/*
 * Decompiled with CFR 0.152.
 */
package org.gcreator.plugins;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.gcreator.core.ClassLoading;
import org.gcreator.plugins.Plugin;
import org.gcreator.plugins.PluginCore;
import org.gcreator.plugins.PluginList;

public class Plugger {
    private static ClassLoader loader = null;

    public static void registerLoader() {
        if (loader == null) {
            File x = new File("./plugins/");
            try {
                if (!x.exists()) {
                    x.mkdir();
                }
                URL url = x.toURI().toURL();
                loader = new URLClassLoader(new URL[]{url});
                ClassLoading.classLoader.add(loader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static PluginCore[] getPlugList(String[] classFiles) {
        if (classFiles == null) {
            return null;
        }
        PluginCore[] plugins = new PluginCore[classFiles.length];
        for (int i = 0; i < plugins.length; ++i) {
            if (classFiles[i] == null) continue;
            try {
                Class plugin;
                Object instance;
                if (loader == null || !((instance = (plugin = ClassLoading.classLoader.loadClass(classFiles[i])).newInstance()) instanceof PluginCore)) continue;
                plugins[i] = (PluginCore)instance;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return plugins;
    }

    public static ClassLoader getPluginClassLoader() {
        return loader;
    }

    public static void onLoad() {
        for (Plugin plugin : PluginList.stdlist.plugins) {
            if (plugin == null || plugin.value == null) continue;
            plugin.value.onLoad();
        }
    }

    public static void onSplashStart() {
        for (Plugin plugin : PluginList.stdlist.plugins) {
            if (plugin == null || plugin.value == null) continue;
            plugin.value.onSplashStart();
        }
    }

    public static void onMainWindowStart() {
        for (Plugin plugin : PluginList.stdlist.plugins) {
            if (plugin == null || plugin.value == null) continue;
            plugin.value.onMainWindowStart();
        }
    }

    public static void onSplashDispose() {
        for (Plugin plugin : PluginList.stdlist.plugins) {
            if (plugin == null || plugin.value == null) continue;
            plugin.value.onSplashDispose();
        }
    }

    public static void onMainWindowDispose() {
        for (Plugin plugin : PluginList.stdlist.plugins) {
            if (plugin == null || plugin.value == null) continue;
            plugin.value.onMainWindowDispose();
        }
    }
}

